//=======================================================================================
// Huds.cs by Mental Trousers
//=======================================================================================
// Handles the NewOpts stuff for the huds that are used. Here you can easily set the
// coordinate, visibility etc of the huds so that there is no editing of the scripts
// required and so that the huds can be moved around if the user does not load NewOpts
// and the built in Hud Mover.
//
// Sometime I want to rewrite this so that others can simply call a function and it sets
// them up with a NewOpts screen laid out the same as the ones that are already there.
// Thats a little way off though as I have got more than enough to keep me busy for quite
// a while.
//=======================================================================================
// Handles the Jump Huds visibility - on/off
//=======================================================================================
function MT::handleFavsHud()
{
	control::setVisible(MT_huds_overlay1, $MT::enableFavsHud);
	control::setVisible(MTContainerFavPreselect, $MT::enableFavsHud);
}

//=======================================================================================
// Handles the Jump Hud on/off
//=======================================================================================
function MT::handleFavsBG()
{
	control::setVisible(MTBgFavPreselect, $MT::favsOpaqueBG);
}

//=======================================================================================
// Handles the X coordinate TestEdit for the favourites hud
//=======================================================================================
function MT::favsXCoord()
{
	if (!$MT::initHuds)
		{
		%res=string::replace ($pref::VideoFullScreenRes, "x", " ");
		%xres=getWord (%res, 0);
		%yres=getWord (%res, 1);
		$MT::XCC::FavPre=control::getText (MT_favsXCoord);
		%xpos=floor($MT::XCC::FavPre*(200/%xres));
		%ypos=floor($MT::YCC::FavPre*(200/%xres));
	
		if (%xpos>90)
			{
			%xpos=%xpos-90;
			control::setPosition(MT_huds_overlay1, 90, 29);
			}
		else
			control::setPosition(MT_huds_overlay1, 0, 29);
	
		control::setValue (MT_huds_overlay1, "<b"@%xpos+47@","@%ypos@":mt\\bmps\\MTPack\\FavsHudIcon.bmp>");
		control::setPosition (MTContainerFavPreselect, $MT::XCC::FavPre, $MT::YCC::FavPre);
		}
}

//=======================================================================================
// Handles the Y coordinate TestEdit for the favourites hud
//=======================================================================================
function MT::favsYCoord()
{
	if (!$MT::initHuds)
		{
		%res=string::replace ($pref::VideoFullScreenRes, "x", " ");
		%xres=getWord (%res, 0);
		%yres=getWord (%res, 1);
		$MT::YCC::FavPre=control::getText (MT_favsYCoord);
		%xpos=floor($MT::XCC::FavPre*(200/%xres));
		%ypos=floor($MT::YCC::FavPre*(200/%xres));
	
		if (%xpos>90)
			%xpos=%xpos-90;
	
		control::setValue (MT_huds_overlay1, "<b"@%xpos+47@","@%ypos@":mt\\bmps\\MTPack\\FavsHudIcon.bmp>");
		control::setPosition (MTContainerFavPreselect, $MT::XCC::FavPre, $MT::YCC::FavPre);
		}
}

//=======================================================================================
// Would handle the background for the jump hud if it had one.
//=======================================================================================
function MT::handleJumpBG()
{

}

//=======================================================================================
// Handles the Jump Hud visibility - on/off
//=======================================================================================
function MT::handleJumpHud()
{
	control::setVisible(MT_huds_overlay2, $MT::enableJumpHud);
	control::setVisible(MTContainerJump, $MT::enableJumpHud);
}

//=======================================================================================
// Handles the X coordinate TestEdit for the jump hud
//=======================================================================================
function MT::JumpXCoord()
{
	if (!$MT::initHuds)
		{
		%res=string::replace ($pref::VideoFullScreenRes, "x", " ");
		%xres=getWord (%res, 0);
		%yres=getWord (%res, 1);
		$MT::XCC::Jump=control::getText (MT_jumpXCoord);
		%xpos=floor($MT::XCC::Jump*(200/%xres));
		%ypos=floor($MT::YCC::Jump*(200/%xres));
	
		if (%xpos>90)
			{
			%xpos=%xpos-90;
			control::setPosition(MT_huds_overlay2, 90, 29);
			}
		else
			control::setPosition(MT_huds_overlay2, 0, 29);
	
		control::setValue (MT_huds_overlay2, "<b"@%xpos+47@","@%ypos@":mt\\bmps\\MTPack\\JumpHudIcon.bmp>");
		control::setPosition (MTContainerJump, $MT::XCC::Jump, $MT::YCC::Jump);
		}
}

//=======================================================================================
// Handles the Y coordinate TestEdit for the jump hud
//=======================================================================================
function MT::JumpYCoord()
{
	if (!$MT::initHuds)
		{
		%res=string::replace ($pref::VideoFullScreenRes, "x", " ");
		%xres=getWord (%res, 0);
		%yres=getWord (%res, 1);
		$MT::YCC::Jump=control::getText (MT_jumpYCoord);
		%xpos=floor($MT::XCC::Jump*(200/%xres));
		%ypos=floor($MT::YCC::Jump*(200/%xres));
	
		if (%xpos>90)
			%xpos=%xpos-90;
	
		control::setValue (MT_huds_overlay2, "<b"@%xpos+47@","@%ypos@":mt\\bmps\\MTPack\\JumpHudIcon.bmp>");
		control::setPosition (MTContainerJump, $MT::XCC::Jump, $MT::YCC::Jump);
		}
}

//=======================================================================================
// Initialise the various buttons etc in the MT Huds NewOpts page
//=======================================================================================
function MT::initHuds ()
{
	if ($MT::initHuds)
		{
		control::setvalue (MT_huds_background, "<b47,0:mt\\bmps\\MTPack\\MTHudsScreenMap.bmp>");
		control::setValue (MT_favsHudLabel, "<jc><f1>Favourites preselect hud");
		control::setValue (MT_jumpHudLabel, "<jc><f1>Jump hud");
		control::setText (MT_jumpXCoord, $MT::XCC::Jump);
		control::setText (MT_jumpYCoord, $MT::YCC::Jump);
		control::setText (MT_favsXCoord, $MT::XCC::FavPre);
		control::setText (MT_favsYCoord, $MT::YCC::FavPre);
		$MT::initHuds=false;
		MT::handleFavsHud();
		MT::handleFavsBG();
		MT::handleJumpHud();
		MT::favsXCoord();
		MT::favsYCoord();
		MT::JumpXCoord();
		MT::JumpYCoord();
		}
}

//=======================================================================================
// Register with NewOpts
//=======================================================================================
function MT::registerHuds ()
{
	NewOpts::registerHelp("MT Huds", "Enable ### hud", "Check this to enable the relevant hud. If you disable"@
							" certain huds, then a message will appear at the bottom of the screen, rather than"@
							" changing the text in the hud.");
	NewOpts::registerHelp("MT Huds", "Opaque background", "Untick this and the black background with the green"@
							" left and right borders will disappear, leaving just the text of the hud visible.");
	NewOpts::registerHelp("MT Huds", "X and Y coordinates", "These are used to set the position of the huds. There"@
							" isn't any checking done to make sure the coordinates are valid, so it is possible to"@
							" position huds off the screen. Also, the screen shot is of an 800x600 resolution"@
							" screen, so things will be placed differently relative to the chat hud, weapon hud etc"@
							" for other resolutions.");
	NewOpts::register("MT Huds", "MT\\gui\\MTPack\\MTHuds.gui", "MT::initHuds();", "", true);
}

$MT::initHuds=true;
MT::registerHuds ();
MT::handleFavsHud();
MT::handleJumpHud();
MT::handleFavsBG();
