//Poop Taunts 0.8
//A seemingly complete waste of time, yet so much fun.
//By: MrPoop

include("Presto\\KillTrak.cs");

if(isfile("Config\\PoopTauntPrefs.cs"))
{
	include("PoopTauntPrefs.cs");
}
else
{
	$PoopTauntPref::Taunt = "TRUE";
}

newObject(PoopTaunts, SimVolume, "Poop\\PoopTaunts.vol");

function PoopTaunts::AdBanner()
{
	Presto::AddScriptBanner(PoopTaunts, 
		"<B3,4:PoopTauntsPresto.bmp>");
}

PoopTaunts::AdBanner();

function PoopTaunts::ExecMe()
{
	exec("Poop\\PoopTaunts.cs");
}

Event::Attach(eventPoopTables, "PoopTaunts::ExecMe();");

function PoopTaunts::Taunt(%killer, %victim, %weapon)
{
	%me = getManagerID();
	%wepnum = getItemType(%weapon);
	if(%killer == %me && $PoopTauntPref::Taunt == "TRUE")
	{
		for(%i = 1; %i <= 5; %i++)
		{
			%tmp = %i@$PoopTables::ModName;
			if($PoopTauntPref::SavedWeapon[%tmp] == %wepnum)
			{
				return;
			}
		}
		if($PoopTaunt::LastTaunt == "")
		{
			remoteEval(2048, lmsg, taunt10);
			$PoopTaunt::LastTaunt = 1;
		}
		else if($PoopTaunt::LastTaunt == 1)
		{
			remoteEval(2048, lmsg, taunt1);
			$PoopTaunt::LastTaunt = 2;
		}
		else if($PoopTaunt::LastTaunt == 2)
		{
			remoteEval(2048, lmsg, taunt2);
			$PoopTaunt::LastTaunt = 3;
		}
		else if($PoopTaunt::LastTaunt == 3)
		{
			remoteEval(2048, lmsg, taunt3);
			$PoopTaunt::LastTaunt = 4;
		}
		else if($PoopTaunt::LastTaunt == 4)
		{
			remoteEval(2048, lmsg, taunt4);
			$PoopTaunt::LastTaunt = 5;
		}
		else if($PoopTaunt::LastTaunt == 5)
		{
			remoteEval(2048, lmsg, noprob);
			$PoopTaunt::LastTaunt = 6;
		}
		else if($PoopTaunt::LastTaunt == 6)
		{
			remoteEval(2048, lmsg, bye);
			$PoopTaunt::LastTaunt = 7;
		}
		else if($PoopTaunt::LastTaunt == 7)
		{
			remoteEval(2048, lmsg, oops2);
			$PoopTaunt::LastTaunt = 8;
		}
		else if($PoopTaunt::LastTaunt == 8)
		{
			remoteEval(2048, lmsg, sorry);
			$PoopTaunt::LastTaunt = "";
		}
	}
}

Event::Attach(eventKillTrak, PoopTaunts::Taunt);

//NewOpts

NewOpts::register("PoopTaunts", "PoopTaunts.gui", "PoopTaunts::OnOpen();", "PoopTaunts::OnClose();", TRUE);
NewOpts::registerHelp("PoopTaunts", "General", "Auto-taunts the enemy when you kill one via local message - NOT THROUGH THE CHAT HUD!!!");
NewOpts::registerHelp("PoopTaunts", "Select Weapons to ignore", "Select from this menu the weapons you do NOT wish PoopTaunts to auto-taunt.  This is would be good for snipers who wish not to alert the enemy to their presence by screaming out locally.  :o)");
NewOpts::registerHelp("PoopTaunts", "Ignored Weapons", "This will list the weapons you have set to be ignored by PoopTaunts.  Selecting a weapon from this list removes it.");

function PoopTaunts::OnOpen()
{
	Control::Setvalue("PoopTaunts::01", "<B0,0:PoopTaunts01.bmp>");
	Control::Setvalue("PoopTaunts::02", "<B0,0:PoopTaunts02.bmp>");
	Control::Setvalue("PoopTaunts::03", "<B0,0:PoopTaunts03.bmp>");
	Control::Setvalue("PoopTaunts::04", "<B0,0:PoopTaunts04.bmp>");
	FGCombo::SetSelected("PoopTaunts::SelectWeapon", $PoopTaunts::WeaponSelected);
	PoopTaunts::GetWeaponSelected();
}

function PoopTaunts::OnClose()
{
	export("$PoopTauntPref::*", "config\\PoopTauntPrefs.cs", false);
}

//Compile the weapons list
FGCombo::clear(PoopTaunts::SelectWeapon);
FGCombo::addEntry(PoopTaunts::SelectWeapon, "<------------------>", 0);
for(%i = 1; %i < $PoopINV::MaxWeapons; %i++)
{
	FGCombo::addEntry(PoopTaunts::SelectWeapon, $PoopINV::MenuWeapon[%i], %i);
}

//Select Weapons to exclude
function PoopTaunts::SetWeaponSelected() 
{
	echo("Weapon Selected");
	$PoopTaunts::WeaponSelected = FGCombo::GetSelected("PoopTaunts::SelectWeapon");
	%tmp = $PoopTaunts::WeaponSelected@$PoopTables::ModName;
	echo(%tmp);
	$PoopTauntPref::SavedWeapon[%tmp] = $PoopINV::Weapon[$PoopTaunts::WeaponSelected];
	$PoopTauntPref::TempWeapon[%tmp] = "TRUE";

	PoopTaunts::GetWeaponSelected();
}

//Selected Weapon
function PoopTaunts::GetWeaponSelected()
{
	echo("Building Ignored weapons menu");
	FGCombo::clear(PoopTaunts::WeaponSelected);
	for(%i = 1; %i < $PoopINV::MaxWeapons; %i++)
	{
		%tmp = %i@$PoopTables::ModName;
		echo($PoopTaunts::TempWeapon[%tmp]);
		if($PoopTauntPref::TempWeapon[%tmp] == "TRUE")
		{
			FGCombo::addEntry(PoopTaunts::WeaponSelected, $PoopINV::MenuWeapon[%i], %i);
		}
	}
}	

//Delete Selected Weapon
function PoopTaunts::DeleteWeaponSelected()
{
	$PoopTaunts::WeaponDeselected = FGCombo::GetSelected("PoopTaunts::WeaponSelected");
	%tmp = $PoopTaunts::WeaponDeselected@$PoopTables::ModName;
	$PoopTauntPref::SavedWeapon[%tmp] = "";
	$PoopTauntPref::TempWeapon[%tmp] = "False";
	
	PoopTaunts::GetWeaponSelected();
}