//PoopSnipe 0.6
//By MrPoop

include("Presto\\HUD.cs");
include("Presto\\Event.cs");
include("Newopts\\SenseStack.cs");

newObject(PoopSnipe, SimVolume, "poop\\poopsnipe.vol");

function PoopSnipe::AddBanner()
{
	Presto::AddScriptBanner(PoopSnipe,
		"<B3,4:PoopSnipePresto.bmp>");
}

PoopSnipe::AddBanner();

Event::Attach(eventPoopTables, "PoopSnipe::ExecMe();");

function PoopSnipe::ExecMe()
{
	exec("Poop\\PoopSnipe.cs");
}

function PoopSnipe::Defaults()
{
	$PoopPrefs::PoopSnipeCrouch = "TRUE";
	$PoopPrefs::PoopSnipeCrouchbmp = "<B0,4:willcrouch.bmp>";
	$PoopPrefs::PoopSnipeLoc = "85% 0% 60 16";
	$PoopPrefs::PoopSnipeSense = "0.00399999";
	$PoopPrefs::PoopSnipeDefaultZoom = 2;
	$PoopPrefs::PoopSnipeCrouchOnly = "TRUE";
}

if(isfile("config\\PoopPrefs.cs"))
{
	include("PoopPrefs.cs");
}
else
{
	PoopSnipe::Defaults();
}

if($PoopPrefs::PoopSnipeLoc == "")
{
	PoopSnipe::Defaults();
}

$PoopSnipe::Zoom[1] = 48;
$PoopSnipe::Zoom[2] = 24;
$PoopSnipe::Zoom[3] = 12;
$PoopSnipe::Zoom[4] = 6;
$PoopSnipe::MaxZoom = 4;
$PoopSnipe::Current = $PoopPrefs::PoopSnipeDefaultZoom;
$PoopSnipe::Set = $PoopSnipe::Zoom[$PoopSnipe::Current];

function PoopSnipe::On()
{
	$PoopSnipe::On = "TRUE";
	$PoopSnipe::prevFOV = $pref::PlayerFov;
	$pref::PlayerFov = $PoopSnipe::Set;
	SenseStack::request(PoopSnipe, $PoopPrefs::PoopSnipeSense);
	if($PoopPrefs::PoopSnipeCrouchOnly == "FALSE" && $PoopPrefs::PoopSnipeCrouch == "TRUE")
	{
		postAction(2048, IDACTION_CROUCH, 1.0);
	}
	if(getItemCount($PoopPrefs::GameSnipeWeapon[$PoopTables::ModName]) == 1)
	{
		$previousWeapon = getMountedItem(0);
		use($PoopPrefs::GameSnipeWeapon[$PoopTables::ModName]);
		if($PoopPrefs::PoopSnipeCrouch == "TRUE")
		{
			postAction(2048, IDACTION_CROUCH, 1.0);
		}
	}
}

function PoopSnipe::Off()
{
	$PoopSnipe::On = "FALSE";
	$pref::PlayerFov = $PoopSnipe::prevFOV;
	SenseStack::release(PoopSnipe);
	if(getItemCount($PoopPrefs::GameSnipeWeapon[$PoopTables::ModName]) == 1)
	{
		useItem ($previousWeapon);
	}
	postAction(2048, IDACTION_STAND, 1.0);
}

function PoopSnipe::Zoom()
{
	$PoopSnipe::Current++;
	if($PoopSnipe::Current > $PoopSnipe::MaxZoom)
		$PoopSnipe::Current = 1;
	$PoopSnipe::Set = $PoopSnipe::Zoom[$PoopSnipe::Current];
	PoopSnipe::UpdateHUD();
	HUD::Update(PoopSnipe);
	if($PoopSnipe::On == "True")
	{
		$pref::PlayerFov = $PoopSnipe::Set;
	}
}

function PoopSnipe::Refresh()
{
	Schedule("HUD::Update(PoopSnipe);", 0.1);
}

function PoopSnipe::Crouch()
{
	if($PoopPrefs::PoopSnipeCrouch == "TRUE")
	{
		$PoopPrefs::PoopSnipeCrouch = "FALSE";
		$PoopPrefs::PoopSnipeCrouchbmp = "<B0,4:wontcrouch.bmp>";
	}
	else
	{
		$PoopPrefs::PoopSnipeCrouch = "TRUE";
		$PoopPrefs::PoopSnipeCrouchbmp = "<B0,4:willcrouch.bmp>";
	}
	HUD::Update(PoopSnipe);
}

function PoopSnipe::UpdateHUD()
{
	if($PoopSnipe::Current == 1)
	{
		$PoopSnipe::HudText = "2x";
	}
	else if($PoopSnipe::Current == 2)
	{
		$PoopSnipe::HudText = "5x";
	}
	else if($PoopSnipe::Current == 3)
	{
		$PoopSnipe::HudText = "10x";
	}
	else if($PoopSnipe::Current == 4)
	{
		$PoopSnipe::HudText = "20x";
	}
	if(getItemCount($PoopPrefs::GameSnipeWeapon[$PoopTables::ModName]) == 1)
	{
		%tmp1 = "<B0,4:willswitch.bmp>";
	}
	else
	{
		%tmp1 = "<B0,4:wontswitch.bmp>";
	}

	%tmp2 = $PoopPrefs::PoopSnipeCrouchbmp;
	%tmp3 = "<F2>";
	%tmp4 = $PoopSnipe::HudText;
	%text = %tmp1@%tmp2@%tmp3@%tmp4;
	HUD::AddTextLine(PoopSnipe, %text);
	return 0;
}

if(HUD::Exists(PoopSnipe))
{
	HUD::Move(PoopSnipe, $PoopPrefs::PoopSnipeLoc);
	HUD::Update(PoopSnipe);
}
else
{
	HUD::New(PoopSnipe, PoopSnipe::UpdateHUD, $PoopPrefs::PoopSnipeLoc);
	HUD::Display(PoopSnipe);
}

Event::Attach(eventClientMessage, PoopSnipe::Refresh);

//NewOpts

NewOpts::register("PoopSnipe", "PoopSnipe.gui", "PoopSnipe::onOpen();", "PoopSnipe::onClose();", TRUE);
NewOpts::registerHelp("PoopSnipe", "General", "PoopSnipe is a nifty difty sniper aid script.  It has many features compiled all through a nifty NewOpts interface.  Duh.  thats what you're looking at.");
NewOpts::registerHelp("PoopSnipe", "Zoom", "This keybind replaces the default Tribes zoom.  It cycles through 2x, 5x, 10x, and 20x.");
NewOpts::registerHelp("PoopSnipe", "Toggle", "Toggles Zooming on and off.");
NewOpts::registerHelp("PoopSnipe", "Crouch Toggle", "Toggles crouching when zoomed in. Handy for when you are behind a hill.");
NewOpts::registerHelp("PoopSnipe", "Select Sniping Weapon", "This might sound silly to all you base tribes players, but if you play on a mod, you could have the Dart rifle or a sniping equivalent selected instead of the old laser rifle.");
NewOpts::registerHelp("PoopSnipe", "Mouse Sensitivity", "I love this one.  Here you can set your mouse sensitivity while zoomed in.  When you zoom back out, your mouse sensitivity goes back to its prior state.  Who's your momma!!!  Say it!!! Say i'm your mamma!!!");
NewOpts::registerHelp("PoopSnipe", "Crouch only with sniping weapon?", "Sets whether you want the crouch toggle to work everytime you zoom or only if you have the sniper weapon.");
NewOpts::registerHelp("PoopSnipe", "Default Zoom Level", "Use this to set your deafault zoom level when you start a game of tribes.  If you want it to start off at 20x, you can do that.  2x?  No problem."); 

//Compile the Weapons selections
FGCombo::clear(PoopSnipe::SelectWeapon);
FGCombo::addEntry(PoopSnipe::SelectWeapon, "<------------------>", 0);
for(%i = 1; %i < $PoopINV::MaxWeapons; %i++)
{
	FGCombo::addEntry(PoopSnipe::SelectWeapon, $PoopINV::MenuWeapon[%i], %i);
}

//Compile the Zoom Selections
FGCombo::clear(PoopSnipe::SelectZoom);
FGCombo::addEntry(PoopSnipe::SelectZoom, "2x", 0);
FGCombo::addEntry(PoopSnipe::SelectZoom, "5x", 1);
FGCombo::addEntry(PoopSnipe::SelectZoom, "10x", 2);
FGCombo::addEntry(PoopSnipe::SelectZoom, "20x", 3);

function PoopSnipe::OnOpen()
{

	Control::Setvalue("PoopSnipe::01", "<B0,0:PoopSnipe01.bmp>");
	Control::Setvalue("PoopSnipe::02", "<B0,0:PoopSnipe02.bmp>");
	Control::Setvalue("PoopSnipe::03", "<B0,0:PoopSnipe03.bmp>");
	Control::Setvalue("PoopSnipe::04", "<B0,0:PoopSnipe04.bmp>");
	%sense = ($PoopPrefs::PoopSnipeSense)*250;
	Control::setValue(PoopSnipe::MouseSense, %sense);
	FGCombo::setSelected("PoopSnipe::SelectWeapon", $PoopPrefs::MenuSnipeWeapon[$PoopTables::ModName]);
	FGCombo::setSelected("PoopSnipe::SelectZoom", $PoopPrefs::PoopSnipeDefaultZoom - 1);
}

function PoopSnipe::OnClose()
{
	export("$PoopPrefs::*", "config\\PoopPrefs.cs", false);
}

//Select Weapon
function PoopSnipe::SetSnipeWeapon() 
{
	$PoopSnipe::WeaponSelected = FGCombo::GetSelected("PoopSnipe::SelectWeapon");
	$PoopPrefs::MenuSnipeWeapon[$PoopTables::ModName] = $PoopSnipe::WeaponSelected;
	%wep = $PoopINV::Weapon[$PoopSnipe::WeaponSelected];
	$PoopPrefs::GameSnipeWeapon[$PoopTables::ModName] = $PoopINV::Name[%wep];

}

//Select Zoom
function PoopSnipe::SetZoom()
{
	$PoopSnipe::ZoomSelected = FGCombo::GetSelected("PoopSnipe::SelectZoom")+1;
	for(%i = 1; %i <= 4; %i++)
	{
		if($PoopSnipe::ZoomSelected == %i)
		{
			$PoopPrefs::PoopSnipeDefaultZoom = %i;
			return;
		}
	}
}

function PoopSnipe::SetMouseSense()
{
	%sense = Control::getValue(PoopSnipe::MouseSense);
	$PoopPrefs::PoopSnipeSense = (%sense/250);
}