//PoopTables.cs
//By MrPoop
//Stolen largely from Zear's Autoload.cs file.  All the credit goes toward him in writing this.
//This script only works as part of the PoopFaves script.

if(isfile("Config\\PoopPrefs.cs")) 
{
	include("PoopPrefs.cs");
}

function PoopFaves::FindTables()
{
	FGCombo::Clear(PoopFaves::TableSelection);
	FGCombo::addEntry(PoopFaves::TableSelection, "<NONE>", 0);
	$PoopFaves::TableNum = 1;
	%path = $ConsoleWorld::DefaultSearchPath;
	$ConsoleWorld::DefaultSearchPath = "config";

	%file = File::findFirst("*.table.cs");
	while(%file != "")
	{
		%filename = String::getSubStr(%file, 12, 50);
		echo(%filename);
		PoopFaves::VerifyFile(%filename);
		%file = File::findNext("*.table.cs");
	}
	$ConsoleWorld::DefaultSearchPath = %path;
}

function PoopFaves::VerifyFile(%filename)
{
	$PoopFaves1::FileNum[$PoopFaves::TableNum] = %filename;
	if(isfile("Config\\Poop\\Tables\\/"@%filename))
	{	
		FGCombo::addEntry(PoopFaves::TableSelection, %filename, $PoopFaves::TableNum);
		echo("Filename Added");
		$PoopFaves::TableNum++;
	}
}

function PoopFaves::SetTableSelection ()
{
	deleteVariables("$PoopINV::*");
	deleteVariables("$PoopFaves::*");
	$PoopFaves::TableSelected = FGCombo::GetSelected("PoopFaves::TableSelection");
	$PoopPrefs::SavedLastTable = $PoopFaves::TableSelected;
	$PoopPrefs::SavedLastTableName = $PoopFaves1::FileNum[$PoopFaves::TableSelected];
	exec("Poop\\PoopLoadouts.cs");
}

function PoopFaves::TableOnOpen ()
{
	FGCombo::SetSelected("PoopFaves::TableSelection", $PoopPrefs::SavedLastTable);
}

function PoopFaves::TableOnClose()
{
	export("$PoopPrefs::*", "config\\PoopPrefs.cs", false);
}

NewOpts::register("PoopFaves - Tables", "Config\\Poop\\gui\\PoopFavesTables.gui", "PoopFaves::TableOnOpen();", "PoopFaves::TableOnClose();", true);

NewOpts::registerHelp("PoopFaves - Tables", "General", "This is a VERY important page.  From here, you select your inventory table.  If you are playing on a base server, then you should select \"Base.Table.cs\".  If you are playing on a Renegades server then you should select \"Renegades.Table.cs\", etc.  You can select this at anytime while playing tribes.  Just keep in mind that you must have the proper table chosen to use this script.  Once nice thing about it is that for each table, you have 100 definable loadouts. Meaning that for base server you have 100 separate loadouts, and whatever else moded server you play has 100 loadouts.  Flexible eh?  Thought so!  :oP");

Poopfaves::FindTables();