//
// This plugin was created by PeterT for use with MiniMod v. 0.7
// or later. The concept is original but much of the code herein
// is not. This plugin also relies on two other MiniMod plugins,
// or their equivalent code in whichever mod you are adapting:
//	Tricon's Springboard, and
//	Z-Tek's Phaselok Turret
//
// The mod creates four additional packs, that will appear in the
// inventory list under the heading "Converter Packs". Each pack
// will, when activated, convert the wearer's grenades, beacons and
// mines into other items. When turned off, normal grenades, beacons
// and mines are available.
//
// This plugin is NOT compatible with Renegades, Shifter, hvTactical,
// Ideal or any other mod which already has multiple grenade, beacon
// or mine types. It is compatible with Orion 2.4 (on which I
// developed it) and presumably with Base.
//
// Here are the details of the packs.
//
// Sensor Pack - Useable by light and medium armours, including
//		 the Engineer if present. Useful for laying down
//		 a decent sensor array, either in the field or
//		 in and around your base.
//
//	Grenade: Pulse Sensor
//	Beacon: Camera
//	Mine: Motion Sensor
//
// Assault Pack - Useable by medium and heavy armours. Useful for
//		  base-storming, especially when the bases are off
//		  the ground.
//
//	Grenade: EMP Grenade
//	Beacon: Emergency Shield
//	Mine: Springboard
//
// Saboteur Pack - Useable by light and medium armours, but not
//		   the Engineer if present. Useful for wreaking
//		   havoc inside an enemy base. A good pack for
//		   those who enjoy indirect damage.
//
//	Grenade: Plastique (15 second timer)
//	Beacon: Satchel Charge
//	Mine: Replicating Mine
//
// Defence Pack - Useable by the Light armour and the Engineer, if
//		  present. Useful for quickly laying down defences
//		  around a remote inventory station or sniper roost,
//		  or within your base.
//
//	Grenade: Hologram Mine
//	Beacon: Phaselok Turret
//	Mine: Sensor Jammer
//
// Of all the above devices, the code for the following has been
// ripped from the mods indicated and included in this plugin. Bear
// in mind that these mods may in turn have been borrowed their code
// from elsewhere, so tracing an idea back to its originator is
// not as easy as it looks.
//
//	Pulse Sensor - Shifter
//	EMP Grenade - hvTactical
//	Emergency Shield - Shifter
//	Plastique - Shifter
//	Satchel Charge - Shifter
//	Replicating Mine - Ideal
//	Hologram Mine: Renegades
//
$DamageScale[hlarmor, $EMPDamageType]	= 1.0;
$DamageScale[larmor, $EMPDamageType]	= 1.0;
$DamageScale[marmor, $EMPDamageType]	= 1.0;
$DamageScale[hlfemale, $EMPDamageType]	= 1.0;
$DamageScale[lfemale, $EMPDamageType]	= 1.0;
$DamageScale[mfemale, $EMPDamageType]	= 1.0;
$DamageScale[earmor, $EMPDamageType]	= 1.0;
$DamageScale[efemale, $EMPDamageType]	= 1.0;
$DamageScale[harmor, $EMPDamageType]	= 1.0;
$DamageScale[uharmor, $EMPDamageType]	= 1.0;

$ItemMax[hlarmor, SensorPack] = 1;
$ItemMax[hlfemale, SensorPack] = 1;
$ItemMax[larmor, SensorPack] = 1;
$ItemMax[lfemale, SensorPack] = 1;
$ItemMax[marmor, SensorPack] = 1;
$ItemMax[mfemale, SensorPack] = 1;
$ItemMax[harmor, SensorPack] = 0;
$ItemMax[uharmor, SensorPack] = 0;
$ItemMax[earmor, SensorPack] = 1;
$ItemMax[efemale, SensorPack] = 1;

$ItemMax[hlarmor, AssaultPack] = 0;
$ItemMax[hlfemale, AssaultPack] = 0;
$ItemMax[larmor, AssaultPack] = 0;
$ItemMax[lfemale, AssaultPack] = 0;
$ItemMax[marmor, AssaultPack] = 1;
$ItemMax[mfemale, AssaultPack] = 1;
$ItemMax[harmor, AssaultPack] = 1;
$ItemMax[uharmor, AssaultPack] = 1;
$ItemMax[earmor, AssaultPack] = 0;
$ItemMax[efemale, AssaultPack] = 0;

$ItemMax[hlarmor, SaboteurPack] = 0;
$ItemMax[hlfemale, SaboteurPack] = 0;
$ItemMax[larmor, SaboteurPack] = 1;
$ItemMax[lfemale, SaboteurPack] = 1;
$ItemMax[marmor, SaboteurPack] = 1;
$ItemMax[mfemale, SaboteurPack] = 1;
$ItemMax[harmor, SaboteurPack] = 0;
$ItemMax[uharmor, SaboteurPack] = 0;
$ItemMax[earmor, SaboteurPack] = 0;
$ItemMax[efemale, SaboteurPack] = 0;

$ItemMax[hlarmor, DefencePack] = 0;
$ItemMax[hlfemale, DefencePack] = 0;
$ItemMax[larmor, DefencePack] = 1;
$ItemMax[lfemale, DefencePack] = 1;
$ItemMax[marmor, DefencePack] = 0;
$ItemMax[mfemale, DefencePack] = 0;
$ItemMax[harmor, DefencePack] = 0;
$ItemMax[uharmor, DefencePack] = 0;
$ItemMax[earmor, DefencePack] = 1;
$ItemMax[efemale, DefencePack] = 1;

