//
// This plugin was created by PeterT for use with MiniMod v. 0.7
// or later. The concept is original but much of the code herein
// is not. This plugin also relies on two other MiniMod plugins,
// or their equivalent code in whichever mod you are adapting:
//	Tricon's Springboard, and
//	Z-Tek's Phaselok Turret
//
// The mod creates four additional packs, that will appear in the
// inventory list under the heading "Converter Packs". Each pack
// will, when activated, convert the wearer's grenades, beacons and
// mines into other items. When turned off, normal grenades, beacons
// and mines are available.
//
// This plugin is NOT compatible with Renegades, Shifter, hvTactical,
// Ideal or any other mod which already has multiple grenade, beacon
// or mine types. It is compatible with Orion 2.4 (on which I
// developed it) and presumably with Base.
//
// Here are the details of the packs.
//
// Sensor Pack - Useable by light and medium armours, including
//		 the Engineer if present. Useful for laying down
//		 a decent sensor array, either in the field or
//		 in and around your base.
//
//	Grenade: Pulse Sensor
//	Beacon: Camera
//	Mine: Motion Sensor
//
// Assault Pack - Useable by medium and heavy armours. Useful for
//		  base-storming, especially when the bases are off
//		  the ground.
//
//	Grenade: EMP Grenade
//	Beacon: Emergency Shield
//	Mine: Springboard
//
// Saboteur Pack - Useable by light and medium armours, but not
//		   the Engineer if present. Useful for wreaking
//		   havoc inside an enemy base. A good pack for
//		   those who enjoy indirect damage.
//
//	Grenade: Plastique (15 second timer)
//	Beacon: Satchel Charge
//	Mine: Replicating Mine
//
// Defence Pack - Useable by the Light armour and the Engineer, if
//		  present. Useful for quickly laying down defences
//		  around a remote inventory station or sniper roost,
//		  or within your base.
//
//	Grenade: Hologram Mine
//	Beacon: Phaselok Turret
//	Mine: Sensor Jammer
//
// Of all the above devices, the code for the following has been
// ripped from the mods indicated and included in this plugin. Bear
// in mind that these mods may in turn have been borrowed their code
// from elsewhere, so tracing an idea back to its originator is
// not as easy as it looks.
//
//	Pulse Sensor - Shifter
//	EMP Grenade - hvTactical
//	Emergency Shield - Shifter
//	Plastique - Shifter
//	Satchel Charge - Shifter
//	Replicating Mine - Ideal
//	Hologram Mine: Renegades
//
$TeamItemMax[ReplicatingMine] = 40;
$TeamItemMax[OriginalReplicatingMine] = 10;

for(%i = 0; %i < 8; %i++)
{
		$TeamItemCount[%i @ "originalreplicatingmine"] = 0;
		$TeamItemCount[%i @ "replicatingmine"] = 0;
}

function Grenade::onUse(%player,%item)
{
	if($matchStarted)
	{
		if(%player.throwTime < getSimTime() )
		{
			// backpack determines grenade type
			%backpack = %player.convpack;

		     	if (%backpack == "Sensor")
			{
				ScoutSensor(%clientId, %player, %item);
			}
			else if(%backpack == "Assault")
			{
				%obj = newObject("","Mine","EMPbomb");
				Player::decItemCount(%player,%item);
			}
			else if (%backpack == "Defence")
			{
				%obj = newObject("","Mine","HoloMine"); 
				Player::decItemCount(%player,%item);
			}
			else if (%backpack == "Saboteur")
			{ 
				%obj = newObject("","Mine","Nukebomb");
				%playerId = (Player::getClient(%player));
				Client::sendMessage(Player::getClient(%player),1, "Plastique Explosive will explode in 15 seconds"); 
				schedule("Grenade::Plastic_Detonate(" @ %obj @ ");", 15);
				Player::decItemCount(%player,%item);
			}
			else
			{
	                	%obj = newObject("","Mine","Handgrenade");				//====  
				Player::decItemCount(%player,%item);
			}

			//========================================= End backpack select
 	 	 	addToSet("MissionCleanup", %obj);
			%client = Player::getClient(%player);
			GameBase::throw(%obj,%player,15 * %client.throwStrength,false);
			%player.throwTime = getSimTime() + 0.5;
			GameBase::setTeam (%obj,GameBase::getTeam (%client));//
		}
	}
}

//***********************************

MineData EMPbomb
{
	mass = 0.3;
	drag = 1.0;
	density = 2.0;
	elasticity = 0.15;
	friction = 1.0;
	className = "Handgrenade";
	description = "Handgrenade";
	shapeFile = "grenade";
	shadowDetailMask = 4;
	explosionId = EMPPulseExp; 
	explosionRadius = 30.0;
	damageValue = 0.1;
	damageType = $EMPDamageType;
	kickBackStrength = 50;
	triggerRadius = 0.5;
	maxDamage = 2.0;

	lightType = 2;   // Pulsing
	lightRadius = 4;
	lightTime = 0.1;
	lightColor = { 0.75, 0.25, 0.65  };
};

function EMPbomb::onAdd(%this)
{
	%data = GameBase::getDataName(%this);
	schedule("Mine::Detonate(" @ %this @ ");",2.0,%this);
}

function Mine::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if (%type == $MineDamageType)
      %value = %value * 0.25;

	%damageLevel = GameBase::getDamageLevel(%this);
	GameBase::setDamageLevel(%this,%damageLevel + %value);
}

function Mine::Detonate(%this)
{
	%data = GameBase::getDataName(%this);
	GameBase::setDamageLevel(%this, %data.maxDamage);
}

//***********************************

MineData HoloMine
{
	className = "Mine";
	description = "Hologram";
	shapeFile = "larmor";
	shadowDetailMask = 4;
	explosionId = mineExp;
	explosionRadius = 15.0; //250
	damageValue = 0.75; //0
	damageType = $MineDamageType;
	kickBackStrength = 350; //500
	triggerRadius = 2.5; //250
	maxDamage = 2.00;//0
	shadowDetailMask = 0;
	destroyDamage = 1.0;
	damageLevel = {1.0, 1.0};
};

function HoloMine::onAdd(%this)
{
	echo("Hologram Mine Deployed");
	%this.damage = 0;
	HoloMine::deployCheck(%this);
	%data = GameBase::getDataName(%this);
//	schedule("Mine::Detonate(" @ %this @ ");",120.0,%this);

}

//***********************************

MineData ReplicatorMine
{
	className = "Mine";
   description = "Replicating Mine";
   shapeFile = "mine";
   shadowDetailMask = 4;
   explosionId = mineExp;
	explosionRadius = 10.0;
	damageValue = 0.65;
	damageType = $MineDamageType;
	kickBackStrength = 150;
	triggerRadius = 2.5;
	maxDamage = 0.5;
	shadowDetailMask = 0;
	destroyDamage = 1.0;
	damageLevel = {1.0, 1.0};
};

function ReplicatorMine::onAdd(%this)
{
	%this.damage = 0;
	ReplicatorMine::deployCheck(%this);
}

function ReplicatorMine::onCollision(%this,%object)
{
	%type = getObjectType(%object);
	%data = GameBase::getDataName(%this);
	if (((%type == "Player")  || %data == Vehicle || %type == "Moveable") && GameBase::isActive(%this) && (GameBase::getTeam(%this)!=GameBase::getTeam(%object))) //JR 1/31/99
		GameBase::setDamageLevel(%this, %data.maxDamage);
}

function ReplicatorMine::deployCheck(%this)
{
	if(GameBase::isAtRest(%this))
	{

		%team = GameBase::getTeam(%this);
		echo(%team @ " in deploy check");

		$TeamItemCount[%team @ "replicatingmine"]++;
		if(%this.generation == 0)
			$TeamItemCount[%team @ "originalreplicatingmine"]++;

		GameBase::playSequence(%this,1,"deploy");
	 	GameBase::setActive(%this,true);
		%set = newObject("set",SimSet);
		if(1 != containerBoxFillSet(%set,$MineObjectType,GameBase::getPosition(%this),1,1,1,0) || $TeamItemCount[%team @ "replicatingmine"] > $TeamItemMax[ReplicatingMine] || $TeamItemCount[%team @ "originalreplicatingmine"] > $TeamItemMax[OriginalReplicatingMine])
		{
			%this.generation = 5;
			%data = GameBase::getDataName(%this);
			GameBase::setDamageLevel(%this, %data.maxDamage);
			if($TeamItemCount[%team @ "originalreplicatingmine"] > $TeamItemMax[OriginalReplicatingMine])
				$TeamItemCount[%team @ "originalreplicatingmine"]--;
		}
		deleteObject(%set);
	}
	else 
		schedule("ReplicatorMine::deployCheck(" @ %this @ ");", 3, %this);
}	

function ReplicatorMine::onDestroyed(%this)
{
	%team = GameBase::getTeam(%this);
	echo(%team @ " in on Destroyed");

	$TeamItemCount[%team @ "replicatingmine"]--;

	if(%this.generation < 4)
		replicateMines(%this, %this.generation+1);
}

function ReplicatorMine::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if (%type == $MineDamageType)
      %value = %value * 0.3;

	%data = GameBase::getDataName(%this);
	if((%data.maxDamage/1.5) < %this.damage+%value) 
		GameBase::setDamageLevel(%this, %data.maxDamage);
	else 
		%this.damage += %value;
}

function replicateMines(%this, %generation)
{
	%team = GameBase::getTeam(%this);
echo("Creating generation " @ %generation @ " for team " @ %team);

	%obj = newObject("","Mine","ReplicatorMine");
 	addToSet("MissionCleanup", %obj);
	GameBase::throw(%obj,%this,-1.5,false);
	%obj.generation = %generation;

	GameBase::setTeam(%obj, %team);

	%obj = newObject("","Mine","ReplicatorMine");
	addToSet("MissionCleanup", %obj);
	GameBase::throw(%obj,%this,1.5,false);
	%obj.generation = %generation;

	GameBase::setTeam(%obj, %team);
}

//*************************************

MineData Nukebomb
{
   mass = 0.3;
   drag = 1.0;
   density = 2.0;
	elasticity = 0.0;
	friction = 99.0;
	className = "Handgrenade";
   description = "Plastique";
   shapeFile = "sensor_small";
   shadowDetailMask = 4;
   explosionId = rocketExp;
	explosionRadius = 10.0;
	damageValue = 2.0;
	damageType = $MortarDamageType;
	kickBackStrength = 300;
	triggerRadius = 0.5;
	maxDamage = 2.0;
};

function Nukebomb::onAdd(%this)
{	
	%obj = %this;
	%data = GameBase::getDataName(%this);
	//Grenade::OnUse(" @ %this @ ");
}

function Nukebomb::onCollision(%this,%obj)
{
    if(getObjectType(%obj) != "Player")
	{
        return;
	}

    if(Player::isDead(%obj))
	{
        return;
	}

    %c = Player::getClient(%obj);


    %playerTeam = GameBase::getTeam(%obj);
	%teleTeam = GameBase::getTeam(%this);
	
		%armor = Player::getArmor(%obj);
   		if (%armor == "earmor" || %armor == "efemale")
		{
			%rnd = floor(getRandom() * 10);
			if(%rnd > 8)
			{	
				Client::sendMessage(%c,1,"OOPS! You cut the wrong wire...");
				Mine::Detonate(" @ %this @ ");
				return;
			}
			else
			{	
				deleteObject(%this);
				Client::sendMessage(%c,1,"You disarm the Plastique Explosive.");
			}
		}
 
  
}

function Nukebomb::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if (%type == $MineDamageType)
      %value = %value * 0.25;

	%damageLevel = GameBase::getDamageLevel(%this);
	GameBase::setDamageLevel(%this,%damageLevel + %value);
}

function Nukebomb::Detonate(%this)
{
	%data = GameBase::getDataName(%this);
	GameBase::setDamageLevel(%this, %data.maxDamage);
}

