// ---------------------------------------------------------------------------
// ping.cs -- Version 2.2 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


include("writer\\version.cs");
version("writer\\ping.cs", "2.2", "Lorne Laliberte", "- May 22, 1999 - ping related functions - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\ladder.cs");


//
// Get current ping
//
function Ping::get(%quiet)
{
    if($GetPing::Receive == $Ping::getSend)
        deleteVariables("$GetPing::*");

    $GetPing::Send++;
    if($GetPing::Send > 1000)
        $GetPing::Send = 1;

    %id = $GetPing::Send;

    $GetPing::Sent[%id] = getSimTime();

    if(%quiet == quiet)
        $GetPing::Message[%id] = false;
    else
        $GetPing::Message[%id] = true;

    remoteEval(2048, buyItem, 0);
}


//
// Call function after sending message to server and back
//
function Ping::wait(%function, %pings)
{
    if( $Ping::Receive == $Ping::Send)
        deleteVariables("$Ping::*");

    if(!%pings)
        %pings = 1;

    $Ping::Send++;
    if($Ping::Send > 1000)
        $Ping::Send = 1;

    %id = $Ping::Send;

    $Ping::Again[%id] = %pings;
    $Ping::Waiting[%id] = true;
    $Ping::Function[%id] = %function;

    remoteEval(2048, buyItem, -1);
    
    return %id;
}


//
// Clear all the Ping::wait-related variables...I don't bother clearing the Ping::get stuff
// because I'm not using it yet, and I've had really bad luck with back-to-back deleteVariables
//
function Ping::reset()
{
    deleteVariables("$Ping::*");
}
Event::Attach(eventConnected, "Ping::reset();");
Event::Attach(eventChangeMission, "Ping::reset();");


//
// Cancel a specific pending Ping::wait function call
//
// Call with no arguments to cancel the next pending call
//
function Ping::cancel(%id)
{
    if(%id == "")
    {
        %id = $Ping::Receive + 1;
        if(%id > 1000)
            %id = 1;
    }
    $Ping::Function[%id] = "";
}


//
// Watch for our sneaky little "You couldn't buy Flag/False" messages :)
//
function Ping::ladderClientMessage(%msg)
{
    if(%msg == "You couldn't buy Flag")
    {
        %receive = $GetPing::Receive + 1;
        if(%receive > 1000)
            %receive = 1;

        if($GetPing::Sent[%receive])
        {
            %id = $GetPing::Receive = %receive;

            %now = getSimTime();

            $PingDelay = (%now - $GetPing::Sent[%id]);
    
            $GetPing::Sent[%id] = 0;

            if($GetPing::Message[%id])
                remoteBP(2048, "<L5>Time to server and back: <f1>" @ floor($PingDelay * 1000) @ "<f0> milliseconds", 4);
        
        }
        return truemute;
    }
    
    if(%msg == "You couldn't buy False")
    {
        %receive = $Ping::Receive + 1;
        if(%receive > 1000)
            %receive = 1;

        if($Ping::Waiting[%receive])
        {
            %id = %receive;

            $Ping::Again[%id]--;

            if($Ping::Again[%id])
            {
                remoteEval(2048, buyItem, -1);
                return mute;            
            }

            $Ping::Receive = %receive;

            if($Ping::Function[%id] != "")
                eval($Ping::Function[%id]);
        }
        return truemute;
    }
    return false;
}
Event::Attach(ladderClientMessage, Ping::ladderClientMessage);


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("actionMap.sae"); 
    
    // Update ping value
    bindCommand(keyboard0, make, alt, "p", TO, "Ping::get();");
    bindCommand(keyboard0, break, alt, "p", TO, "");
}
