// ---------------------------------------------------------------------------
// pack_and_back.cs -- Version 2.1 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


include("writer\\version.cs");
version("writer\\pack_and_back.cs", "2.1", "Lorne Laliberte", "- May 22, 1999 - switch to repair pack and back - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\inventory_table.cs");
include("writer\\item_events.cs");


//
// Switch back to previous weapon if the repair pack is dropped
// when the repair gun is mounted
//
function PackAndBack::onUnmount(%weapon)
{
    if(%weapon == $Inv::Repair_Gun)
    {
        if( ($OldWeapon == "") || ($OldWeapon == -1) )
        {
            nextWeapon();
        }
        else
        {
            if(getItemCount($Inv::Name[$OldWeapon]))
                newUseItem($OldWeapon);
            else
                nextWeapon();
        }
    }
}
Event::Attach(eventUnmount, PackAndBack::onUnmount);


//
// Re-select the previously selected weapon when a repair pack is turned off
//
function PackAndBack::onUse(%itemtype, %itemname)
{
    %pack = getMountedItem(1);
    %weapon = getMountedItem(0);

  	if(%itemtype == $Inv::Repair_Pack)
  	{	
        // Repair packs replace the currently selected weapon
        // with the RepairGun, and are turned off by selecting
        // a different weapon

  	    if(%weapon == $Inv::Repair_Gun)
  	    {
            // Do we know what weapon was selected before?
            if( ($OldWeapon == "") || ($OldWeapon == -1) )
            {
                // No -- switch to next available weapon
                nextWeapon();
            }
            else
            {
                // Yes -- switch back to previously selected weapon
                newUseItem($OldWeapon);
            }

            // We need to cancel the useItem() call for the repair pack
            // or the useItem call for $OldWeapon won't get through.
            // By returning "mute" we tell use() not to issue the useItem() call.

            return mute;
  	    }
  	    else
  	    {
            // Switch to the repair pack and remember which weapon
            // was selected so we can switch back to it later
      		$OldWeapon = %weapon;
  	    }
  	}
  	return;
}
Event::Attach(eventUse, PackAndBack::onUse);
