// ---------------------------------------------------------------------------
// mmb_repair.cs -- Version 2.1 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\mmb_repair.cs", "2.1", "Lorne Laliberte", "- May 22, 1999 - middle mouse button repair - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\inventory_table.cs");
include("writer\\pack_and_back.cs");
include("writer\\am_repair.cs");

// Set default weapon to use if no repair/shield/jammer pack
Event::Attach(eventInventoryTableReady, "$MMB::Weapon = $Inv::Laser_Rifle;");

//
// Start repairing an object (or yourself), automatically stopping and restoring your
// previously selected weapon when the repair is complete.
// Stop at any time during the repair (and restore the previously selected weapon)
// by clicking the middle mouse button before the repair is complete.
// If no repair pack, toggle shield or jammer pack on and off.
// If no repair, shield or jammer pack, switch to the weapon specified in $MMB::Weapon.
// And if that weapon isn't carried, use a repair kit if you have one.
//
function MMB::onButtonClick()
{
    %pack = getMountedItem(1);
    if($MMB::Repairing && (getMountedItem(0) == $Inv::Repair_Gun))
    {
        // Interrupt repair
        MMB::StopRepair();
    }
    else
    {
        if(%pack != -1) // we're carrying a pack
        {
          	if(%pack == $Inv::Repair_Pack) // it's a repair pack
            {
                // We may be in the process of stopping a repair, so 
                // we need to make sure we aren't waiting for the
                // switch to our previously selected weapon to finish.
                // If we don't we'll end up switching back to our
                // previously selected weapon and start firing at what
                // we're trying to repair.  This is required because there
                // is an inherent delay in switching weapons, and the
                // new weapon isn't seen as mounted until the switch
                // is complete.

                if(!$MMB::Stopping) // we're not still switching back
                {
                    if(getMountedItem(0) != $Inv::Repair_Gun)
                    {
                        // Switch to repair gun
                        newUseItem($Inv::Repair_Pack);
                    }
                    
                    MMB::StartRepair();
                }
                return;
            }
          	else if(%pack == $Inv::Shield_Pack)
            {
                // Toggle shield pack on or off
                use(backpack);
                return;
            }
          	else if(%pack == $Inv::Sensor_Jammer_Pack)
            {
                // Toggle jammer pack on or off
                use(backpack);
                return;
            }
        }

        // We're not carrying a repair, shield or jammer pack
      	if(getItemCount($Inv::Name[$MMB::Weapon]))
        {
            if((%weapon = getMountedItem(0)) == $MMB::Weapon) // We're already using the "no pack" weapon
            {
                if( ($MMB::PrevWeapon != "") && ($MMB::PrevWeapon != -1) )
                {
                    if(MMB::AmmoCheck($MMB::PrevWeapon)) // weapon has ammo or doesn't need it
                    {
                        // Switch to previous weapon if we're carrying it
                        newUseItem($MMB::PrevWeapon);
                    }
                    else // out of ammo for previous weapon
                    {
                        // Switch to next available weapon with ammo
                        nextWeapon();
                    }
                }
                else
                {
                    // Switch to next available weapon with ammo
                    nextWeapon();
                }
            }
            else // we're not already using the "no pack" weapon
            {
                // Remember current weapon
                $MMB::PrevWeapon = %weapon;

                if(MMB::AmmoCheck($MMB::Weapon)) // weapon has ammo or doesn't need it
                {
                    // Switch to "no pack" weapon if we're carrying it
                    newUseItem($MMB::Weapon);
                }
                else // out of ammo for "no pack" weapon
                {
                    // Switch to next available weapon with ammo
                    nextWeapon();
                }
            }
        }
        else
        {
            // We're not carrying the "no pack" weapon
            // so switch to next weapon
            nextWeapon();
        }
    }
}

//
// Return true if weapon has any ammo left (or doesn't need any)
//
function MMB::AmmoCheck(%weapon)
{
    %ammo = $Inv::Ammo[%weapon];
    return (%ammo == "") || getItemCount(%ammo);
}

//
// Wait for the Repair Gun to be mounted then start the repair
//
function MMB::StartRepair()
{
    if(getMountedItem(0) == $Inv::Repair_Gun)
    {
        // Turn repair pack on
        postAction(2048, IDACTION_FIRE1, -0);
        $MMB::Repairing = 1;
    }
    else
    {
        // Repair gun isn't mounted yet, wait another 0.1 seconds
        schedule("MMB::StartRepair();", 0.1);
    }
}

//
// Stop repairing and switch back to previously selected weapon
//
function MMB::StopRepair()
{
    $MMB::Repairing = 0;

    // Turn repair pack off
    postAction(2048, IDACTION_BREAK1, -0);

    if( ($OldWeapon != "") && ($OldWeapon != -1) )
        newUseItem($OldWeapon); // switch back to previously selected weapon
    else
        nextWeapon();

    MMB::VerifyStop();
}

//
// Prevent any more middle mouse button repairs until after we've switched
// back to the previous weapon
//
function MMB::VerifyStop()
{
    if( ($OldWeapon != "") && ($OldWeapon != $Inv::Repair_Gun) )
    {
        if(getMountedItem(0) == $Inv::Repair_Gun)
        {
            $MMB::Stopping = 1;
            schedule("MMB::VerifyStop();",0.1);
        }
        else
        {
            $MMB::Stopping = 0;
        }
    }
}


//
// Set the currently selected weapon as the weapon to use on
// a MMB click if not carrying any repair/shield/jammer pack
//
function MMB::selectWeapon()
{
    if((%weapon = getMountedItem(0)) != -1)
    {
        if (%weapon != $Inv::Repair_Gun) // prevent potential headaches :)
        {
            $MMB::Weapon = %weapon;
        	remoteBP(2048, "<L5><f0>Middle Mouse Button Click <f1>no-pack weapon<f0> set to <f1>" @ $Inv::Name[$MMB::Weapon] @"<f0>", 5);
        }
    }
}


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("actionMap.sae"); 
    
    // Use repair pack, etc.
    bindCommand(mouse0, make, button2, TO, "MMB::onButtonClick();");
    bindCommand(mouse0, break, button2, TO, "");

    // Select current weapon as Middle Mouse Button weapon    
    bindCommand(keyboard0, make, r_alt, "m", TO, "MMB::selectWeapon();");
    bindCommand(keyboard0, break, r_alt, "m", TO, "");
}
