// ---------------------------------------------------------------------------
// item_events.cs -- Version 1.1 -- May 20, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\item_events.cs", "1.1", "Lorne Laliberte", "- May 20, 1999 - adds item events - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\inventory_table.cs");


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


//
// Returns true if weapon has ammo or doesn't need any
//
function AmmoCheck(%weapon)
{
    %ammo = $Inv::Ammo[%weapon];
    return (%ammo == "") || getItemCount(%ammo);
}


//
// Use this instead of useItem() to automatically trigger the
// eventUse and eventWeaponSwitch events as appropriate
//
function newUseItem(%itemtype)
{
    if(%itemtype == $Inv::Backpack)
        %itemtype = getMountedItem(1);

    if(%itemtype == $Inv::Weapon)
        %itemtype = getMountedItem(0);

    if(%itemtype != -1)
    {
        Event::Trigger(eventUse, %itemtype, $Inv::Name[%itemtype]);

        if( !Event::Returned(eventUse, mute) )
        {
            %weapon = getMountedItem(0);
            %pack = getMountedItem(1);

            // The client useItem function will make sure the use is
            // sequenced correctly with trigger events.  The remoteEval
            // works fine but may be delivered out of order.
            // remoteEval(2048,useItem,%itemtype);
            useItem(%itemtype);

            if(%itemtype == $Inv::Repair_Pack)
            {
                if( (%pack == $Inv::Repair_Pack) && (%weapon != $Inv::Repair_Gun) )
                    Event::Trigger(eventWeaponSwitch, $Inv::Repair_Gun, %weapon);

                return;
            }

            if(%itemtype != %weapon)
            {
                for(%i = $Inv::WeaponCount; %i > 0; %i--)
                {
                    if(%itemtype == $Inv::WeaponList[%i])
                    {
                        if(AmmoCheck(%itemtype))
                            Event::Trigger(eventWeaponSwitch, %itemtype, %weapon);

                        return;
                    }
                }
            }
        }
    }
    else
    {
        echo("Unknown item type \"" @ %itemtype @ "\"");
    }
}


//
// Override the use() function in client.cs
//
function use(%itemname)
{
    %itemtype = getItemType(%itemname);

    if(%itemname == backpack)
    {
        %itemtype = getMountedItem(1);
        %itemname = $Inv::Name[%itemtype];
    }

    if(%itemname == weapon)
    {
        %itemtype = getMountedItem(0);
        %itemname = $Inv::Name[%itemtype];
    }

    if(%itemtype != -1)
    {
        Event::Trigger(eventUse, %itemtype, %itemname);

        if( !Event::Returned(eventUse, mute) )
        {
            %weapon = getMountedItem(0);
            %pack = getMountedItem(1);

            // The client useItem function will make sure the use is
            // sequenced correctly with trigger events.  The remoteEval
            // works fine but may be delivered out of order.
            // remoteEval(2048,useItem,%itemtype);
            useItem(%itemtype);

            if(%itemtype == $Inv::Repair_Pack)
            {
                if( (%pack == $Inv::Repair_Pack) && (%weapon != $Inv::Repair_Gun) )
                    Event::Trigger(eventWeaponSwitch, $Inv::Repair_Gun, %weapon);

                return;
            }

            if(%itemtype != %weapon)
            {
                for(%i = $Inv::WeaponCount; %i > 0; %i--)
                {
                    if(%itemtype == $Inv::WeaponList[%i])
                    {
                        if(AmmoCheck(%itemtype))
                            Event::Trigger(eventWeaponSwitch, %itemtype, %weapon);

                        return;
                    }
                }
            }
        }
    }
    else
    {
        echo("Unknown item \"" @ %itemname @ "\"");
    }
}


//
// Override the drop() function in client.cs
//
function drop(%itemname)
{
    %itemtype = getItemType(%itemname);

    if(%itemname == backpack)
        %itemtype = getMountedItem(1);

    if(%itemname == weapon)
        %itemtype = getMountedItem(0);

    if(%itemtype != -1)
    {
        if(getItemCount(%itemname))
            Event::Trigger(eventDrop, %itemtype, %itemname);

        %weapon = getMountedItem(0);

        if( !Event::Returned(eventDrop, mute) )
            remoteEval(2048, dropItem, %itemtype);

        if(%weapon == $Inv::Repair_Gun)
        {
            if(%itemtype == $Inv::Repair_Pack)
            {
                Event::Trigger(eventUnmount, %weapon);
                return;
            }
        }

        if(%itemtype == %weapon)
        {
            Event::Trigger(eventUnmount, %weapon);
            return;
        }
    }
    else
    {
        echo("Unknown item \"" @ %itemname @ "\"");
    }
}


//
// Override the nextWeapon() function in client.cs
//
function nextWeapon()
{
    %weapon = getMountedItem(0);

    // Up to the server right now
    remoteEval(2048,nextWeapon);

    Event::Trigger(eventWeaponSwitch, "", %weapon);
}


//
// Override the prevWeapon() function in client.cs
//
function prevWeapon()
{
    %weapon = getMountedItem(0);

    // Up to the server right now
    remoteEval(2048,prevWeapon);

    Event::Trigger(eventWeaponSwitch, "", %weapon);
}

