// ---------------------------------------------------------------------------
// fire_on_my_target.cs -- Version 1.4 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\fire_on_my_target.cs", "1.4", "Lorne Laliberte", "- May 22, 1999 - automatically says 'fire on my target' - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\fire.cs");
include("writer\\flood.cs");
include("writer\\whatif.cs");
include("writer\\inventory_table.cs");


//
// Automatically say "Fire on my target" when you fire the targeting laser
// unless you already said that in the last 15 seconds :)
//
function AutoMessage::FireOnMyTarget(%weapon)
{
	if(%weapon == $Inv::Targeting_Laser)
	{
        if($FireOnMyTarget::Enabled)
        {
    		if(Flood::Protect(FireOnMyTarget, 15))
    			say(1, "Fire on my target~wfiretgt");
        }
	}
}
Event::Attach(eventWeaponFired, AutoMessage::FireOnMyTarget);


function FireOnMyTarget::Toggle()
{
    remoteBP(2048, "<L5>Automatically say \"Fire on my target\" " @ wif($FireOnMyTarget::Enabled = !$FireOnMyTarget::Enabled, "ON", "OFF"), 4);
}


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae");

    // Toggle the automatic "Fire on my target" message 
    bindCommand(keyboard0, make, alt, "f", TO, "FireOnMyTarget::Toggle();");
    bindCommand(keyboard0, break, alt, "f", TO, "");
}
