// ---------------------------------------------------------------------------
// drop_ammo.cs -- Version 1.1 -- April 9, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


include("writer\\version.cs");
version("writer\\drop_ammo.cs", "1.1", "Lorne Laliberte", "- April 9, 1999 - drop unnecessary ammo - www.planetstarsiege.com/lorne/");

include("writer\\inventory_table.cs");

//
// Drop any ammo we're carrying if we aren't carrying a weapon that needs it
//
function dropUnnecessaryAmmo()
{
    for(%itemtype = 100; %itemtype > 0; %itemtype--)
    {
        if( (%ammo = $Inv::Ammo[%itemtype]) != "" ) // this item (weapon) can use ammo
        {
            if(!getItemCount($Inv::Name[%itemtype])) // we don't have this weapon
            {
                // Drop this unnecessary ammo
                if(getItemCount(%ammo))
                {
                    for(%i = 0; %i < 20; %i++)
                    {
                        drop(%ammo);
                    }
                }
            }
        }
    }
}


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae"); 
    
    // Drop unnecessary ammo
    bindCommand(keyboard0, make, alt, "n", TO, "dropUnnecessaryAmmo();");
    bindCommand(keyboard0, break, alt, "n", TO, "");
}
