// -----------------------------------------------------------------------------------
// WARPOINTER v1.0g
// The Automatic Waypointing System Toolkit
// by Rayn 
// Rayn@planet-tribes.com
// Rayn's Scripting Archives:  http://www.planet-tribes.com/rayn
// -----------------------------------------------------------------------------------
// 				Visit WWW.PLANET-TRIBES.COM
// ----------------------------------------------------------------------------------- 		
// DESCRIPTION:
// WarPointer is a toolkit designed around the use of a waypointing system.  You can
// use it to find waypoints, and then use it to integrate them into your scripts.
// Currently utilized in WarPoints, The Automatic Waypointing System. (included)
// 
// REQUIRED FILES:
// Presto Pack >= 0.93
// Crunchy's Events.cs (included)
//
// INSTALL NOTES:
// unzip to your config directory and everything should go where it belongs.
// to verify here's the file list:
// config\rayn\warpoint_readme.txt 
// config\rayn\warpointer.cs
// config\rayn\warpoints.cs
// config\crunchy\events.cs
// 
// Add the following line to config\autoexec.cs:
//
// Include("rayn\\warpoints.cs");
//
// This will bind (alt-w) to the new warpointing (waypointing) menu.
// You can set this in preferences but you I recommend keeping the
// alt-w.
// ---------------------------------------------------------------------------
// Bug reports, suggestions, ideas, waypoints: rayn@planet-tribes.com
// ----------------------------------------------------------------------------------
// INDEX OF WARPOINTER DOCS:
//
// I. Using Warpointer in your scripts
// II. Adding New Waypoints to Warpoints
//    a. Adding New Levels
//    b. Adding to Existing Levels (note: read both!)
// III. Using the Waypoint Exportation Tool (WET)
// ----------------------------------------------------------------------------------
// I. Using WarPointer in your scripts:
// -----------------------------------------------------------------------------------
// Let's try to understand how the script works:
// When you start a new mission, a call is made that triggers the following:
// eventWarpointInitLevel()
// this event is attached to a function that resets our stored waypoints, and in the case
// of the WarPoints tool, resets our menus so we don't have old waypoints from past levels.
// Then a call is made to Warpointer::levelname::Init();
// Level name is obtained in two ways from the console:
// 1) echo($ServerMission)
// 2) Using WET (see below)
// The function much match levelname exactly i.e:
// Warpointer::Desert_Of_Death::Init() works
// Warpointer::DesertOfDeath::Init() will do nothing.
// You don't need to know this just yet unless you're adding levels though.
//  
// The init() function makes calls to:
// Waypointer::initWaypoint("Label",%team,%x,%y)
// for all defined Waypoints
//
// Label is the name of the target i.e "Base"
//
// %team is either 0,1,5.  0 for Blood Eagle (default), or 1 for Diamond Sword (default)
// team 5 is for neutral things like objectives, weapons, and items
// 
// %x and %y are the coordinates obtained using WET (see below) or some other more difficult tactic.
// For every waypoint that is initialized it triggers eventWarpointNewWaypoint(%name, %team, %x, %y)
// To this event you should attach a function that will handle your new waypoint.
// Warpoints takes every triggered waypoint and adds it to its menu.  I can't think
// of anything else you would possibly do with waypoints but add them to
// menus .. but you never know.
//
// Next is support for tracking every player in the game.  On drops, team changes
// connects, and joins eventWarpointInitPlayers is called.  Attach a function
// to reset your old menu or whatever and eliminate the old list of players.
// then for every player in the game, evertWarpointNewPlayer(%client) is called
// %client = the client's ID number (i.e 2049) what you do with this is
// your business.  Examine Warpoints to see what I did.
//
// In summary:
// 1) eventWarpointInitLevel called on new level
// 2) eventWarpointNewWaypoint(%name, %team, %x, %y) called for every
//    stored waypoint
// 3) eventWarpointInitPlayers called on connect, client join, client drop,
//      or client change team.
// 4) eventWarpointNewPlayer(%clientid) called for every player in the game
//
// These docs are not great, but what else besides something very
// similar to Warpoints could the waypoints be used with? Beats me.
// Thus, examine Warpoints for script examples.
// -----------------------------------------------------------------------------------
// II. Adding Waypoints to Warpointer:
// -----------------------------------------------------------------------------------
// There are two ways to add waypoints, adding to an already defined level (all 
// base levels are defined in this script) and defining a whole new level of waypoints.
// 
// a. ADDING NEW MISSIONS
// -------------------
// Every time a level is loaded, Warpointer tries to run the function:
// Warpointer::%level_name::init().  If no function is defined the
// level does not load any waypoints.  Thus, this level is not supported.
// If you wanted to add support for a new mission you would have to define
// a new Warpointer::$level_name::init() function.  Lets examine the
// structure of one of these:
//
// Warpointer::WooHooWalkabout::Init()
// {
//   Warpointer::newWaypoint("Base",0,342,234);
//   $Warpointer::success = true;
//   Event::Trigger("eventWarpointWooHooWalkabout");
// }
// Three parts to the level init function:
// 1) waypoints, triggered in the manner that follows:
//    a call to Warpointer::newWaypoint(%label,%team,%x,%y);
// %label = the target's name
// %team = 0 for team 0 (Blood Eagle by default)
//         1 for team 1 (Diamond Sword by default)
//         5 for non team items (placed in neutral menu)
// %x,%y are the co-ordinates you obtain using the WET (see docs below)
// 2) $warpointer::success = true;
//    Always add this so warpointer knows the level was loaded and exists.
// 3) Event::Trigger("eventWarpointWoohooWalkabout")
//    Always trigger an eventWarpointMissionName at the end of your new
//    level definition so additional waypoints can be added later.
//
// The above script would be placed in a new file (NOT THIS ONE) and then
// included anywhere after the line Include("rayn\\warpoints.cs") in your
// autoexec.cs.  You only need to define a new level Init function if the
// level you want waypoints on is not supported. Otherwise you have
// a simpler job.
//
// --------------------------
// b. ADDING WAYPOINTS TO EXISTING MISSIONS:
// ---------------------------
// Say you want to add waypoints to the level Dangerous Crossing (missionname: DangerousCrossing)
// [BTW: For additional correct missionames and events look below in the Waypointer::levels::init() functions]
// 
// You'll need to define a function in a new script file (any name) i.e:
//
// Event::attach(eventWarpointDangerousCrossing, "myscript::myfunction");
//
// function myscript::myfunction {
// Warpointer::InitWaypoint("Plasma Turret",0,400,500);
// Warpointer::InitWaypoint("Outside",5,324,492);    // these are made up co-ordinates
// }
// Notice the structure of the warpoint adding command:
//
// Warpointer::InitWaypoint("Waypoint Label","Team","X","Y");// Read the new level section to understand why you must attach the function
//
// Reminder: team 0 = blood eagle (or equivalent), 1 = diamond sword (or equivalent)
// and 5 = belongs to neither team.
// 
// You'll have to add this line to your autoexec.cs:
// Include("yourFileName.cs"); after the line Include("rayn\\warpoints.cs");
//
// Now what will happen is when my functions are finished adding waypoints to the Broadside waypoint menu in
// warpoints, your function (above) will be called and add two more waypoints:
// Plasma Turret - Blood Eagle (team 0) - at (400,500)
// Outside - Neutral (team 5) - at (324, 492)
// The function is called because you attached it to (eventWarpointDangerousCrossing)
// and all level init definitions will trigger a similar (eventWarpointMissionName) event.
// thus, telling your script to send its waypoints to warpoints. It won't work
// if you don't attach!
//
// When you are on team blood eagle, the plasma turret will be placed in the friendly target menu,
// and conversely if you're on diamond sword placed in the enemy.  Neutral targets are always placed
// in the neutral menu.
//
// Understand?
// Pretty easy, but please don't attempt to modify the already stored waypoints in this file or you
// may encounter trouble.  If you have questions regarding this process contact me rayn@planet-tribes.com
// 
// A brief note: Using WET (see docs below) is the best method I know for finding new waypoints.  
// <NOTE:?>
// Once you have your waypoints: Defined a bunch of new waypoints? Send them in to me and I'll include them
// in the next release and credit you!! rayn@planet-tribes.com
//
//
// THINGS YOU SHOULD NEVER DO:
// 1) Trigger an event in your own function for a previously defined level i.e:
// function myscript::myfunction {
// Warpointer::InitWaypoint("Plasma Turret",0,400,500);
// Warpointer::InitWaypoint("Outside",5,324,492);    // these are made up co-ordinates
// Event::Trigger(eventWarpointBroadside);
// }
//
// This will cause an endless loop in this case, but in others it will just destroy the menu and probably
// crash tribes. For a list of defined levels (all base except 5 f&R in beta version) go much farther down
// in the script.  
// 
// 2) Add waypoints in the defined sections in warpointer.cs (this script):
// Use a new script file and attach the event, otherwise you may encounter trouble plus no one else
// will ever be able to use your waypoints unless you distribute your modified script, which I frown upon
// because then people will all have different versions and this may cause trouble for my TeamCommander
// script (currently in alpha) and others who may use this script for support.
// 
// -----------------------------------------------------------------------------------
// III. DOCUMENTATION ON THE WET (Waypoint Exporting Tool):
// -=---------------------------------------------------------------------------------
// Use Warpoint Exporting Tool(WET): Use this to mark waypoints while you PLAY ON YOUR
// OWN HOSTED GAME (ONLY!) Please refer to above for information on adding levels and 
// waypoints to Warpointer.  To use the marking tool, first set findWaypoints to true.
// Then you must host your own game on the level of your choice.  Go to the location you
// wish to mark on foot.  Now hit 'T' to talk.  Type a label for this waypoint.
// Now Hit F9 (unless you have changed the key bindings below). 
//
// One of two things will happen:
// 1) You'll receive a message that the waypoint was marked. This is good.
// 2) You'll receive a message that the marking fails.  This can happen
// because in order to function, WET can only test a certain percentage
// of all existing coordinates to match your current waypoint.  What that
// means is a few holes are left, and you've encountered one. If you encounter
// a hole, you just need to readjust your position and try again until you
// mark the waypoint.  Don't worry about being right on the money, close enough
// is good enough.  Bigger levels have bigger holes.  This is a real pain
// in the ass.  Cases in point: Tale Of Two Bases, CrissCross.  Its gonna
// piss you off, trust me.  But hey, this is much easier than doing it
// using the console.
//
// Now say you've collected a nice bit of waypoints.  You want to save them!
// Hit F11.  You'll get a message telling you the waypoints were saved.
// These new waypoints go into the file config\\warpoints.txt.
// You can press F11 multiple times in the same Tribes session and all
// of the saved waypoints will be stored without overwriting the old ones.
// However: if you were to save a bunch of points, quit, come back and do
// it again, you're old ones would be erased.  To combat this, when trying
// to save waypoints, if there exists the file config\\warpoints.txt,
// it is copied to warpoints0.txt to back them up.  If that's taken
// then we use warpoints1.txt .. etc etc.
//
// What do you do with the WET files you ask?
//
// Take a look at it, you'll have something similar to the following:
//
// $Warpointer::FoundWaypointsFallen_Crashed Ship_12 = "Warpointer::InitWaypoint(\"Crashed Ship\",0,355,442);";

// You should have a list of these.  The first section 'Fallen' is the level
// name.  You'll only need this if you are adding a new level.  The next section
// 'Crashed Ship' is the waypoint's label as you typed in earlier using 'T' right
// before you marked the waypoint.  The last digit is just an ID that will allow you
// to waypoint items with the same label, the bigger the last number the more recently
// the waypoint was marked.
//
// Now you'll notice you have "355,482".  There are your (x,y) coordinates for use in
// a warpointer function.  Now that you have the name, level, and x, y's you're ready
// to create a new warpoint.  So take a look up above to read about doing that.
// You'll have to convert each line to work in your function, take for example:
// "Warpointer::InitWaypoint(\"Crashed Ship\",0,355,442);";
// You need to remove the \'s before the quotes, and change 0 (the team)
// to the proper team for your new waypoint (i.e 1 or 5) if necessary.
// then add it to your new function and voila!
// --------------------------------------------------------------------------------------
// Set to true to activate marking, otherwise set to false.
// Don't set to tr
   $warpointer::findWaypoints = "false";
// ------------------------------------------------------------------------------------
// --------------------- BEGIN CODE ---------------------------------------------------
include("presto\\event.cs");
include("crunchy\\events.cs");
include("presto\\teamtrak.cs");
if ($warpointer::findWaypoints) {
bindCommand(keyboard0, make, "f9", TO, "Warpointer::findWaypoint();");
bindCommand(keyboard0, break, "f9", TO, "");
bindCommand(keyboard0, make, "f11", TO, "Warpointer::exportFoundPoints();");
bindCommand(keyboard0, break, "f11", TO, ""); 
Event::Attach(eventClientMessage, "warpointer::lastMessage"); }

Event::Attach(eventMissionInfo, Warpointer::loadCurrentLevel);     // load the level on new level 
Event::Attach(eventMissionInfo, Warpointer::loadPlayers);          // load players on new level
Event::Attach(eventClientChangeTeam, Warpointer::checkTeamChange); // switch our menus around on team change

// Dropped in v1.1 to eliminate lag on drop/join
// Event::Attach(eventClientJoinedTeam, Warpointer::addPlayer);
// Event::Attach(eventClientChangeTeam, Warpointer::checkTeamChange);
// Event::Attach(eventConnected, Warpointer::loadPlayers);
// Event::Attach(eventClientMessage, warpointer::parsemessage);


$warpointer::mylastmsg = " ";
$warpointer::id = "0";
$warpointer::debug = false;
$warpointer::saved = 0;
// --------------------------------------------------------------
// WARPOINTER CORE CODE
// ---------------------------------------------------------------

function Warpointer::loadCurrentLevel()
{
  Event::Trigger(eventWarpointInitLevel);	// tell program we're loading the level
  $warpointer::success = "false";		// reset success variable
  %level = $ServerMission;

  ECHO("Warpointer: Loading Level Information for " @ %level);  // got it
 
  eval("Warpointer::"@%level@"::Init();"); 
  if ($warpointer::success) {
  	ECHO("Warpoints: Successfully Loaded Mission " @ %level); // nice!
  	Event::Trigger(eventWarpointLevelSuccess); }
  else {
    ECHO("Warpoints: Error, Unknown Mission: " @ %level); // doh!
    Event::Trigger(eventWarpointLevelFailure); }
}

function Warpointer::InitWaypoint(%n, %t, %a, %b)
{
 Event::Trigger(eventWarpointNewWaypoint, %n, %t, %a, %b);  
}

function Warpointer::loadPlayers()
{
 Event::Trigger(eventWarpointInitPlayers);  // tell script we've reset!
 for (%i = 2083; %i > 2048; %i--) {
      if (Client::getName(%i) != "") {
         Event::Trigger(eventWarpointNewPlayer, %i); } // send every player to our script
}
}

function Warpointer::addPlayer(%c)  // not yet used, for adding a single player
{
  Event::Trigger(eventWarpointNewPlayer, %c);
}

function Warpointer::checkTeamChange(%client)
{
  if(%client == getManagerId())    // if its us, switch our menus around!
     warpointer::loadcurrentlevel();    
}

function Warpointer::setWaypoint(%name, %team, %x, %y)
{
   if (%team == Client::getTeam(getManagerId()))
      %ind = "our ";
   else if
      (%team == 5)
      %ind = "";
   else  
      %ind = "enemy ";
   if ($warpointer::debug) 
      ECHO("Warpoints: Attempting to set waypoint to "@%name@"at ("@%x@","@%y@")");
   remoteEval(2048,"issueCommand",1,"Targetting "@ %ind @ %name@".", %x, %y, getManagerId());
}

function Warpointer::setPlayerWaypoint(%ct)
{
    %nm = Client::getname(%ct);
    remoteEval(2048, "IssueTargCommand", 0, "Targetting "@%nm, %ct - 2048, getManagerId());
    return;
    
}

function Warpointer::targetFlagCarrier(%t)
{
 
   if (%t < 0 || %t > 1)
      return;
   %car = Team::GetFlagLocation(!%t);
 
   if (%car != $Trak::locationHome && %car != $Trak::LocationField && %car != "") {
   %clientId = getClientByName(%car);
 
   remoteEval(2048, "issueTargCommand",1,"Targetting "@ %car, %clientId - 2048, getManagerId());
   }
}

// ----------------------------------------------------
//              -- WARPOINTS - BASIC LEVELS -- 
// ----------------------------------------------------

function Warpointer::Broadside::Init() {
Warpointer::InitWaypoint("Base",0,630,521);
Warpointer::InitWaypoint("Flag",0,646,521);
Warpointer::InitWaypoint("Generators",0,670,521);
Warpointer::InitWaypoint("Roof",0,656,521);
Warpointer::InitWaypoint("Base",1,381,501);
Warpointer::InitWaypoint("Flag",1,368,507);
Warpointer::InitWaypoint("Generators",1,346,519);
Warpointer::InitWaypoint("Roof",1,357,513);
$warpointer::success = "true";
Event::Trigger(eventWarpointBroadside);
}

function Warpointer::Blastside::Init() {
Warpointer::InitWaypoint("Base",0,630,521);
Warpointer::InitWaypoint("Flag",0,654,521);
Warpointer::InitWaypoint("Generators",0,670,521);
Warpointer::InitWaypoint("Roof",0,656,521);
Warpointer::InitWaypoint("Base",1,381,501);
Warpointer::InitWaypoint("Flag",1,361,510);
Warpointer::InitWaypoint("Generators",1,346,519);
Warpointer::InitWaypoint("Roof",1,357,513);
$warpointer::success = "true";
Event::Trigger(eventWarpointBlastside);
}

function Warpointer::DangerousCrossing::Init() {
Warpointer::InitWaypoint("Base",0,800,750);
Warpointer::InitWaypoint("Flag",0,800,750);
Warpointer::InitWaypoint("Inventory Station",0,860,863);
Warpointer::InitWaypoint("Base",1,421,288);
Warpointer::InitWaypoint("Flag",1,421,288);
Warpointer::InitWaypoint("Inventory Station",1,471,159);
$warpointer::success = "true";
Event::Trigger(eventWarpointDangerousCrossing);
}

function Warpointer::Desert_Of_Death::Init() {
Warpointer::InitWaypoint("Flag",0,389,196);
Warpointer::InitWaypoint("East Sensor",0,537,327);
Warpointer::InitWaypoint("WestmSensor",0,319,245);
Warpointer::InitWaypoint("Base",0,389,196);
Warpointer::InitWaypoint("ELF Gun",5,195,433);
Warpointer::InitWaypoint("Plasma Gun",5,449,517);
Warpointer::InitWaypoint("Laser Rifle",5,441,511);
Warpointer::InitWaypoint("EnergyPack 0",5,359,405);
Warpointer::InitWaypoint("EnergyPack 1",5,392,699);
Warpointer::InitWaypoint("Flag",1,371,883);
Warpointer::InitWaypoint("East Sensor",1,492,775);
Warpointer::InitWaypoint("West Sensor",1,142,773);
Warpointer::InitWaypoint("Base",1,371,883);
$warpointer::success = "true";
Event::Trigger(eventWarpointDesertOfDeath);
}

function Warpointer::Raindance::Init() {
Warpointer::InitWaypoint("Base",0,534,133);
Warpointer::InitWaypoint("Flag",0,577,138);
Warpointer::InitWaypoint("Plasma Turret",0,532,329);
Warpointer::InitWaypoint("Rocket Turret",0,458,263);
Warpointer::InitWaypoint("Base",1,428,819);
Warpointer::InitWaypoint("Flag",1,386,844);
Warpointer::InitWaypoint("Plasma Turret",1,460,555);
Warpointer::InitWaypoint("Rocket Turret",1,460,675);
$warpointer::success = "true";
Event::Trigger(eventWarpointRaindance);
}

function Warpointer::Rollercoaster::Init() {
Warpointer::InitWaypoint("Base",0,595,874);
Warpointer::InitWaypoint("Flag",0,488,902);
Warpointer::InitWaypoint("Base",1,484,126);
Warpointer::InitWaypoint("Flag",1,382,168);
Warpointer::InitWaypoint("Solar Panel 1",0,587,874);
Warpointer::InitWaypoint("Solar Panel 2",0,604,869);
Warpointer::InitWaypoint("Vehicle Pad",0,601,886);
Warpointer::InitWaypoint("Solar Panel 1",1,491,119);
Warpointer::InitWaypoint("Solar Panel 2",1,473,127);
Warpointer::InitWaypoint("Vehicle Pad",1,492,134);
$warpointer::success = "true";
Event::Trigger(eventWarpointRollercoaster);
}

function Warpointer::Scarabrae::Init() {
Warpointer::InitWaypoint("Base",0,512,148);
Warpointer::InitWaypoint("Flag",0,525,158);
Warpointer::InitWaypoint("Generators",0,502,141);
Warpointer::InitWaypoint("Tower",5,676,481);
Warpointer::InitWaypoint("Base",1,601,826);
Warpointer::InitWaypoint("Flag",1,590,818);
Warpointer::InitWaypoint("Generators",1,614,833);
$warpointer::success = "true";
Event::Trigger(eventWarpointScarabrae);
}

function Warpointer::Snowblind::Init() {
Warpointer::InitWaypoint("Base",0,201,495);
Warpointer::InitWaypoint("Flag",0,194,502);
Warpointer::InitWaypoint("Tower",0,445,681);
Warpointer::InitWaypoint("Base",1,859,612);
Warpointer::InitWaypoint("Flag",1,862,607);
Warpointer::InitWaypoint("Tower",1,515,418);
$warpointer::success = "true";
Event::Trigger(eventWarpointSnowblind);
}

function Warpointer::Stonehenge::Init() {
Warpointer::InitWaypoint("Base",0,278,288);
Warpointer::InitWaypoint("Flag",0,230,244);
Warpointer::InitWaypoint("Base",1,776,675);
Warpointer::InitWaypoint("Flag",1,814,735);
Warpointer::InitWaypoint("RepairPack",5,442,459);
$warpointer::success = "true";
Event::Trigger(eventWarpointStonehenge);
}

function Warpointer::IceRidge::Init() {
Warpointer::InitWaypoint("Base",0,599,212);
Warpointer::InitWaypoint("Flag",0,599,212);
Warpointer::InitWaypoint("Plasma Turret",0,437,430);
Warpointer::InitWaypoint("Base",1,345,787);
Warpointer::InitWaypoint("Flag",1,345,787);
Warpointer::InitWaypoint("Plasma Turret",1,533,719);
$warpointer::success = "true";
Event::Trigger(eventWarpointIceRidge);
}

function Warpointer::ADishBestServedCold::Init() {
Warpointer::InitWaypoint("Abandoned Dropship",5,536,521);
Warpointer::InitWaypoint("Secondary Gen",0,863,639);
Warpointer::InitWaypoint("Command Station",0,817,616);
Warpointer::InitWaypoint("Main Generator",0,779,645);
Warpointer::InitWaypoint("Base",0,779,645);
Warpointer::InitWaypoint("Base",1,239,359);
Warpointer::InitWaypoint("Main Generator",1,243,357);
Warpointer::InitWaypoint("Secondary Generator",1,144,270);
Warpointer::InitWaypoint("Command Station",1,219,261);
Warpointer::InitWaypoint("Vehicle Pad",1,199,348);
$warpointer::success = "true";
Event::Trigger(eventWarpointADishBestServedCold);
}

function Warpointer::AntHill::Init()
{
Warpointer::InitWaypoint("Base",0,188,515);
Warpointer::InitWaypoint("Base",1,935,395);
Warpointer::InitWaypoint("The Structure",5,526,511);
$warpointer::success = "true";
Event::Trigger(eventWarpointAnthill);
}

function Warpointer::BloodRunsCold::Init()
{
Warpointer::InitWaypoint("Chaingun",5,402,492);
Warpointer::InitWaypoint("ELF Gun",5,523,527);
Warpointer::InitWaypoint("Grenade Launcher",5,489,520);
Warpointer::InitWaypoint("Plasma Gun",5,515,562);
Warpointer::InitWaypoint("Shield Pack",5,455,503);
$warpointer::success = "true";
Event::Trigger(eventWarpointBloodRunsCold);
}

function Warpointer::BloodyVengeance::Init()
{
Warpointer::InitWaypoint("Base",0,692,817);
Warpointer::InitWaypoint("Generator 1",0,672,848);
Warpointer::InitWaypoint("Generator 2",0,754,849);
Warpointer::InitWaypoint("Plasma Turret 1",0,739,777);
Warpointer::InitWaypoint("Plasma Turret 2",0,639,775);
Warpointer::InitWaypoint("Solar Panel 1",0,720,823);
Warpointer::InitWaypoint("Solar Panel 2",0,656,823);
Warpointer::InitWaypoint("Base",1,413,125);
Warpointer::InitWaypoint("Generator 1",432,94);
Warpointer::InitWaypoint("Generator 2",1,352,96);
Warpointer::InitWaypoint("Plasma Turret 1",1,366,171);
Warpointer::InitWaypoint("Plasma Turret 2",1,466,166);
Warpointer::InitWaypoint("Solar Panel 1",1,391,121);
Warpointer::InitWaypoint("Solar Panel 2",1,452,119);
$warpointer::success = "true";
Event::Trigger(eventWarpointBloodyVengeance);
}

function Warpointer::Citadels::Init()
{
Warpointer::InitWaypoint("Base",0,127,85);
Warpointer::InitWaypoint("Base",1,910,945);
Warpointer::InitWaypoint("Center Citadel",5,531,542);
Warpointer::InitWaypoint("Northwest Citadel",5,884,610);
Warpointer::InitWaypoint("Southwest Citadel",5,162,456);
$warpointer::success = "true";
Event::Trigger(eventWarpointCitadels);
}

function Warpointer::CrissCross::Init()
{
Warpointer::InitWaypoint("Base",0,602,102);
Warpointer::InitWaypoint("Base",1,462,907);
Warpointer::InitWaypoint("Center Tower",5,512,507);
Warpointer::InitWaypoint("Northwest Tower",5,239,713);
Warpointer::InitWaypoint("Northeast Tower",5,737,726);
Warpointer::InitWaypoint("Southeast Tower",5,689,341);
Warpointer::InitWaypoint("Southwest Tower",5,311,335);
$warpointer::success = "true";
Event::Trigger(eventWarpointCrissCross);
}

function Warpointer::DeathKnell::Init()
{
Warpointer::InitWaypoint("Base",0,586,947);
Warpointer::InitWaypoint("Flag Towers",5,374,535);
Warpointer::InitWaypoint("East Flag",5,383,498);
Warpointer::InitWaypoint("West Flag",5,378,570);
Warpointer::InitWaypoint("South Flag",5,348,529);
Warpointer::InitWaypoint("North Flag",5,412,532);
$warpointer::success = "true";
Event::Trigger(eventWarpointDeathKnell);
}

function Warpointer::HammerDown::Init()
{
Warpointer::InitWaypoint("Base",0,340,766);
Warpointer::InitWaypoint("Alpha Base",0,711,822);
Warpointer::InitWaypoint("Beta Base",0,194,540);
Warpointer::InitWaypoint("Alpha Generator",0,716,844);
Warpointer::InitWaypoint("Beta Generator",0,194,540);
Warpointer::InitWaypoint("Command Station",0,352,759);
Warpointer::InitWaypoint("Main Generator",0,357,748);
Warpointer::InitWaypoint("Base",1,788,172);
Warpointer::InitWaypoint("Delta Base",1,425,226);
Warpointer::InitWaypoint("Gamma Base",1,953,336);
Warpointer::InitWaypoint("Delta Generator",1,425,226);
Warpointer::InitWaypoint("Gamma Generator",1,945,337);
Warpointer::InitWaypoint("Command Station",1,757,187);
Warpointer::InitWaypoint("Main Generator",1,775,152);
$warpointer::success = "true";
Event::Trigger(eventWarpointHammerDown);
}

function Warpointer::KingUnderTheHill::Init()
{
Warpointer::InitWaypoint("AmmoPack",5,493,401);
Warpointer::InitWaypoint("Chaingun",5,273,540);
Warpointer::InitWaypoint("Disc Launcher",5,380,161);
Warpointer::InitWaypoint("EnergyPack",5,448,512);
Warpointer::InitWaypoint("Grenades",5,757,453);
Warpointer::InitWaypoint("Laser Rifle",5,482,576);
Warpointer::InitWaypoint("Repair Kit",5,440,593);
Warpointer::InitWaypoint("RepairPack",5,471,448);
Warpointer::InitWaypoint("SensorJammer Pack",5,450,404);
Warpointer::InitWaypoint("ShieldPack",5,496,509);
$warpointer::success = "true";
Event::Trigger(eventWarpointKingUnderTheHill);
}

function Warpointer::NoQuarter::Init()
{
Warpointer::InitWaypoint("Base",0,889,507);
Warpointer::InitWaypoint("Generator 1",0,882,513);
Warpointer::InitWaypoint("Generator 2",0,875,487);
Warpointer::InitWaypoint("Base",1,96,463);
Warpointer::InitWaypoint("Generator 1",1,109,487);
Warpointer::InitWaypoint("Generator 2",1,102,459);
Warpointer::InitWaypoint("Northeast Tower",5,654,660);
Warpointer::InitWaypoint("Southwest Tower",5,375,312);
$warpointer::success = "true";
Event::Trigger(eventWarpointNoQuarter);
}

function Warpointer::PeakPerformance::Init()
{
Warpointer::InitWaypoint("Central Tower",5,560,517);
Warpointer::InitWaypoint("Northeast Tower",5,744,746);
Warpointer::InitWaypoint("Northwest Tower",5,391,841);
Warpointer::InitWaypoint("Southeast Tower",5,755,167);
Warpointer::InitWaypoint("Southwest Tower",5,386,259);
$warpointer::success = "true";
Event::Trigger(eventWarpointPeakPerformance);
}

function Warpointer::Peekaboo::Init()
{
Warpointer::InitWaypoint("Ammo Supply Unir",5,213,413);
Warpointer::InitWaypoint("Chaingun",5,189,430);
Warpointer::InitWaypoint("Disc Launcher",5,332,348);
Warpointer::InitWaypoint("ELF Gun",5,296,733);
Warpointer::InitWaypoint("EnergyPack",5,829,456);
Warpointer::InitWaypoint("Grenade Launcher",5,797,833);
Warpointer::InitWaypoint("Laser Rifle",5,829,458);
Warpointer::InitWaypoint("Mines",5,800,827);
Warpointer::InitWaypoint("Plasma Gun",5,802,831);
Warpointer::InitWaypoint("Repair Kit",5,829,458);
Warpointer::InitWaypoint("ShieldPack",5,629,602);
$warpointer::success = "true";
Event::Trigger(eventWarpointPeekaboo);
}

function Warpointer::Sandstorm::Init()
{
Warpointer::InitWaypoint("AmmoPack",5,486,461);
Warpointer::InitWaypoint("Chaingun A",5,707,646);
Warpointer::InitWaypoint("Chaingun B",5,700,291);
Warpointer::InitWaypoint("Chaingun C",5,263,300);
Warpointer::InitWaypoint("Disc Launcher",5,457,732);
Warpointer::InitWaypoint("ELF Gun",5,225,614);
Warpointer::InitWaypoint("Grenade Launcher",5,300,873);
Warpointer::InitWaypoint("Plasma Gun A",5,70,175);
Warpointer::InitWaypoint("Plasma Gun B",5,448,202);
Warpointer::InitWaypoint("Repair Kit",5,559,323);
Warpointer::InitWaypoint("ShieldPack",5,571,325);
$warpointer::success = "true";
Event::Trigger(eventWarpointSandstorm);
}

function Warpointer::SeekAndDestroy::Init()
{
Warpointer::InitWaypoint("Base",0,372,740);
Warpointer::InitWaypoint("Main Generator",0,393,741);
Warpointer::InitWaypoint("Small Generator 1",0,381,765);
Warpointer::InitWaypoint("Small Generator 2",0,380,710);
Warpointer::InitWaypoint("Pulse Sensor",1,381,736);
Warpointer::InitWaypoint("Northeast Tower",5,823,639);
Warpointer::InitWaypoint("Southwest Tower",5,176,281);
Warpointer::InitWaypoint("Base",1,702,210);
Warpointer::InitWaypoint("Main Generator",1,685,210);
Warpointer::InitWaypoint("Small Generator 1",1,702,237);
Warpointer::InitWaypoint("Small Generator 2",1,697,183);
Warpointer::InitWaypoint("Pulse Sensor",1,702,210);
$warpointer::success = "true";
Event::Trigger(eventWarpointSeekAndDestroy);
}

function Warpointer::Siege::Init()
{
Warpointer::InitWaypoint("Base",0,610,754);
Warpointer::InitWaypoint("Main Generators",0,625,783);
Warpointer::InitWaypoint("Station Generators",0,610,759);
Warpointer::InitWaypoint("Command Stations",0,610,759);
Warpointer::InitWaypoint("Pulse Sensor",0,595,742);
Warpointer::InitWaypoint("Mortar Bunker",581,479);
Warpointer::InitWaypoint("Base",1,352,270);
Warpointer::InitWaypoint("Main Generators",1,352,270);
Warpointer::InitWaypoint("Station Generators",1,364,300);
Warpointer::InitWaypoint("Command Stations",1,364,300);
Warpointer::InitWaypoint("Pulse Sensor",1,372,319);
$warpointer::success = "true";
Event::Trigger(eventWarpointSiege);
}

function Warpointer::TempleOfDoom::init()
{
Warpointer::InitWaypoint("Base",0,719,963);
Warpointer::InitWaypoint("Base",1,726,141);
Warpointer::InitWaypoint("Ancient Temple",5,344,544);
$warpointer::success = "true";
Event::Trigger(eventWarpointTempleOfDoom);
}

function Warpointer::TheRedSands::Init()
{
Warpointer::InitWaypoint("AmmoPack",5,670,227);
Warpointer::InitWaypoint("Chaingun",5,669,229);
Warpointer::InitWaypoint("Disc Launcher",5,519,549);
Warpointer::InitWaypoint("ELF Gun",5,794,609);
Warpointer::InitWaypoint("EnergyPack",5,528,903);
Warpointer::InitWaypoint("Grenade Launcher A",5,616,380);
Warpointer::InitWaypoint("Grenade Launcher B",5,245,711);
Warpointer::InitWaypoint("Grenades",5,624,398);
Warpointer::InitWaypoint("Laser Rifle",5,542,889);
Warpointer::InitWaypoint("Mines",5,619,398);
Warpointer::InitWaypoint("Plasma Gun",5,829,878);
Warpointer::InitWaypoint("Repair Kit",5,805,624);
Warpointer::InitWaypoint("RepairPack",5,846,867);
$warpointer::success = "true";
Event::Trigger(eventWarpointTheRedSands);
}

function Warpointer::Towers::Init()
{
Warpointer::InitWaypoint("East Tower",5,874,606);
Warpointer::InitWaypoint("North Tower",5,678,550);
Warpointer::InitWaypoint("Northwest Tower",5,232,663);
Warpointer::InitWaypoint("South Tower",5,626,293);
Warpointer::InitWaypoint("Southwest Towerr",5,292,380);
$warpointer::success = "true";
Event::Trigger(eventWarpointTowers);
}

function Warpointer::Valhalla::Init()
{
Warpointer::InitWaypoint("Base",0,450,84);
Warpointer::InitWaypoint("Base",1,697,902);
Warpointer::InitWaypoint("Central Tower",5,589,437);
Warpointer::InitWaypoint("East Tower",5,912,437);
Warpointer::InitWaypoint("West Tower",5,239,667);
$warpointer::success = "true";
Event::Trigger(eventWarpointValhalla);
}
// END BASE LEVELS

function Warpointer::No_Rail::Init()
{
Warpointer::InitWaypoint("Base",0,575,520);
Warpointer::InitWaypoint("Flag",0,651,520);
Warpointer::InitWaypoint("Generator A",0,581,530);
Warpointer::InitWaypoint("Generator B",0,572,510);
Warpointer::InitWaypoint("Base",1,336,523);
Warpointer::InitWaypoint("Flag",1,260,520);
Warpointer::InitWaypoint("Generator A",1,330,510);
Warpointer::InitWaypoint("Generator B",1,340,531);
Warpointer::InitWaypoint("The Mono-Rail",5,454,521);
$warpointer::success = "true";
Event::Trigger(eventWarpointNo_Rail);
}

function Warpointer::WoohooWalkAbout::Init()
{
Warpointer::InitWaypoint("Base",0,427,575);
Warpointer::InitWaypoint("Flag",0,408,544);
Warpointer::InitWaypoint("Generator",0,411,579);
Warpointer::InitWaypoint("Rocket Turret",0,420,575);
Warpointer::InitWaypoint("Base",1,665,579);
Warpointer::InitWaypoint("Flag",1,677,609);
Warpointer::InitWaypoint("Generator",1,675,575);
Warpointer::InitWaypoint("Rocket Turret",1,666,579);
$warpointer::success = true;
Event::Trigger(eventWarpointWoohooWalkAbout);
}
// -------------------------------------------------------
//            -- END WARPOINTER BASIC LEVELS -=
// -------------------------------------------------------



// ---------------------------------
// -- WARPOINT MARKING ROUTINES  ---
// ---------------------------------
function Warpointer::findWaypoint() {
    $warpointer::currentPos = Gamebase::getPosition(getManagerId());
    %xa = floor(getWord($warpointer::currentPos, 0));
    %ya = floor(getWord($warpointer::currentPos, 1));
    for (%i = 0; %i < 1024; %i++) {
    if (%xa == floor(getword(waypointtoworld(%i @ " 0"), 0)))
      %x = %i;
    if (%ya == floor(getword(waypointtoworld("0 " @ %i @ ""), 1)))
      %y = %i; }
    echo("Attempting to target (" @ %x @ "," @ %y @ "): " @ $warpointer::mylastmsg);
    if (%x != "" && %y != "") {
    $warpointer::id++;
//    $Warpointer::FoundWaypoints[$ServerMission, $warpointer::mylastmsg, $warpointer::id] = %x @","@ %y;  
    $Warpointer::FoundWaypoints[$ServerMission, $warpointer::mylastmsg, $warpointer::id] = "Warpointer::InitWaypoint(\""@$warpointer::mylastmsg@"\",0,"@%x@","@%y@");"; 
    Client::centerprint("<jc>Successfully Marked "@$warpointer::mylastmsg@" at ("@%x@","@%y@")",1);
    Schedule("Client::CenterPrint(\"\",1);",2.75);	
    remoteEval(2048,"issueCommand",1,"Warpoint set to "@$warpointer::mylastmsg@".", %x, %y, getManagerId()); }
    else {
    Client::centerprint("<jc>Could not mark "@$warpointer::mylastmsg@"\nPlease adjust your position and re-attempt.\nIt may take several tries.",1);
    Schedule("Client::CenterPrint(\"\",1);",1.75); }	


    return; }

function Warpointer::lastMessage(%client, %msg) {
	if (%client != getManagerId()) return;
	$warpointer::mylastmsg = %msg;
}

function Warpointer::exportFoundPoints()
{
 if(!isfile("config\\warpoints.txt") || $warpointer::saved == "1") {
 Client::centerprint("<jc>"@$warpointer::id@" Waypoints Exported to Config\\warpoints.txt",1);
 Schedule("Client::CenterPrint(\"\",1);",3.75);
 export ("$Warpointer::FoundWaypoints*","config\\warpoints.txt"); 
 $warpointer::saved=1;                                  }
 else {
 for (%i = 0; isFile("config\\warpoints"@%i@".txt"); %i++)
   %j = %i;
 Client::centerprint("<jc>"@$warpointer::id@" Waypoints Exported to Config\\warpoints.txt\nOld Waypoints Stored in config\\warpoints"@%i@".txt",1);
 Schedule("Client::CenterPrint(\"\",1);",3.75);
 File::Copy("config\\warpoints.txt","config\\warpoints"@%i@".txt");
 export ("$Warpointer::FoundWaypoints*","config\\warpoints.txt"); }      
 $warpointer::saved = 1;
}

// no longer a necessary function
function Warpointer::parseMessage(%client, %msg)
{
 if (%client) return;
    if (String::findSubStr(%msg, "joined team") != "-1")
       Event::Trigger(eventClientJoinedTeam, %client);
}

// -------------------------------------------------
