// Lifetime Stat Tracker v1.02

// What's new-1.02
// New HUD. Thanks to Shots, the HUD has been redesigned and improved
// New event trigger for scripters. eventStatsRead is now triggered after the stats have been read

// Put it in some sub-directoy under config, Spades if ya like
// then add the line Include("whereyouputit\\stattrak.cs"); in config\autoexec.cs.
// This script absolutely requires the Presto Pack, so get it now.
// http://www.planetstarsiege.com/presto/

// Thanks to Writer and Presto for their help with a few functions, especially export()

// Feel free to make changes, but if you do, i'd appreciate it if you'd post info about what
// you changed to the Planet Starsiege scripting forum, or e-mail me: spades@mailcity.com
// http://forums.planetstarsiege.com/index.asp?topic=205

// DO NOT REMOVE STATS.CS FROM THE CONFIG DIRECTORY. This is where your stats are held.
// If you delete that file, you lose your stats.

Include("presto\\event.cs");
Include("presto\\KillTrak.cs");
Include("presto\\teamtrak.cs");

HUD::New(hudStat, StatTrak::UpdateHUD, "100% 89, 120 60");
HUD::Display(hudStat);

function StatTrak::Update()
{
  File::delete("config\\stats.cs");

  // Rewrite stats file and records
  export("$StatTrak::NextRec", "config\\stats.cs");
  export("$StatTrak::Name*", "config\\stats.cs", True);
  export("$StatTrak::Kills*", "config\\stats.cs", True);
  export("$StatTrak::Deaths*", "config\\stats.cs", True);
  export("$StatTrak::SelfDeaths*", "config\\stats.cs", True);
  export("$StatTrak::Flagcaps*", "config\\stats.cs", True);
  echo("File written");
  HUD::Update(hudStat);
}

function StatTrak::Kill()
{
  $StatTrak::Kills[$StatTrak::ClientNum]++;
  echo("Kill");
  StatTrak::Update();
}

function StatTrak::Death()
{
  $StatTrak::Deaths[$StatTrak::ClientNum]++;
  echo("Death");
  StatTrak::Update();
}

function StatTrak::SelfDeath()
{
  $StatTrak::SelfDeaths[$StatTrak::ClientNum]++;
  StatTrak::Update();
}

function StatTrak::Flagcaps(%teamNum, %client)
{
  echo("Someone captured the flag");
  echo(%client);
  if(%client == getManagerId())
  {
    echo("Flag captured");
    $StatTrak::Flagcaps[$StatTrak::ClientNum]++;
    StatTrak::Update();
  }
}

function StatTrak::ReadFile()
{
  echo("Attempting to read file");
  %clientname = client::getname(getManagerId());
  $StatTrak::ClientNum = "";
  $StatTrak::NextRec = "";
  //Check for existence of previous stats
  exec("stats.cs");

  //Check for existence of previous records for this client name
  for(%i=0; %i<$StatTrak::NextRec; %i++)
  {
      if($StatTrak::Name[%i] == %clientname)
        $StatTrak::ClientNum = %i;
  }

  //If the name isn't found, create a new record
  if($StatTrak::ClientNum == "")
  {

    echo("Creating new record");
    //This is the first record. Initialize NextRec
    if($StatTrak::NextRec == "")
    {
      $StatTrak::NextRec = 0;
      echo("Creating first record");
      StatTrak::Update();
    }

    $StatTrak::ClientNum = $StatTrak::NextRec;
    $StatTrak::NextRec++;
    $StatTrak::Name[$StatTrak::ClientNum] = %clientname;
    $StatTrak::Kills[$StatTrak::ClientNum] = 0;
    $StatTrak::Deaths[$StatTrak::ClientNum] = 0;
    $StatTrak::SelfDeaths[$StatTrak::ClientNum] = 0;
    $StatTrak::Flagcaps[$StatTrak::ClientNum] = 0;
  }
  HUD::Update(hudStat);
  Event::Trigger(eventStatsRead);
  echo("File has been read, FYI");
}

function StatTrak::KD(%killer, %victim, %weapon)
{
  if(%victim == getManagerId() && %killer != getManagerId())
    StatTrak::Death();
  else if(%victim == getManagerID() && %killer == getManagerId())
    StatTrak::SelfDeath();
  else if(%killer == getManagerId() && %weapon != "Team Kill")
    StatTrak::Kill();
}

function StatTrak::UpdateHUD()
{
echo("HUD Update");
%line1 = "<f1>Kills: <f2>" @ $StatTrak::Kills[$StatTrak::ClientNum] @ "\n";
%line2 = "<f1>Deaths: <f2>" @ $StatTrak::Deaths[$StatTrak::ClientNum] @ "\n";
%line3 = "<f1>Self Deaths: <f2>" @ $StatTrak::SelfDeaths[$StatTrak::ClientNum] @ "\n";
%line4 = "<f1>Caps: <f2>" @ $StatTrak::Flagcaps[$StatTrak::ClientNum];

Hud::AddText(hudStat, %line1 @ %line2 @ %line3 @ %line4);
}

Event::Attach(eventConnected, StatTrak::ReadFile);
Event::Attach(eventKillTrak, StatTrak::KD);
Event::Attach(eventFlagCaptured, StatTrak::Flagcaps);