// WAR/POINTS v1.0g
// The Automatic Waypointing System
// by Rayn 
// Rayn@planet-tribes.com
// =========================================================================
// "WarPoints is a complete Automatic Waypointing System. Want to target the
// enemy base? Just bring up the menu and select it. Having trouble finding
// the energy pack on Desert of Death? Again, use Warpoints. Currently
// supports all mission types and contains over 250 preset waypoints on
// virtually all Tribes base missions. You can also target specific players.
// Features the ability to add your own custom waypoints with
// relative ease using the Waypoint Export Tool (WET).
// Sick of waypoints? Go WarPoints."
// ----------------------------------------------------------
// PLEASE READ WARPOINTER.CS for information on adding new waypoints
// ----------------------------------------------------------
// INSTALL NOTES: (see warpointer.cs)
// Add the line:
// include("rayn\\warpoints.cs");
// to your autoexec.cs after the line:
// include("presto\\install");
//
// REQ FILES:
// PrestoPack 0.93 or greater
// Crunchy's events.cs (included)
//
// Your waypoint menu is now on ALT-W.
// Pressing it will bring up this menu:
// Target:
// e) Enemy
// f) Friendly
// n) Neutral
// Enemy - Enemy structures and players
// Friendly - Friendly structures and players
// Neutral - Everything else i.e items, weapons, buildings, objectives,
// rocks, field locations
//
// Just hit alt-w, select your waypoint and bingo.
// ------------------------------------------------------------
// SUPPORTED LEVELS:
// All non-F&R base Tribes levels
// WooHoo Walkabout
// No-Rail
// ------------------------------------------------------------
//                   BEWARE OF CODE BELOW!
// ------------------------------------------------------------
include("rayn\\warpointer.cs");
include("presto\\menu.cs");


$warpointer::debug = false;
// --------------------------------------------------------------
// WARPOINTS CORE CODE
// ---------------------------------------------------------------
Event::Attach(eventWarpointNewWaypoint,"Warpoints::NewWaypoint");
Event::Attach(eventWarpointInitLevel, "Warpoints::resetMenus");
Event::Attach(eventWarpointInitPlayers, "Warpoints::buildPlayerMenus");
Event::Attach(eventWarpointNewPlayer, "Warpoints::NewPlayer");

// Event::Attach(eventClientdrop, "Warpoints::dropPlayer");  // removed v1.0

function Warpoints::NewWaypoint(%name, %team, %x, %y)
{
  %char = "abcdefghijklmnopqrstuvwxyz234567890";
  %level = $ServerMission;
  if ($warpointer::debug)
     ECHO("LOADING WAYPOINT:" @ %name @ "," @ %team @ "," @ %x @ "," @ %y); 
  %choice = String::GetSubStr(%char, $warpoints::Index[%team], 1);
  Menu::AddChoice("warmenu"@%team, %choice@%name, "Warpointer::SetWaypoint(\""@%name@"\","@%team@","@%x@","@%y@");");
  $warpoints::Index[%team]++;  
}

function Warpoints::resetMenus()
{
 // Init our major menus
 // ECHO("Warpoints: Resetting Menus");
 $warpoints::Index[0] = 0; // our waypoint letter pointers
 $warpoints::Index[1] = 0;
 $warpoints::Index[5] = 0;
  Menu::New(warmain, "Target:");
 %us = Client::Getteam(getManagerId());
 if (%us > 1 || %us < 0)
   %us = 1;

 if (%us == 0) {
  Menu::New(warmenu0, "Target Friendly:");
  Menu::New(warmenu1, "Target Enemy:"); }
 else {
  Menu::New(warmenu0, "Target Enemy:");
  Menu::New(warmenu1, "Target Friendly:"); }
 Menu::New(warmenu5, "Target Neutral:");
 %them = !(%us);
 Menu::addMenu(warmain, "e", warmenu@%them);
 Menu::addmenu(warmain, "f", warmenu@%us);
 Menu::addMenu(warmain, "n", warmenu5);
 Menu::addMenu(warmenu0, "1Players", warteam0);
 Menu::addMenu(warmenu1, "1Players", warteam1);
 Menu::addChoice(warmenu0, "2Flag Carrier", "Warpointer::targetFlagCarrier(0);");
 Menu::addChoice(warmenu1, "2Flag Carrier", "Warpointer::targetFlagCarrier(1);");
}

function Warpoints::dropPlayer(%c,%t)		// not used, YET
{
 if (%t = "")
  %t = Client::getTeam(%c);
  %e = $Warpoints::elementIndex[Client::getName(%c)];
  ECHO("Drop Player: "@%c@":"@%e);
  List::Remove(warteam@%t, %e);
  List::DefaultSort(warteam@%t);
}


function Warpoints::buildPlayerMenus()
{
 			     // these functions reset the player menus
 // ECHO("BUILDING MENUS");  // v1.1: attached menu display to menu build functions
			     // to avoid lag, now it will lag only when you select
			     // the enemy team, cuts down on join/drop lag.
 $warpoints::PlayerIndex[0] = 0;
 $warpoints::PlayerIndex[1] = 0;
 Menu::New(warteam0, "Players:","Warpointer::loadplayers();");
 Menu::New(warteam1, "Players:","Warpointer::loadplayers();");
}

function Warpoints::NewPlayer(%cl)
{
  %char = "abcdefghijklmnopqrstuvwxyz234567890";		// choice array
  
  if ($warpointer::debug)
     ECHO("LOADING PLAYER:" @ Client::getName(%cl));            // show us who we found
  %team = Client::getTeam(%cl);		// check the team
  if (%team < -1 || %team > 1)		// unsupported team, ignore it
     return;
  %name = Client::getName(%cl);		// get players name, add to meanu
  %choice = String::GetSubStr(%char, $warpoints::PlayerIndex[%team], 1); // watch this?
  if (%choice == "-1") 	// no more players can be added, we're outta digits
     return; 
  Menu::AddChoice("warteam"@%team, %choice@%name,
"Warpointer::SetPlayerWaypoint("@%cl@");");		// add our player
  $warpoints::PlayerIndex[%team]++;			// move the choice pointer
}


function Warpoints::AddBanner()
{
	Presto::AddScriptBanner(Warpoints,
                " <f2>WarPoints <jr><f0>version 1.0g <jl>\n" @
		" <jc><f1>The Automatic Waypointing\n" @
		" <f1>System\n" @
		"\n" @
                 "<f0>Written By:\n" @
                 "<f2>Rayn\n" @
                 "<f1>rayn@planet-tribes.com" @
                 "<f2>WWW.PLANET-TRIBES.COM");
}
Warpoints::AddBanner();

editActionMap("playMap.sae");
bindCommand(keyboard0, make, alt, "w", TO, "Menu::Display(warmain);");
bindCommand(keyboard0, break, alt, "w", TO, "");
