// ---------------------------------------------------------------------------
// favorites0.cs -- Version 2.3 -- November 13, 1999
// by Lorne Laliberte ([SS-12] Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

// Writer's Favorites -- use these, or copy this file and rename it as
// favorites1.cs and set up your favorites for fast_favorites.cs in that file.
//
// Note: it's best not to set up your favorites in here (favorites0.cs) since this
//       file could be overwritten whenever you update my files.
//
//
// See the end of this file for the list of $Inv:: variable names you can use.
//
// To buy a single item, replace the "" with the $Inv:: variable name for the
// item you want to buy.  Make sure all the other fields (except loadout) have "".
//
// To buy multiple items, replace the "" with the $Inv:: variable name for the
// items you want to buy in each field (armor, pack, weapon1, weapon2 etc).
//
// You can keep any of your current loadout items by leaving that field blank ("").
// For instance, if you want to change your pack and your weapons, but leave your
// armor and vehicle selections the same, leave the armor and vehicle fields blank.
//
// fast_favorites.cs will automatically use buyFavorites instead of buyItem
// if more than one type of item is given.  Using buyFavorites means any items
// in your inventory that aren't in the favorites will be removed.
//
// To buy a single weapon, use only the weapon1 field.  Same for extra1.
//
// The Extra fields are specific to each loadout -- if you want to buy the same
// item with every loadout, you have to specificy it in each one.  Or you could
// just define a loadout with only the Extra stuff you want, and assign that to
// its own key combo, and use it to modify all the other loadouts from in-game.
//
// ---------------------------------------------------------------------------
// Example setup for ALT + F1 key:
//
// $FastFaves::key[alt, f1, loadout] = "Engineer";
//
// - sets the loadout name for the ALT + F1 key combo.  The loadout name is
//   told to your teammates the first time you leave a station carrying that loadout
//   if you're using my am_armor.cs script.
//
// $FastFaves::key[alt, f1, armor]   = $Inv::Medium_Armor;
//
// - you want medium armor
//
// $FastFaves::key[alt, f1, pack]    = $Inv::Inventory_Station;
//
// - you want to carry a remote inventory station
//
// $FastFaves::key[alt, f1, weapon1] = $Inv::Plasma_Gun;
// $FastFaves::key[alt, f1, weapon2] = $Inv::Chaingun;
// $FastFaves::key[alt, f1, weapon3] = $Inv::Disc_Launcher;
// $FastFaves::key[alt, f1, weapon4] = $Inv::Grenade_Launcher;
// $FastFaves::key[alt, f1, weapon5] = "";
// $FastFaves::key[alt, f1, weapon6] = "";
//
// - you want to carry a Plasma Gun, Chaingun, Disc Launcher and a Grenade Launcher.
//   (A Targeting Laser is always bought, you don't have to list it in your favorites.)
//   The order of the weapons doesn't matter.
//
// $FastFaves::key[alt, f1, extra1]  = $Inv::Mortar_Ammo;
// $FastFaves::key[alt, f1, extra2]  = "";
// $FastFaves::key[alt, f1, extra3]  = "";
// $FastFaves::key[alt, f1, extra4]  = "";
// $FastFaves::key[alt, f1, extra5]  = "";
// $FastFaves::key[alt, f1, extra6]  = "";
// $FastFaves::key[alt, f1, extra7]  = "";
//
// - you want to carry Mortar Ammo for your teammates in the field

// $FastFaves::key[alt, f1, vehicle] = $Inv::LPC;
//
// - you want to buy an LPC when you access vehicle stations...note that
//   this will only work if you have $FastFaves::AutoBuyVehicle set to true.
//
// $FastFaves::key[alt, f1, mount]   = $Inv::Disc_Launcher;
//
// - switch to Disc Launcher as soon as you exit the inventory station
//
// FastFaves::bindKey(alt, f1);
//
// - bind this loadout to the ALT + F1 key combo when you connect to a server
// ---------------------------------------------------------------------------


// Name this favorites file -- you have to name it something or it won't get used
// Make sure you change the number between the [] to match the filename
// i.e. if this file is favorites1.cs, change the next line to $FastFaves::Favorites[1] = "<some name>";

$FastFaves::Favorites[0] = "Writer's Favorites";


// Set which favorites to use by default (after connecting to a game)
$FastFaves::defaultModifier = "";
$FastFaves::defaultKey      = numpad1;
$FastFaves::Vehicle         = $Inv::Scout;


// Set whether you want to always buy these essential items
$FastFaves::BuyMines = true;
$FastFaves::BuyGrenades = true;
$FastFaves::BuyBeacons = true;

// Set what item you want to drop at inventory stations when $FastFave::DropPack is enabled
$FastFaves::DropItem = $Inv::Repair_Pack;



// Set up your favorites below!

$FastFaves::key["", decimal, loadout] = "";
$FastFaves::key["", decimal, armor]   = "";
$FastFaves::key["", decimal, pack]    = "";
$FastFaves::key["", decimal, weapon1] = "";
$FastFaves::key["", decimal, weapon2] = "";
$FastFaves::key["", decimal, weapon3] = "";
$FastFaves::key["", decimal, weapon4] = "";
$FastFaves::key["", decimal, weapon5] = "";
$FastFaves::key["", decimal, weapon6] = "";
$FastFaves::key["", decimal, extra1]  = "";
$FastFaves::key["", decimal, extra2]  = "";
$FastFaves::key["", decimal, extra3]  = "";
$FastFaves::key["", decimal, extra4]  = "";
$FastFaves::key["", decimal, extra5]  = "";
$FastFaves::key["", decimal, extra6]  = "";
$FastFaves::key["", decimal, extra7]  = "";
$FastFaves::key["", decimal, vehicle] = "";
$FastFaves::key["", decimal, mount]   = "";

//FastFaves::bindKey(decimal);
//-------------------------------------

$FastFaves::key["", numpad0, loadout] = "";      
$FastFaves::key["", numpad0, armor]   = "";
$FastFaves::key["", numpad0, pack]    = $Inv::Turret;
$FastFaves::key["", numpad0, weapon1] = "";
$FastFaves::key["", numpad0, weapon2] = "";
$FastFaves::key["", numpad0, weapon3] = "";
$FastFaves::key["", numpad0, weapon4] = "";
$FastFaves::key["", numpad0, weapon5] = "";
$FastFaves::key["", numpad0, weapon6] = "";
$FastFaves::key["", numpad0, extra1]  = "";
$FastFaves::key["", numpad0, extra2]  = "";
$FastFaves::key["", numpad0, extra3]  = "";
$FastFaves::key["", numpad0, extra4]  = "";
$FastFaves::key["", numpad0, extra5]  = "";
$FastFaves::key["", numpad0, extra6]  = "";
$FastFaves::key["", numpad0, extra7]  = "";
$FastFaves::key["", numpad0, vehicle] = "";
$FastFaves::key["", numpad0, mount]   = "";

FastFaves::bindKey(numpad0);
//-------------------------------------


$FastFaves::key["", numpad1, loadout] = "Dueler";
$FastFaves::key["", numpad1, armor]   = $Inv::Light_Armor;
$FastFaves::key["", numpad1, pack]    = $Inv::Energy_Pack;
$FastFaves::key["", numpad1, weapon1] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad1, weapon2] = $Inv::Chaingun;
$FastFaves::key["", numpad1, weapon3] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad1, weapon4] = "";
$FastFaves::key["", numpad1, weapon5] = "";
$FastFaves::key["", numpad1, weapon6] = "";
$FastFaves::key["", numpad1, extra1]  = "";
$FastFaves::key["", numpad1, extra2]  = "";
$FastFaves::key["", numpad1, extra3]  = "";
$FastFaves::key["", numpad1, extra4]  = "";
$FastFaves::key["", numpad1, extra5]  = "";
$FastFaves::key["", numpad1, extra6]  = "";
$FastFaves::key["", numpad1, extra7]  = "";
$FastFaves::key["", numpad1, vehicle] = "";
$FastFaves::key["", numpad1, mount]   = $Inv::Chaingun;

FastFaves::bindKey(numpad1);
//-------------------------------------

$FastFaves::key["", numpad2, loadout] = "Assult";
$FastFaves::key["", numpad2, armor]   = $Inv::Light_Armor;
$FastFaves::key["", numpad2, pack]    = $Inv::Energy_Pack;
$FastFaves::key["", numpad2, weapon1] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad2, weapon2] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad2, weapon3] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad2, weapon4] = "";
$FastFaves::key["", numpad2, weapon5] = "";
$FastFaves::key["", numpad2, weapon6] = "";
$FastFaves::key["", numpad2, extra1]  = "";
$FastFaves::key["", numpad2, extra2]  = "";
$FastFaves::key["", numpad2, extra3]  = "";
$FastFaves::key["", numpad2, extra4]  = "";
$FastFaves::key["", numpad2, extra5]  = "";
$FastFaves::key["", numpad2, extra6]  = "";
$FastFaves::key["", numpad2, extra7]  = "";
$FastFaves::key["", numpad2, vehicle] = "";
$FastFaves::key["", numpad2, mount]   = $Inv::Disc_Launcher;

FastFaves::bindKey(numpad2);
//-------------------------------------

$FastFaves::key["", numpad3, loadout] = "Shielded Assult";
$FastFaves::key["", numpad3, armor]   = $Inv::Light_Armor;
$FastFaves::key["", numpad3, pack]    = $Inv::shield_Pack;
$FastFaves::key["", numpad3, weapon1] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad3, weapon2] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad3, weapon3] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad3, weapon4] = "";
$FastFaves::key["", numpad3, weapon5] = "";
$FastFaves::key["", numpad3, weapon6] = "";
$FastFaves::key["", numpad3, extra1]  = "";
$FastFaves::key["", numpad3, extra2]  = "";
$FastFaves::key["", numpad3, extra3]  = "";
$FastFaves::key["", numpad3, extra4]  = "";
$FastFaves::key["", numpad3, extra5]  = "";
$FastFaves::key["", numpad3, extra6]  = "";
$FastFaves::key["", numpad3, extra7]  = "";
$FastFaves::key["", numpad3, vehicle] = "";
$FastFaves::key["", numpad3, mount]   = $Inv::Disc_Launcher;

FastFaves::bindKey(numpad3);
//-------------------------------------


$FastFaves::key["", numpad4, loadout] = "Sniper";
$FastFaves::key["", numpad4, armor]   = $Inv::Light_Armor;
$FastFaves::key["", numpad4, pack]    = $Inv::Energy_Pack;
$FastFaves::key["", numpad4, weapon1] = $Inv::Chaingun;
$FastFaves::key["", numpad4, weapon2] = $Inv::Laser_Rifle;
$FastFaves::key["", numpad4, weapon3] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad4, weapon4] = "";
$FastFaves::key["", numpad4, weapon5] = "";
$FastFaves::key["", numpad4, weapon6] = "";
$FastFaves::key["", numpad4, extra1]  = "";
$FastFaves::key["", numpad4, extra2]  = "";
$FastFaves::key["", numpad4, extra3]  = "";
$FastFaves::key["", numpad4, extra4]  = "";
$FastFaves::key["", numpad4, extra5]  = "";
$FastFaves::key["", numpad4, extra6]  = "";
$FastFaves::key["", numpad4, extra7]  = "";
$FastFaves::key["", numpad4, vehicle] = "";
$FastFaves::key["", numpad4, mount]   = $Inv::Disc_Launcher;

FastFaves::bindKey(numpad4);
//-------------------------------------

$FastFaves::key["", numpad5, loadout] = "Carier";
$FastFaves::key["", numpad5, armor]   = $Inv::Medium_Armor;
$FastFaves::key["", numpad5, pack]    = $Inv::Inventory_station;
$FastFaves::key["", numpad5, weapon1] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad5, weapon2] = $Inv::Chaingun;
$FastFaves::key["", numpad5, weapon3] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad5, weapon4] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad5, weapon5] = "";
$FastFaves::key["", numpad5, weapon6] = "";
$FastFaves::key["", numpad5, extra1]  = "";
$FastFaves::key["", numpad5, extra2]  = "";
$FastFaves::key["", numpad5, extra3]  = "";
$FastFaves::key["", numpad5, extra4]  = "";
$FastFaves::key["", numpad5, extra5]  = "";
$FastFaves::key["", numpad5, extra6]  = "";
$FastFaves::key["", numpad5, extra7]  = "";
$FastFaves::key["", numpad5, vehicle] = "";
$FastFaves::key["", numpad5, mount]   = $Inv::Plasma_Gun;

FastFaves::bindKey(numpad5);
//-------------------------------------

$FastFaves::key["", numpad6, loadout] = "Engineer";
$FastFaves::key["", numpad6, armor]   = $Inv::Medium_Armor;
$FastFaves::key["", numpad6, pack]    = $Inv::Repair_Pack;
$FastFaves::key["", numpad6, weapon1] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad6, weapon2] = $Inv::Chaingun;
$FastFaves::key["", numpad6, weapon3] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad6, weapon4] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad6, weapon5] = "";
$FastFaves::key["", numpad6, weapon6] = "";
$FastFaves::key["", numpad6, extra1]  = "";
$FastFaves::key["", numpad6, extra2]  = "";
$FastFaves::key["", numpad6, extra3]  = "";
$FastFaves::key["", numpad6, extra4]  = "";
$FastFaves::key["", numpad6, extra5]  = "";
$FastFaves::key["", numpad6, extra6]  = "";
$FastFaves::key["", numpad6, extra7]  = "";
$FastFaves::key["", numpad6, vehicle] = "";
$FastFaves::key["", numpad6, mount]   = $Inv::Plasma_Gun;

FastFaves::bindKey(numpad6);
//-------------------------------------

$FastFaves::key["", numpad7, loadout] = "Heavy Assult";
$FastFaves::key["", numpad7, armor]   = $Inv::Heavy_Armor;
$FastFaves::key["", numpad7, pack]    = $Inv::Repair_Pack;
$FastFaves::key["", numpad7, weapon1] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad7, weapon2] = $Inv::Chaingun;
$FastFaves::key["", numpad7, weapon3] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad7, weapon4] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad7, weapon5] = $Inv::Mortar;
$FastFaves::key["", numpad7, weapon6] = "";
$FastFaves::key["", numpad7, extra1]  = "";
$FastFaves::key["", numpad7, extra2]  = "";
$FastFaves::key["", numpad7, extra3]  = "";
$FastFaves::key["", numpad7, extra4]  = "";
$FastFaves::key["", numpad7, extra5]  = "";
$FastFaves::key["", numpad7, extra6]  = "";
$FastFaves::key["", numpad7, extra7]  = "";
$FastFaves::key["", numpad7, vehicle] = "";
$FastFaves::key["", numpad7, mount]   = $Inv::Mortar;

FastFaves::bindKey(numpad7);
//-------------------------------------

$FastFaves::key["", numpad8, loadout] = "Defender";
$FastFaves::key["", numpad8, armor]   = $Inv::Heavy_Armor;
$FastFaves::key["", numpad8, pack]    = $Inv::Shield_Pack;
$FastFaves::key["", numpad8, weapon1] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad8, weapon2] = $Inv::Chaingun;
$FastFaves::key["", numpad8, weapon3] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad8, weapon4] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad8, weapon5] = $Inv::Mortar;
$FastFaves::key["", numpad8, weapon6] = "";
$FastFaves::key["", numpad8, extra1]  = "";
$FastFaves::key["", numpad8, extra2]  = "";
$FastFaves::key["", numpad8, extra3]  = "";
$FastFaves::key["", numpad8, extra4]  = "";
$FastFaves::key["", numpad8, extra5]  = "";
$FastFaves::key["", numpad8, extra6]  = "";
$FastFaves::key["", numpad8, extra7]  = "";
$FastFaves::key["", numpad8, vehicle] = "";
$FastFaves::key["", numpad8, mount]   = $Inv::Plasma_Gun;

FastFaves::bindKey(numpad8);
//-------------------------------------

$FastFaves::key["", numpad9, loadout] = "Bloody Jumper";
$FastFaves::key["", numpad9, armor]   = $Inv::Heavy_Armor;
$FastFaves::key["", numpad9, pack]    = $Inv::Energy_Pack;
$FastFaves::key["", numpad9, weapon1] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad9, weapon2] = $Inv::Chaingun;
$FastFaves::key["", numpad9, weapon3] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad9, weapon4] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad9, weapon5] = $Inv::Mortar;
$FastFaves::key["", numpad9, weapon6] = "";
$FastFaves::key["", numpad9, extra1]  = "";
$FastFaves::key["", numpad9, extra2]  = "";
$FastFaves::key["", numpad9, extra3]  = "";
$FastFaves::key["", numpad9, extra4]  = "";
$FastFaves::key["", numpad9, extra5]  = "";
$FastFaves::key["", numpad9, extra6]  = "";
$FastFaves::key["", numpad9, extra7]  = "";
$FastFaves::key["", numpad9, vehicle] = "";
$FastFaves::key["", numpad9, mount]   = $Inv::Disc_Launcher;

FastFaves::bindKey(numpad9);
//-------------------------------------

$FastFaves::key[control, decimal, loadout] = "";
$FastFaves::key[control, decimal, armor]   = "";
$FastFaves::key[control, decimal, pack]    = "";
$FastFaves::key[control, decimal, weapon1] = "";
$FastFaves::key[control, decimal, weapon2] = "";
$FastFaves::key[control, decimal, weapon3] = "";
$FastFaves::key[control, decimal, weapon4] = "";
$FastFaves::key[control, decimal, weapon5] = "";
$FastFaves::key[control, decimal, weapon6] = "";
$FastFaves::key[control, decimal, extra1]  = "";
$FastFaves::key[control, decimal, extra2]  = "";
$FastFaves::key[control, decimal, extra3]  = "";
$FastFaves::key[control, decimal, extra4]  = "";
$FastFaves::key[control, decimal, extra5]  = "";
$FastFaves::key[control, decimal, extra6]  = "";
$FastFaves::key[control, decimal, extra7]  = "";
$FastFaves::key[control, decimal, vehicle] = "";
$FastFaves::key[control, decimal, mount]   = "";

FastFaves::bindKey(control, decimal);
//-------------------------------------

$FastFaves::key[control, numpad0, loadout] = "";
$FastFaves::key[control, numpad0, armor]   = "";
$FastFaves::key[control, numpad0, pack]    = $Inv::Inventory_Station;
$FastFaves::key[control, numpad0, weapon1] = "";
$FastFaves::key[control, numpad0, weapon2] = "";
$FastFaves::key[control, numpad0, weapon3] = "";
$FastFaves::key[control, numpad0, weapon4] = "";
$FastFaves::key[control, numpad0, weapon5] = "";
$FastFaves::key[control, numpad0, weapon6] = "";
$FastFaves::key[control, numpad0, extra1]  = "";
$FastFaves::key[control, numpad0, extra2]  = "";
$FastFaves::key[control, numpad0, extra3]  = "";
$FastFaves::key[control, numpad0, extra4]  = "";
$FastFaves::key[control, numpad0, extra5]  = "";
$FastFaves::key[control, numpad0, extra6]  = "";
$FastFaves::key[control, numpad0, extra7]  = "";
$FastFaves::key[control, numpad0, vehicle] = "";
$FastFaves::key[control, numpad0, mount]   = "";

FastFaves::bindKey(control, numpad0);
//-------------------------------------

$FastFaves::key[control, numpad1, loadout] = "";
$FastFaves::key[control, numpad1, armor]   = "";
$FastFaves::key[control, numpad1, pack]    = $Inv::Ammo_Station;
$FastFaves::key[control, numpad1, weapon1] = "";
$FastFaves::key[control, numpad1, weapon2] = "";
$FastFaves::key[control, numpad1, weapon3] = "";
$FastFaves::key[control, numpad1, weapon4] = "";
$FastFaves::key[control, numpad1, weapon5] = "";
$FastFaves::key[control, numpad1, weapon6] = "";
$FastFaves::key[control, numpad1, extra1]  = "";
$FastFaves::key[control, numpad1, extra2]  = "";
$FastFaves::key[control, numpad1, extra3]  = "";
$FastFaves::key[control, numpad1, extra4]  = "";
$FastFaves::key[control, numpad1, extra5]  = "";
$FastFaves::key[control, numpad1, extra6]  = "";
$FastFaves::key[control, numpad1, extra7]  = "";
$FastFaves::key[control, numpad1, vehicle] = "";
$FastFaves::key[control, numpad1, mount]   = "";

FastFaves::bindKey(control, numpad1);
//-------------------------------------

$FastFaves::key[control, numpad2, loadout] = "";
$FastFaves::key[control, numpad2, armor]   = "";
$FastFaves::key[control, numpad2, pack]    = $Inv::Repair_Pack;
$FastFaves::key[control, numpad2, weapon1] = "";
$FastFaves::key[control, numpad2, weapon2] = "";
$FastFaves::key[control, numpad2, weapon3] = "";
$FastFaves::key[control, numpad2, weapon4] = "";
$FastFaves::key[control, numpad2, weapon5] = "";
$FastFaves::key[control, numpad2, weapon6] = "";
$FastFaves::key[control, numpad2, extra1]  = "";
$FastFaves::key[control, numpad2, extra2]  = "";
$FastFaves::key[control, numpad2, extra3]  = "";
$FastFaves::key[control, numpad2, extra4]  = "";
$FastFaves::key[control, numpad2, extra5]  = "";
$FastFaves::key[control, numpad2, extra6]  = "";
$FastFaves::key[control, numpad2, extra7]  = "";
$FastFaves::key[control, numpad2, vehicle] = "";
$FastFaves::key[control, numpad2, mount]   = "";

FastFaves::bindKey(control, numpad2);
//-------------------------------------

$FastFaves::key[control, numpad3, loadout] = "";
$FastFaves::key[control, numpad3, armor]   = "";
$FastFaves::key[control, numpad3, pack]    = $Inv::Shield_Pack;
$FastFaves::key[control, numpad3, weapon1] = "";
$FastFaves::key[control, numpad3, weapon2] = "";
$FastFaves::key[control, numpad3, weapon3] = "";
$FastFaves::key[control, numpad3, weapon4] = "";
$FastFaves::key[control, numpad3, weapon5] = "";
$FastFaves::key[control, numpad3, weapon6] = "";
$FastFaves::key[control, numpad3, extra1]  = "";
$FastFaves::key[control, numpad3, extra2]  = "";
$FastFaves::key[control, numpad3, extra3]  = "";
$FastFaves::key[control, numpad3, extra4]  = "";
$FastFaves::key[control, numpad3, extra5]  = "";
$FastFaves::key[control, numpad3, extra6]  = "";
$FastFaves::key[control, numpad3, extra7]  = "";
$FastFaves::key[control, numpad3, vehicle] = "";
$FastFaves::key[control, numpad3, mount]   = "";

FastFaves::bindKey(control, numpad3);
//-------------------------------------

$FastFaves::key[control, numpad4, loadout] = "";
$FastFaves::key[control, numpad4, armor]   = "";
$FastFaves::key[control, numpad4, pack]    = $Inv::Ammo_Pack;
$FastFaves::key[control, numpad4, weapon1] = "";
$FastFaves::key[control, numpad4, weapon2] = "";
$FastFaves::key[control, numpad4, weapon3] = "";
$FastFaves::key[control, numpad4, weapon4] = "";
$FastFaves::key[control, numpad4, weapon5] = "";
$FastFaves::key[control, numpad4, weapon6] = "";
$FastFaves::key[control, numpad4, extra1]  = "";
$FastFaves::key[control, numpad4, extra2]  = "";
$FastFaves::key[control, numpad4, extra3]  = "";
$FastFaves::key[control, numpad4, extra4]  = "";
$FastFaves::key[control, numpad4, extra5]  = "";
$FastFaves::key[control, numpad4, extra6]  = "";
$FastFaves::key[control, numpad4, extra7]  = "";
$FastFaves::key[control, numpad4, vehicle] = "";
$FastFaves::key[control, numpad4, mount]   = "";

FastFaves::bindKey(control, numpad4);
//-------------------------------------

$FastFaves::key[control, numpad5, loadout] = "Shielded";
$FastFaves::key[control, numpad5, armor]   = "";
$FastFaves::key[control, numpad5, pack]    = $Inv::Sensor_Jammer_Pack;
$FastFaves::key[control, numpad5, weapon1] = "";
$FastFaves::key[control, numpad5, weapon2] = "";
$FastFaves::key[control, numpad5, weapon3] = "";
$FastFaves::key[control, numpad5, weapon4] = "";
$FastFaves::key[control, numpad5, weapon5] = "";
$FastFaves::key[control, numpad5, weapon6] = "";
$FastFaves::key[control, numpad5, extra1]  = "";
$FastFaves::key[control, numpad5, extra2]  = "";
$FastFaves::key[control, numpad5, extra3]  = "";
$FastFaves::key[control, numpad5, extra4]  = "";
$FastFaves::key[control, numpad5, extra5]  = "";
$FastFaves::key[control, numpad5, extra6]  = "";
$FastFaves::key[control, numpad5, extra7]  = "";
$FastFaves::key[control, numpad5, vehicle] = "";
$FastFaves::key[control, numpad5, mount]   = "";

FastFaves::bindKey(control, numpad5);
//-------------------------------------

$FastFaves::key[control, numpad6, loadout] = "";
$FastFaves::key[control, numpad6, armor]   = "";
$FastFaves::key[control, numpad6, pack]    = $Inv::Energy_Pack;
$FastFaves::key[control, numpad6, weapon1] = "";
$FastFaves::key[control, numpad6, weapon2] = "";
$FastFaves::key[control, numpad6, weapon3] = "";
$FastFaves::key[control, numpad6, weapon4] = "";
$FastFaves::key[control, numpad6, weapon5] = "";
$FastFaves::key[control, numpad6, weapon6] = "";
$FastFaves::key[control, numpad6, extra1]  = "";
$FastFaves::key[control, numpad6, extra2]  = "";
$FastFaves::key[control, numpad6, extra3]  = "";
$FastFaves::key[control, numpad6, extra4]  = "";
$FastFaves::key[control, numpad6, extra5]  = "";
$FastFaves::key[control, numpad6, extra6]  = "";
$FastFaves::key[control, numpad6, extra7]  = "";
$FastFaves::key[control, numpad6, vehicle] = "";
$FastFaves::key[control, numpad6, mount]   = "";

FastFaves::bindKey(control, numpad6);
//-------------------------------------

$FastFaves::key[control, numpad7, loadout] = "";
$FastFaves::key[control, numpad7, armor]   = "";
$FastFaves::key[control, numpad7, pack]    = "";
$FastFaves::key[control, numpad7, weapon1] = "";
$FastFaves::key[control, numpad7, weapon2] = "";
$FastFaves::key[control, numpad7, weapon3] = "";
$FastFaves::key[control, numpad7, weapon4] = "";
$FastFaves::key[control, numpad7, weapon5] = "";
$FastFaves::key[control, numpad7, weapon6] = "";
$FastFaves::key[control, numpad7, extra1]  = "";
$FastFaves::key[control, numpad7, extra2]  = "";
$FastFaves::key[control, numpad7, extra3]  = "";
$FastFaves::key[control, numpad7, extra4]  = "";
$FastFaves::key[control, numpad7, extra5]  = "";
$FastFaves::key[control, numpad7, extra6]  = "";
$FastFaves::key[control, numpad7, extra7]  = "";
$FastFaves::key[control, numpad7, vehicle] = $Inv::Scout;
$FastFaves::key[control, numpad7, mount]   = "";

FastFaves::bindKey(control, numpad7);
//-------------------------------------

$FastFaves::key[control, numpad8, loadout] = "";
$FastFaves::key[control, numpad8, armor]   = "";
$FastFaves::key[control, numpad8, pack]    = "";
$FastFaves::key[control, numpad8, weapon1] = "";
$FastFaves::key[control, numpad8, weapon2] = "";
$FastFaves::key[control, numpad8, weapon3] = "";
$FastFaves::key[control, numpad8, weapon4] = "";
$FastFaves::key[control, numpad8, weapon5] = "";
$FastFaves::key[control, numpad8, weapon6] = "";
$FastFaves::key[control, numpad8, extra1]  = "";
$FastFaves::key[control, numpad8, extra2]  = "";
$FastFaves::key[control, numpad8, extra3]  = "";
$FastFaves::key[control, numpad8, extra4]  = "";
$FastFaves::key[control, numpad8, extra5]  = "";
$FastFaves::key[control, numpad8, extra6]  = "";
$FastFaves::key[control, numpad8, extra7]  = "";
$FastFaves::key[control, numpad8, vehicle] = $Inv::LPC;
$FastFaves::key[control, numpad8, mount]   = "";

FastFaves::bindKey(control, numpad8);
//-------------------------------------

$FastFaves::key[control, numpad9, loadout] = "";
$FastFaves::key[control, numpad9, armor]   = "";
$FastFaves::key[control, numpad9, pack]    = "";
$FastFaves::key[control, numpad9, weapon1] = "";
$FastFaves::key[control, numpad9, weapon2] = "";
$FastFaves::key[control, numpad9, weapon3] = "";
$FastFaves::key[control, numpad9, weapon4] = "";
$FastFaves::key[control, numpad9, weapon5] = "";
$FastFaves::key[control, numpad9, weapon6] = "";
$FastFaves::key[control, numpad9, extra1]  = "";
$FastFaves::key[control, numpad9, extra2]  = "";
$FastFaves::key[control, numpad9, extra3]  = "";
$FastFaves::key[control, numpad9, extra4]  = "";
$FastFaves::key[control, numpad9, extra5]  = "";
$FastFaves::key[control, numpad9, extra6]  = "";
$FastFaves::key[control, numpad9, extra7]  = "";
$FastFaves::key[control, numpad9, vehicle] = $Inv::HPC;
$FastFaves::key[control, numpad9, mount]   = "";

FastFaves::bindKey(control, numpad9);
//-------------------------------------


$FastFaves::key[alt, decimal, loadout] = "Feed Station (Empty Loadout)";
$FastFaves::key[alt, decimal, armor]   = "";
$FastFaves::key[alt, decimal, pack]    = "";
$FastFaves::key[alt, decimal, weapon1] = "";
$FastFaves::key[alt, decimal, weapon2] = "";
$FastFaves::key[alt, decimal, weapon3] = "";
$FastFaves::key[alt, decimal, weapon4] = "";
$FastFaves::key[alt, decimal, weapon5] = "";
$FastFaves::key[alt, decimal, weapon6] = "";
$FastFaves::key[alt, decimal, extra1]  = "";
$FastFaves::key[alt, decimal, extra2]  = "";
$FastFaves::key[alt, decimal, extra3]  = "";
$FastFaves::key[alt, decimal, extra4]  = "";
$FastFaves::key[alt, decimal, extra5]  = "";
$FastFaves::key[alt, decimal, extra6]  = "";
$FastFaves::key[alt, decimal, extra7]  = "";
$FastFaves::key[alt, decimal, vehicle] = "";
$FastFaves::key[alt, decimal, mount]   = "";

FastFaves::bindKey(alt, decimal);
//-------------------------------------

$FastFaves::key[alt, numpad0, loadout] = "";
$FastFaves::key[alt, numpad0, armor]   = "";
$FastFaves::key[alt, numpad0, pack]    = "";
$FastFaves::key[alt, numpad0, weapon1] = "";
$FastFaves::key[alt, numpad0, weapon2] = "";
$FastFaves::key[alt, numpad0, weapon3] = "";
$FastFaves::key[alt, numpad0, weapon4] = "";
$FastFaves::key[alt, numpad0, weapon5] = "";
$FastFaves::key[alt, numpad0, weapon6] = "";
$FastFaves::key[alt, numpad0, extra1]  = "";
$FastFaves::key[alt, numpad0, extra2]  = "";
$FastFaves::key[alt, numpad0, extra3]  = "";
$FastFaves::key[alt, numpad0, extra4]  = "";
$FastFaves::key[alt, numpad0, extra5]  = "";
$FastFaves::key[alt, numpad0, extra6]  = "";
$FastFaves::key[alt, numpad0, extra7]  = "";
$FastFaves::key[alt, numpad0, vehicle] = "";
$FastFaves::key[alt, numpad0, mount]   = "";

//FastFaves::bindKey(alt, numpad0);
//-------------------------------------

$FastFaves::key[alt, numpad1, loadout] = "";
$FastFaves::key[alt, numpad1, armor]   = "";
$FastFaves::key[alt, numpad1, pack]    = $Inv::Motion_Sensor;
$FastFaves::key[alt, numpad1, weapon1] = "";
$FastFaves::key[alt, numpad1, weapon2] = "";
$FastFaves::key[alt, numpad1, weapon3] = "";
$FastFaves::key[alt, numpad1, weapon4] = "";
$FastFaves::key[alt, numpad1, weapon5] = "";
$FastFaves::key[alt, numpad1, weapon6] = "";
$FastFaves::key[alt, numpad1, extra1]  = "";
$FastFaves::key[alt, numpad1, extra2]  = "";
$FastFaves::key[alt, numpad1, extra3]  = "";
$FastFaves::key[alt, numpad1, extra4]  = "";
$FastFaves::key[alt, numpad1, extra5]  = "";
$FastFaves::key[alt, numpad1, extra6]  = "";
$FastFaves::key[alt, numpad1, extra7]  = "";
$FastFaves::key[alt, numpad1, vehicle] = "";
$FastFaves::key[alt, numpad1, mount]   = "";

FastFaves::bindKey(alt, numpad1);
//-------------------------------------

$FastFaves::key[alt, numpad2, loadout] = "";
$FastFaves::key[alt, numpad2, armor]   = "";
$FastFaves::key[alt, numpad2, pack]    = $Inv::Pulse_Sensor;
$FastFaves::key[alt, numpad2, weapon1] = "";
$FastFaves::key[alt, numpad2, weapon2] = "";
$FastFaves::key[alt, numpad2, weapon3] = "";
$FastFaves::key[alt, numpad2, weapon4] = "";
$FastFaves::key[alt, numpad2, weapon5] = "";
$FastFaves::key[alt, numpad2, weapon6] = "";
$FastFaves::key[alt, numpad2, extra1]  = "";
$FastFaves::key[alt, numpad2, extra2]  = "";
$FastFaves::key[alt, numpad2, extra3]  = "";
$FastFaves::key[alt, numpad2, extra4]  = "";
$FastFaves::key[alt, numpad2, extra5]  = "";
$FastFaves::key[alt, numpad2, extra6]  = "";
$FastFaves::key[alt, numpad2, extra7]  = "";
$FastFaves::key[alt, numpad2, vehicle] = "";
$FastFaves::key[alt, numpad2, mount]   = "";

FastFaves::bindKey(alt, numpad2);
//-------------------------------------

$FastFaves::key[alt, numpad3, loadout] = "";
$FastFaves::key[alt, numpad3, armor]   = "";
$FastFaves::key[alt, numpad3, pack]    = $Inv::Sensor_Jammer;
$FastFaves::key[alt, numpad3, weapon1] = "";
$FastFaves::key[alt, numpad3, weapon2] = "";
$FastFaves::key[alt, numpad3, weapon3] = "";
$FastFaves::key[alt, numpad3, weapon4] = "";
$FastFaves::key[alt, numpad3, weapon5] = "";
$FastFaves::key[alt, numpad3, weapon6] = "";
$FastFaves::key[alt, numpad3, extra1]  = "";
$FastFaves::key[alt, numpad3, extra2]  = "";
$FastFaves::key[alt, numpad3, extra3]  = "";
$FastFaves::key[alt, numpad3, extra4]  = "";
$FastFaves::key[alt, numpad3, extra5]  = "";
$FastFaves::key[alt, numpad3, extra6]  = "";
$FastFaves::key[alt, numpad3, extra7]  = "";
$FastFaves::key[alt, numpad3, vehicle] = "";
$FastFaves::key[alt, numpad3, mount]   = "";

FastFaves::bindKey(alt, numpad3);
//-------------------------------------

$FastFaves::key[alt, numpad4, loadout] = "";
$FastFaves::key[alt, numpad4, armor]   = "";
$FastFaves::key[alt, numpad4, pack]    = $Inv::Camera;
$FastFaves::key[alt, numpad4, weapon1] = "";
$FastFaves::key[alt, numpad4, weapon2] = "";
$FastFaves::key[alt, numpad4, weapon3] = "";
$FastFaves::key[alt, numpad4, weapon4] = "";
$FastFaves::key[alt, numpad4, weapon5] = "";
$FastFaves::key[alt, numpad4, weapon6] = "";
$FastFaves::key[alt, numpad4, extra1]  = "";
$FastFaves::key[alt, numpad4, extra2]  = "";
$FastFaves::key[alt, numpad4, extra3]  = "";
$FastFaves::key[alt, numpad4, extra4]  = "";
$FastFaves::key[alt, numpad4, extra5]  = "";
$FastFaves::key[alt, numpad4, extra6]  = "";
$FastFaves::key[alt, numpad4, extra7]  = "";
$FastFaves::key[alt, numpad4, vehicle] = "";
$FastFaves::key[alt, numpad4, mount]   = "";

FastFaves::bindKey(alt, numpad4);
//-------------------------------------

$FastFaves::key[alt, numpad5, loadout] = "";
$FastFaves::key[alt, numpad5, armor]   = "";
$FastFaves::key[alt, numpad5, pack]    = "";
$FastFaves::key[alt, numpad5, weapon1] = "";
$FastFaves::key[alt, numpad5, weapon2] = "";
$FastFaves::key[alt, numpad5, weapon3] = "";
$FastFaves::key[alt, numpad5, weapon4] = "";
$FastFaves::key[alt, numpad5, weapon5] = "";
$FastFaves::key[alt, numpad5, weapon6] = "";
$FastFaves::key[alt, numpad5, extra1]  = "";
$FastFaves::key[alt, numpad5, extra2]  = "";
$FastFaves::key[alt, numpad5, extra3]  = "";
$FastFaves::key[alt, numpad5, extra4]  = "";
$FastFaves::key[alt, numpad5, extra5]  = "";
$FastFaves::key[alt, numpad5, extra6]  = "";
$FastFaves::key[alt, numpad5, extra7]  = "";
$FastFaves::key[alt, numpad5, vehicle] = "";
$FastFaves::key[alt, numpad5, mount]   = "";

FastFaves::bindKey(alt, numpad5);
//-------------------------------------

$FastFaves::key[alt, numpad6, loadout] = "";
$FastFaves::key[alt, numpad6, armor]   = "";
$FastFaves::key[alt, numpad6, pack]    = "";
$FastFaves::key[alt, numpad6, weapon1] = "";
$FastFaves::key[alt, numpad6, weapon2] = "";
$FastFaves::key[alt, numpad6, weapon3] = "";
$FastFaves::key[alt, numpad6, weapon4] = "";
$FastFaves::key[alt, numpad6, weapon5] = "";
$FastFaves::key[alt, numpad6, weapon6] = "";
$FastFaves::key[alt, numpad6, extra1]  = "";
$FastFaves::key[alt, numpad6, extra2]  = "";
$FastFaves::key[alt, numpad6, extra3]  = "";
$FastFaves::key[alt, numpad6, extra4]  = "";
$FastFaves::key[alt, numpad6, extra5]  = "";
$FastFaves::key[alt, numpad6, extra6]  = "";
$FastFaves::key[alt, numpad6, extra7]  = "";
$FastFaves::key[alt, numpad6, vehicle] = "";
$FastFaves::key[alt, numpad6, mount]   = "";

//FastFaves::bindKey(alt, numpad6);
//-------------------------------------

$FastFaves::key[alt, numpad7, loadout] = "";
$FastFaves::key[alt, numpad7, armor]   = "";
$FastFaves::key[alt, numpad7, pack]    = "";
$FastFaves::key[alt, numpad7, weapon1] = "";
$FastFaves::key[alt, numpad7, weapon2] = "";
$FastFaves::key[alt, numpad7, weapon3] = "";
$FastFaves::key[alt, numpad7, weapon4] = "";
$FastFaves::key[alt, numpad7, weapon5] = "";
$FastFaves::key[alt, numpad7, weapon6] = "";
$FastFaves::key[alt, numpad7, extra1]  = "";
$FastFaves::key[alt, numpad7, extra2]  = "";
$FastFaves::key[alt, numpad7, extra3]  = "";
$FastFaves::key[alt, numpad7, extra4]  = "";
$FastFaves::key[alt, numpad7, extra5]  = "";
$FastFaves::key[alt, numpad7, extra6]  = "";
$FastFaves::key[alt, numpad7, extra7]  = "";
$FastFaves::key[alt, numpad7, vehicle] = "";
$FastFaves::key[alt, numpad7, mount]   = "";

//FastFaves::bindKey(alt, numpad7);
//-------------------------------------

$FastFaves::key[alt, numpad8, loadout] = "";
$FastFaves::key[alt, numpad8, armor]   = "";
$FastFaves::key[alt, numpad8, pack]    = "";
$FastFaves::key[alt, numpad8, weapon1] = "";
$FastFaves::key[alt, numpad8, weapon2] = "";
$FastFaves::key[alt, numpad8, weapon3] = "";
$FastFaves::key[alt, numpad8, weapon4] = "";
$FastFaves::key[alt, numpad8, weapon5] = "";
$FastFaves::key[alt, numpad8, weapon6] = "";
$FastFaves::key[alt, numpad8, extra1]  = "";
$FastFaves::key[alt, numpad8, extra2]  = "";
$FastFaves::key[alt, numpad8, extra3]  = "";
$FastFaves::key[alt, numpad8, extra4]  = "";
$FastFaves::key[alt, numpad8, extra5]  = "";
$FastFaves::key[alt, numpad8, extra6]  = "";
$FastFaves::key[alt, numpad8, extra7]  = "";
$FastFaves::key[alt, numpad8, vehicle] = "";
$FastFaves::key[alt, numpad8, mount]   = "";

//FastFaves::bindKey(alt, numpad8);
//-------------------------------------

$FastFaves::key[alt, numpad9, loadout] = "";
$FastFaves::key[alt, numpad9, armor]   = "";
$FastFaves::key[alt, numpad9, pack]    = "";
$FastFaves::key[alt, numpad9, weapon1] = "";
$FastFaves::key[alt, numpad9, weapon2] = "";
$FastFaves::key[alt, numpad9, weapon3] = "";
$FastFaves::key[alt, numpad9, weapon4] = "";
$FastFaves::key[alt, numpad9, weapon5] = "";
$FastFaves::key[alt, numpad9, weapon6] = "";
$FastFaves::key[alt, numpad9, extra1]  = "";
$FastFaves::key[alt, numpad9, extra2]  = "";
$FastFaves::key[alt, numpad9, extra3]  = "";
$FastFaves::key[alt, numpad9, extra4]  = "";
$FastFaves::key[alt, numpad9, extra5]  = "";
$FastFaves::key[alt, numpad9, extra6]  = "";
$FastFaves::key[alt, numpad9, extra7]  = "";
$FastFaves::key[alt, numpad9, vehicle] = "";
$FastFaves::key[alt, numpad9, mount]   = "";

//FastFaves::bindKey(alt, numpad9);
//-------------------------------------

$FastFaves::key[shift, decimal, loadout] = "";
$FastFaves::key[shift, decimal, armor]   = "";
$FastFaves::key[shift, decimal, pack]    = "";
$FastFaves::key[shift, decimal, weapon1] = "";
$FastFaves::key[shift, decimal, weapon2] = "";
$FastFaves::key[shift, decimal, weapon3] = "";
$FastFaves::key[shift, decimal, weapon4] = "";
$FastFaves::key[shift, decimal, weapon5] = "";
$FastFaves::key[shift, decimal, weapon6] = "";
$FastFaves::key[shift, decimal, extra1]  = "";
$FastFaves::key[shift, decimal, extra2]  = "";
$FastFaves::key[shift, decimal, extra3]  = "";
$FastFaves::key[shift, decimal, extra4]  = "";
$FastFaves::key[shift, decimal, extra5]  = "";
$FastFaves::key[shift, decimal, extra6]  = "";
$FastFaves::key[shift, decimal, extra7]  = "";
$FastFaves::key[shift, decimal, vehicle] = "";
$FastFaves::key[shift, decimal, mount]   = "";

//FastFaves::bindKey(shift, decimal);
//-------------------------------------

$FastFaves::key[shift, numpad0, loadout] = "";
$FastFaves::key[shift, numpad0, armor]   = "";
$FastFaves::key[shift, numpad0, pack]    = "";
$FastFaves::key[shift, numpad0, weapon1] = "";
$FastFaves::key[shift, numpad0, weapon2] = "";
$FastFaves::key[shift, numpad0, weapon3] = "";
$FastFaves::key[shift, numpad0, weapon4] = "";
$FastFaves::key[shift, numpad0, weapon5] = "";
$FastFaves::key[shift, numpad0, weapon6] = "";
$FastFaves::key[shift, numpad0, extra1]  = "";
$FastFaves::key[shift, numpad0, extra2]  = "";
$FastFaves::key[shift, numpad0, extra3]  = "";
$FastFaves::key[shift, numpad0, extra4]  = "";
$FastFaves::key[shift, numpad0, extra5]  = "";
$FastFaves::key[shift, numpad0, extra6]  = "";
$FastFaves::key[shift, numpad0, extra7]  = "";
$FastFaves::key[shift, numpad0, vehicle] = "";
$FastFaves::key[shift, numpad0, mount]   = "";

//FastFaves::bindKey(shift, numpad0);
//-------------------------------------

$FastFaves::key[shift, numpad1, loadout] = "";
$FastFaves::key[shift, numpad1, armor]   = "";
$FastFaves::key[shift, numpad1, pack]    = "";
$FastFaves::key[shift, numpad1, weapon1] = "";
$FastFaves::key[shift, numpad1, weapon2] = "";
$FastFaves::key[shift, numpad1, weapon3] = "";
$FastFaves::key[shift, numpad1, weapon4] = "";
$FastFaves::key[shift, numpad1, weapon5] = "";
$FastFaves::key[shift, numpad1, weapon6] = "";
$FastFaves::key[shift, numpad1, extra1]  = "";
$FastFaves::key[shift, numpad1, extra2]  = "";
$FastFaves::key[shift, numpad1, extra3]  = "";
$FastFaves::key[shift, numpad1, extra4]  = "";
$FastFaves::key[shift, numpad1, extra5]  = "";
$FastFaves::key[shift, numpad1, extra6]  = "";
$FastFaves::key[shift, numpad1, extra7]  = "";
$FastFaves::key[shift, numpad1, vehicle] = "";
$FastFaves::key[shift, numpad1, mount]   = "";

//FastFaves::bindKey(shift, numpad1);
//-------------------------------------

$FastFaves::key[shift, numpad2, loadout] = "";
$FastFaves::key[shift, numpad2, armor]   = "";
$FastFaves::key[shift, numpad2, pack]    = "";
$FastFaves::key[shift, numpad2, weapon1] = "";
$FastFaves::key[shift, numpad2, weapon2] = "";
$FastFaves::key[shift, numpad2, weapon3] = "";
$FastFaves::key[shift, numpad2, weapon4] = "";
$FastFaves::key[shift, numpad2, weapon5] = "";
$FastFaves::key[shift, numpad2, weapon6] = "";
$FastFaves::key[shift, numpad2, extra1]  = "";
$FastFaves::key[shift, numpad2, extra2]  = "";
$FastFaves::key[shift, numpad2, extra3]  = "";
$FastFaves::key[shift, numpad2, extra4]  = "";
$FastFaves::key[shift, numpad2, extra5]  = "";
$FastFaves::key[shift, numpad2, extra6]  = "";
$FastFaves::key[shift, numpad2, extra7]  = "";
$FastFaves::key[shift, numpad2, vehicle] = "";
$FastFaves::key[shift, numpad2, mount]   = "";

//FastFaves::bindKey(shift, numpad2);
//-------------------------------------

$FastFaves::key[shift, numpad3, loadout] = "";
$FastFaves::key[shift, numpad3, armor]   = "";
$FastFaves::key[shift, numpad3, pack]    = "";
$FastFaves::key[shift, numpad3, weapon1] = "";
$FastFaves::key[shift, numpad3, weapon2] = "";
$FastFaves::key[shift, numpad3, weapon3] = "";
$FastFaves::key[shift, numpad3, weapon4] = "";
$FastFaves::key[shift, numpad3, weapon5] = "";
$FastFaves::key[shift, numpad3, weapon6] = "";
$FastFaves::key[shift, numpad3, extra1]  = "";
$FastFaves::key[shift, numpad3, extra2]  = "";
$FastFaves::key[shift, numpad3, extra3]  = "";
$FastFaves::key[shift, numpad3, extra4]  = "";
$FastFaves::key[shift, numpad3, extra5]  = "";
$FastFaves::key[shift, numpad3, extra6]  = "";
$FastFaves::key[shift, numpad3, extra7]  = "";
$FastFaves::key[shift, numpad3, vehicle] = "";
$FastFaves::key[shift, numpad3, mount]   = "";

//FastFaves::bindKey(shift, numpad3);
//-------------------------------------

$FastFaves::key[shift, numpad4, loadout] = "";
$FastFaves::key[shift, numpad4, armor]   = "";
$FastFaves::key[shift, numpad4, pack]    = "";
$FastFaves::key[shift, numpad4, weapon1] = "";
$FastFaves::key[shift, numpad4, weapon2] = "";
$FastFaves::key[shift, numpad4, weapon3] = "";
$FastFaves::key[shift, numpad4, weapon4] = "";
$FastFaves::key[shift, numpad4, weapon5] = "";
$FastFaves::key[shift, numpad4, weapon6] = "";
$FastFaves::key[shift, numpad4, extra1]  = "";
$FastFaves::key[shift, numpad4, extra2]  = "";
$FastFaves::key[shift, numpad4, extra3]  = "";
$FastFaves::key[shift, numpad4, extra4]  = "";
$FastFaves::key[shift, numpad4, extra5]  = "";
$FastFaves::key[shift, numpad4, extra6]  = "";
$FastFaves::key[shift, numpad4, extra7]  = "";
$FastFaves::key[shift, numpad4, vehicle] = "";
$FastFaves::key[shift, numpad4, mount]   = "";

//FastFaves::bindKey(shift, numpad4);
//-------------------------------------

$FastFaves::key[shift, numpad5, loadout] = "";
$FastFaves::key[shift, numpad5, armor]   = "";
$FastFaves::key[shift, numpad5, pack]    = "";
$FastFaves::key[shift, numpad5, weapon1] = "";
$FastFaves::key[shift, numpad5, weapon2] = "";
$FastFaves::key[shift, numpad5, weapon3] = "";
$FastFaves::key[shift, numpad5, weapon4] = "";
$FastFaves::key[shift, numpad5, weapon5] = "";
$FastFaves::key[shift, numpad5, weapon6] = "";
$FastFaves::key[shift, numpad5, extra1]  = "";
$FastFaves::key[shift, numpad5, extra2]  = "";
$FastFaves::key[shift, numpad5, extra3]  = "";
$FastFaves::key[shift, numpad5, extra4]  = "";
$FastFaves::key[shift, numpad5, extra5]  = "";
$FastFaves::key[shift, numpad5, extra6]  = "";
$FastFaves::key[shift, numpad5, extra7]  = "";
$FastFaves::key[shift, numpad5, vehicle] = "";
$FastFaves::key[shift, numpad5, mount]   = "";

//FastFaves::bindKey(shift, numpad5);
//-------------------------------------

$FastFaves::key[shift, numpad6, loadout] = "";
$FastFaves::key[shift, numpad6, armor]   = "";
$FastFaves::key[shift, numpad6, pack]    = "";
$FastFaves::key[shift, numpad6, weapon1] = "";
$FastFaves::key[shift, numpad6, weapon2] = "";
$FastFaves::key[shift, numpad6, weapon3] = "";
$FastFaves::key[shift, numpad6, weapon4] = "";
$FastFaves::key[shift, numpad6, weapon5] = "";
$FastFaves::key[shift, numpad6, weapon6] = "";
$FastFaves::key[shift, numpad6, extra1]  = "";
$FastFaves::key[shift, numpad6, extra2]  = "";
$FastFaves::key[shift, numpad6, extra3]  = "";
$FastFaves::key[shift, numpad6, extra4]  = "";
$FastFaves::key[shift, numpad6, extra5]  = "";
$FastFaves::key[shift, numpad6, extra6]  = "";
$FastFaves::key[shift, numpad6, extra7]  = "";
$FastFaves::key[shift, numpad6, vehicle] = "";
$FastFaves::key[shift, numpad6, mount]   = "";

//FastFaves::bindKey(shift, numpad6);
//-------------------------------------

$FastFaves::key[shift, numpad7, loadout] = "";
$FastFaves::key[shift, numpad7, armor]   = "";
$FastFaves::key[shift, numpad7, pack]    = "";
$FastFaves::key[shift, numpad7, weapon1] = "";
$FastFaves::key[shift, numpad7, weapon2] = "";
$FastFaves::key[shift, numpad7, weapon3] = "";
$FastFaves::key[shift, numpad7, weapon4] = "";
$FastFaves::key[shift, numpad7, weapon5] = "";
$FastFaves::key[shift, numpad7, weapon6] = "";
$FastFaves::key[shift, numpad7, extra1]  = "";
$FastFaves::key[shift, numpad7, extra2]  = "";
$FastFaves::key[shift, numpad7, extra3]  = "";
$FastFaves::key[shift, numpad7, extra4]  = "";
$FastFaves::key[shift, numpad7, extra5]  = "";
$FastFaves::key[shift, numpad7, extra6]  = "";
$FastFaves::key[shift, numpad7, extra7]  = "";
$FastFaves::key[shift, numpad7, vehicle] = "";
$FastFaves::key[shift, numpad7, mount]   = "";

//FastFaves::bindKey(shift, numpad7);
//-------------------------------------

$FastFaves::key[shift, numpad8, loadout] = "";
$FastFaves::key[shift, numpad8, armor]   = "";
$FastFaves::key[shift, numpad8, pack]    = "";
$FastFaves::key[shift, numpad8, weapon1] = "";
$FastFaves::key[shift, numpad8, weapon2] = "";
$FastFaves::key[shift, numpad8, weapon3] = "";
$FastFaves::key[shift, numpad8, weapon4] = "";
$FastFaves::key[shift, numpad8, weapon5] = "";
$FastFaves::key[shift, numpad8, weapon6] = "";
$FastFaves::key[shift, numpad8, extra1]  = "";
$FastFaves::key[shift, numpad8, extra2]  = "";
$FastFaves::key[shift, numpad8, extra3]  = "";
$FastFaves::key[shift, numpad8, extra4]  = "";
$FastFaves::key[shift, numpad8, extra5]  = "";
$FastFaves::key[shift, numpad8, extra6]  = "";
$FastFaves::key[shift, numpad8, extra7]  = "";
$FastFaves::key[shift, numpad8, vehicle] = "";
$FastFaves::key[shift, numpad8, mount]   = "";

//FastFaves::bindKey(shift, numpad8);
//-------------------------------------

$FastFaves::key[shift, numpad9, loadout] = "";
$FastFaves::key[shift, numpad9, armor]   = "";
$FastFaves::key[shift, numpad9, pack]    = "";
$FastFaves::key[shift, numpad9, weapon1] = "";
$FastFaves::key[shift, numpad9, weapon2] = "";
$FastFaves::key[shift, numpad9, weapon3] = "";
$FastFaves::key[shift, numpad9, weapon4] = "";
$FastFaves::key[shift, numpad9, weapon5] = "";
$FastFaves::key[shift, numpad9, weapon6] = "";
$FastFaves::key[shift, numpad9, extra1]  = "";
$FastFaves::key[shift, numpad9, extra2]  = "";
$FastFaves::key[shift, numpad9, extra3]  = "";
$FastFaves::key[shift, numpad9, extra4]  = "";
$FastFaves::key[shift, numpad9, extra5]  = "";
$FastFaves::key[shift, numpad9, extra6]  = "";
$FastFaves::key[shift, numpad9, extra7]  = "";
$FastFaves::key[shift, numpad9, vehicle] = "";
$FastFaves::key[shift, numpad9, mount]   = "";

//FastFaves::bindKey(shift, numpad9);
//-------------------------------------




// ----------------------------------------------------------------------------
// Here are the variable names you can use for the various items, as defined in
// inventory.cs:
//
// Special:
//
// $Inv::Weapon
// $Inv::Ammo
// $Inv::Backpack
//
// BASE armor:
//
// $Inv::Light_Armor");
// $Inv::Medium_Armor");
// $Inv::Heavy_Armor");
//
// BASE vehicles:
//
// $Inv::Scout   <-- on renegades this will point to the scout armor, tell the author of renegades to rename one of them
// $Inv::LPC
// $Inv::HPC
//
// BASE weapons and ammo:
//
// $Inv::Blaster
// $Inv::Chaingun               $Inv::Bullet
// $Inv::Disc_Launcher          $Inv::Disc
// $Inv::ELF_gun
// $Inv::Grenade_Launcher       $Inv::Grenade_Ammo  ($Inv::GrenadeAmmo on servers running old versions of Tribes)
// $Inv::Laser_Rifle
// $Inv::Mortar                 $Inv::Mortar_Ammo   ($Inv::MortarAmmo on servers running old versions of Tribes)
// $Inv::Plasma_Gun             $Inv::Plasma_Bolt
// $Inv::Repair_Gun
// $Inv::Targeting_Laser
//
// BASE packs:
//
// $Inv::Inventory_Station
// $Inv::Ammo_Station
// $Inv::Energy_Pack
// $Inv::Repair_Pack
// $Inv::Shield_Pack
// $Inv::Ammo_Pack
// $Inv::Sensor_Jammer_Pack
// $Inv::Motion_Sensor
// $Inv::Pulse_Sensor
// $Inv::Sensor_Jammer
// $Inv::Camera
// $Inv::Turret
// 
// BASE misc equipment:
// 111111111111
// $Inv::Repair_Kit
// $Inv::Mine
// $Inv::Grenade
// $Inv::Beacon
// 
// MOD armor:
// 
// $Inv::Spy
// $Inv::Scout   <-- on base servers this will point to the scout vehicle
// $Inv::Sniper
// $Inv::Mercenary
// $Inv::Burster
// $Inv::Engineer
// $Inv::Alien
// $Inv::Cyborg
// $Inv::Dragoon
// 
// MOD vehicles:
// 
// $Inv::Firestorm_Bomber
// $Inv::Stealth_LPC
// $Inv::Wraith
// $Inv::Interceptor
// $Inv::BomberLPC
// $Inv::StealthHPC
// 
// MOD weapons and ammo:
// 
// $Inv::Dart_Rifle             $Inv::Poison_Dart
// $Inv::EMP_Grenade_Launcher   $Inv::EMPGrenadeAmmo
// $Inv::Engineer_Repair_Gun
// $Inv::Flame_Thrower
// $Inv::Gauss_Gun
// $Inv::Hyper_Blaster
// $Inv::Ion_Rifle
// $Inv::IX_2000_Sniper_Rifle   $Inv::Rifle_Ammo
// $Inv::MAG_Gun
// $Inv::Magnum                 $Inv::Magnum_Bullets
// $Inv::Omega_Cannon
// $Inv::Phalanxx_Cannon        $Inv::Phalanxx_Ammo
// $Inv::Pyro_Torch             $Inv::Pyro_Charge
// $Inv::Railgun                $Inv::Railgun_Bolt
// $Inv::Rocket_Launcher        $Inv::Rocket_Ammo   ($Inv::Rockets on some servers)
// $Inv::Shockwave_Cannon
// $Inv::Shotgun                $Inv::Shotgun_Shells
// $Inv::Sniper_Rifle           $Inv::Sniper_Bullet
// $Inv::Stinger                $Inv::Rockets
// $Inv::Thunderbolt
// $Inv::Vulcan                 $Inv::Vulcan_Bullet
// 
// MOD packs:
// 
// $Inv::Accelerator_Device
// $Inv::Auto_Rocket_Cannon
// $Inv::Avenger
// $Inv::Blast_Wall
// $Inv::Cloaking_Device
// $Inv::Command_Laptop
// $Inv::Command_Station
// $Inv::Cybernetic_Laser
// $Inv::Deployable_Platform
// $Inv::ELF_Turret
// $Inv::Flak_Cannon
// $Inv::Force_Field
// $Inv::Heat_Sink
// $Inv::Hologram
// $Inv::Ion_Turret
// $Inv::Interceptor_Pack
// $Inv::Laser_Turret
// $Inv::Large_Force_Field
// $Inv::Lightning_Pack
// $Inv::Mechanical_Tree
// $Inv::Missile_Turret
// $Inv::Mortar_Turret
// $Inv::Plasma_Turret
// $Inv::Regeneration_Pack
// $Inv::Rail_Turret
// $Inv::Shock_Turret
// $Inv::Rocket_Booster
// $Inv::Rocket_Turret
// $Inv::Sentry
// $Inv::Small_Force_Field
// $Inv::Springboard
// $Inv::StealthHPC_Pack
// $Inv::StealthShield_Pack
// $Inv::Suicide_DetPack
// $Inv::Teleport_Pad
// $Inv::Vengeance_Missile_Pack
// $Inv::Vulcan_Turret
