// !!!!!!!!!!! mHUD 4.4 -> 'Smart' Reticle / Rangefinder <- 5/23/99 !!!!!!!!!!!
// 
// By:
//    Cowboy
//    cowboy@planetstarsiege.com
//    http://www.planetstarsiege.com/cowboy/
//    ICQ# 31184463
// 
//    I've been working with Writer on this latest release, incorporating the
//    scout reticle (in conjunction with his pilot_mode.cs script)...
//
//    Get that script and many others at: http://www.planetstarsiege.com/lorne/
//
//    If you use Writer's stuff, you'll also what to get mhud_mod.cs off his
//    page, it makes mHUD even more compatible with his scripts!
//
//    Lots of help, code, and reticles from GrymReaper - Kick ass!
//
// Features (newest changes first):
//
// * Added support for a separate Scout reticle (when used in conjunction with
//   Writer's pilot_mode.cs script), and Writer sent me his reticle to include.
//   Also, added more flexability with Writer's zoom.cs keys binding!
// * I've included 'overlay' Reticles for Plasma Gun, Chaingun, Disc Launcher,
//   Laser Rifle, Targeting Laser, and Repair Gun (as well as Mortar & Grenade
//   rangefinders)
// * Completely fixed the bug where certain items in CmdHUD's inventory and
//   command map screens wouldn't be selectable! 
// * Supports different Mortar & Grenade Launcher rangefinders for each major
//   resolution (Presto did 640x480, I did 800x600, Mannkind did 1024x768) If
//   you use a different resolution, you can make your own!
// * Rebound the sniper zoom key (default 'e') to get rangefinders to disappear
//   if you were zooming in
// * I rebind the 1st/3rd person toggle key (default 'r') so that it'll turn
//   off the mHUD display when you are in 3rd person mode (fixed)
// * Bound 'alt-f12' to toggle Debug Mode, will echo to the console everything
//   that mHUD does, for troubleshooting or curiosity :)
// * Bound 'alt-q' to force the Mortar rangefinder on, use it if you're at a
//   commander station and using a Mortar Turret! (stays on until you change
//   Gui modes or change weapons)
// * Reticles are now 'overlays' and ADD to the default cursor! use your own
//   personal favorite default (or use mine) and any cursor you make ADDS to
//   your existing one! (if you want, you can set it up the old way, but I'm
//   not going to provide support for that anymore)
// * Different reticles possible for each base weapon, including definitions
//   for any mod weapons you want to add (I also did one for 'Repair Gun'!)
// * Supports resize-on-the-fly! (uses Presto's functions)
// * All reticle sizes are now 63 pixels wide! It turns out that larger sizes
//   would overlap CmdHUD commander and inventory panels! That's no good!
//
// Requires PrestoHUD 0.93+ and now ACTUALLY FULLY COMPATIBLE with CmdHUD 1.0+
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// 
// Installation notes:
// 
// Unzip file to your tribes directory! All the files will be put in the right
// places!
//
// (Unzip h_reticle.bmp into the tribes\base directory, unzip all other files
// into \config\cowboy directory, and add line: Include("cowboy\\mHUD.cs"); to
// your autoexec.cs file somewhere AFTER the exec("presto\\install.cs"); line.)
//
// mHUD.gui now goes in the config\cowboy directoy (duh!)
// 
// NOTE: This replaces the built-in crosshairs, and will overwrite your
//       crosshairs, so make a backup! I suggest trying my h_reticle.bmp first
//       to see how it works, although  you _can_ use your own h_reticle.bmp!
//
// This now supports resizing, and there are correct rangefinder bitmaps for
// 640x480, 800x600, and 1024x768! If you want to create an _accurate_ one
// for a different resolution, do it up and mail it to me! If i use it here,
// you'll get the credit!
//
// Same goes for reticles! I have only got a few done.. If you can come up
// with better ones, send 'em over!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// 
// (c) 1999 Cowboy, whatever... I hope you enjoy this, and all that I ask is 
// that you give me and GymReaper props for it.. enjoy!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

Include("presto\\Install.cs");
Include("presto\\Event.cs");
Include("presto\\Inventory.cs");

//
// User settings:
//
// $mHUD::UpdateTime: how often we check for switching weapon status 
//
// you probably won't need to change this.. but if you do, here ya go!

$mHUD::UpdateTime = 0.3;

//
// this is the key that changes 1st/3rd person view mode
//
$mHUD::ToggleView::Key = "r";

//
// this is tribes' sniper zoom toggle key
//
// if you "include" Writer's zoom.cs, this will auomatically be overridden
//
$mHUD::Zoom::Key = "e";

//
// this toggles 'forcing' the Mortar reticle/rangefinder
//
$mHUD::ForceMortar::Key = "alt q";

//
// This key toggles debug mode, showing everything that happens echoed to
// the console. If you want to see how mHUD does its thing, press alt-f12
// (debug mode off by default)
//
$mHUD::DebugMode::Key = "alt f12";
$mHUD::DebugMode = false;

// need to define this here to allow adding weapons!
function mHUD::AddWeapon(%Weapon, %Reticle, %RangeFinder) {
	$mHUD::Reticle[%Weapon] = %Reticle;
	$mHUD::RangeFinder[%Weapon] = %RangeFinder;
	if ($mHUD::DebugMode) {
		echo("Weapon Added: " @ %weapon);
		if ($mHUD::Reticle[%Weapon] != "") echo(" w/Reticle: " @ $mHUD::Reticle[%Weapon]);
		if ($mHUD::RangeFinder[%Weapon] != "") echo(" w/Rangefinder: " @ $mHUD::RangeFinder[%Weapon]);
		}
	}

//
// Define weapon types!
//
// mHUD::AddWeapon("Weapon Name", ReticleBmp, RangeFinderBmp);
//
// NOTE: You can easily get "Weapon Name" by selecting the weapon in Tribes,
//       bringing up the console (~) and typing in this command:
//
//       echo($Inv::Name[getMountedItem(0)]);
//
//       This echoes the name of the selected weapon to the console!
//
// Each weapon can have its own combination of reticle & rangefinder. If the
// weapon doesn't need either a Reticle or RangeFinder, use a "". This way you
// can define ANY possible combination per weapon: use just a reticle, just a
// rangefinder, or use both reticle & rangefinder!
//
// (see my examples below!)
//
// Notice that the rangefinder bitmap ends in "_" because it's required that
// each rangefinder exist for all available resolutions. (for accuracy)
//
// for "cowboy\\mHUD_rangefinder_Mortar_", these files exist:
//
//    cowboy\\mHUD_rangefinder_Mortar_unknown.bmp
//    cowboy\\mHUD_rangefinder_Mortar_640.bmp
//    cowboy\\mHUD_rangefinder_Mortar_800.bmp
//    cowboy\\mHUD_rangefinder_Mortar_1024.bmp
//
// This script AUTOMATICALLY adds the current resolution's X value (ex: 1024)
// and ".bmp" to the end of the string!
//
// if you add your own bitmaps, keep in mind you have to also add the full file
// name of the bitmap in the 'ADD TAGS' section (below)


mHUD::AddWeapon("Grenade Launcher", "", "cowboy\\mHUD_rangefinder_Grenade_");

mHUD::AddWeapon("Mortar", "", "cowboy\\mHUD_rangefinder_Mortar_");


//
// ADD TAGS, hopefully these id #'s will never be used by anyone else!
//

//don't use this one, sometimes it stays on ALL the time (???) weird...
IDBMP_MHUD_UNRELIABLE		= 00160950, ""; 

//base weapons
IDBMP_MHUD_RETICLE_BLASTER 	= 00160951, ""; 
IDBMP_MHUD_RETICLE_PLASMA 	= 00160952, "cowboy\\mHUD_reticle_Plasma.bmp"; 
IDBMP_MHUD_RETICLE_CHAINGUN	= 00160953, "cowboy\\mHUD_reticle_Chaingun.bmp"; 
IDBMP_MHUD_RETICLE_DISC 	= 00160954, "cowboy\\mHUD_reticle_Disc.bmp"; 
IDBMP_MHUD_RETICLE_GRENADE 	= 00160955, "";
IDBMP_MHUD_RETICLE_LASER 	= 00160956, "cowboy\\mHUD_reticle_Laser.bmp"; 
IDBMP_MHUD_RETICLE_ELF 		= 00160957, ""; 
IDBMP_MHUD_RETICLE_MORTAR 	= 00160958, ""; 
IDBMP_MHUD_RETICLE_TARGET 	= 00160959, "cowboy\\mHUD_reticle_Target.bmp"; 

//repair gun
IDBMP_MHUD_RETICLE_REPAIR	= 00160960, "cowboy\\mHUD_reticle_Repairgun.bmp";

//scout flier
IDBMP_MHUD_RETICLE_SCOUT	= 00160961, "cowboy\\mHUD_reticle_Scout.bmp";

//mod or additional weapons
IDBMP_MHUD_RETICLE_1		= 00160962, "";
IDBMP_MHUD_RETICLE_2		= 00160963, "";
IDBMP_MHUD_RETICLE_3		= 00160964, "";
IDBMP_MHUD_RETICLE_4		= 00160965, "";
IDBMP_MHUD_RETICLE_5		= 00160966, "";
IDBMP_MHUD_RETICLE_6		= 00160967, "";
IDBMP_MHUD_RETICLE_7		= 00160968, "";
IDBMP_MHUD_RETICLE_8		= 00160969, "";

//mortar rangefinder
IDBMP_MHUD_R000_MORTAR 		= 00160970, "cowboy\\mHUD_rangefinder_Mortar_unknown.bmp";
IDBMP_MHUD_R640_MORTAR		= 00160971, "cowboy\\mHUD_rangefinder_Mortar_640.bmp";
IDBMP_MHUD_R800_MORTAR		= 00160972, "cowboy\\mHUD_rangefinder_Mortar_800.bmp";
IDBMP_MHUD_R1024_MORTAR		= 00160973, "cowboy\\mHUD_rangefinder_Mortar_1024.bmp";

//grenade rangefinder
IDBMP_MHUD_R000_GRENADE		= 00160974, "cowboy\\mHUD_rangefinder_Grenade_unknown.bmp";
IDBMP_MHUD_R640_GRENADE		= 00160975, "cowboy\\mHUD_rangefinder_Grenade_640.bmp";
IDBMP_MHUD_R800_GRENADE		= 00160976, "cowboy\\mHUD_rangefinder_Grenade_800.bmp";
IDBMP_MHUD_R1024_GRENADE	= 00160977, "cowboy\\mHUD_rangefinder_Grenade_1024.bmp";

//mod rangefinder
IDBMP_MHUD_RMISC_0		= 00160978, "";
IDBMP_MHUD_RMISC_1		= 00160979, "";
IDBMP_MHUD_RMISC_2		= 00160980, "";
IDBMP_MHUD_RMISC_3		= 00160981, "";

//mod rangefinder
IDBMP_MHUD_RMISC_4		= 00160982, "";
IDBMP_MHUD_RMISC_5		= 00160983, "";
IDBMP_MHUD_RMISC_6		= 00160984, "";
IDBMP_MHUD_RMISC_7		= 00160985, "";

//mod rangefinder
IDBMP_MHUD_RMISC_8		= 00160986, "";
IDBMP_MHUD_RMISC_9		= 00160987, "";
IDBMP_MHUD_RMISC_10		= 00160988, "";
IDBMP_MHUD_RMISC_11		= 00160989, "";

//
// For Presto Pack 0.93+, this displays script info in a box on the main
// menu screen, kind of an 'Advertisement/Info Box' for installed scripts.
//

$mHUD::CowboyScriptBanner1 =	"<jc><f2>mHUD 4.4 <f1>by <f2>Cowboy\n" @
				"<f1>'Smart' Reticle / Rangefinder\n";

$mHUD::WriterScriptBanner =	"<f2>*** Writer-Compatible ***\n" @
				"\n" @
				"<f0>Read the readme for <f1>Key\n"@
				"Bindings <f0>and <f1>New Features!\n" @
				"<f2>Now with Reticle Overlays!\n" @
				"\n";

$mHUD::CowboyScriptBanner2 =	"<f1>Released 5/23/99 by Cowboy";


if ($Presto::version >= 0.93) {
	Presto::AddScriptBanner(mHUD, $mHUD::CowboyScriptBanner1 @ $mHUD::WriterScriptBanner @ $mHUD::CowboyScriptBanner2);
	}

//
// This constantly runs and checks to see if which weapon is loaded
//
// 'Safe' scheduling code from Presto! thanks!
//
function scheduled_mHUD::Timer(%id) {
   if (%id != $mHUD_scheduled_id)
      return;
   mHUD::Timer();
   schedule("scheduled_MHUD::Timer("@$mHUD_scheduled_id@");", $mHUD::UpdateTime);
   }
 
function schedule_mHUD::Timer() {
   $mHUD_scheduled_id++;
   schedule("scheduled_mHUD::Timer("@$mHUD_scheduled_id@");", $mHUD::UpdateTime);
   }
 
Event::Attach(eventConnected, schedule_MHUD::Timer);
 
function mHUD::Timer() {
	%weapon = mHUD::CurrentWeapon();
	
	if ($mHUD::LastResolution != Presto::ScreenSize())
		mHUD::UpdateResolution();

	if (!$mHUD::Initialized && %weapon != -1) {
		if (included("writer\\zoom.cs")) {
			Event::Attach(eventZoomOn, mHUD::ToggleSniperWriterOn);
			Event::Attach(eventZoomOff, mHUD::ToggleSniperWriterOff);
			}
		else
			bindkey(play, $mHUD::Zoom::Key, "mHUD::ToggleSniper(1);", "mHUD::ToggleSniper(0);");
		$mHUD::Initialized = true;
		mHUD::Init();
		}

	if ($mHUD::ForceMortar == $mHUD::ForceMortarOn)
		mHUD::UpdateReticle();
	
	if (%weapon != $mHUD::LastWeapon
		|| $mHUD::ToggleViewState != $mHUD::LastToggleViewState
		|| $mHUD::ToggleSniperState != $mHUD::LastToggleSniperState) {
		
		mHUD::ForceMortarToggle(false);
		mHUD::UpdateReticle();
		}

	if (included("cowboy\\CmdHUD.cs") && $CmdHUD::guiMode == 2 && $mHUD::CurrentGui == CommandGui) {
		if ($CmdHUD::MapState && !$mHUD::CmdHUD::ReticleState ) {
			$mHUD::CmdHUD::ReticleState = true;
			mHUD::SetVisible(RangeFinder, $mHUD::CmdHUD::ReticleState);
			mHUD::SetVisible(Reticle, $mHUD::CmdHUD::ReticleState);
			}
		else if (!$CmdHUD::MapState && $mHUD::CmdHUD::ReticleState) {
			$mHUD::CmdHUD::ReticleState = false;
			mHUD::SetVisible(RangeFinder, $mHUD::CmdHUD::ReticleState);
			mHUD::SetVisible(Reticle, $mHUD::CmdHUD::ReticleState);
			}
		}
	}

function mHUD::UpdateResolution() {
	$mHUD::LastResolution = Presto::ScreenSize();
	$mHUD::X = getWord($mHUD::LastResolution, 0);
	$mHUD::Y = getWord($mHUD::LastResolution, 1);

	if ($mHUD::DebugMode) echo($mHUD::X @ ", " @ $mHUD::Y);
	
	if ($mHUD::X == 640)
		$mHUD::resX = "640";
	else if ($mHUD::X == 800)
		$mHUD::resX = "800";
	else if ($mHUD::X == 1024)
		$mHUD::resX = "1024";
	else
		$mHUD::resX = "unknown";
	}

function mHUD::isString(%string) {
	if (%string == "" || %string == -1)
		return false;
	else
		return true;
	}
	
function mHUD::UpdateReticle() {
	%weapon = mHUD::CurrentWeapon();

	if ($mHUD::ForceMortar)
		%weapon = "Mortar";

	$mHUD::CurrentReticle = $mHUD::Reticle[%weapon];
	$mHUD::ReticleVisible = mHUD::isString($mHUD::CurrentReticle);

	$mHUD::CurrentRangeFinder = $mHUD::RangeFinder[%weapon];
	$mHUD::RangeFinderVisible = mHUD::isString($mHUD::CurrentRangeFinder);

	if (!$mHUD::ForceMortar)
		$mHUD::LastWeapon = %weapon;
	$mHUD::ForceMortarOn = !$mHUD::ForceMortarOn;
	$mHUD::LastToggleViewState = $mHUD::ToggleViewState;
	$mHUD::LastToggleSniperState = $mHUD::ToggleSniperState;
	
	if ($mHUD::DebugMode) echo("Current Weapon: " @ %weapon);
	
	mHUD::LoadBitmaps();
	}

function mHUD::LoadBitmaps() {
	$mHUD::CmdHUD::ReticleState = true;
	
	if ($mHUD::ToggleViewState) {
		mHUD::SetVisible(Reticle, false);
		mHUD::SetVisible(RangeFinder, false);
		}
	else if ($mHUD::ToggleSniperState) {
		mHUD::SetVisible(Reticle, $mHUD::ReticleVisible);
		mHUD::SetVisible(RangeFinder, false);
		}
	else {
		mHUD::SetVisible(Reticle, $mHUD::ReticleVisible);
		mHUD::SetVisible(RangeFinder, $mHUD::RangeFinderVisible);
		}
	
	mHUD::SetValue(Reticle, $mHUD::CurrentReticle);
	mHUD::SetValue(RangeFinder, $mHUD::CurrentRangeFinder @ $mHUD::resX @ ".bmp");

	if ($mHUD::DebugMode) { echo("Bitmaps Loaded"); echo(""); }
	}

function mHUD::SetVisible(%object, %state) {
	Control::SetVisible("mHUD::" @ %object @ "::" @ $mHUD::Counter, %state);
	if ($mHUD::DebugMode) echo("SetVisible: mHUD::" @ %object @ "::" @ $mHUD::Counter @ ", "@ %state);
	}

function mHUD::SetValue(%object, %value) {
	if (%object == Reticle && !$mHUD::ReticleVisible) return;
	else if (%object == RangeFinder && !$mHUD::RangeFinderVisible) return;
	else if ($mHUD::ToggleViewState) return;
	
	Control::SetValue("mHUD::" @ %object @ "::" @ $mHUD::Counter, "<B0,0:" @ %value @ ">");
	if ($mHUD::DebugMode) echo("SetValue: mHUD::" @ %object @ "::" @ $mHUD::Counter @ ", <B0,0:" @ %value @ ">");
	}

function mHUD::CreateBitmap(%frame, %name) {
	%var = newobject(%name, FearGuiFormattedText, 0, 0, 255, 255);
	addToSet(%frame, %var);
	if ($mHUD::DebugMode) echo(%name @ "\(" @ %var @ "\) Created in " @ %frame);
	return %var;
	}	

function mHUD::CreateRangeFinderFrame(%gui) {
	%frame = newobject("mHUD::Frame::RangeFinder::" @ $mHUD::Counter, SimGui::Control, $mHUD::X / 2 - 31, $mHUD::Y / 2 + 35, 63, 255);
	addToSet(%gui, %frame);
	if ($mHUD::DebugMode) echo("mHUD::Frame::RangeFinder::" @ $mHUD::Counter @ " Created in " @ %gui);
	return %frame;
	}

function mHUD::CreateReticleFrame(%gui) {
	%frame = newobject("mHUD::Frame::Reticle::" @ $mHUD::Counter, SimGui::Control, $mHUD::X / 2 - 31, $mHUD::Y / 2 - 31, 63, 63);
	addToSet(%gui, %frame);
	if ($mHUD::DebugMode) echo("mHUD::Frame::Reticle::" @ $mHUD::Counter @ " Created in " @ %gui);
	return %frame;
	}

function mHUD::DeleteRangeFinderFrame(%gui, %frame) {
	removeFromSet(%gui, %frame);
	if ($mHUD::DebugMode) echo("mHUD::Frame::RangeFinder::" @ $mHUD::Counter @ " Deleted from " @ %gui);
	return %frame;
	}

function mHUD::DeleteReticleFrame(%gui, %frame) {
	removeFromSet(%gui, %frame);
	if ($mHUD::DebugMode) echo("mHUD::Frame::Reticle::" @ $mHUD::Counter @ " Deleted from " @ %gui);
	return %frame;
	}
	
//
// Initialize the objects: load the gui, get the IDs, move stuff around
//
function mHUD::Init() {
	Event::Attach(eventConnected, mHUD::Reset);
	Event::Attach(eventChangeMission, mHUD::Reset);
	if ($mHUD::DebugMode) echo("mHUD Initialized");
	}

function mHUD::LoadGui() {
	guiPushDialog(MainWindow, "cowboy\\mHUD.gui");
	guiPopDialog(MainWindow, "cowboy\\mHUD.gui");
	if ($mHUD::DebugMode) echo("mHUD Gui Initialized (Transparent Bitmaps)");
	}
	
//
// Detect what gui you are in, if you use CmdHUD
//
function mHUD::GuiOpen(%gui) {
	mHUD::LoadGui();
	$mHUD::CurrentGui = %gui;
	if ($mHUD::DebugMode) echo("GuiOpen: " @ %gui);
	if (included("cowboy\\CmdHUD.cs") || %gui == "playGui") {
 		if (%gui == "playGui" || %gui == "CommandGui" || %gui == "CmdInventoryGui") {
			$mHUD::Counter++;
			$mHUD::RangeFinderFrame = mHUD::CreateRangeFinderFrame(%gui);
			$mHUD::RangeFinderBitmap = mHUD::CreateBitmap($mHUD::RangeFinderFrame, "mHUD::RangeFinder::" @ $mHUD::Counter);
			$mHUD::ReticleFrame = mHUD::CreateReticleFrame(%gui);
			$mHUD::ReticleBitmap = mHUD::CreateBitmap($mHUD::ReticleFrame, "mHUD::Reticle::" @ $mHUD::Counter);
			mHUD::LoadBitmaps();
			}
		}
	}

//
// Detect what gui you just left, if you use CmdHUD
//
function mHUD::GuiClose(%gui) {
	if ($mHUD::DebugMode) echo("GuiClose: " @ %gui);
	if (included("cowboy\\CmdHUD.cs") || %gui == "playGui") {
		mHUD::DeleteRangeFinderFrame(%gui, $mHUD::RangeFinderFrame);
		mHUD::DeleteReticleFrame(%gui, $mHUD::ReticleFrame);
		}
	mHUD::ForceMortarToggle(false);
	}

//
// toggle 1st person/3rd person views
//
function mHUD::ToggleView() {
	$mHUD::ToggleViewState = !$mHUD::ToggleViewState;
	postAction(2048, IDACTION_VIEW, 1);
	if ($mHUD::DebugMode) echo("View State: " @ $mHUD::ToggleViewState);
	}

//
// toggle sniper zoom
//
function mHUD::ToggleSniper(%state) {
	postAction(2048, IDACTION_SNIPER_FOV, %state);
	mHUD::ToggleSniperWriter(%state);
	}

//
// if Writer's zoom.cs is installed, use his eventZoomOn and eventZoomOff
// triggers 
//
function mHUD::ToggleSniperWriter(%state) {
	$mHUD::ToggleSniperState = !$mHUD::ToggleSniperState;

	if (%state && $mHUD::ForceMortar) {
		$mHUD::SnipeAndMortar = true;
		$mHUD::SnipeWeapon = mHUD::CurrentWeapon();
		}
	else if (!%state && $mHUD::SnipeAndMortar && !$mHUD::ForceMortar) {
		$mHUD::ForceMortar = true;
		$mHUD::SnipeAndMortar = false;
		}
		
	if ($mHUD::SnipeWeapon != mHUD::CurrentWeapon())
		$mHUD::ForceMortar = false;

	if ($mHUD::DebugMode) echo("Sniper State: " @ $mHUD::ToggleSniperState);
	}

function mHUD::ToggleSniperWriterOn() {
	mHUD::ToggleSniperWriter(true);
	if ($mHUD::DebugMode) echo("mHUD::ToggleSniperWriter(true)");
	}

function mHUD::ToggleSniperWriterOff() {
	mHUD::ToggleSniperWriter(false);
	if ($mHUD::DebugMode) echo("mHUD::ToggleSniperWriter(false)");
	}

//
// force the mortar rangefinder on (toggle)
//	
function mHUD::ForceMortarToggle(%state) {
	if (%state == "")
		$mHUD::ForceMortar = !$mHUD::ForceMortar;
	else
		$mHUD::ForceMortar = (%state && $mHUD::ForceMortar);
		
	$mHUD::ForceMortarOn = $mHUD::ForceMortar;
	
	if ($mHUD::DebugMode) echo("Force Mortar Toggle: " @ $mHUD::ForceMortar);
	}

function mHUD::CurrentWeapon() {
	%weapon = getMountedItem(0);
	%weaponName = $Inv::Name[%weapon];
	
	if (%weapon == -1) {
		if ($Pilotmode != 0 )
			%value = "Scout";
		else
			%value = -1;
		}
	else
		%value = %weaponName;
		
	if ($mHUD::DebugMode) echo("mHUD::CurrentWeapon(): " @ %value);
	return %value;
	}

//
// Reset all objects and variables
//
function mHUD::Reset() {
	$mHUD::LastWeapon = "";
	$mHUD::ForceMortar = false;
	$mHUD::ForceMortarOn = false;
	if ($mHUD::DebugMode) echo("mHUD Reset");
	}

function mHUD::InitViewState() {
	$mHUD::ToggleViewState = false;
	$mHUD::ToggleSniperState = false;
	}

$mHUD::Counter = 0;
$mHUD::Initialized = false;
$mHUD::InventoryInitialized = false;

Event::Attach(eventConnected, mHUD::Timer);
Event::Attach(eventConnected, mHUD::InitViewState);

Event::Attach(eventGuiOpen, mHUD::GuiOpen);
Event::Attach(eventGuiClose, mHUD::GuiClose);

bindkey(play, $mHUD::ToggleView::Key, "mHUD::ToggleView();");
bindkey(play, $mHUD::ForceMortar::Key, "mHUD::ForceMortarToggle();");
bindkey(action, $mHUD::DebugMode::Key, "$mHUD::DebugMode = !$mHUD::DebugMode;");
