// ---------------------------------------------------------------------------
// WriterDefaults.cs -- Version 1.12 -- November 14, 1999
// by Lorne Laliberte ([SS-12] Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


// RENAME THIS FILE FROM WriterDefaults.cs TO WriterPrefs.cs BEFORE MAKING ANY
// CHANGES


// All the settings for my scripts -- every key binding, every option -- can be
// changed from this file!


// Note: You can either manually edit this file, or use my NewOpts pages
//       to automatically generate a WriterPrefs.cs file with your settings.
//       When you use the newopts method it will backup this file if a backup
//       doesn't already exist.
//       [NOT YET IMPLEMENTED - Lorne]


// Some of the settings may be commented out (a "//" in front of any text
// makes Tribes ignore that text...when programmers want to turn a line of
// code off, they "comment it out" by prefixing it with //).
//
// These are settings that I don't use, or have no idea what key to bind to.
// To use them, simply remove the "//" from the start of the line, and change
// the settings as you wish.
//
// Any key bindings that I don't have any defaults for will look like this:
//
//bindCommand(keyboard0, make, alt, "whatever", TO, "am_armor::toggle();");
//bindCommand(keyboard0, break, alt, "whatever", TO, "");
//
// Make sure you change the modifier (alt) and the key ("whatever" ;) if you
// uncomment such lines. :)



// Tribes key bindings:
//
// The Tribes bindCommand() function assigns any valid Tribes statement or
// function to mouse button or key combination.  The format is:
//
// bindCommand(<device>, <make|break>, [<modifier>,] <key|button>, TO, "<statement>");
//
// <device>      usually either keyboard0 or mouse0
// <make|break>  use make for the PRESS and break for the RELEASE of the button or key
// <modifier>    modify the key with alt, shift, control, r_shift, etc. [optional]
// <key|button>  the key or button, i.e. "w" or button0
// <statement>   any Tribes statement, which means it must end with a semi-colon (;)
//               (a function call is a kind of statement).  For instance, to bind a
//               key to set the variable $foo to 27, you could use the statement
//               "$foo = 27;" -- and to call the foo() function, you would use "foo();"



// Disabling scripts:
//
// To disable a script, set the $Enabled["writer\\script_name.cs"] option
// to false instead of true.


// To disable any key bindings, simply comment them out by prefixing them
// with //


//-----------------------------------------------------------------------------
// AM_ARMOR: informs your team what armor you are wearing when you leave an
//           inventory station, if it has changed since the last time you left
//           an inventory station.  Also informs your team what loadout you are
//           carrying if fast_favorites.cs is enabled.

$Enabled["writer\\am_armor.cs"] = true;


// KEYS:

EditActionMap("playMap.sae");

// Toggle am_armor on/off fro within Tribes
//bindCommand(keyboard0, make, alt, "whatever", TO, "am_armor::toggle();");
//bindCommand(keyboard0, break, alt, "whatever", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// AM_DEPLOY: informs your team what deployable item you are carrying when you
//            leave an inventory station, and informs your team when you
//            actually deploy it.

$Enabled["writer\\am_deploy.cs"] = true;


// OPTIONS:


// Set this to true if you don't want to see the white "<item> deployed" messages
$AutoMessage::Mute::Deployed = true;

// Set this to true if you don't want to announce what you're carrying when you exit a station
$AutoMessage::Mute::Carrying = false;

// Length of "flood protection" time (in seconds) before you will announce
// that you're carrying the same thing
$AutoMessage::DeployFloodTime = 20;


// KEYS:

EditActionMap("playMap.sae");

// Toggle am_deploy on/off from within Tribes
//bindCommand(keyboard0, make, alt, "whatever", TO, "am_deploy::toggle();");
//bindCommand(keyboard0, break, alt, "whatever", TO, "");


//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// AM_POWER_DOWN: informs your team if the power is down when you access an
//                inventory station, notifies or thanks them when the power
//                is restored.

$Enabled["writer\\am_power_down.cs"] = true;


// OPTIONS:


// Set this to false if you don't want to trigger eventPowerRestored
// on eventEnterStation, which would happen at remote inventory stations
// even if your power is still down.  If set to true, you can hold down
// the SHIFT key as you step up to a remote inv station to prevent the
// eventPowerRestored from being triggered.  NOTE: if you're using
// station_types.cs, you should set this to false.
$Station::triggerPowerRestored = false;

// Set which key you want to hold to prevent eventPowerRestored
// when $Station::triggerPowerRestored is set to true.
//$PowerDown::ToggleKey = shift; // hold shift key
$PowerDown::ToggleKey = ""; // disable

// What you say when you try to access a station when the power is down
$PowerIsDown::string = "Our Power is Down!~job:need-rep-gen~wneedrep";

// What you say when you access a station and the power has been restored
$PowerRestored::string = "Our Power is Back Up!~wthanks";

// What you say when you manually trigger the PowerRestored event
$IHaveRestoredPower::string = "Our Power is Back Up!~wcheer1";

// What you say when someone else announces repairs to solar panel or gens
$TheySayPowerIsUp::string = "Thanks for restoring power!~wthanks";


// KEYS:

EditActionMap("playMap.sae");


// Manually trigger the eventPowerRestored event, and notify your team that the
// power is back up
bindCommand(keyboard0, make, alt, "r", TO, "AutoMessage::IHaveRestoredPower();");
bindCommand(keyboard0, break, alt, "r", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// AM_REPAIR.CS: informs your team when you begin and complete repairs.

$Enabled["writer\\am_repair.cs"] = true;


// OPTIONS:

// Set this to true to not inform your team about repairing certain items
$AutoMessage::FilterModeOn = false;

// Set which items not to report when filter mode is on
$AutoMessage::FilterItem[0] = "Scout";
$AutoMessage::FilterItem[1] = "LPC";
$AutoMessage::FilterItem[2] = "HPC";
$AutoMessage::FilterCount = 3;

// Set this to true if you don't want to see the white "Repairing <item>" messages
$AutoMessage::Mute::RepairingItem = true;

// Set this to true if you don't want to see the white "Repairing <player>" messages
$AutoMessage::Mute::RepairingPlayer = true;

// Set this to true if you don't want to see the white "Repair stopped" messages
$AutoMessage::Mute::RepairStopped = false;

// Set this to true if you don't want to see the white "Repair done" messages
$AutoMessage::Mute::RepairDone = true;

// Set this to true if you don't want to notify your team on beginning repairs
$AutoMessage::Mute::RepairBegunOn = false;

// Set this to true if you don't want to tell an antsy teammate to sit still for repairs
$AutoMessage::Mute::HoldPosition = false;

// Set this to true if you don't want to notify your team on completing repairs
$AutoMessage::Mute::HasBeenRepaired = false;


// If you change any of the repair strings, make sure you don't use the word
// "repairing" at all, or you will trigger am_repair over and over and
// get spam-blocked. :)

// What you say when you tell the team what you're repairing -- leave a space
// at the end of this string, as the item being repaired gets appended to it.
$RepairBegun::string = "Repair begun on ";

// What you say when a player you're repairing moves, interrupting the repair.
// The player you are repairing gets appended to the beginning of this string.
$HoldPosition::string = ", hold position to be repaired.";

// What you say when you complete repairs on an item.  The item you are
// repairing gets appended to the beginning of this string.
$RepairDone::string = " has been repaired!~job:fin-rep";

// What you say when you complete repairs to a generator or solar panel
// when the power was down
$PowerRepaired::string = "Our Power is Back Up!";


// KEYS:

EditActionMap("playMap.sae");

// Toggle repair message filtering on/off
bindCommand(keyboard0, make, alt, "t", TO, "AutoMessage::ToggleFilterMode();");
bindCommand(keyboard0, break, alt, "t", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// AM_STATION_DOWN.CS: informs your team when you try to access a damaged station
//                     and you aren't carrying a repair pack

$Enabled["writer\\am_station_down.cs"] = true;

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// AM_THANKS.CS: automatically thank players who repair you

$Enabled["writer\\am_thanks.cs"] = true;


// OPTIONS:

// Set this to true if you don't want to see the white "Being repaired by <player>" messages
$AutoMessage::Mute::BeingRepairedBy = false;

// Set this to the delay, in seconds, you want to wait before saying thanks
// for being repaired by another player
$AutoMessage::ThankYouDelay = 3;

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// AMMO_CHECK.CS: switch to next weapon when you run out of ammo

$Enabled["writer\\ammo_check.cs"] = false;

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// AUTO_REPAIR_KIT.CS: automatically use a repair kit when you pick one up,
//                     heal yourself faster at inventory stations, and provide
//                     a taunt for when enemies leave a repair kit behind

$Enabled["writer\\auto_repair_kit.cs"] = true;


// OPTIONS:


// What you say when you press the repair kit taunt key
$RepairKitTaunt::string = "Thanks for the repair kit!~wthanks";

// Delay in seconds to wait between attempts to use and buy repair kits
// when you press the useRepairKit key at an inventory station


// KEYS:

EditActionMap("playMap.sae");

// Toggle Auto Use Repair Kit mode
bindCommand(keyboard0, make, shift, "capslock", TO, "AutoUseRepairKitToggle();");
bindCommand(keyboard0, break, shift, "capslock", TO, "");

// Repair Kit Taunt ("Thanks for the repair kit!")
bindCommand(keyboard0, make, alt, "capslock", TO, "RepairKitTaunt();");
bindCommand(keyboard0, break, alt, "capslock", TO, "");

// Use repair kit -- if you're at an inventory station, you can press this key
// to quickly buy and use kits to bring your health up faster (even if you walk away)
bindCommand(keyboard0, make, "capslock", TO, "useRepairKit();");
bindCommand(keyboard0, break, "capslock", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// CROUCH_TOGGLE.CS: toggle crouch mode on/off so you don't have to hold the
//                   crouch key down

$Enabled["writer\\crouch_toggle.cs"] = true;


// KEYS:

EditActionMap("playMap.sae");

// Toggle crouch
bindCommand(keyboard0, make, "x", TO, "CrouchToggle();");
bindCommand(keyboard0, break, "x", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// CUSTOM_WEAPONS.CS: allows you to assign up to four weapons to any of the
//                    number keys, and change the assigned weapons at any time
//                    during a game. For each number key, you can specify: 
//
//                    (1) a weapon to use on a single keypress, 
//                    (2) an alternate weapon if that one isn't available, 
//                    (3) a weapon to use on a double keypress, and
//                    (4) an alternate weapon if that one isn't available.
//
//                    The script will use the first weapon that you are actually
//                    carrying, so if neither of the "single keypress" weapons
//                    are carried, it will look for (3), and if that isn't
//                    carried, it will try (4). Similarly, if you "double press"
//                    the key and neither of the double keypress weapons are carried,
//                    the script will look for (1), then (2).
//
//                    Saves your current config to a file named custom_weapons_.cs in the Tribes\config folder. Any changes you make while in the game will be saved to the appropriate file! Version 3.2 adds an option to use the default Tribes number key setup instead of my own more efficient setup -- just set $WeaponKey::UseOriginalTribesConfig to true in the file


// Note: when custom_weapons.cs is disabled from within Tribes it will restore
//       the default (as in, installed with Tribes) Tribes weapon key bindings.
$Enabled["writer\\custom_weapons.cs"] = false;


// OPTIONS:

// Set this to true if you want to use the original Tribes config
// Note that you will have to delete Tribes\config\custom_weapons_base.cs
// (if it exists) before the original Tribes setup will be used.
//
// But you really should try my config, it makes accessing all the weapons
// a lot faster/easier. :)
$WeaponKey::UseOriginalTribesConfig = false;


// KEYS:

// Important note: custom_weapons.cs is hardcoded to bind to the number keys
//                 (alone and in combination with the right shift and right
//                 control keys).  If you would like to use different keys
//                 to select your weapons, custom_weapons.cs would have to
//                 be modified.  Please contact me if you have any questions.

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// DROP_AMMO.CS: drops any ammo you don't have a weapon for -- make sure you do
//               this in a place where the enemy isn't going to grab it.  It's
//               better to drop it than to carry it around for the next enemy
//               player who bests you in a shootout.


// NOTE: to disable this script, simply comment out the binding here and bind
//       the key to something else.

// KEYS:

EditActionMap("playMap.sae");

// Drop unnecessary ammo
bindCommand(keyboard0, make, shift, "a", TO, "dropUnnecessaryAmmo();");
bindCommand(keyboard0, break, shift, "a", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// FAST_FAVORITES.CS:  The big one! :)  A very flexible key-based system to
//                     help you buy stuff at inventory stations faster. Set up
//                     your favorite "loadouts" of items in favorites0.cs -- you
//                     can have as many favorites as you can set aside keys for
//                     (I have more than 20 defined by default).
//
//                     The best way to use this is to select your favorites in
//                     advance (using the keys you've bound in favorites0.cs)
//                     and use the auto-buy feature to buy your favorites as soon
//                     as possible when you access an inventory station.
//
//                     This is a VERY complex script, and there are too many
//                     options to explain in depth here.  Please refer to the
//                     online manual at www.planetstarsiege.com/lorne/fast_faves.html
//                     for more information.

$Enabled["writer\\fast_favorites.cs"] = true;


//OPTIONS:


// Set this to true if you want to force shutting the cursor off on eventExitStation.
// This might solve the "exit station, get cursor on screen" bug which should not
// happen unless you've enabled station_types.cs or have some other script that is
// messing with things.  I have been unable to duplicate the bug with the new fast
// faves, under any circumstances, with only my scripts installed -- you do the math.
$FastFaves::ForceCursorOff = true;

// Set this to true to automatically buy the currently selected loadout
// as soon as you access an inventory station.
$FastFaves::AutoBuy = true;

// Set this to true to automatically buy the currently selected vehicle
// whenever you access a vehicle station.
$FastFaves::AutoBuyVehicle = true;  

// Set this to true to automatically announce that an APC is ready to go
// whenever you buy a vehicle
$FastFaves::AnnounceAPC = true;

// Set this to true to prevent the inventory menu from popping up automatically
// when you access an inventory station.  Note that it will still pop up momentarily
// at vehicle stations, and at inventory stations on some servers. In those cases,
// fast_favorites automatically closes the screen for you.  Note also that you can
// always access the inventory menu using the "I" key.
$pref::noEnterInvStation = true;

// Set favorites file to use when you first load Tribes
// Setting this to 0 will load config\writer\favorites0.cs
// Setting this to 1 will load config\writer\favorites1.cs, etc.
$FastFaves::FavoritesFile = 0;

// Set the maximum number of favorites files to look for
$FastFaves::MaxFavoritesFiles = 9;

// Set this to true to not reset your current loadout to the file's default
// when you change to a different favorites?.cs file
$FastFaves::RememberCurrentLoadoutBetweenFavoritesFiles = false;

// Set this to true to continue using your current favorites.cs file (temporary! :)
$UseOldFavoritesFile = false;

// Drop a pack every time you use an inventory station.  DropPack might not be
// the best name for this since you can technically drop any (droppable :) item you please, but
// most people will use the default to drop a Repair Pack, hence the name. :)
$FastFaves::DropPack = true;

// Set which key you want to HOLD DOWN to temporarily enable (or disable) dropping a pack
// and to force dropping a pack when you're carrying the DropItem (Repair Pack by default)
// or a Remote Ammo Station or Remote Inventory Station.
// (Set this to "" to disable this feature.)
// Note: if you prefer to use a regular toggle key, there is a binding for one
// in the KEYS section
$FastFaves::DropPackHoldKey = shift;

// Set this to true to show a message when you hold the key down (useful for learning how it works)
$FastFaves::ShowDropPackHoldKeyMessage = false;

// Set this to true if you want to show the weapons when pre-selecting
// a loadout (you can toggle this with ALT-L in the game
$FastFaves::ShowPreloadWeapons = false;

// Set this to true if you want to show the currently carried weapons after
// you buy them (you can toggle this with ALT-L in the game
$FastFaves::ShowWeapons = false;

// Set this to true if you want to see a message whenever you leave a station
// without carrying a pack of some kind
$FastFaves::ExitedWithoutPackWarning = true;

// Set this to true if you don't want to see the white "To many weapons for <armor> to carry" messages
// (And hey Dynamix, it's "Too" not "To" :)
$FastFaves::Mute::ToManyWeapons = true;


// KEYS:

// Note: the actual favorites key combos are defined in the favorites?.cs files

EditActionMap("playMap.sae");

// Toggle the inventory screen on/off at any time
bindCommand(keyboard0, make, "i", TO, "$Mode::ExitInventory=false; remoteEval(2048, ToggleInventoryMode);");
bindCommand(keyboard0, break, "i", TO, "");

bindCommand(keyboard0, make, "decimal", TO, "$Mode::ExitInventory=false; remoteEval(2048, ToggleInventoryMode);");
bindCommand(keyboard0, break, "decimal", TO, "");

// Toggle auto-buying mode on/off (automatically buy selected loadout)
bindCommand(keyboard0, make, alt, "numpad*", TO, "FastFaves::AutoBuyToggle();");
bindCommand(keyboard0, break, alt, "numpad*", TO, "");

// Show the items that will be bought next time we access an inventory station
bindCommand(keyboard0, make, shift, "l", TO, "FastFaves::PreloadMessage();");
bindCommand(keyboard0, break, shift, "l", TO, "");

// Show the current loadout
bindCommand(keyboard0, make, control, "l", TO, "FastFaves::LoadoutMessage();");
bindCommand(keyboard0, break, control, "l", TO, "");

// Toggle the weapons list on/off in the preload and loadout messages
bindCommand(keyboard0, make, alt, "l", TO, "FastFaves::ShowWeaponsToggle();");
bindCommand(keyboard0, break, alt, "l", TO, "");

// Switch to next favorites?.cs file
bindCommand(keyboard0, make, alt, "numpad+", TO, "FastFaves::nextFavoritesFile();");
bindCommand(keyboard0, break, alt, "numpad+", TO, "");

// Switch to previous favorites?.cs file
bindCommand(keyboard0, make, alt, "numpad-", TO, "FastFaves::prevFavoritesFile();");
bindCommand(keyboard0, break, alt, "numpad-", TO, "");

// Toggle automatically dropping a pack on/off
// (use this if you aren't using $FastFaves::DropPackHoldKey)
//bindCommand(keyboard0, make, control, "numpad/", TO, "FastFaves::DropPackToggleKeyPressed();");
//bindCommand(keyboard0, break, control, "numpad/", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// FIRE.CS: adds events to the fire button (or key)

// KEYS:

EditActionMap("playMap.sae"); 

// Set this to your fire button!
bindCommand(mouse0, make, button0, TO, "FirePressed();"); 
bindCommand(mouse0, break, button0, TO, "FireReleased();");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// FIRE_ON_MY_TARGET.CS: automatically say "Fire on my target!" when you paint
//                       a target with the targeting laser.

$Enabled["writer\\fire_on_my_target.cs"] = true;


// OPTIONS:


// Set this to true to enable the "Fire on my target!" message when you start
// Tribes
$FireOnMyTarget::Enabled = true;


// KEYS:

EditActionMap("playMap.sae");

// Toggle the automatic "Fire on my target" message
bindCommand(keyboard0, make, alt, "f", TO, "FireOnMyTarget::Toggle();");
bindCommand(keyboard0, break, alt, "f", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// JET.CS: adds events to the jet button (or key)

// KEYS:

EditActionMap("playMap.sae"); 

// Set this to your jet button!
bindCommand(mouse0, make, button1, TO, "JetPressed();"); 
bindCommand(mouse0, break, button1, TO, "JetReleased();");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// JUMP.CS: hold a key to keep jump, jump, jumping, or tap the key to toggle
//          continuous jumping mode on/off.  The skier's best friend. :)

// OPTIONS:

// Set this to true to have "continuous jumping when the key is tapped" mode 
// on when you start Tribes
$TapJumpOn = false;


// KEYS:

EditActionMap("playMap.sae");

// Keep jumping while a key is held down or after the key is tapped
bindCommand(keyboard0, make, "space", TO, "Jump(1);");
bindCommand(keyboard0, break, "space", TO, "Jump(0);");

// Toggle the "continuous jumping when the key is tapped" mode on/off
bindCommand(keyboard0, make, control, "space", TO, "TapJumpToggle();");
bindCommand(keyboard0, break, control, "space", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// JUMP_AND_JET.CS: automatically jump whenever you jet -- I don't recommend
//                  this script since it prevents you from jetting without
//                  also jumping.  I still don't know why so many people want
//                  this. :)

$Enabled["writer\\jump_and_jet.cs"] = false;

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// KEEP_MOVING.CS: tap one of your movement keys to continue moving in that
//                 direction until you press that key again (or the key for the
//                 opposite direction).  [Requires move.cs]

$Enabled["writer\\keep_moving.cs"] = false;


// OPTIONS:


// Set this to true to enable keep moving mode when you start tribes.  I find it
// can be trickier to make small quick movements precisely with it on, so I use
// the toggle to turn it on whenever I need it.
$KeepMoving::Enabled = false;

// Automatically enable Keep Moving mode when in Pilot Mode (requires pilot_mode.cs)
$Writer::EnableKeepMovingOnPilotMode = FALSE;


// KEYS:

//EditActionMap("playMap.sae");


// Toggle continuous movement on key tap for the 4 movement keys
//bindCommand(keyboard0, make, alt, "w", TO, "KeepMoving::Toggle();");
//bindCommand(keyboard0, break, alt, "w", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// LASER_READY.CS: adds a small energy bar just above, below or beside your
//                 crosshairs when you 
//
//                 (1) are wearing light armor and
//                 (2) are carrying an energy pack and
//                 (3) are using one of the weapons in the list below
//
//                 Also plays a local sound ("Ready") when you're using the
//                 laser rifle and the energy bar reaches full strength.

$Enabled["writer\\laser_ready.cs"] = true;

// OPTIONS:

// Note: in order to prevent other players from hearing the sound, make sure
// you copy the wLREADY.wav file into your Tribes\base\voices directory,
// and change the 'LREADY' part to a unique string (7 characters or less)
// of your choice.  Then change $LaserReady::Sound (below) to match.
//
// For instance, if you change the filename to wLRSHOOT.wav, change
// $LaserReady = "LREADY"; below to $LaserReady = "LRSHOOT";
//
// Note that anyone else who uses the same name will be able to hear
// you say "Ready" when they are nearby...so you should really make up a unique
// string of 7 characters. :)
//
// If you want to use your own sound file, you can, so long as it is in the
// proper format for Tribes (by which I mean sampling frequency, etc.).

// What did you change the LREADY part of the sound file wLREADY.wav to?
$LaserReady::Sound = "LREADY"; // file name is wLREADY.wav


// List of weapons the energy bar is (relatively :) accurate with:
//
// Set any of these to false to disable showing the energy bar when that
// weapon is mounted.
$EnergyBar::useWith["Laser Rifle"] = true;
$EnergyBar::useWith["Plasma Gun"] = false;
$EnergyBar::useWith["Disc Launcher"] = false;
$EnergyBar::useWith["Chaingun"] = false;
$EnergyBar::useWith["Grenade Launcher"] = false;

// Set energy bar start position
//
// 0 = top
// 1 = right
// 2 = bottom
// 3 = left
//
$EnergyBar::Position = 3;

// Set the size of your normal crosshair (h_reticle.bmp) here
$EnergyBar::reticleSizeX = 63;
$EnergyBar::reticleSizeY = 63;


// KEYS:


EditActionMap("playMap.sae");

// Toggle small energy bar on/off
bindCommand(keyboard0, make, alt, "quote", TO, "EnergyBar::toggle();");
bindCommand(keyboard0, break, alt, "quote", TO, "");

// Cycle through energy bar positions
bindCommand(keyboard0, make, "quote", TO, "EnergyBar::cycle();");
bindCommand(keyboard0, break, "quote", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// LITTERBUG.CS: hold a key down while at an inventory station to make a pile
//               of stuff for you or your teammates to pick up

$Enabled["writer\\litterbug.cs"] = true;

// OPTIONS:

// Set which items you want to be able to select from
// I recommend shortening this list if you don't use some of the items :)

// Note that you can now drop different kinds of items in sequence, and
// specify whether you want to loop through the items or not.
//
// Line-by-line example:
//
// $Litterbug::itemlist[15, name] = "Example";
//
//  - sets the name that will be shown when you cycle through stuff with
//    shift-; and shift-'
//
// $Litterbug::itemlist[15, 0] = "Turret";
// $Litterbug::itemlist[15, 1] = "Turret";
// $Litterbug::itemlist[15, 2] = "Repair Pack";
// $Litterbug::itemlist[15, 3] = "Repair Kit";
// $Litterbug::itemlist[15, 4] = "Shield Pack";
// $Litterbug::itemlist[15, 5] = "Ammo Station";
//
// - sets the items to drop: 2 turrets, then a repair pack, then a repair kit,
//   then a shield pack and then an ammo station
//
// $Litterbug::itemlist[15, count] = 6;
//
// - set count to the number of items -- very important :)
//
// $Litterbug::itemlist[15, goto] = 4;
//
// - after tossing the 6 items, litterbug will start over at item 4.  In this
//   example, it will keep tossing shield packs and ammo stations, until you
//   let go of the litterbug key.  If you wanted to keep tossing all 6 items
//   you would set this to 0.  If you don't want litterbug to loop at all,
//   set goto to -1.



$Litterbug::itemlist[0, name] = "Four Turrets";
$Litterbug::itemlist[0, 0] = "Turret";
$Litterbug::itemlist[0, 1] = "Turret";
$Litterbug::itemlist[0, 2] = "Turret";
$Litterbug::itemlist[0, 3] = "Turret";
$Litterbug::itemlist[0, count] = 4;
$Litterbug::itemlist[0, goto] = -1; // keep tossing Pulse Sensors

$Litterbug::itemlist[1, name] = "Repair Packs";
$Litterbug::itemlist[1, 0] = "Repair Pack";
$Litterbug::itemlist[1, count] = 1;
$Litterbug::itemlist[1, goto] = 0;

$Litterbug::itemlist[2, name] = "Pulse Sensors";
$Litterbug::itemlist[2, 0] = "Pulse Sensor";
$Litterbug::itemlist[2, count] = 1;
$Litterbug::itemlist[2, goto] = 0;

$Litterbug::itemlist[3, name] = "Motion Sensors";
$Litterbug::itemlist[3, 0] = "Motion Sensor";
$Litterbug::itemlist[3, count] = 1;
$Litterbug::itemlist[3, goto] = 0;

$Litterbug::itemlist[4, name] = "Cameras";
$Litterbug::itemlist[4, 0] = "Camera";
$Litterbug::itemlist[4, count] = 1;
$Litterbug::itemlist[4, goto] = 0;


$Litterbug::itemlist[5, name] = "Inventory Stations";
$Litterbug::itemlist[5, 0] = "Inventory Station";
$Litterbug::itemlist[5, count] = 1;
$Litterbug::itemlist[5, goto] = 0;

$Litterbug::itemlist[5, name] = "Ammo Stations";
$Litterbug::itemlist[5, 0] = "Ammo Station";
$Litterbug::itemlist[5, count] = 1;
$Litterbug::itemlist[5, goto] = 0;

$Litterbug::itemlist[6, name] = "Two Turrets";
$Litterbug::itemlist[6, 0] = "Turret";
$Litterbug::itemlist[6, 1] = "Turret";
$Litterbug::itemlist[6, count] = 2;
$Litterbug::itemlist[6, goto] = -1;


$Litterbug::itemlist[7, name] = "Three Turrets";
$Litterbug::itemlist[7, 0] = "Turret";
$Litterbug::itemlist[7, 1] = "Turret";
$Litterbug::itemlist[7, 2] = "Turret";
$Litterbug::itemlist[7, count] = 3;
$Litterbug::itemlist[7, goto] = -1; // keep tossing Pulse Sensors


$Litterbug::itemlist[8, name] = "Spiders Web";
$Litterbug::itemlist[8, 0] = "Pulse Sensor";
$Litterbug::itemlist[8, 1] = "Pulse Sensor";
$Litterbug::itemlist[8, 2] = "Pulse Sensor";
$Litterbug::itemlist[8, 3] = "Pulse Sensor";
$Litterbug::itemlist[8, 4] = "Pulse Sensor";
$Litterbug::itemlist[8, 5] = "Pulse Sensor";
$Litterbug::itemlist[8, 6] = "Pulse Sensor";
$Litterbug::itemlist[8, count] = 7;
$Litterbug::itemlist[8, goto] = -1; // keep tossing Pulse Sensors

$Litterbug::itemlist[9, name] = "Shield Packs";
$Litterbug::itemlist[9, 0] = "Shield Pack";
$Litterbug::itemlist[9, count] = 1;
$Litterbug::itemlist[9, goto] = 0;


// If you add any more items to the list make sure you change this :)
$Litterbug::maxitem = 9;

// Start with this item # in the list
$Litterbug::current = 0;

// Set the delay to use in seconds
// Note that a short delay can cause a lot of lag
// especially if you have higher pings, if you usually
// play with higher pings you'll likely want to change
// this to 0.6 or even higher.
$Litterbug::delay = 0.1;


// KEYS:


EditActionMap("playMap.sae");

// Hold this key down to buy and drop items for your teammates
bindCommand(keyboard0, make, shift, "b", TO, "Litterbug::start();");
bindCommand(keyboard0, break, shift, "b", TO, "Litterbug::stop();");

// Select next droppable item
bindCommand(keyboard0, make, shift, "quote", TO, "Litterbug::next();");
bindCommand(keyboard0, break, shift, "quote", TO, "");

// Select previous droppable item
bindCommand(keyboard0, make, shift, ";", TO, "Litterbug::prev();");
bindCommand(keyboard0, break, shift, ";", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// MMB_REPAIR.CS: click the middle mouse button to start repairing an object
//                (or yourself) with the repair gun, automatically stopping and
//                restoring your previously selected weapon when the repair is
//                complete.  Click the middle mouse button at any time during
//                the repair to stop repairing and restore the previously
//                selected weapon.
//
//                If you're not carrying a repair pack, click the middle mouse
//                button to either toggle the pack on/off, or to switch to a
//                single "no-pack" weapon of your choice -- I have this set to
//                the laser rifle by default.
//
//                You can change this "no-pack" weapon at any time by pressing
//                the right ALT key and M. Click the middle mouse button again
//                to switch back to your previously selected weapon, or to the
//                next available weapon if the previous weapon is no longer
//                carried.
//
//                If you aren't carrying your "no-pack weapon," click the
//                middle mouse button to use the next available weapon.

// NOTE: you can actually bind this to any key or button you want. :)
//
//       It's only names mmb_repair.cs because I designed it to use with my
//       middle mouse button.  But you don't have to use it that way. :)


// OPTIONS:


// Set this to true to deploy deployable packs using the mmb_repair button or key
//$MMB::DeployDeployables = false;

// Set default weapon to use if no repair/shield/jammer pack -- to change the
// default weapon, change the $Inv::Laser_Rifle variable to the equivalent
// $Inv:: variable for the weapon you want.
//Event::Attach(eventInventoryTableReady, "$MMB::Weapon = $Inv::Morter;");


// KEYS:

EditActionMap("playMap.sae");

// Use repair pack, etc.
//bindCommand(mouse0, make, button2, TO, "MMB::onButtonClick();");
//bindCommand(mouse0, break, button2, TO, "");

// Select current weapon as Middle Mouse Button weapon
//bindCommand(keyboard0, make, r_alt, "m", TO, "MMB::selectWeapon();");
//bindCommand(keyboard0, break, r_alt, "m", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// MOVE.CS: adds events to the movement keys

// KEYS:

EditActionMap("playMap.sae");

// Press key to run forward
bindCommand(keyboard0, make, "w", TO, "ForwardPressed();");
bindCommand(keyboard0, break, "w", TO, "ForwardReleased();");

// Press key to run left
bindCommand(keyboard0, make, "a", TO, "LeftPressed();");
bindCommand(keyboard0, break, "a", TO, "LeftReleased();");

// Press key to run back
bindCommand(keyboard0, make, "s", TO, "BackPressed();");
bindCommand(keyboard0, break, "s", TO, "BackReleased();");

// Press key to run right
bindCommand(keyboard0, make, "d", TO, "RightPressed();");
bindCommand(keyboard0, break, "d", TO, "RightReleased();");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// PACK_AND_BACK.CS: toggles backpacks on/off (and deploys items), with the
//                   added touch of automatically re-selecting the weapon you
//                   were using before you switched a repair pack on.
//
//                   Also re-selects a weapon when you drop a repair pack.
//
//                   It even automatically adjusts to your current key config!
//
//                   There's absolutely no reason not to use this. :)

$Enabled["writer\\pack_and_back.cs"] = true;

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// PDA_DANCE.CS: press a key to perform a random "evasive maneuvers" dance
//
//               Useful while you're using the PDA, or if you need to head to
//               leave the computer for a bit, or if you want your opponents to
//               think you've flipped. :)

// KEYS:

EditActionMap("actionMap.sae");

// Start or stop dancin' :)
bindCommand(keyboard0, make, alt, "d", TO, "Dance::pdaDance();");
bindCommand(keyboard0, break, alt, "d", TO, "");

// Start dancin' and bring up the commander screen
// or stop dancin' and close the commander screen
bindCommand(keyboard0, make, alt, "c", TO, "remoteEval(2048, ToggleCommandMode);");
bindCommand(keyboard0, break, alt, "c", TO, "Dance::pdaDance();");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// PILOT_MODE.CS: increases your mouse sensitivity to make piloting easier.
//                Can either be toggled manually or automatically (see below).

$Enabled["writer\\pilot_mode.cs"] = true;


// OPTIONS:


// Set the various levels of sensitivity you want to choose from while in
// pilot mode
$PilotMode::Sensitivity[0]  = 0.016;
$PilotMode::Sensitivity[1]  = 0.022;
$PilotMode::Sensitivities   = 2; // Number of different sensitivity levels in array

// Set this to true to have pilot_mode.cs try and guess when you've jumped into
// a scout.  The way it does this is by check to see whether you jumped or used
// your jets in the last 2 seconds when you suddenly aren't holding a weapon
// any more.  This works very well in most cases, since I disable the detection
// when you access an inventory or vehicle station.  But there is currently no
// way to tell that you're accessing an ammo station, which means if you have
// Auto Detect enabled and you jump of jet within 2 seconds of accessing an
// ammo station, pilot mode will be triggered.
//
// I don't find it bothers me that much, since I don't often jump or jet to
// access ammo stations, and pilot_mode.cs automatically disables itself as
// soon as you exit the station.  If you need to access an ammo station often
// in a particular game, you can always temporarily disable the Auto Detection.
$PilotMode::AutoDetect = false;

// Set this to true if you want your sensitivity jacked up when you're in
// pilot mode.  Set this to false if you only want to use pilot_mode.cs to
// enable the scout reticle while using Cowboy's mHUD.cs, and don't want your
// mouse sensitivity changed.
$PilotMode::SetSensitivity = true;

// Set this to true to disable your normal jump key while in pilot mode.
// I use this to prevent myself from accidentally jumping out of vehicles
// when I instinctively hit my space bar to "jump" up.  If you set this to
// true, make sure you bind a key to turn off pilot mode (see below) since
// that will be your new "exit vehicle" key.
$PilotMode::DisableJumpKey = true;


// KEYS:


EditActionMap("playMap.sae");

// Turn on pilot mode and cycle through mouse sensitivity settings for flying
bindCommand(keyboard0, make, l_shift, "c", TO, "PilotMode::On();");

// Toggle auto-detect Pilot Mode on/off
bindCommand(keyboard0, make, l_shift, "p", TO, "PilotMode::ToggleAutoDetect();");

// Set a new jump key to turn off Pilot mode and exit the vehicle
bindCommand(keyboard0, make, shift, "space", TO, "PilotMode::Off();");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// STATION_EVENTS.CS: adds station access events
//

// OPTIONS:

// Set this to true if you don't want to see the white "Station Access On" messages
$Station::Mute::StationAccessOn = true;

// Set this to true if you don't want to see the white "Station Access Off" messages
$Station::Mute::StationAccessOff = true;

// Set this to true if you don't want to see the white "Command Access On" messages
$Command::Mute::CommandAccessOn = true;

// Set this to true if you don't want to see the white "Command Access Off" messages
$Command::Mute::CommandAccessOff = true;

// Set this to true if you don't want to see the white "Unit is disabled" messages
$Station::Mute::UnitIsDisabled = false;

// Set this to true if you don't want to see the white "Unit is not powered" messages
$Station::Mute::UnitIsNotPowered = false;

// Set this to true if you don't want to see the white "Resupply Complete" messages
$Station::Mute::ResupplyComplete = false;

// Set this to true if you don't want to see the white "--ACCESS DENIED-- Wrong Team " messages
$Station::Mute::AccessDenied = false;

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// STATION_TYPES.CS: adds station-type-specific access events
//
// ONLY USE THIS SCRIPT IF YOU NEED THE INVENTORY STATION TYPE EVENTS 
// LIKE eventEnterDeployableInventoryStation!
//
// Note: none of my scripts require this!  But other people's scripts might.

$Enabled["writer\\station_types.cs"] = false;

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// STICKY_FIRE.CS: lets you make the fire button sticky for whatever weapons
//                 you want -- basically it makes the weapon keep firing after
//                 you hold the fire button down for a certain length of time
//

$Enabled["writer\\sticky_fire.cs"] = false;


// OPTIONS:


// Setup a list of weapons to use, and how long to wait before "sticking"
// the fire button on
$StickyFire::Weapon[0] = "Chaingun";
$StickyFire::HoldTime[0] = 0.5;

// Set this to the number of weapons
$StickyFire::Weapons = 1;

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// TAP_THROW.CS: hold a key and release it to throw a grenade (or a mine),
//               A power meter is shown on the screen to help you guage the
//               strength at which the grenade (or mine) will be thrown.
//
//               Quickly tap the key to throw all the grenades (or mines) you
//               have at full force.
//
//               Press that key again to stop throwing the grenades (or mines).
//
//               Press the key for another item to start throwing that item
//               instead.  (The script is set up to throw grenades and mines 
//               by default but you can use it to throw anything).


// KEYS:


EditActionMap("playMap.sae");

// Tap key to throw all grenades, hold key to throw one grenade
//bindCommand(keyboard0, make, "", TO, "tapThrow(1, \"Grenade\");");
//bindCommand(keyboard0, break, "", TO, "tapThrow(0, \"Grenade\");");

// Tap key to throw all mines, hold key to throw one mine
//bindCommand(keyboard0, make, "", TO, "tapThrow(1, \"Mine\");");
//bindCommand(keyboard0, break,"", TO, "tapThrow(0, \"Mine\");");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// WEAPON_SWITCH.CS: adds events that trigger whenever you switch weapons

$Enabled["writer\\weapon_switch.cs"] = true;

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// XHUD.CS: shows your current zoom level (very unobtrusively) at the top of
//          the screen.

$Enabled["writer\\xHUD.cs"] = false;


// OPTIONS:


// Set screen coordinates for xHUD
//$xHUD::X = 375;
//$xHUD::Y = 75;

// Set default colour to use (can be 1, 2 or 3)
//$xHUD::Colour = 1;


// KEYS:


//EditActionMap("playMap.sae");

// Cycle through available colours
//bindCommand(keyboard0, make, alt, "]", TO, "xHUD::nextColour();");
//bindCommand(keyboard0, break, alt, "]", TO, "");

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// YOU_DIED.CS: adds eventYouDied

$Enabled["writer\\you_died.cs"] = true;

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// ZOOM.CS: adds events for zoom key and zooming, lets you toggle whether you
//          want the zoom to rollover (from 20x to 2x and 2x to 20x), lets you
//          toggle zoom mode on with a key tap, and provides a function to set
//          the zoom directly to any one of the 4 standard zoom levels.

$Enabled["writer\\zoom.cs"] = false;


// OPTIONS:


// Set this to true to enable toggling the zoom by tapping the zoom key quickly
//$Zoom::KeyTapEnabled = true;

// Set the length of time between pressing and releasing the zoom key,
// in seconds, that will constitute a key "tap" (enabling zoom mode until the
// next press of the key).  I find 0.075 seconds works well.
//$Zoom::KeyTapTime = 0.075;

// Set this to 1 to enable the zoom rollover by default, or set it to 0 to
// disable the zoom rollover by default.
//$Zoom::rollover = 0;


// KEYS:


//EditActionMap("playMap.sae");

// Set this to your zoom key!
//bindCommand(keyboard0, make, "e", TO, "zoomPressed();");
//bindCommand(keyboard0, break, "e", TO, "zoomReleased();");

// Set zoom levels directly
//bindCommand(keyboard0, make, l_shift, "1", TO, "Zoom::set(0);");
//bindCommand(keyboard0, make, l_shift, "2", TO, "Zoom::set(1);");
//bindCommand(keyboard0, make, l_shift, "3", TO, "Zoom::set(2);");
//bindCommand(keyboard0, make, l_shift, "4", TO, "Zoom::set(3);");

// Toggle 2x -> 20x and 20x ->2x rollover on and off
//bindCommand(keyboard0, make, control, "z", TO, "Zoom::toggleRollover();");

// Increase zoom
//bindCommand(keyboard0, make, "z", TO, "Zoom::in();");

// Decrease zoom
//bindCommand(keyboard0, make, "x", TO, "Zoom::out();");

//-----------------------------------------------------------------------------

