// -----------------------
// TeamHUD.cs version 0.1
// -----------------------

//  Written by Joe Chott (verxion@pobox.com AKA Verxion)
//  ======ATTENTION=====================================
//  MUCH of this code (in fact, almost all of it) came
//  directly from HyperHud, which was written by Dark Ninja
//  Dark Ninja is a really cool guy, he allowed me to borrow
//  his code.  So don't go thinking I wrote this all by my
//  self.  :)

// **********************************************************************************
// These lines are where you customize the location of the hud.

// === The THud::position variable isn't working for me, so I hardwired the
// === coordinates below on the "HUD::New. . ." line.  Change them as you see fit.

// Use this line to place THUD at an absolute position
// $THud::position = "6 211 120 30";

// Or use this line to put it under DynHUD (if you have that enabled)
// $THud::position = "left(hudDyn) bottom(hudDyn)-1 width(hudDyn) 30";

// Or use this line to put it under ScoreHud (if you have that enabled)
$THud::position = "left(ScoreHud) bottom(ScoreHud)-1 width(ScoreHud) 30";

// **********************************************************************************

// Include files

Include("presto\\TeamTrak.cs");
Include("presto\\HUD.cs");
Include("presto\\Event.cs");

// Make our hud

HUD::New(THud, THud::Update, $THud::position);
HUD::Display(THud);

// Simple function to update our HUD

function THud::Update() {

// Initialize the player count to nothing

	%myplayers = 0;
	%theirplayers = 0;

// Find which team is my team

	%myteam = Client::getTeam(getManagerId());

// Assume 128 players per server max (change that if you want to)
// Go through every possible player, and find out what team they
// are on.  Increment the player counts accordingly.

	for (%i = 2048 + 128; %i > 2048; %i--) {
		%team = Client::getTeam(%i);
		if (Client::getName(%i) != "")
			if (%team == %myteam)
				%myplayers++;
			else if (%team > -1)
				%theirplayers++;
	}

// Update the two lines in this hud with the player count

	HUD::AddTextLine(THud, "<f1> Our players: <f2>"@%myplayers);
	HUD::AddTextLine(THud, "<f1>Their players: <f2>"@%theirplayers);

// Tell the scheduler that we don't need to be polled

	return 0;	
}

// Attach our update function to the appropriate events

Event::Attach(eventClientJoin, "HUD::Update(THud);");
Event::Attach(eventClientDrop, "HUD::Update(THud);");
Event::Attach(eventConnectionAccepted, "HUD::Update(THud);");
Event::Attach(eventChangeMission, "HUD::Update(THud);");