// This script was originally designed by the Fortress Kiln scripting staff.
Include("Presto\\TeamTrak.cs");

function HitList::Defaults()
{
	$KilnPref::Name1 = "";
	$KilnPref::Name2 = "";
	$KilnPref::Name3 = "";
	$KilnPref::Name4 = "";
	$KilnPref::Name5 = "";
	$KilnPref::HitListKey = bindKey(play, "=", "HitList::MarkTarget();");
}

function HitList::StorePrefs()
{
        export("$KilnPref::*", "config\\HitListNames.cs", false);
}

if(isFile("config\\HitListNames.cs"))
        Include("HitListNames.cs");
else
        HitList::Defaults();

function HitList::targetClientByName(%name, %msg)
{
	%clientId = getClientByName(%name);
	remoteEval(2048, "IssueTargCommand", 0, %msg, %clientID - 2048, getManagerId());
}

	$HitList::Cycle = 0;

function HitList::MarkTarget()
{
	$HitList::Cycle++;

	if(($HitList::Cycle < 1) || ($HitList::Cycle > 5))
	{ 
		$HitList::Cycle = 1;
	}
	
	remoteCP(2048,"<jc><f2>Hunting HitList Name " @ $HitList::Cycle, 1);

	if(($HitList::Cycle == 1) && ($KilnPref::Name1 != ""))
	{
			HitList::targetClientByName($KilnPref::Name1, "Target Acquired: " @ $KilnPref::Name1 @ "!");
	}
	else if(($HitList::Cycle == 2) && ($KilnPref::Name2 != ""))
	{
			HitList::targetClientByName($KilnPref::Name2, "Target Acquired: " @ $KilnPref::Name2 @ "!");
	}
	else if(($HitList::Cycle == 3) && ($KilnPref::Name3 != ""))
	{
			HitList::targetClientByName($KilnPref::Name3, "Target Acquired: " @ $KilnPref::Name3 @ "!");
	}
	else if(($HitList::Cycle == 4) && ($KilnPref::Name4 != ""))
	{
			HitList::targetClientByName($KilnPref::Name4, "Target Acquired: " @ $KilnPref::Name4 @ "!");
	}
	else if(($HitList::Cycle == 5) && ($KilnPref::Name5 != ""))
	{
			HitList::targetClientByName($KilnPref::Name5, "Target Acquired: " @ $KilnPref::Name5 @ "!");
	}
}

Presto::AddScriptBanner(HitList, "<f2><jc>HitList\n<f0><jc>Version 1.0N\n<f2>Uses NewOpts\n<f0>Adjust settings from options screen\n<f1><jc>By the Fortress Kiln\nThe Order is All\n<f2>Set keys on Options Screen<f0>");
NewOpts::register("HitList", "Kiln\\GUIs\\hitlist.gui", "", "", true);