// -- Writer NewOpts -- v1.0.1 ------------------------------------------------------------------------------
// Written by |HH|Crunchy (Jonathan Slark)
// Email: jonslark@barrysworld.co.uk
// Replaces Writer's keys.cs v1.24
//
// *** Requires the Presto Pack v0.93 or later ***  http://www.planetstarsiege.com/presto/
// *** Requires Zear's NewOpts v0.9 or later *** http://www.cetisp.com/~thammock/scripts/
//
//
// Changes in v1.0.1:
//	+ Made saving of preferences more efficient. There was a noticeable pause when leaving a pref page.
//

$Writer::dirGui = "Crunchy\\gui\\";

function Writer::bindKeys()
{
	if(isFile("config\\WriterPrefs.cs")) exec("WriterPrefs.cs");

    //-----------------------------------------------------------------------------
    // KEEP_MOVING.CS
    if(included("writer\\keep_moving.cs"))
    {
        EditActionMap("playMap.sae");

        // Change these to match your movement keys
        $Keys::[moveforward] = "w";
        $Keys::[moveleft] = "a";
        $Keys::[moveback] = "s";
        $Keys::[moveright] = "d";

        // Toggle continuous movement on key tap for the 4 movement keys
        bindCommand(keyboard0, make, alt, "w", TO, "KeepMoving::Toggle();");
        bindCommand(keyboard0, break, alt, "w", TO, "");

        // Press key to run forward
        bindAction(keyboard0, make, $Keys::[moveforward], TO, IDACTION_MOVEFORWARD, 1.0);
        bindAction(keyboard0, break, $Keys::[moveforward], TO, IDACTION_MOVEFORWARD, 0.0);

        // Press key to run left
        bindAction(keyboard0, make, $Keys::[moveleft], TO, IDACTION_MOVELEFT, 1.0);
        bindAction(keyboard0, break, $Keys::[moveleft], TO, IDACTION_MOVELEFT, 0.0);

        // Press key to run back
        bindAction(keyboard0, make, $Keys::[moveback], TO, IDACTION_MOVEBACK, 1.0);
        bindAction(keyboard0, break, $Keys::[moveback], TO, IDACTION_MOVEBACK, 0.0);

        // Press key to run right
        bindAction(keyboard0, make, $Keys::[moveright], TO, IDACTION_MOVERIGHT, 1.0);
        bindAction(keyboard0, break, $Keys::[moveright], TO, IDACTION_MOVERIGHT, 0.0);
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // FAST_FAVORITES.CS
    if(included("writer\\fast_favorites.cs"))
    {
        function FastFaves::bindKeys()
        {
            echo("binding user's keys for fast favorites");

            // Fast Inventory selection keys

    // I've pre-empted this call so I can use the decimal key to toggle the inventory screen on/off.
    // If you re-enable this call, make sure you remove or change the decimal key binding above.
    //
    //        FastFaves::bindKey(decimal)

            FastFaves::bindKey(numpad0);
            FastFaves::bindKey(numpad1);
            FastFaves::bindKey(numpad2);
            FastFaves::bindKey(numpad3);
            FastFaves::bindKey(numpad4);
            FastFaves::bindKey(numpad5);
            FastFaves::bindKey(numpad6);
            FastFaves::bindKey(numpad7);
            FastFaves::bindKey(numpad8);
            FastFaves::bindKey(numpad9);

            FastFaves::bindKey(control, decimal);
            FastFaves::bindKey(control, numpad0);
            FastFaves::bindKey(control, numpad1);
            FastFaves::bindKey(control, numpad2);
            FastFaves::bindKey(control, numpad3);
            FastFaves::bindKey(control, numpad4);
            FastFaves::bindKey(control, numpad5);
            FastFaves::bindKey(control, numpad6);
            FastFaves::bindKey(control, numpad7);
            FastFaves::bindKey(control, numpad8);
            FastFaves::bindKey(control, numpad9);

            FastFaves::bindKey(alt, decimal);
            FastFaves::bindKey(alt, numpad0);
            FastFaves::bindKey(alt, numpad1);
            FastFaves::bindKey(alt, numpad2);
            FastFaves::bindKey(alt, numpad3);
            FastFaves::bindKey(alt, numpad4);
            FastFaves::bindKey(alt, numpad5);
            FastFaves::bindKey(alt, numpad6);
            FastFaves::bindKey(alt, numpad7);
            FastFaves::bindKey(alt, numpad8);
            FastFaves::bindKey(alt, numpad9);

            FastFaves::bindKey(shift, decimal);
            FastFaves::bindKey(shift, numpad0);
            FastFaves::bindKey(shift, numpad1);
            FastFaves::bindKey(shift, numpad2);
            FastFaves::bindKey(shift, numpad3);
            FastFaves::bindKey(shift, numpad4);
            FastFaves::bindKey(shift, numpad5);
            FastFaves::bindKey(shift, numpad6);
            FastFaves::bindKey(shift, numpad7);
            FastFaves::bindKey(shift, numpad8);
            FastFaves::bindKey(shift, numpad9);
        }
        Event::Attach(eventFavoritesInitialized, FastFaves::bindKeys);
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
	//
	// NewOpts - don't change anything below this point
	//
    //-----------------------------------------------------------------------------

	NewOpts::register("Writer Main Keys",
					  $Writer::dirGui@"WriterMainKeys.gui",
					  "Writer::onMainKeysOpen();",
					  "",
					  TRUE);

	NewOpts::register("Writer Misc Keys",
					  $Writer::dirGui@"WriterMiscKeys.gui",
					  "Writer::onMiscKeysOpen();",
					  "Writer::onMiscKeysClose();",
					  TRUE);

	if(included("writer\\custom_weapons.cs"))
	{
		NewOpts::register("Writer Weapons",
						  $Writer::dirGui@"WriterWepKeys1.gui",
						  "Writer::onWepKeys1Open();",
						  "Writer::onWepKeys1Close();",
					  	  TRUE);
	}

	if(included("writer\\custom_weapons.cs") || included("writer\\fast_favorites.cs"))
	{
		NewOpts::register("Writer Extra",
						  $Writer::dirGui@"WriterExtraKeys.gui",
						  "Writer::onExtraKeysOpen();",
						  "Writer::onExtraKeysClose();",
					  	  TRUE);
	}

	NewOpts::register("Writer Prefs 1",
					  $Writer::dirGui@"WriterPrefs1.gui",
					  "Writer::onPrefs1Open();",
					  "Writer::onPrefs1Close();",
				  	  TRUE);

	if(included("writer\\station_events.cs"))
	{
		NewOpts::register("Writer Prefs 2",
						  $Writer::dirGui@"WriterPrefs2.gui",
						  "",
						  "Writer::onPrefs2Close();",
					  	  TRUE);
	}

	Include("Crunchy\\WriterHelp.cs");
}

function Writer::onMainKeysOpen()
{
    //-----------------------------------------------------------------------------
    // AUTO_REPAIR_KIT.CS
    if(included("writer\\auto_repair_kit.cs"))
    {
		Control::setActive(Writer1::keyAutoRepair, TRUE);
		Control::setActive(Writer1::keyUseRepair, TRUE);
		Control::setActive(Writer1::keyRepairTaunt, TRUE);
    }
	else
    {
		Control::setActive(Writer1::keyAutoRepair, FALSE);
		Control::setActive(Writer1::keyUseRepair, FALSE);
		Control::setActive(Writer1::keyRepairTaunt, FALSE);
    }

    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // CROUCH_TOGGLE.CS
    if(included("writer\\crouch_toggle.cs"))
    {
		Control::setActive(Writer1::keyCrouch, TRUE);
    }
	else
	{
		Control::setActive(Writer1::keyCrouch, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // DROP_AMMO.CS
    if(included("writer\\drop_ammo.cs"))
    {
		Control::setActive(Writer1::keyDropAmmo, TRUE);
    }
	else
	{
		Control::setActive(Writer1::keyDropAmmo, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // FIRE.CS
    if(included("writer\\fire.cs"))
    {
		Control::setActive(Writer1::keyFire, TRUE);
    }
	else
	{
		Control::setActive(Writer1::keyFire, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // JET.CS
    if(included("writer\\jet.cs"))
    {
		Control::setActive(Writer1::keyJet, TRUE);
    }
	else
	{
		Control::setActive(Writer1::keyJet, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // JUMP.CS
    if(included("writer\\jump.cs"))
    {
		Control::setActive(Writer1::keyJump, TRUE);
		Control::setActive(Writer1::keyJumpTog, TRUE);
    }
	else
	{
		Control::setActive(Writer1::keyJump, FALSE);
		Control::setActive(Writer1::keyJumpTog, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // MMB_REPAIR.CS
    if(included("writer\\mmb_repair.cs"))
    {
		Control::setActive(Writer1::keyMMBRepair, TRUE);
		Control::setActive(Writer1::keyMMBWep, TRUE);
    }
	else
	{
		Control::setActive(Writer1::keyMMBRepair, FALSE);
		Control::setActive(Writer1::keyMMBWep, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // TAP_THROW.CS
    if(included("writer\\tap_throw.cs"))
    {
		Control::setActive(Writer1::keyGren, TRUE);
		Control::setActive(Writer1::keyMine, TRUE);
    }
	else
	{
		Control::setActive(Writer1::keyGren, FALSE);
		Control::setActive(Writer1::keyMine, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // ZOOM.CS
    if(included("writer\\zoom.cs"))
    {
		Control::setActive(Writer1::keyZoomOn, TRUE);
		Control::setActive(Writer1::keyZoomIn, TRUE);
		Control::setActive(Writer1::keyZoomOut, TRUE);
		Control::setActive(Writer1::keyZoomRollover, TRUE);
		Control::setActive(Writer1::keyZoom0, TRUE);
		Control::setActive(Writer1::keyZoom1, TRUE);
		Control::setActive(Writer1::keyZoom2, TRUE);
		Control::setActive(Writer1::keyZoom3, TRUE);
    }
	else
	{
		Control::setActive(Writer1::keyZoomOn, FALSE);
		Control::setActive(Writer1::keyZoomIn, FALSE);
		Control::setActive(Writer1::keyZoomOut, FALSE);
		Control::setActive(Writer1::keyZoomRollover, FALSE);
		Control::setActive(Writer1::keyZoom0, FALSE);
		Control::setActive(Writer1::keyZoom1, FALSE);
		Control::setActive(Writer1::keyZoom2, FALSE);
		Control::setActive(Writer1::keyZoom3, FALSE);
	}
    //-----------------------------------------------------------------------------
}

function Writer::onMiscKeysOpen()
{
    //-----------------------------------------------------------------------------
    // AM_REPAIR.CS
    if(included("writer\\am_repair.cs"))
    {
		Control::setActive(Writer2::keyRepairFilter, TRUE);
    }
	else
	{
		Control::setActive(Writer2::keyRepairFilter, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // DISC_JUMP.CS -- NOT INCLUDED BY DEFAULT (I don't use this any more)
    if(included("writer\\extras\\disc_jump.cs"))
    {
		Control::setActive(Writer2::keyDiscJump, TRUE);
    }
	else
	{
		Control::setActive(Writer2::keyDiscJump, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // FIRE_ON_MY_TARGET.CS
    if(included("writer\\fire_on_my_target.cs"))
    {
		Control::setActive(Writer2::keyFireTarget, TRUE);
    }
	else
	{
		Control::setActive(Writer2::keyFireTarget, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // LASER_READY.CS
    if(included("writer\\laser_ready.cs"))
    {
		Control::setActive(Writer2::keyEnergyBar, TRUE);
		Control::setActive(Writer2::keyEnergyBarPos, TRUE);
    }
	else
	{
		Control::setActive(Writer2::keyEnergyBar, FALSE);
		Control::setActive(Writer2::keyEnergyBarPos, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // LITTERBUG.CS
    if(included("writer\\litterbug.cs"))
    {
		Control::setActive(Writer2::keyLitterbug, TRUE);
		Control::setActive(Writer2::keyLitterbugDyn, TRUE);
		Control::setActive(Writer2::keyLitterbugNext, TRUE);
		Control::setActive(Writer2::keyLitterbugPrev, TRUE);
    }
	else
	{
		Control::setActive(Writer2::keyLitterbug, FALSE);
		Control::setActive(Writer2::keyLitterbugDyn, FALSE);
		Control::setActive(Writer2::keyLitterbugNext, FALSE);
		Control::setActive(Writer2::keyLitterbugPrev, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // PDA_DANCE.CS
    if(included("writer\\pda_dance.cs"))
    {
		Control::setActive(Writer2::keyPDADance, TRUE);
		Control::setActive(Writer2::keyDance, TRUE);
    }
	else
	{
		Control::setActive(Writer2::keyPDADance, FALSE);
		Control::setActive(Writer2::keyDance, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // PILOT_MODE.CS
    if(included("writer\\pilot_mode.cs"))
    {
		Control::setActive(Writer1::keyPilotModeOn, TRUE);
		Control::setActive(Writer1::keyPilotModeOff, TRUE);
		Control::setActive(Writer1::keyAutoPilotMode, TRUE);
    }
	else
	{
		Control::setActive(Writer1::keyPilotModeOn, FALSE);
		Control::setActive(Writer1::keyPilotModeOff, FALSE);
		Control::setActive(Writer1::keyAutoPilotMode, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // PING.CS
    if(included("writer\\ping.cs"))
    {
		Control::setActive(Writer2::keyGetPing, TRUE);
    }
	else
	{
		Control::setActive(Writer2::keyGetPing, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // REPAIR_KEY.CS -- NOT INCLUDED BY DEFAULT (I don't use this any more)
    if(included("writer\\extras\\repair_key.cs"))
    {
		Control::setActive(Writer2::keyRepair, TRUE);
    }
	else
	{
		Control::setActive(Writer2::keyRepair, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // SMOOTH_ZOOM.CS
    if(included("writer\\smooth_zoom.cs"))
    {
		Control::setActive(Writer2::keySmoothIn, TRUE);
		Control::setActive(Writer2::keySmoothOut, TRUE);
    }
	else
	{
		Control::setActive(Writer2::keySmoothIn, FALSE);
		Control::setActive(Writer2::keySmoothOut, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // XHUD.CS
    if(included("writer\\xHUD.cs"))
    {
		Control::setActive(Writer2::keyxHUDCycle, TRUE);
    }
	else
	{
		Control::setActive(Writer2::keyxHUDCycle, FALSE);
	}
    //-----------------------------------------------------------------------------

	// Use the buttons from the main screen.
	Control::setVisible(Writer::buttonDefaults, TRUE);
	Control::setVisible(Writer::buttonCancel, TRUE);
}

function Writer::onMiscKeysClose()
{
	Control::setVisible(Writer::buttonDefaults, FALSE);
	Control::setVisible(Writer::buttonCancel, FALSE);
}

function Writer::onWepKeys1Open()
{
	// Use the buttons from the main screen.
	Control::setVisible(Writer::buttonDefaults, TRUE);
	Control::setVisible(Writer::buttonCancel, TRUE);
}

function Writer::onWepKeys1Close()
{
	Control::setVisible(Writer::buttonDefaults, FALSE);
	Control::setVisible(Writer::buttonCancel, FALSE);
}

function Writer::onExtraKeysOpen()
{
    //-----------------------------------------------------------------------------
    // CUSTOM_WEAPONS.CS
    if(included("writer\\custom_weapons.cs"))
    {
		Control::setActive(Writer4::keyAlt1, TRUE);
		Control::setActive(Writer4::keyAlt2, TRUE);
		Control::setActive(Writer4::keyAlt3, TRUE);
		Control::setActive(Writer4::keyAlt4, TRUE);
		Control::setActive(Writer4::keyAlt5, TRUE);
		Control::setActive(Writer4::keyAlt6, TRUE);
		Control::setActive(Writer4::keyAlt7, TRUE);
		Control::setActive(Writer4::keyAlt8, TRUE);
		Control::setActive(Writer4::keyAlt9, TRUE);
		Control::setActive(Writer4::keyAlt0, TRUE);
	}
	else
	{
		Control::setActive(Writer4::keyAlt1, FALSE);
		Control::setActive(Writer4::keyAlt2, FALSE);
		Control::setActive(Writer4::keyAlt3, FALSE);
		Control::setActive(Writer4::keyAlt4, FALSE);
		Control::setActive(Writer4::keyAlt5, FALSE);
		Control::setActive(Writer4::keyAlt6, FALSE);
		Control::setActive(Writer4::keyAlt7, FALSE);
		Control::setActive(Writer4::keyAlt8, FALSE);
		Control::setActive(Writer4::keyAlt9, FALSE);
		Control::setActive(Writer4::keyAlt0, FALSE);
	}
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // FAST_FAVORITES.CS
    if(included("writer\\fast_favorites.cs"))
    {
		Control::setActive(Writer4::keyInventory2, TRUE);
		Control::setActive(Writer4::keyAssign, TRUE);
		Control::setActive(Writer4::keyAutoBuy, TRUE);
		Control::setActive(Writer4::keyExtraAmmo, TRUE);
		Control::setActive(Writer4::keyMessage, TRUE);
		Control::setActive(Writer4::keyLoadout, TRUE);
		Control::setActive(Writer4::keyWeapons, TRUE);
	}
	else
	{
		Control::setActive(Writer4::keyInventory2, FALSE);
		Control::setActive(Writer4::keyAssign, FALSE);
		Control::setActive(Writer4::keyAutoBuy, FALSE);
		Control::setActive(Writer4::keyExtraAmmo, FALSE);
		Control::setActive(Writer4::keyMessage, FALSE);
		Control::setActive(Writer4::keyLoadout, FALSE);
		Control::setActive(Writer4::keyWeapons, FALSE);
	}
    //-----------------------------------------------------------------------------

	// Use the buttons from the main screen.
	Control::setVisible(Writer::buttonDefaults, TRUE);
	Control::setVisible(Writer::buttonCancel, TRUE);
}

function Writer::onExtraKeysClose()
{
	Control::setVisible(Writer::buttonDefaults, FALSE);
	Control::setVisible(Writer::buttonCancel, FALSE);
}

function Writer::onPrefs1Open()
{
	if(included("writer\\am_deploy.cs"))
	{
		Control::setActive(Writer5::editDeployFlood, TRUE);
		Control::setActive(Writer5::checkMuteDeploy, TRUE);
	}
	else
	{
		Control::setActive(Writer5::editDeployFlood, FALSE);
		Control::setActive(Writer5::checkMuteDeploy, FALSE);
	}

	if(included("writer\\am_repair.cs"))
	{
		Control::setActive(Writer5::checkMuteRepair, TRUE);
		Control::setActive(Writer5::checkMutePlayer, TRUE);
		Control::setActive(Writer5::checkMuteStop, TRUE);
		Control::setActive(Writer5::checkMuteDone, TRUE);
	}
	else
	{
		Control::setActive(Writer5::checkMuteRepair, FALSE);
		Control::setActive(Writer5::checkMutePlayer, FALSE);
		Control::setActive(Writer5::checkMuteStop, FALSE);
		Control::setActive(Writer5::checkMuteDone, FALSE);
	}

	if(included("writer\\am_thanks.cs"))
	{
		Control::setActive(Writer5::checkMuteBeing, TRUE);
	}
	else
	{
		Control::setActive(Writer5::checkMuteBeing, FALSE);
	}

	if(included("writer\\custom_weapons.cs"))
	{
		Control::setActive(Writer5::checkOrignialConfig, TRUE);
	}
	else
	{
		Control::setActive(Writer5::checkOrignialConfig, FALSE);
	}

	if(included("writer\\fast_favorites.cs"))
	{
		Control::setActive(Writer5::checkAutoBuy, TRUE);
		Control::setActive(Writer5::checkShowWeps, TRUE);
		Control::setActive(Writer5::checkToMany, TRUE);
	}
	else
	{
		Control::setActive(Writer5::checkAutoBuy, FALSE);
		Control::setActive(Writer5::checkShowWeps, FALSE);
		Control::setActive(Writer5::checkToMany, FALSE);
	}

	if(included("writer\\laser_ready.cs"))
	{
		FGCombo::clear(Writer5::comboBarPos);
		FGCombo::addEntry(Writer5::comboBarPos, "Top", 0);
		FGCombo::addEntry(Writer5::comboBarPos, "Right", 1);
		FGCombo::addEntry(Writer5::comboBarPos, "Bottom", 2);
		FGCombo::addEntry(Writer5::comboBarPos, "Left", 3);
		FGCombo::setSelected(Writer5::comboBarPos, $EnergyBar::Position);
		Control::setActive(Writer5::comboBarPos, TRUE);
		Control::setActive(Writer5::editReticleWidth, TRUE);
		Control::setActive(Writer5::editReticleHeight, TRUE);
	}
	else
	{
		FGCombo::clear(Writer5::comboBarPos);
		FGCombo::addEntry(Writer5::comboBarPos, "Top", 0);
		FGCombo::addEntry(Writer5::comboBarPos, "Right", 1);
		FGCombo::addEntry(Writer5::comboBarPos, "Bottom", 2);
		FGCombo::addEntry(Writer5::comboBarPos, "Left", 3);
		FGCombo::setSelected(Writer5::comboBarPos, $EnergyBar::Position);
		Control::setActive(Writer5::comboBarPos, FALSE);
		Control::setActive(Writer5::editReticleWidth, FALSE);
		Control::setActive(Writer5::editReticleHeight, FALSE);
	}

	if(included("writer\\litterbug.cs"))
	{
		Control::setActive(Writer5::checkPingWait, TRUE);
	}
	else
	{
		Control::setActive(Writer5::checkPingWait, FALSE);
	}

	if(included("writer\\pilot_mode.cs"))
	{
		Control::setActive(Writer5::checkAutoPilot, TRUE);
	}
	else
	{
		Control::setActive(Writer5::checkAutoPilot, FALSE);
	}

	if(included("writer\\xHUD.cs"))
	{
		FGCombo::clear(Writer5::comboColour);
		FGCombo::addEntry(Writer5::comboColour, "Orange", 0);
		FGCombo::addEntry(Writer5::comboColour, "Beige", 1);
		FGCombo::addEntry(Writer5::comboColour, "White", 2);
		FGCombo::setSelected(Writer5::comboColour, $xHUD::Colour);
		Control::setActive(Writer5::comboColour, TRUE);
		Control::setActive(Writer5::editXHUDx, TRUE);
		Control::setActive(Writer5::editXHUDy, TRUE);
	}
	else
	{
		FGCombo::clear(Writer5::comboColour);
		FGCombo::addEntry(Writer5::comboColour, "Orange", 0);
		FGCombo::addEntry(Writer5::comboColour, "Beige", 1);
		FGCombo::addEntry(Writer5::comboColour, "White", 2);
		FGCombo::setSelected(Writer5::comboColour, $xHUD::Colour);
		Control::setActive(Writer5::comboColour, FALSE);
		Control::setActive(Writer5::editXHUDx, FALSE);
		Control::setActive(Writer5::editXHUDy, FALSE);
	}
}

function Writer::onPrefs1Close()
{
	$EnergyBar::Position = FGCombo::getSelected(Writer5::comboBarPos);
	if($EnergyBar::Exists)
        EnergyBar::make();
	$xHUD::Colour = FGCombo::getSelected(Writer5::comboColour);
	if($xHUD::Exists)
		xHUD::make();

	Writer::savePrefs();
}

function Writer::onPrefs2Close()
{
	Writer::savePrefs();
}

function Writer::savePrefs()
{
	export("*::Mute::*", "config\\WriterPrefs.cs", false);

	if(included("writer\\am_deploy.cs"))
		export("$AutoMessage::DeployFloodTime", "config\\WriterPrefs.cs", true);

	if(included("writer\\custom_weapons.cs"))
		export("$WeaponKey::UseOriginalTribesConfig", "config\\WriterPrefs.cs", true);

	if(included("writer\\fast_favorites.cs"))
	{
		export("$FastFaves::AutoBuyLoadout", "config\\WriterPrefs.cs", true);
		export("$FastFaves::ShowPreloadWeapons", "config\\WriterPrefs.cs", true);
	}

	if(included("writer\\laser_ready.cs"))
	{
		export("$EnergyBar::reticleSizeX", "config\\WriterPrefs.cs", true);
		export("$EnergyBar::reticleSizeY", "config\\WriterPrefs.cs", true);
	}

	if(included("writer\\litterbug.cs"))
		export("$Litterbug::UsePingWait", "config\\WriterPrefs.cs", true);

	if(included("writer\\pilot_mode.cs"))
		export("$PilotMode::AutoDetectOn", "config\\WriterPrefs.cs", true);

	if(included("writer\\xHUD.cs"))
	{
		export("$xHUD::Colour", "config\\WriterPrefs.cs", true);
		export("$xHUD::X", "config\\WriterPrefs.cs", true);
		export("$xHUD::Y", "config\\WriterPrefs.cs", true);
	}
}