// -- TeamSize HUD -- v2.0 ----------------------------------------------------------------------------------
// Written by |HH|Crunchy (Jonathan Slark)
// Web page: http://www.planetstarsiege.com/crunchy/
// Email: crunchy@planetstarsiege.com
// Inspired by team size indicator on the HyperHUD by DarkNinja.
//
// *** Requires Presto Pack 0.93 or later ***  http://www.planetstarsiege.com/presto/
// *** Requires Zear's NewOpts v0.95 or later *** http://www.planetstarsiege.com/zear/
//
// Displays number of players on the two teams and the number of spectators.  The green player icon represents 
// your team, the red icon is for the enemy team.  The spectators have a white icon.  If there is an imbalance 
// in the teams this is shown by white text for the over sized team and orange text for the smaller team. If 
// the teams are balanced both are shown using cream text.  You can adjust the ratio that is used to check for 
// an imbalance in the options menu.  If one team had 7 players and the other had 10 then there is a ratio of 
// 0.7, if you set the ratio in the options menu to 0.75 the HUD will conside this an imblanace.
//
//
// Changes in 2.0:
//	+ Added number of spectators.
//	+ Seperated number of friendly / enemy players into two sepearate lines.
//	+ New icons.
//	+ Icons blink when team sizes change.
//	+ Displays teams of size 10 or more correctly.
//	+ Updates on each team change, as apposed to the every 2 seconds in v1.3.
//	= Imbalance in teams is shown using white text for the over sized team and orange text for the smaller 
//	  team, if teams are balanced both are shown using cream text.
//
// Changes in v1.3:
//	+ HUDMover compatible.
//
// Changes in v1.2:
//	+ Added options page for NewOpts.
//
// Changes in v1.1:
//	+ Changed layout of the HUD slightly.  Thanks to |HH|Apollo for the cool modification :)
//  + If your an observer shows sizes of the two teams and not the observers.
//
//
// -- Preferences --
//
// Set your options in the normal Tribes option menu.  Goto options then scripts.  From the pull down menu 
// select TeamSize HUD.  From here you can set your options and preferences.
//

//
// -- Header --
//

if ($Presto::version >= 0.93) {

function TeamSizeHUD::SetDefaults() {
	$CrunchyPref::TeamSizeHUDPos = "0% 21% 40 44";
	$CrunchyPref::TeamSizeRatio = 0.75;
	}
if(isFile("config\\CrunchyPrefs.cs")) Include("CrunchyPrefs.cs");
else TeamSizeHUD::SetDefaults();
if($CrunchyPref::TeamSizeHUDPos == "" || getword($CrunchyPref::TeamSizeHUDPos, 3) == "18")
	TeamSizeHUD::SetDefaults();

Include("Presto\\HUD.cs");
Include("Presto\\Event.cs");
Include("Presto\\TeamTrak.cs");
Include("Presto\\List.cs");
if(isFile("config\\Presto\\Schedule.cs")) Include("Presto\\Schedule.cs");
else { // Taken from Presto Pack 0.94 alpha
    function Schedule::Add(%eval, %time, %tag) {
    	if (%tag == "")
    		%tag = %eval;	// Use function as tag if none provided.
    	$Schedule::ID[%tag]++;
    	$Schedule::eval[%tag] = %eval;
    	schedule("Schedule::Exec(\""@escapestring(%tag)@"\", "@$Schedule::ID[%tag]@");", %time);
    	}
    function Schedule::Exec(%tag, %id) {
    	if ($Schedule::ID[%tag] != %id)
    		return;
    	%eval = $Schedule::eval[%tag];
    	Schedule::Cancel(%tag);
    	eval(%eval);
    	}
    function Schedule::Cancel(%tag) {
    	$Schedule::ID[%tag]++;
    	$Schedule::eval[%tag] = "";
    	}
	}

Event::Attach(eventConnected, "HUD::Update(TeamSizeHUD);");
Event::Attach(eventChangeMission, "HUD::Update(TeamSizeHUD);");
Event::Attach(eventClientJoin, TeamSize::onJoin);
Event::Attach(eventClientDrop, TeamSize::onDrop);
Event::Attach(eventClientChangeTeam, TeamSize::onChangeTeam);

$TeamSize::FriendlyIcon = "Crunchy\\bmp\\small_greenplayer";
$TeamSize::EnemyIcon = "Crunchy\\bmp\\small_redplayer";
$TeamSize::SpecIcon = "Crunchy\\bmp\\small_whiteplayer";

//
// -- Begin code --
//

if(!HUD::Exists(TeamSizeHUD)) {
	HUD::New(TeamSizeHUD, TeamSize::UpdateHUD, $CrunchyPref::TeamSizeHUDPos);
	HUD::Display(TeamSizeHUD);
	}

function TeamSize::onDrop(%client) {
	%team = $TeamSize::[%client, team];
	$TeamSize::Blink[%team] = false;
	Schedule::Add("TeamSize::Blink("@%team@",0);", 0.3, "TeamSize::Blink"@%team);
	HUD::Update(TeamSizeHUD);
	}
function TeamSize::onJoin(%client) {
	TeamSize::onChangeTeam(%client, -1);
	}
function TeamSize::onChangeTeam(%client, %team) {
	$TeamSize::[%client, team] = %team;
	$TeamSize::Blink[%team] = false;
	Schedule::Add("TeamSize::Blink("@%team@",0);", 0.3, "TeamSize::Blink"@%team);
	HUD::Update(TeamSizeHUD);
	}
function TeamSize::Blink(%team, %i) {
	if(%i > 10) {
		$TeamSize::Blink[%team] = false;
		HUD::Update(TeamSizeHUD);
		}
	else {
		$TeamSize::Blink[%team] = !$TeamSize::Blink[%team];
		HUD::Update(TeamSizeHUD);
		Schedule::Add("TeamSize::Blink("@%team@","@%i+1@");", 0.3, "TeamSize::Blink"@%team);
		}
	}

function TeamSize::UpdateHUD() {
	if(Client::GetTeam(getManagerID()) == -1) {
		%myteam = List::Count(Team::GetList(0));
		%nmeteam = List::Count(Team::GetList(1));
		if($TeamSize::Blink[0]) %myext = "_on";
		else %myext = "_off";
		if($TeamSize::Blink[1]) %nmeext = "_on";
		else %nmeext = "_off";
		}
	else {
		%myteam = List::Count(Team::GetList(Team::Friendly()));
		%nmeteam = List::Count(Team::GetList(Team::Enemy()));
		if($TeamSize::Blink[Team::Friendly()]) %myext = "_on";
		else %myext = "_off";
		if($TeamSize::Blink[Team::Enemy()]) %nmeext = "_on";
		else %nmeext = "_off";
		}
	%specteam = List::Count(Team::GetList(-1));
	if($TeamSize::Blink[-1]) %specext = "_on";
	else %specext = "_off";

	if(%nmeteam == 0) {  // Don't divide by zero
		if(%myteam == 0) {
			%mycolour = "<f1>";
			%nmecolour = "<f1>";
			}
		else {
			%mycolour = "<f2>";
			%nmecolour = "<f0>";
			}
		}
	else {
		%ratio = %myteam / %nmeteam;
		if(%ratio < $CrunchyPref::TeamSizeRatio) {
			%mycolour = "<f0>";
			%nmecolour = "<f2>";
			}
		else if(%ratio > 1/$CrunchyPref::TeamSizeRatio) {
			%mycolour = "<f2>";
			%nmecolour = "<f0>";
			}
		else {
			%mycolour = "<f1>";
			%nmecolour = "<f1>";
			}
		}

	%myicon = "<B4,3:"@$TeamSize::FriendlyIcon@%myext@".bmp>";
	%nmeicon = "<B-16,3:"@$TeamSize::EnemyIcon@%nmeext@".bmp>";
	%specicon = "<B-16,3:"@$TeamSize::SpecIcon@%specext@".bmp>";
	HUD::AddTextLine(TeamSizeHUD,%mycolour@%myicon@"<L4>"@%myteam);
	HUD::AddTextLine(TeamSizeHUD,%nmecolour@%nmeicon@"<L4>"@%nmeteam);
	HUD::AddTextLine(TeamSizeHUD,"<f1>"@%specicon@"<L4>"@%specteam);

	return 0;
	}

//
// NewOpts
//

function TeamSizeHUD::onOpen() {
	}

function TeamSizeHUD::onClose() {
	export("$CrunchyPref::*", "config\\CrunchyPrefs.cs", false);
	}

NewOpts::register("TeamSize HUD",
				  "Crunchy\\gui\\TeamSizeHUDoptions.gui",
				  "TeamSizeHUD::onOpen();",
				  "TeamSizeHUD::onClose();",
				  TRUE);
Include("Crunchy\\TeamSizeHUDHelp.cs");


} // PrestoPack installed check
else echo("TeamSizeHUD: requires Presto Pack 0.93 or later.");
