// -- TeamSize HUD -- v1.3 ----------------------------------------------------------------------------------
// Written by |HH|Crunchy (Jonathan Slark)
// Web page: http://www.planetstarsiege.com/crunchy/
// Email: crunchy@planetstarsiege.com
// Inspired by team size indicator on the HyperHUD by DarkNinja.
//
// *** Requires Presto Pack 0.93 or later ***  http://www.planetstarsiege.com/presto/
// *** Requires Zear's NewOpts v0.95 or later *** http://www.planetstarsiege.com/zear/
//
// Display's the sizes of the two teams, if there is a sufficient difference between the two team sizes then 
// the green "ok" icon will change to a red "bad" icon.  See the Preferences below.  Designed to be part of 
// the suite of HUDs I have written.
//
//
// Changes in v1.3:
//	+ HUDMover compatible.
//
// Changes in v1.2:
//	+ Added options page for NewOpts.
//
// Changes in v1.1:
//	+ Changed layout of the HUD slightly.  Thanks to |HH|Apollo for the cool modification :)
//  + If your an observer shows sizes of the two teams and not the observers.
//
//
// -- Preferences --
//
// Set your options in the normal Tribes option menu.  Goto options then scripts.  From the pull down menu 
// select Item HUD.  From here you can set your options and preferences.
//

//
// -- Header --
//

if ($Presto::version >= 0.93) {

function TeamSizeHUD::SetDefaults() {
	$CrunchyPref::TeamSizeHUDPos = "0% 28% 40 56";
	$CrunchyPref::TeamSizeRatio = 0.75;
	}
if(isFile("config\\CrunchyPrefs.cs"))
// Load last prefs off disk
	Include("CrunchyPrefs.cs");  // We only want this run once, a script might want to override.
else
	TeamSizeHUD::SetDefaults();
if($CrunchyPref::TeamSizeHUDPos == "")
	TeamSizeHUD::SetDefaults();

Include("Presto\\HUD.cs");
Include("Presto\\Event.cs");
Include("Presto\\TeamTrak.cs");
Include("Presto\\List.cs");

Event::Attach(eventConnected, "HUD::Update(TeamSizeHUD);");
Event::Attach(eventChangeMission, "HUD::Update(TeamSizeHUD);");

//
// -- Begin code --
//

if(HUD::Exists(TeamSizeHUD)) {
	HUD::Move(TeamSizeHUD, $CrunchyPref::TeamSizeHUDPos);
	HUD::Update(TeamSizeHUD);
	}
else {
	HUD::New(TeamSizeHUD, TeamSize::UpdateHUD, $CrunchyPref::TeamSizeHUDPos);
	HUD::Display(TeamSizeHUD);
	}

function TeamSize::UpdateHUD() {
	if(Client::GetTeam(getManagerID()) == -1) {
		%myteam = List::Count(Team::GetList(0));
		%nmeteam = List::Count(Team::GetList(1));
		}
	else {
		%myteam = List::Count(Team::GetList(Team::Friendly()));
		%nmeteam = List::Count(Team::GetList(Team::Enemy()));
		}

	if(%nmeteam == 0) // Don't want to divide by zero.
		%ratio = 0;
	else
		%ratio = %myteam/%nmeteam;
	if(%ratio >= (1/$CrunchyPref::TeamSizeRatio) || %ratio <= $CrunchyPref::TeamSizeRatio)
		%icon = "<B5,2:M_Player_red.bmp>";
	else
		%icon = "<B5,4:M_Player_green.bmp>";

	HUD::AddTextLine(TeamSizeHUD,"<f1>"@%myteam@%icon@%nmeteam);

	return 2;
	}

//
// NewOpts
//

function TeamSizeHUD::onOpen() {
	}

function TeamSizeHUD::onClose() {
	export("$CrunchyPref::*", "config\\CrunchyPrefs.cs", false);
	}

NewOpts::register("TeamSize HUD",
				  "Crunchy\\gui\\TeamSizeHUDoptions.gui",
				  "TeamSizeHUD::onOpen();",
				  "TeamSizeHUD::onClose();",
				  TRUE);
Include("Crunchy\\TeamSizeHUDHelp.cs");


} // PrestoPack installed check
else echo("TeamSizeHUD: requires Presto Pack 0.93 or later.");
