// -- TeamScore HUD -- v1.0.1 -------------------------------------------------------------------------------
// Written by |HH|Crunchy (Jonathan Slark)
// Web page: http://www.crunchy.oaktree.co.uk/scripting/
//
// *** Requires the Presto Pack v0.93 or later ***  http://www.planetstarsiege.com/presto/
// *** Requires Zear's NewOpts v0.95 or later *** http://www.cetisp.com/~thammock/scripts/
// *** Requires my ObjectiveTrak script, a new tool for scripters! v2.0 beta 6 or later ***
//
// TeamScore HUD displays the scores of your team and your enemy team, it's currently restricted to tracking 
// scores for two teams.  The scoring system works for all mission types!  The left number is the amount of 
// points needed for a team to win the map out right.  The number next to the green player is the score of 
// your team.  The number next to the red player is the score of the enemy team.  There is an option to make 
// the TeamScore HUD attach itself to the top of the Objective HUD (v2.3.2 or later required).
//
// If you join mid game the scores have a ? after them as the script can't find out the current score.  If 
// you start a new mission then the script will know the score properly.
//
//
// Changes in v1.0.1
//	+ When in obeserver mode scores of the two teams are now shown (as apposed to the score for the 
//	  observers :).
//	+ If a winning score is not known then it is represented by a ? instead of blank.  This probably means 
//	  that none of the score info is known and the scores won't update.
//  = Fixed bug where HUD could get frozen between missions.  At least I hope this fixes it, various ppl 
//	  reported it but it hasn't happened to me.  The worst kind of bug to fix :).
//
//
// -- Preferences --
//
// Preferences are now set using a NewOpts page!  Start Tribes then go to Options, Scripts and then select 
// ObjectiveHUD from the pull down list.  Now you can change the options, get some help and then the options 
// are saved so you only need to set all this once.
//

//
// -- Header --
//

if ($Presto::version < 0.93)
	echo("TeamScore HUD requires Presto Pack v0.93 or later.");
else
{

Include("Presto\\Event.cs");
Include("Presto\\HUD.cs");
Include("Crunchy\\ObjectiveTrak.cs");

Event::Attach(eventConnected, "HUD::Update(TeamScoreHUD);");
Event::Attach(eventChangeMission, "HUD::Update(TeamScoreHUD);");

$ObjectiveHUD::dirBMP = "Crunchy\\bmp\\";

function TeamScoreHUD::SetDefaults()
{
	$CrunchyPref::AttachTeamScoreHUD = false;
	$CrunchyPref::TeamScoreHUDPos = "100% 50% 126 16";
}
if(isFile("config\\CrunchyPrefs.cs"))
{
	// Load last prefs off disk
	Include("CrunchyPrefs.cs");  // We only want this run once, a script might want to override.

	// In the case the defaults don't contain one for TeamScore HUD
	if($CrunchyPref::TeamScoreHUDPos == "")
		TeamScoreHUD::SetDefaults();
}
else
	TeamScoreHUD::SetDefaults();

//
// -- Begin code --
//

// Round up a float if the decimal part is > 0.5.
function roundup(%num)
{
	%f = floor(%num);
	if(%num - %f < 0.5)
		return %f;
	else
		return %f+1;
}

// Update the HUD.
function TeamScoreHUD::Update()
{
	// If not in observer mode show the friendly and enemy scores.
	if(Team::Friendly() != -1)
	{
		%teamFriendly = roundup(Objective::GetTeamScore(Team::Friendly()));
		%teamEnemy = roundup(Objective::GetTeamScore(Team::Enemy()));
	}
	// If in observer mode then show the score for the two teams playing.
	else
	{
		%teamFriendly = roundup(Objective::GetTeamScore(0));
		%teamEnemy = roundup(Objective::GetTeamScore(1));
	}
	// If its the middle of the game we aren't sure of the scores.
	if($MidGame) %teamFriendly = %teamFriendly@"?";
	if($MidGame) %teamEnemy = %teamEnemy@"?";

	if((%winscore = Objective::GetWinScore()) == "") %winscore = "?";

	Control::SetValue(Object::getName($TeamScoreHUD::Text[0]),
					  "<f1><B1,3:"@$ObjectiveHUD::dirBMP@"small_finish.bmp>"@%winscore);
	Control::SetValue(Object::getName($TeamScoreHUD::Text[1]),
					  "<f1><B2,3:M_Player_green.bmp>"@%teamFriendly);
	Control::SetValue(Object::getName($TeamScoreHUD::Text[2]),
 					  "<f1><B2,1:M_Player_red.bmp>"@%teamEnemy);

	return 1;
}

// Make the HUD up.
function TeamScoreHUD::Create()
{
	%perLine = HUD::GetCoordValue(TeamScoreHUD, 3);
	%width = (HUD::GetCoordValue(TeamScoreHUD, 2)-8)/3;
	$TeamScoreHUD::Text[0] =
		HUD::AddObject(TeamScoreHUD, FearGuiFormattedText, 4, 0, %width, %perLine+2);
	$TeamScoreHUD::Text[1] =
		HUD::AddObject(TeamScoreHUD, FearGuiFormattedText, 4+%width, 0, %width, %perLine+2);
	$TeamScoreHUD::Text[2] =
		HUD::AddObject(TeamScoreHUD, FearGuiFormattedText, 4+%width*2, 0, %width, %perLine+2);
}

// Attach the HUD to Objective HUD.
function TeamScoreHUD::Attach()
{
	%width = HUD::GetCoordValue(TeamScoreHUD, 2);
	%height = HUD::GetCoordValue(TeamScoreHUD, 3);
	%where = "left(ObjectiveHUD) top(ObjectiveHUD)-"@%height-1@" "@%width@" "@%height;

	if(HUD::Exists(TeamScoreHUD) && HUD::Exists(ObjectiveHUD))
		HUD::Move(TeamScoreHUD, %where);
}

// Attach or detach the attach function.
function TeamScoreHUD::AttachEnable(%flag)
{
	if(%flag)
	{
		Event::Attach(eventObjectiveHUDResize, "TeamScoreHUD::Attach();");
		TeamScoreHUD::Attach();
	}
	else
		Event::Detach(eventObjectiveHUDResize, "TeamScoreHUD::Attach();");
}

// Create a new HUD or move the existing one.
if(HUD::Exists(TeamScoreHUD))
{
	TeamScoreHUD::AttachEnable($CrunchyPref::AttachTeamScoreHUD);
	HUD::Update(TeamScoreHUD);
}
else
{
	HUD::NewFrame(TeamScoreHUD, TeamScoreHUD::Update, $CrunchyPref::TeamScoreHUDPos);
	TeamScoreHUD::Create();
	TeamScoreHUD::AttachEnable($CrunchyPref::AttachTeamScoreHUD);
	HUD::Display(TeamScoreHUD);
}

//
// New Opts
//

// Setup options page
function TeamScoreHUD::onOpen()
{
}

// Update preferences and HUD if needed.
function TeamScoreHUD::onClose()
{
	TeamScoreHUD::AttachEnable($CrunchyPref::AttachTeamScoreHUD);

	export("$CrunchyPref::*", "config\\CrunchyPrefs.cs", false);
}

// Register the options page.
NewOpts::register("TeamScore HUD",
				  "config\\Crunchy\\gui\\TeamScoreHUDoptions.gui",
				  "TeamScoreHUD::onOpen();",
				  "TeamScoreHUD::onClose();",
				  TRUE);
Include("Crunchy\\TeamScoreHUDHelp.cs");

} // Presto Pack check