// -- Target Flag -- v1.1 -----------------------------------------------------------------------------------
// Written by |HH|Crunchy (Jonathan Slark)
// Email: jonslark@barrysworld.co.uk
// Orginal idea taken from the PlanetStarseige forum.
//
// *** Requires Presto Pack 0.92 or later ***  http://www.planetstarsiege.com/presto/
// Install the script by putting it in you config dir and exec'ing it in your autoexec.cs.  Then make sure
// the bindings suit you in the Preferences section.
// eg:
//	exec("Presto\\Install.cs");
//	Include("TargetFlag.cs");
//
// When someone wips yer flag you can set your compass with one keypress, the same goes for your flag
// carrier if you want to escort him.  You can change back and forth between the two carriers as well.
// This could be automated but what if both flags are taken, and if you have a waypoint set  would you
// want it overidden?
//
//
// Changes in v1.1
//  + Added preferences for the key bindings.
//  + Added banner to main screen.
//
//
// -- Preferences --
//
// Target friendly carrier key binding (could be two words like "control m"):
$CrunchyPref::TargetFriendlyKey = "m";
//
// Target enemy carrier key binding:
$CrunchyPref::TargetEnemyKey = "n";
//

//
// -- Header --
//

Include("Presto\\TeamTrak.cs");

if ($Presto::version >= 0.93)
{
	Presto::AddScriptBanner(TargetFlag,
		" <f2>Target Flag <jr><f0>version 1.1 <jl>\n" @
		" \n" @
		" <f0>Target a flag carrier.\n" @
		" \n" @
		" <f1> Friendly <f0>is on <f1>"@$CrunchyPref::TargetFriendlyKey@"<f0>.\n" @
		" <f1> Enemy <f0>is on <f1>"@$CrunchyPref::TargetEnemyKey@"<f0>.\n" @
		" \n" @
		" <f0>Written by: <f1>|HH|Crunchy\n" @
		" <f1>jonslark@barrysworld.co.uk");
}

//
// -- Begin code --
//

function targetClientByName(%name, %msg)
{
	%clientId = getClientByName(%name);
	remoteEval(2048, "IssueTargCommand", 0, %msg, %clientID - 2048, getManagerId());
}

function TargetFlag::Taker(%friendly)
{
	if(%friendly)
	{
		%location = Team::GetFlagLocation(Team::Enemy());
		if(%location == $Trak::locationHome || %location == $Trak::locationField)
			return;

		targetClientByName(%location, "Escort the flag carrier " @ %location @ ".~wescfr");
	}
	else
	{
		%location = Team::GetFlagLocation(Team::Friendly());
		if(%location == $Trak::locationHome || %location == $Trak::locationField)
			return;

		targetClientByName(%location, "Kill the flag carrier " @ %location @ "!~wattway");
	}
}

bindKey(play, $CrunchyPref::TargetFriendlyKey, "TargetFlag::Taker(true);");
bindKey(play, $CrunchyPref::TargetEnemyKey, "TargetFlag::Taker(false);");
