// -- Events -- v1.1 ----------------------------------------------------------------------------------------
// Written by |HH|Crunchy (Jonathan Slark)
// Web page: http://www.planetstarsiege.com/crunchy/
// Email: crunchy@planetstarsiege.com
//
// New events:
//
//  eventClientTeamAdd(%team, %name)
//
//  	This event is triggered when a new team is added.  It returns the team number and the team name.  For
//		some reason the teams are one higher than they should be.  So, observers is team 0, team 0 is team 1, 
//		etc.
//
//	eventMissionInfo(%server, %missionName, %missionType)
//
//		This event is triggered during the loading process as soon as the mission information is
//		available to the client side.  The event returns the server ID, mission name and mission type.
//

//
// -- Event Triggers --
//

// Function override for event trigger on team added.
function onTeamAdd(%team, %name)
{
	echo("Team :" @ %team @", Name: " @ %name);
	Event::Trigger(eventClientTeamAdd, %team, %name);
}

// Overriden function from client.cs
// Called with mission information.
function remoteMInfo(%server, %missionName)
{
	echo("Server: ",%server);

	if(%server == 2048)
	{
		%file = "missions\\" @ %missionName @ ".dsc";
		$MDESC::Type = "";
		$MDESC::Text = "";
		if(File::findFirst(%file) != "")
			exec(%file);
		$ServerMission = %missionName;
		$ServerText = $MDESC::Text;
		$ServerMissionType = $MDESC::Type;
		if(isObject(LobbyGui))
			LobbyGui::onOpen();  // update lobby screen text.
	}

	Event::Trigger(eventMissionInfo, %server, %missionName, $ServerMissionType);
}
