// -- Item HUD -- v1.1 --------------------------------------------------------------------------------------
// Written by |HH|Crunchy (Jonathan Slark)
// Email: jonslark@barrysworld.co.uk
// Based on code from Presto's DynHUD.
//
// *** Requires Presto Pack 0.93 or later ***  http://www.planetstarsiege.com/presto/
// *** Requires Zear's NewOpts v0.9 or later *** http://www.cetisp.com/~thammock/scripts/
// Put the script in a directory name "Crunchy" in your tribes/config dir, along with the pictures, and 
// include it in your autoexec.cs.
// eg:
//	exec("Presto\\Install.cs");
//	Include("NewOpts\\Install.cs");
//	Include("Crunchy\\ItemHUD.cs");
//
// Displays mines, grenades, beacons and repair pack count.  Uses icons so the HUD is compact and easy to 
// read.  The icons are highlighted when that item is available, dull if not.  Designed to be used with my 
// other HUDs as a replacement for DynHUD.
//
//
// Changes in v1.1:
//	+ Added options page for NewOpts.
//
//
// -- Preferences --
//
// Set your options in the normal Tribes option menu.  Goto options then scripts.  From the pull down menu 
// select Item HUD.  From here you can set your options and preferences.
//

//
// -- Header --
//

if (!$Presto::installed || $Presto::version < 0.93) // Check presto pack is installed.
	echo("TeamSizeHUD: requires Presto Pack 0.93 or later.");
else {

function ItemHUD::SetDefaults()
{
	$CrunchyPref::ItemHUDPos = "0% 26% 40 56";
}
if(isFile("config\\CrunchyPrefs.cs"))
// Load last prefs off disk
	Include("CrunchyPrefs.cs");  // We only want this run once, a script might want to override.
else
	ItemHUD::SetDefaults();
if($CrunchyPref::ItemHUDPos == "")
	ItemHUD::SetDefaults();

Include("Presto\\Event.cs");
Include("Presto\\HUD.cs");
Include("Presto\\Inventory.cs");

Event::Attach(eventConnected, "HUD::Update(ItemHUD);");
Event::Attach(eventChangeMission, "HUD::Update(ItemHUD);");

//
// -- Begin code --
//

if(HUD::Exists(ItemHUD))
{
	HUD::Move(ItemHUD, $CrunchyPref::ItemHUDPos);
	HUD::Update(ItemHUD);
}
else
{
	HUD::New(ItemHUD, Item::UpdateHUD, $CrunchyPref::ItemHUDPos);
	HUD::Display(ItemHUD);
}

function Item::UpdateHUD()
{
	function iconFlag(%flag)
	{
		if(%flag)
			return "on";
		else
			return "DF";
	}

	%mines = getItemCount($Inv::Name[$Inv::Mine]);
	%grens = getItemCount($Inv::Name[$Inv::Grenade]);
	%beacons = getItemCount($Inv::Name[$Inv::Beacon]);
	%repair = getItemCount($Inv::Name[$Inv::Repair_Kit]);
	HUD::AddTextLine(ItemHUD,"<B2,4:Crunchy\\bmp\\small_mine_"@iconFlag(%mines)@".bmp><L4><f1>"@%mines);
	HUD::AddTextLine(ItemHUD,"<B-18,4:Crunchy\\bmp\\small_grens_"@iconFlag(%grens)@".bmp><L4><f1>"@%grens);
	HUD::AddTextLine(ItemHUD,
		"<B-18,4:Crunchy\\bmp\\small_beacon_"@iconFlag(%beacons)@".bmp><L4><f1>"@%beacons);
//************************
// Change by [RL]Prey[TOP]
        if (getItemCount($Inv::Name[$Inv::Repair_Kit]) > 0)
			HUD::AddTextLine(ItemHUD,"<B-18,4:Crunchy\\bmp\\small_repair_"@iconFlag(%repair)@".bmp><L4><f1>Y");
	else
			HUD::AddTextLine(ItemHUD,"<B-18,4:Crunchy\\bmp\\small_repair_"@iconFlag(%repair)@".bmp><L4><f1>N");
//************************
	return 1;
}

//
// NewOpts
//

function ItemHUD::onOpen()
{
	Control::setText("ItemHUD::editXPos", getWord($CrunchyPref::ItemHUDPos,0));
	Control::setText("ItemHUD::editYPos", getWord($CrunchyPref::ItemHUDPos,1));
	Control::setText("ItemHUD::editWidth", getWord($CrunchyPref::ItemHUDPos,2));
	Control::setText("ItemHUD::editHeight", getWord($CrunchyPref::ItemHUDPos,3));
}

function ItemHUD::onClose()
{
	$CrunchyPref::ItemHUDPos = Control::getText("ItemHUD::editXPos")@" "@
							   Control::getText("ItemHUD::editYPos")@" "@
							   Control::getText("ItemHUD::editWidth")@" "@
							   Control::getText("ItemHUD::editHeight");

	if(HUD::Exists(ItemHUD))
		HUD::Move(ItemHUD, $CrunchyPref::ItemHUDPos);

	export("$CrunchyPref::*", "config\\CrunchyPrefs.cs", false);
}

NewOpts::register("Item HUD",
				  "Crunchy\\gui\\ItemHUDoptions.gui",
				  "ItemHUD::onOpen();",
				  "ItemHUD::onClose();",
				  TRUE);
Include("Crunchy\\ItemHUDHelp.cs");


} // Presto Pack check