// -- Flag Response -- v1.3 ---------------------------------------------------------------------------------
// Written by |HH|Crunchy (Jonathan Slark)
// Email: jonslark@barrysworld.co.uk
//
// *** Requires Presto Pack 0.92 or later ***  http://www.planetstarsiege.com/presto/
// This script is automatic and needs no further installation other than being put in you config dir and
// exec'ing it in your autoexec.cs.
// eg:
//	exec("Presto\\Install.cs");
//	Include("FlagResponse.cs");
//
// Sends a message to your team when you have the flag and an optional global message when you cap. The
// two messages are in the first two functions, adjust to taste.  The message that you have got the
// enemy flag is only sent out after a certain amount of time and if in that time it wasn't dropped or
// capped.
//
// If like me you tend to miss flag messages the script can center print them for you.
//
// The cap message is chosen randomly from the list of cap messages in the header below, personalize
// these for yourself!
//
//
// Changes in v1.3
//  + Cap messages are added with a function and use the method from Presto's say.cs.
//  + Added banner to main screen (Presto Pack v0.93).
//  + Changed preference system to make it slightly easier.
//  + Added flood protect on flag take, can be useful.
//  = Fixed bug where centre prints would stay on screen, Thanks to Shaz for spotting that one :)
//
//
// -- Preferences --
//
// You can change the delay of announcing when you have the flag by the following line:
$CrunchyPref::FlagResponseWait = 4;
// This is set quite long so that if that flag is dropped or capped in that time the message is not sent.
//
// To get center printed messages on important flag events set the following preference to true.
$CrunchyPref::CenterPrintFlag = true;
//
// To adjust the length of time the center print stays on for, change this:
$CrunchyPref::CenterPrintLen = 5;
//
// If you want to celebrate when you cap then set this true:
$CrunchyPref::CapResponse = true;
//
// You can adjust the time delay in sending a message when you cap:
$CrunchyPref::CapResponseWait = 2.2;
// This delay is to avoid the response clashing with the flag cap sound which takes about 2 seconds.

//
// -- Header --
//

Include("Presto\\Events.cs");
Include("Presto\\TeamTrak.cs");
Include("Presto\\Say.cs");

$Auto::CapMsgNum = 0;  // Counter starts at zero, do not edit.
// Add Cap celebration messages below with this function.
// First argument is the chat message.
// Second argument is the optional overiding text.
function Auto::AddCapMsg(%say, %text)
{
	$Auto::CapSay[$Auto::CapMsgNum] = %say;
	$Auto::CapText[$Auto::CapMsgNum] = %text;
	$Auto::CapMsgNum++; // We've added a cap message.
}

// The cap celebration messages, edit to taste.  Uses Presto's say.cs method.
// These are the default boring ones, makes some interesing and unique ones for yourself :)
Auto::AddCapMsg(yellYeah);
Auto::AddCapMsg(yellWoohoo);
Auto::AddCapMsg(yellAllRight);

Event::Attach(eventFlagTaken, Auto::FlagTaken);
Event::Attach(eventFlagCaptured, Auto::FlagCaptured);
Event::Attach(eventFlagDropped, Auto::FlagDropped);

// Add banner on main screen.
if ($Presto::version >= 0.93)
{
	function EnableOption(%option)
	{
		if (%option)
			return "<f0> is <f1>enabled<f0>.";
		else
			return "<f0> is disabled.";
	}

	Presto::AddScriptBanner(FlagResponse,
		" <f2>Flag Response <jr><f0>version 1.3 <jl>\n" @
		"\n"@
		" <f1> CenterPrintFlag"@EnableOption($CrunchyPref::CenterPrintFlag)@"\n" @
		" <f1> CapResponse"@EnableOption($CrunchyPref::CapResponse)@"\n" @
		" <f1> CapMsgNum <f0>is <f1>"@$Auto::CapMsgNum@"<f0>.\n" @
		"\n"@
		"\n"@
		" <f0>Written by: <f1>|HH|Crunchy\n" @
		" <f1>jonslark@barrysworld.co.uk");
}

$Auto::Flood = 20;  // Seconds to protect flood for.

//
// -- Begin code --
//

// Triggered to announce you have flag
function Auto::AnnounceHave()
{
	if(!$Auto::FlagReset && Flood::Protect(HaveFlag, $Auto::Flood))
		Say::Team(flagHave, "I have the enemy flag.");
}

// Triggered to announce you have capped!
function Auto::AnnounceCap(%msg)
{
	if(%msg == "")
		%msg = floor(getRandom() * $Auto::CapMsgNum);
	Say::Public($Auto::CapSay[%msg], $Auto::CapText[%msg]);
}

function Auto::FlagTaken(%teamNum, %client)
{
	if(%client == getManagerID())
	{
		$Auto::FlagReset = false;
		schedule("Auto::AnnounceHave();",$CrunchyPref::FlagResponseWait);
	}
	else if($CrunchyPref::CenterPrintFlag)
	{
		if(%teamNum == Team::Friendly())
			remoteBP(2048,"<jc><f0>" @ Client::getName(%client) @ " took your flag!",
				   $CrunchyPref::CenterPrintLen);
		else
			remoteBP(2048,"<jc><f1>" @ Client::getName(%client) @ " took the enemy flag!",
				   $CrunchyPref::CenterPrintLen);
	}

}

function Auto::FlagCaptured(%teamNum, %client)
{
	if(%client == getManagerID() && $CrunchyPref::CapResponse) // Optional cap announce
		schedule("Auto::AnnounceCap();",$CrunchyPref::CapResponseWait);

	if(%teamNum == Team::Enemy())
		$Auto::FlagReset = true; // If the enemey flag was capped, don't anounce you have it :)
}

function Auto::FlagDropped(%teamNum, %client)
{
	if(%client != getManagerID() && $CrunchyPref::CenterPrintFlag)
	{
		if(%teamNum == Team::Friendly())
			remoteBP(2048,"<jc><f0>Your flag was dropped in the field!",
				   $CrunchyPref::CenterPrintLen);
		else
			remoteBP(2048,"<jc><f1>The enemies flag was dropped in the field!",
				   $CrunchyPref::CenterPrintLen);
	}

	if(%teamNum == Team::Enemy())
		$Auto::FlagReset = true; // If the enemey flag was dropped, don't anounce you have it :)
}
