// -- DropHUD -- v1.1 ----------------------------------------------------------------------------------------
// Written by |HH|Crunchy (Jonathan Slark)
// Web page: http://www.planetstarsiege.com/crunchy/
// Email: crunchy@planetstarsiege.com
// Original concept by |HH|Rico.
// Icons designed by |HH|Crunchy and |HH|Rico.  Do NOT use the icons without permission.
//
// The HUD displays an icon that represents the currently selected group.  A group contains items that will be 
// dropped when you press the drop group key.  You can move between the groups with the next and prev group 
// keys.  The HUD resets to the default group when you exit an invetory station.  The default groups are:
//
// Drop All
//   Drop all ammo
//   Repair kit
//   Mines
//   Grenades
//   Beacons
//
// Heavy Ammo
//   Grenade ammo
//   Mortar ammo
//
// Heavy Ammo+
//   Grenade ammo
//   Mortar ammo
//   Repair kit
//   Mines
//   Grenades
//   Beacons
//
// Single item groups:
//   Repair Kit
//   Mines
//   Grenades
//   Beacons
//   Bullets
//   Grenade Ammo
//   Mortar Ammo
//   Plasma Ammo
//
// Note: If you know what you are doing you could edit the groups at the bottom of this script.  The top group 
// is the default.
//
//
// Changes in v1.1:
//	+ Made Drop HUD same width as Item HUD so the HUDs stack neatly.
//	+ Optionally tells your team what you dropped.
//	+ You can only select a group for which you can drop at least one item.  eg: If you drop the repair kit 
//	  you will not be able to select the repair kit group again.
//	+ |HH|Rico redesigned some of the icons, they look really nice :).
//	+ Changed default group to DropAll, you don't start off with heavy ammo.
//

//
// -- Header --
//

Include("Presto\\HUD.cs");
Include("Presto\\Say.cs");
if(isFile("config\\Presto\\Schedule.cs")) Include("Presto\\Schedule.cs");
else {
    function Schedule::Add(%eval, %time, %tag) {
    	if (%tag == "")
    		%tag = %eval;	// Use function as tag if none provided.
    	$Schedule::ID[%tag]++;
    	$Schedule::eval[%tag] = %eval;
    	schedule("Schedule::Exec(\""@escapestring(%tag)@"\", "@$Schedule::ID[%tag]@");", %time);
    	}
    function Schedule::Exec(%tag, %id) {
    	if ($Schedule::ID[%tag] != %id)
    		return;
    	%eval = $Schedule::eval[%tag];
    	Schedule::Cancel(%tag);
    	eval(%eval);
    	}
    function Schedule::Cancel(%tag) {
    	$Schedule::ID[%tag]++;
    	$Schedule::eval[%tag] = "";
    	}
	}
Include("Writer\\inventory_table.cs");
Include("Writer\\station_events.cs");
if(isFile("config\\Crunchy\\Say.cs")) Include("Crunchy\\Say.cs");
else Say::New(sayGeneric, "", "");

Event::Attach(eventExitInventoryStation, "DropHUD::onExitInv();");

$DropHUD::DefaultGroup = $DropHUD::CurrentGroup = 1;

function DropHUD::SetDefaults() {
	$CrunchyPref::DropHUDPos = "100% 50% 40 24";
	$CrunchyPref::DropHUD::Announce = true;
	}
if(isFile("config\\CrunchyPrefs.cs")) {
	Include("CrunchyPrefs.cs");
	if($CrunchyPref::DropHUD::Announce == "" || getword($CrunchyPref::DropHUDPos,2) == "32")
		DropHUD::SetDefaults();
	}
else DropHUD::SetDefaults();

//
// -- Begin code --
//

$DropHUD::GroupNum = 0;
function DropHUD::NewGroup(%group, %bmp) {
	%i = $DropHUD::GroupNum++;
	$DropHUD::Group[%i, num] = 0;
	$DropHUD::Group[%i, bmp] = %bmp;
	$DropHUD::Group[%group] = %i;
	}
function DropHUD::AddItem(%group, %item) {
	%i = $DropHUD::Group[%group];
	%n = $DropHUD::Group[%i, num]++;
	$DropHUD::Group[%i, %n] = %item;
	}

// Method for this comes from Writer's drop unecessary ammo code :)
function DropHUD::DropAllAmmo() {
    for(%itemtype = 100; %itemtype > 0; %itemtype--) {
        if((%ammo = $Inv::Ammo[%itemtype]) != "" ) {
			if(getItemCount(%ammo)) {
				for(%i = 0; %i < 20; %i++)
					drop(%ammo);
				}
			}
		}
	}
function DropHUD::DropAll(%item) {
	%item = $Inv::Name[%item];

	if(getItemCount(%item)) {
		for(%i = 0; %i < 20; %i++)
			drop(%item);
		}
	}
function DropHUD::DropItem(%item) {
	if(%item == DropAll) {
		DropHUD::DropAllAmmo();
		DropHUD::DropAll($Inv::Grenade);
		DropHUD::DropAll($Inv::Mine);
		DropHUD::DropAll($Inv::Repair_Kit);
		DropHUD::DropAll($Inv::Beacon);
		}
	else	
		DropHUD::DropAll(%item);
	}
function DropHUD::DropGroup(%i) {
	for(%n = 1; %n <= $DropHUD::Group[%i, num]; %n++) {
		%item = $DropHUD::Group[%i, %n];
		if(%item == DropAll) {
			%list = "All Ammo";
			if(getItemCount($Inv::Name[$Inv::Mine])) %list = %list@", Mine";
			if(getItemCount($Inv::Name[$Inv::Grenade])) %list = %list@", Grenade";
			if(getItemCount($Inv::Name[$Inv::Repair_Kit])) %list = %list@", Repair Kit";
			if(getItemCount($Inv::Name[$Inv::Beacon])) %list = %list@", Beacon";
			}
		else if(eval("getItemCount($Inv::Name["@%item@"]);")) {
			if(%list != "")	%list = %list@", ";
			eval("%list = %list@$Inv::Name["@%item@"];");
			}
		eval("DropHUD::DropItem("@%item@");");
		}

	if($CrunchyPref::DropHUD::Announce && Flood::Protect("DropHUD::"@%i, 20))
		Say::Team(sayGeneric, "Dropped: "@%list);
	if(%item != DropAll) Schedule::Add("DropHUD::Cycle(1);",1);
	}

function DropHUD::VerifyGroup(%i) {
	%have = false;
	for(%n = 1; %n <= $DropHUD::Group[%i, num]; %n++) {
		%item = $DropHUD::Group[%i, %n];
		if(%item == DropAll) return true;
		%have = %have || eval("getItemCount($Inv::Name["@%item@"]);");
		}
	return %have;
	}

function DropHUD::onExitInv() {
	$DropHUD::CurrentGroup = $DropHUD::DefaultGroup;
	HUD::Update(DropHUD);
	}
function DropHUD::Cycle(%delta) {
	$DropHUD::CurrentGroup += %delta;
	if($DropHUD::CurrentGroup > $DropHUD::GroupNum) $DropHUD::CurrentGroup = 1;
	if($DropHUD::CurrentGroup < 1) $DropHUD::CurrentGroup = $DropHUD::GroupNum;
	while(!DropHUD::VerifyGroup($DropHUD::CurrentGroup)) {
		$DropHUD::CurrentGroup += %delta;
		if($DropHUD::CurrentGroup > $DropHUD::GroupNum) $DropHUD::CurrentGroup = 1;
		if($DropHUD::CurrentGroup < 1) $DropHUD::CurrentGroup = $DropHUD::GroupNum;
		}

	HUD::Update(DropHUD);
	}
function DropHUD::Update() {
	%bmp = "<B3,4:"@$DropHUD::Group[$DropHUD::CurrentGroup, bmp]@".bmp>";
	HUD::AddTextLine(DropHUD, %bmp);

	return 0;
	}

if(HUD::Exists(DropHUD)) HUD::Update(DropHUD);
else {
	HUD::New(DropHUD, DropHUD::Update, $CrunchyPref::DropHUDPos);
	HUD::Display(DropHUD);
	}

//
// NewOpts
//

// Setup options page
function DropHUD::onOpen() {
	}

// Update preferences and HUD if needed.
function DropHUD::onClose() {
	export("$CrunchyPref::*", "config\\CrunchyPrefs.cs", false);
	}

// Options page for Zear's NewOpts
NewOpts::register("Drop HUD",
				  "Crunchy\\gui\\DropHUDoptions.gui",
				  "DropHUD::onOpen();",
				  "DropHUD::onClose();",
				  TRUE);
Include("Crunchy\\DropHUDHelp.cs");

//
// Group definitions
//

DropHUD::NewGroup(drop_all, "Crunchy\\bmp\\drop_all");
DropHUD::AddItem(drop_all, "DropAll");

DropHUD::NewGroup(heavy_ammo, "Crunchy\\bmp\\heavy_ammo");
DropHUD::AddItem(heavy_ammo, "$Inv::Grenade_Ammo");
DropHUD::AddItem(heavy_ammo, "$Inv::Mortar_Ammo");

DropHUD::NewGroup(heavy_ammo2, "Crunchy\\bmp\\heavy_ammo_plus");
DropHUD::AddItem(heavy_ammo2, "$Inv::Grenade_Ammo");
DropHUD::AddItem(heavy_ammo2, "$Inv::Mortar_Ammo");
DropHUD::AddItem(heavy_ammo2, "$Inv::Repair_Kit");
DropHUD::AddItem(heavy_ammo2, "$Inv::Grenade");
DropHUD::AddItem(heavy_ammo2, "$Inv::Mine");
DropHUD::AddItem(heavy_ammo2, "$Inv::Beacon");

DropHUD::NewGroup(mines, "Crunchy\\bmp\\repair_kit");
DropHUD::AddItem(mines, "$Inv::Repair_Kit");

DropHUD::NewGroup(mines, "Crunchy\\bmp\\mines");
DropHUD::AddItem(mines, "$Inv::Mine");

DropHUD::NewGroup(grenades, "Crunchy\\bmp\\grenades");
DropHUD::AddItem(grenades, "$Inv::Grenade");

DropHUD::NewGroup(beacons, "Crunchy\\bmp\\beacons");
DropHUD::AddItem(beacons, "$Inv::Beacon");

DropHUD::NewGroup(bullets, "Crunchy\\bmp\\bullets");
DropHUD::AddItem(bullets, "$Inv::Bullet");

DropHUD::NewGroup(grenade_ammo, "Crunchy\\bmp\\grenade_ammo");
DropHUD::AddItem(grenade_ammo, "$Inv::Grenade_Ammo");

DropHUD::NewGroup(mortar_ammo, "Crunchy\\bmp\\mortar_ammo");
DropHUD::AddItem(mortar_ammo, "$Inv::Mortar_Ammo");

DropHUD::NewGroup(plasma_ammo, "Crunchy\\bmp\\plasma_ammo");
DropHUD::AddItem(plasma_ammo, "$Inv::Plasma_Bolt");
