// !!!!!!!!!!! mHUD 4.0b -> 'Smart' Reticle / Rangefinder <- 5/7/99 !!!!!!!!!!!
// 
// By:
//    Cowboy
//    cowboy@planetstarsiege.com
//    http://www.planetstarsiege.com/cowboy/
//    ICQ# 31184463
// 
//    Lots of help, code, and reticles from GrymReaper - Kick ass!
//
// Features (newest changes first):
//
// * Bound 'alt-f12' to toggle Debug Mode, will echo to the console everything
//   that mHUD does, for troubleshooting or curiosity :)
// * Bound 'alt-q' to force the Mortar rangefinder on, use it if you're at a
//   commander station and using a Mortar Turret! (stays on until you change
//   Gui modes or change weapons)
// * I rebind the 1st/3rd person toggle key (default 'r') so that it'll turn
//   off the mHUD display when you are in 3rd person mode
// * Reticles are now 'overlays' and ADD to the default cursor! use your own
//   personal favorite default (or use mine) and any cursor you make ADDS to
//   your existing one! (if you want, you can set it up the old way, but I'm
//   not going to provide support for that anymore)
// * Different reticles possible for each base weapon, including definitions
//   for any mod weapons you want to add (I also did one for 'Repair Gun'!)
// * Supports resize-on-the-fly! (uses Presto's functions)
// * All reticle sizes are now 63 pixels wide! It turns out that larger sizes
//   would overlap CmdHUD commander and inventory panels! That's no good!
// * Supports different Mortar & Grenade Launcher rangefinders for each major
//   resolution (I did 800x600 and Presto did 640x480 - but if you want to make
//   one for the resolution YOU use, email it to me and I'll include it!)
//
// Requires PrestoHUD 0.93+ and fully compatible with CmdHUD 1.0+
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// 
// Installation notes:
// 
// Unzip h_reticle.bmp into the tribes\base directory, unzip all other files
// into \config\cowboy directory, and add line: Include("cowboy\\mHUD.cs"); to
// your autoexec.cs file somewhere AFTER the exec("presto\\install.cs"); line.
//
// mHUD.gui now goes in the config\cowboy directoy (duh!)
// 
// NOTE: This replaces the built-in crosshairs, and will overwrite your
//       crosshairs, so make a backup! I suggest trying my h_reticle.bmp first
//       to see how it works, although  you _can_ use your own h_reticle.bmp!
//
// This now supports resizing, although there are only correct rangefinder
// bitmaps for 640x480 and 800x600! If you want to create an _accurate_ one
// for a different resolution, do it up and mail it to me! If i use it here,
// you'll get the credit!
//
// Same goes for reticles! I have only got a few done.. If you can come up
// with better ones, send 'em over!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// 
// (c) 1999 Cowboy, whatever... I hope you enjoy this, and all that I ask is 
// that you give me and GymReaper props for it.. enjoy!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

Include("presto\\Event.cs");
Include("presto\\Inventory.cs");

//
// User settings:
//
// $mHUD::UpdateTime: how often we check for switching weapon status 
// $mHUD::InitInvTime: how long to wait before inventory station first loads
//
// you probably won't need to change these.. but if you do, here they are!

$mHUD::UpdateTime = 0.3;
$mHUD::InitInvTime = 0.5;

//
// this is the key that changes 1st/3rd person view mode
//
EditActionMap("playMap.sae");
bindCommand(keyboard0, make, "r", TO, "mHUD::ToggleView();");

//
// this toggles 'forcing' the Mortar reticle/rangefinder
//
bindCommand(keyboard0, make, alt, "q", TO, "mHUD::ForceMortarToggle();");

//
// This key toggles debug mode, showing everything that happens echoed to
// the console. If you want to see how mHUD does its thing, press alt-f12
// (debug mode off by default)
//
EditActionMap("actionMap.sae");
bindCommand(keyboard0, make, alt, "f12", TO, "$mHUD::DebugMode = !$mHUD::DebugMode;");
$mHUD::DebugMode = false;

// need to define this here to allow adding weapons!
function mHUD::AddWeapon(%Weapon, %Reticle, %RangeFinder) {
	$mHUD::Reticle[%Weapon] = %Reticle;
	$mHUD::RangeFinder[%Weapon] = %RangeFinder;
	}

//
// Define weapon types!
//
// mHUD::AddWeapon("Weapon Name", ReticleBmp, RangeFinderBmp);
//
// notice that the rangefinder bitmap ends in "_" because it's required that
// each rangefinder exist for all available resolutions. (for accuracy)
//
// for "cowboy\\mHUD_rangefinder_Mortar_", these files exist:
//
//    cowboy\\mHUD_rangefinder_Mortar_unknown.bmp
//    cowboy\\mHUD_rangefinder_Mortar_640.bmp
//    cowboy\\mHUD_rangefinder_Mortar_800.bmp
//    cowboy\\mHUD_rangefinder_Mortar_1024.bmp
//
// if a weapon doesn't need either a Reticle or RangeFinder, use a "".
// (see my examples below!)
//
// if you add your own, keep in mind you have to also add the bitmap in the
// 'ADD TAGS' section (below)

mHUD::AddWeapon("Repair Gun", "cowboy\\mHUD_reticle_Repairgun.bmp", "");
mHUD::AddWeapon("Chaingun", "cowboy\\mHUD_reticle_Chaingun.bmp", "");
mHUD::AddWeapon("Grenade Launcher", "", "cowboy\\mHUD_rangefinder_Grenade_");
mHUD::AddWeapon("Laser Rifle", "cowboy\\mHUD_reticle_Laser.bmp", "");
mHUD::AddWeapon("Mortar", "", "cowboy\\mHUD_rangefinder_Mortar_");

//
// ADD TAGS, hopefully these id #'s will never be used by anyone else!
//

//repair gun
IDBMP_MHUD_RETICLE_REPAIR	= 00160950, "cowboy\\mHUD_reticle_Repairgun.bmp";

//base weapons
IDBMP_MHUD_RETICLE_BLASTER 	= 00160951, ""; 
IDBMP_MHUD_RETICLE_PLASMA 	= 00160952, ""; 
IDBMP_MHUD_RETICLE_CHAINGUN	= 00160953, "cowboy\\mHUD_reticle_Chaingun.bmp"; 
IDBMP_MHUD_RETICLE_DISC 	= 00160954, ""; 
IDBMP_MHUD_RETICLE_GRENADE 	= 00160955, "";
IDBMP_MHUD_RETICLE_LASER 	= 00160956, "cowboy\\mHUD_reticle_Laser.bmp"; 
IDBMP_MHUD_RETICLE_ELF 		= 00160957, ""; 
IDBMP_MHUD_RETICLE_MORTAR 	= 00160958, ""; 
IDBMP_MHUD_RETICLE_TARGET 	= 00160959, ""; 

//mod weapons
IDBMP_MHUD_RETICLE_M_0		= 00160960, "";
IDBMP_MHUD_RETICLE_M_1		= 00160961, "";
IDBMP_MHUD_RETICLE_M_2		= 00160962, "";
IDBMP_MHUD_RETICLE_M_3		= 00160963, "";
IDBMP_MHUD_RETICLE_M_4		= 00160964, "";
IDBMP_MHUD_RETICLE_M_5		= 00160965, "";
IDBMP_MHUD_RETICLE_M_6		= 00160966, "";
IDBMP_MHUD_RETICLE_M_7		= 00160967, "";
IDBMP_MHUD_RETICLE_M_8		= 00160968, "";
IDBMP_MHUD_RETICLE_M_9		= 00160969, "";

//mortar rangefinder
IDBMP_MHUD_R000_MORTAR 		= 00160970, "cowboy\\mHUD_rangefinder_Mortar_unknown.bmp";
IDBMP_MHUD_R640_MORTAR		= 00160971, "cowboy\\mHUD_rangefinder_Mortar_640.bmp";
IDBMP_MHUD_R800_MORTAR		= 00160972, "cowboy\\mHUD_rangefinder_Mortar_800.bmp";
IDBMP_MHUD_R1024_MORTAR		= 00160973, "cowboy\\mHUD_rangefinder_Mortar_1024.bmp";

//grenade rangefinder
IDBMP_MHUD_R000_GRENADE		= 00160974, "cowboy\\mHUD_rangefinder_Grenade_unknown.bmp";
IDBMP_MHUD_R640_GRENADE		= 00160975, "cowboy\\mHUD_rangefinder_Grenade_640.bmp";
IDBMP_MHUD_R800_GRENADE		= 00160976, "cowboy\\mHUD_rangefinder_Grenade_800.bmp";
IDBMP_MHUD_R1024_GRENADE	= 00160977, "cowboy\\mHUD_rangefinder_Grenade_1024.bmp";

//mod rangefinder
IDBMP_MHUD_RMISC_0		= 00160978, "";
IDBMP_MHUD_RMISC_1		= 00160979, "";
IDBMP_MHUD_RMISC_2		= 00160980, "";
IDBMP_MHUD_RMISC_3		= 00160981, "";

//mod rangefinder
IDBMP_MHUD_RMISC_4		= 00160982, "";
IDBMP_MHUD_RMISC_5		= 00160983, "";
IDBMP_MHUD_RMISC_6		= 00160984, "";
IDBMP_MHUD_RMISC_7		= 00160985, "";

//mod rangefinder
IDBMP_MHUD_RMISC_8		= 00160986, "";
IDBMP_MHUD_RMISC_9		= 00160987, "";
IDBMP_MHUD_RMISC_10		= 00160988, "";
IDBMP_MHUD_RMISC_11		= 00160989, "";

//
// For Presto Pack 0.93+, this displays script info in a box on the main
// menu screen, kind of an 'Advertisement/Info Box' for installed scripts.
//

if ($Presto::version >= 0.93) {
	Presto::AddScriptBanner(mHUD,
		"<jc><f2>mHUD 4.0b <f1>by <f2>Cowboy\n" @
		"<f1>'Smart' Reticle / Rangefinder\n" @
		"\n" @
		"<f0>Read the readme for <f1>Key\n"@
		"Bindings <f0>and <f1>New Features!\n" @
		"<f2>Now with Reticle Overlays!\n" @
		"\n" @
		"<f1>Released 5/7/99 by Cowboy\n" @
		"<f0>with thanks to GrymReaper");
	}

//
// This constantly runs and checks to see if which weapon is loaded
//
// 'Safe' scheduling code from Presto! thanks!
//
function scheduled_mHUD::Timer(%id) {
   if (%id != $mHUD_scheduled_id)
      return;
   mHUD::Timer();
   schedule("scheduled_MHUD::Timer("@$mHUD_scheduled_id@");", $mHUD::UpdateTime);
   }
 
function schedule_mHUD::Timer() {
   $mHUD_scheduled_id++;
   schedule("scheduled_mHUD::Timer("@$mHUD_scheduled_id@");", $mHUD::UpdateTime);
   }
 
Event::Attach(eventConnected, schedule_MHUD::Timer);
 
function mHUD::Timer() {
		if ($mHUD::LastResolution != Presto::ScreenSize())
		mHUD::UpdateResolution();

	if (!$mHUD::Initialized && getMountedItem(0) != -1) {
		$mHUD::Initialized = true;
		mHUD::Init();
		}

	if ($mHUD::ForceMortar == $mHUD::ForceMortarOn)
		mHUD::UpdateReticle();
	
	if ($Inv::Name[getMountedItem(0)] != $mHUD::LastWeapon || $mHUD::ToggleViewState != $mHUD::LastToggleViewState) {
		mHUD::ForceMortarToggle(false);
		mHUD::UpdateReticle();
		}

	if (included("cowboy\\CmdHUD.cs") && $CmdHUD::guiMode == 2 && $mHUD::CurrentGui == CommandGui) {
		if ($CmdHUD::MapState && !$mHUD::CmdHUD::ReticleState ) {
			$mHUD::CmdHUD::ReticleState = true;
			mHUD::SetVisible(RangeFinder, $mHUD::CmdHUD::ReticleState);
			mHUD::SetVisible(Reticle, $mHUD::CmdHUD::ReticleState);
			}
		else if (!$CmdHUD::MapState && $mHUD::CmdHUD::ReticleState) {
			$mHUD::CmdHUD::ReticleState = false;
			mHUD::SetVisible(RangeFinder, $mHUD::CmdHUD::ReticleState);
			mHUD::SetVisible(Reticle, $mHUD::CmdHUD::ReticleState);
			}
		}
	}

function mHUD::UpdateResolution() {
	$mHUD::LastResolution = Presto::ScreenSize();
	$mHUD::X = getWord($mHUD::LastResolution, 0);
	$mHUD::Y = getWord($mHUD::LastResolution, 1);

	if ($mHUD::DebugMode) echo($mHUD::X @ ", " @ $mHUD::Y);
	
	if ($mHUD::X == 640)
		$mHUD::resX = "640";
	else if ($mHUD::X == 800)
		$mHUD::resX = "800";
	else if ($mHUD::X == 1024)
		$mHUD::resX = "1024";
	else
		$mHUD::resX = "unknown";
	}
	
function mHUD::UpdateReticle() {
	%wpnItem = getMountedItem(0);
	%wpnName = $Inv::Name[%wpnItem];

	if ($mHUD::ForceMortar)
		%wpnName = "Mortar";

	if (%wpnItem != -1 || $mHUD::ForceMortar) {
		if ($mHUD::Reticle[%wpnName] != "") {
			$mHUD::CurrentReticle = $mHUD::Reticle[%wpnName];
			$mHUD::ReticleVisible = true;
			}
		else
			$mHUD::ReticleVisible = false;

		if ($mHUD::RangeFinder[%wpnName] != "") {
			$mHUD::CurrentRangeFinder = $mHUD::RangeFinder[%wpnName];
			$mHUD::RangeFinderVisible = true;
			}
		else
			$mHUD::RangeFinderVisible = false;
		}
	if (%wpnItem == -1 || ($mHUD::Reticle[%wpnName] == "" && $mHUD::RangeFinder[%wpnName] == "")) {
		if (!$mHUD::ForceMortar) {
			$mHUD::ReticleVisible = false;
			$mHUD::RangeFinderVisible = false;
			}
		}
	if (!$mHUD::ForceMortar)
		$mHUD::LastWeapon = %wpnName;

	$mHUD::ForceMortarOn = !$mHUD::ForceMortarOn;
	$mHUD::LastToggleViewState = $mHUD::ToggleViewState;
	
	if ($mHUD::DebugMode) echo("Current Weapon: " @ %wpnName @ ", " @ %wpnItem);
	
	mHUD::LoadBitmaps();
	}

function mHUD::LoadBitmaps() {
	$mHUD::CmdHUD::ReticleState = true;
	
	if ($mHUD::ToggleViewState && $mHUD::CurrentGui == CommandGui) {
		mHUD::SetVisible(Reticle, false);
		mHUD::SetVisible(RangeFinder, false);
		}
	else {
		mHUD::SetVisible(Reticle, $mHUD::ReticleVisible);
		mHUD::SetVisible(RangeFinder, $mHUD::RangeFinderVisible);
		}
	
	mHUD::SetValue(Reticle, $mHUD::CurrentReticle);
	mHUD::SetValue(RangeFinder, $mHUD::CurrentRangeFinder @ $mHUD::resX @ ".bmp");
	}

function mHUD::SetVisible(%object, %state) {
	Control::SetVisible("mHUD::Frame::" @ %object @ "::" @ $mHUD::Counter, %state);
	if ($mHUD::DebugMode) echo("SetVisible: mHUD::Frame::" @ %object @ "::" @ $mHUD::Counter @ ", "@ %state);
	}

function mHUD::SetValue(%object, %value) {
	if (%object == Reticle && !$mHUD::ReticleVisible) return;
	else if (%object == RangeFinder && !$mHUD::RangeFinderVisible) return;
	else if ($mHUD::ToggleViewState && $mHUD::CurrentGui == CommandGui) return;
	
	Control::SetValue("mHUD::Frame::" @ %object @ "::" @ $mHUD::Counter, "<B" @ %value @ ">");
	if ($mHUD::DebugMode) echo("SetValue: mHUD::Frame::" @ %object @ "::" @ $mHUD::Counter @ ", <B" @ %value @ ">");
	}

function mHUD::CreateRangeFinder(%gui) {
	%var = newobject("mHUD::Frame::RangeFinder::" @ $mHUD::Counter, FearGuiFormattedText, $mHUD::X / 2 - 35, $mHUD::Y / 2 + 35, 63, 255);
	addToSet(%gui, %var);
	if ($mHUD::DebugMode) echo("mHUD::Frame::RangeFinder::" @ $mHUD::Counter @ " Created in " @ %gui);
	return %var;
	}

function mHUD::CreateReticle(%gui) {
	%var = newobject("mHUD::Frame::Reticle::" @ $mHUD::Counter, FearGuiFormattedText, $mHUD::X / 2 - 35, $mHUD::Y / 2 - 31, 63, 63);
	addToSet(%gui, %var);
	if ($mHUD::DebugMode) echo("mHUD::Frame::Reticle::" @ $mHUD::Counter @ " Created in " @ %gui);
	return %var;
	}

function mHUD::DeleteRangeFinder(%gui, %var) {
	removeFromSet(%gui, %var);
	if ($mHUD::DebugMode) echo("mHUD::Frame::RangeFinder::" @ $mHUD::Counter @ " Deleted from " @ %gui);
	return %var;
	}

function mHUD::DeleteReticle(%gui, %var) {
	removeFromSet(%gui, %var);
	if ($mHUD::DebugMode) echo("mHUD::Frame::Reticle::" @ $mHUD::Counter @ " Deleted from " @ %gui);
	return %var;
	}
	
//
// Initialize the objects: load the gui, get the IDs, move stuff around
//
function mHUD::Init() {
	guiPushDialog(MainWindow, "cowboy\\mHUD.gui");
	guiPopDialog(MainWindow, "cowboy\\mHUD.gui");

	Event::Attach(eventConnected, mHUD::Reset);
	Event::Attach(eventChangeMission, mHUD::Reset);
	if ($mHUD::DebugMode) echo("mHUD Initialized");

	if (!included("cowboy\\CmdHUD.cs")) {
		$mHUD::Counter++;
		$mHUD::RangeFinderFrame = mHUD::CreateRangeFinder(playGui);
		$mHUD::ReticleFrame = mHUD::CreateReticle(playGui);
		mHUD::LoadBitmaps();
		}
	}

//
// Detect what gui you are in, if you use CmdHUD
//
function mHUD::GuiOpen(%gui) {
	$mHUD::CurrentGui = %gui;
	if ($mHUD::DebugMode) echo("GuiOpen: " @ %gui);
	if (included("cowboy\\CmdHUD.cs")) {
 		if (%gui == "playGui" || %gui == "CommandGui" || %gui == "CmdInventoryGui") {
			$mHUD::Counter++;
			$mHUD::RangeFinderFrame = mHUD::CreateRangeFinder(%gui);
			$mHUD::ReticleFrame = mHUD::CreateReticle(%gui);
			mHUD::LoadBitmaps();
			}
		}
	}

//
// Detect what gui you just left, if you use CmdHUD
//
function mHUD::GuiClose(%gui) {
	if ($mHUD::DebugMode) echo("GuiClose: " @ %gui);
	if (included("cowboy\\CmdHUD.cs")) {
		mHUD::DeleteRangeFinder(%gui, $mHUD::RangeFinderFrame);
		mHUD::DeleteReticle(%gui, $mHUD::ReticleFrame);
		}
	mHUD::ForceMortarToggle(false);
	}

//
// toggle 1st person/3rd person views
//
function mHUD::ToggleView() {
	$mHUD::ToggleViewState = !$mHUD::ToggleViewState;
	postAction(2048, IDACTION_VIEW, 1);
	if ($mHUD::DebugMode) echo("View State: " @ $mHUD::ToggleViewState);
	}
	
function mHUD::ForceMortarToggle(%state) {
	if (%state == "")
		$mHUD::ForceMortar = !$mHUD::ForceMortar;
	else
		$mHUD::ForceMortar = (%state && $mHUD::ForceMortar);
		
	$mHUD::ForceMortarOn = $mHUD::ForceMortar;
	
	if ($mHUD::DebugMode) echo("Force Mortar Toggle: " @ $mHUD::ForceMortar);
	}

//
// Reset all objects and variables
//
function mHUD::Reset() {
	$mHUD::LastWeapon = "";
	$mHUD::ForceMortar = false;
	$mHUD::ForceMortarOn = false;
	if ($mHUD::DebugMode) echo("mHUD Reset");
	}

function mHUD::InitViewState() {
	$mHUD::ToggleViewState = false;
	}

$mHUD::Counter = 0;
$mHUD::Initialized = false;
$mHUD::InventoryInitialized = false;

Event::Attach(eventConnected, mHUD::Timer);
Event::Attach(eventConnected, mHUD::InitViewState);

Event::Attach(eventGuiOpen, mHUD::GuiOpen);
Event::Attach(eventGuiClose, mHUD::GuiClose);
