// !!!!!!!!!!!! mHUD 2.0 -> Enhanced Mortar Rangefinder! <- 5/5/99 !!!!!!!!!!!!
// 
// By:
//    Cowboy
//    cowboy@planetstarsiege.com
//    http://www.planetstarsiege.com/cowboy/
//    ICQ# 31184463
// 
//    Lots of help, code, and reticles from GrymReaper - Kick ass!
//
// Pretty self-explanatory.. This creates an transparent-rangefinder bitmap
// that gets displayed ONLY if your current weapon is the Mortar. I plan on
// adding in a grenade launcher bitmap option, as well as breaking the 800x600
// resolution barrier.. 
//
// Requires PrestoHUD 0.93+ and fully compatible with CmdHUD 1.0+
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// 
// Installation notes:
// 
// Unzip mHUD.gui into the tribes\gui directory. If this directory doesn't
// exist, create it! Unzip h_reticle.bmp into the tribes\base directory, and
// unzip all other files into \config\cowboy directory and add line: 
// Include("cowboy\\mHUD.cs"); to your autoexec.cs file somewhere AFTER the
// exec("presto\\install.cs"); line.
// 
// NOTE: This replaces the built-in crosshairs, and will overwrite your
//       crosshairs, so make a backup!
//
// You will see variables below where you can define your screen size. Note
// that while the Reticle and Rangefinder appear in the correct spots, the
// Rangefinder is only to scale at 800x600! If you want to edit the bitmaps
// mHUD_rangefinder_Mortar.bmp and mHUD_rangefinder_Grenade.bmp for your
// particular resolution (640x480 or 1024x768), PLEASE DO SO! If you get them
// working and accurate, and they fit in to the 'look' here, email them to me
// and I'll include them (and give you credit, of course)
//
// This does NOT support resizing-on-the-fly.. but, who cares?
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// 
// (c) 1999 Cowboy, whatever... I hope you enjoy this, and all that I ask is 
// that you give me and GymReaper props for it.. enjoy!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

Include("presto\\Event.cs");
Include("presto\\Inventory.cs");

//
// User settings:
//
// $mHUD::UpdateTime: how often we check for Mortar weapon status 
// $mHUD::InitInvTime: how long to wait before inventory station first loads
//
// you probably won't need to change these.. but if you do, here they are!

$mHUD::UpdateTime = 0.3;
$mHUD::InitInvTime = 0.5;

// Set your screen resolution here! (will not support 'resizing-on-the-fly'!)
//
// note - I haven't created mortar / grenade rangefinders in res other than
//        800x600 yet, so they will only be to scale in 800x600!
//
//        If you want to create ones for 1024x768 and 640x480, do them up and
//        send them to me! I'll give you credit and include them if they're
//        good! Keep in mind that the maximum height is 255 pixels!

$mHUD::X = 800;	// Screen Width
$mHUD::Y = 600;	// Screen Height

//
// For Presto Pack 0.93+, this displays script info in a box on the main
// menu screen, kind of an 'Advertisement/Info Box' for installed scripts.
//

if ($Presto::version >= 0.93) {
	Presto::AddScriptBanner(mHUD,
		"<jc><f2>mHUD 2.0 <f1>by <f2>Cowboy\n" @
		"<f1>'Smart' Reticle / Rangefinder\n" @
		"\n" @
		"<f0>Resolution set to: <f1>" @ $mHUD::X @"x"@ $mHUD::Y @ "\n" @
		"<f0>Thanks to <f1>GrymReaper<f0> for his\n"@
		"code and reticles! <f1>Awesome!\n" @
		"\n" @
		"<f1>Released 5/5/99 by Cowboy\n" @
		"cowboy@planetstarsiege.com");
	}
//
// add tag, hopefully these id #'s will never be used!
//
IDBMP_MHUD_RANGE_MORTAR 	= 00160950, "cowboy\\mHUD_rangefinder_Mortar.bmp"; 
IDBMP_MHUD_RANGE_GRENADE 	= 00160951, "cowboy\\mHUD_rangefinder_Grenade.bmp"; 

IDBMP_MHUD_RETICLE_STANDARD 	= 00160952, "cowboy\\mHUD_reticle_Default.bmp"; 
IDBMP_MHUD_RETICLE_LASER 	= 00160953, "cowboy\\mHUD_reticle_Laser.bmp"; 
IDBMP_MHUD_RETICLE_CHAINGUN	= 00160954, "cowboy\\mHUD_reticle_Chaingun.bmp"; 

$mHUD::Mortar::RangeFinder = "<B0,0:cowboy\\mHUD_rangefinder_Mortar.bmp>";
$mHUD::Grenade::RangeFinder = "<B0,0:cowboy\\mHUD_rangefinder_Grenade.bmp>";

$mHUD::Reticle::Standard = "<B0,0:cowboy\\mHUD_reticle_Default.bmp>";
$mHUD::Reticle::Laser = "<B0,0:cowboy\\mHUD_reticle_Laser.bmp>";
$mHUD::Reticle::Chaingun = "<B0,0:cowboy\\mHUD_reticle_Chaingun.bmp>";

//
// This constantly runs and checks to see if the which weapon is loaded
//
function mHUD::Timer() {
	if (!$mHUD::Initialized && getMountedItem(0) != -1) {
		$mHUD::Initialized = true;
		mHUD::Init();
		}
	if ($Inv::Name[getMountedItem(0)] != $mHUD::LastWeapon)
		mHUD::UpdateReticle();

	schedule("mHUD::Timer();", $mHUD::UpdateTime);
	}

function mHUD::UpdateReticle() {
	if (getMountedItem(0) == -1) {
		mHUD::SetVisible(RangeFinder, false);
		mHUD::SetVisible(Reticle, false);
		}
	else if ($Inv::Name[getMountedItem(0)] == "Mortar") {
		$mHUD::RangeFinder = $mHUD::Mortar::RangeFinder;
		$mHUD::Reticle = $mHUD::Reticle::Standard;
		mHUD::SetValue(RangeFinder, $mHUD::RangeFinder);
		mHUD::SetValue(Reticle, $mHUD::Reticle);
		mHUD::SetVisible(RangeFinder, true);
		mHUD::SetVisible(Reticle, true);
		}
	else if ($Inv::Name[getMountedItem(0)] == "Grenade Launcher") {
		$mHUD::RangeFinder = $mHUD::Grenade::RangeFinder;
		$mHUD::Reticle = $mHUD::Reticle::Standard;
		mHUD::SetValue(RangeFinder, $mHUD::RangeFinder);
		mHUD::SetValue(Reticle, $mHUD::Reticle);
		mHUD::SetVisible(RangeFinder, true);
		mHUD::SetVisible(Reticle, true);
		}
	else if ($Inv::Name[getMountedItem(0)] == "Laser Rifle") {
		$mHUD::Reticle = $mHUD::Reticle::Laser;
		mHUD::SetValue(Reticle, $mHUD::Reticle);
		mHUD::SetVisible(RangeFinder, false);
		mHUD::SetVisible(Reticle, true);
		}
	else if ($Inv::Name[getMountedItem(0)] == "Chaingun") {
		$mHUD::Reticle = $mHUD::Reticle::Chaingun;
		mHUD::SetValue(Reticle, $mHUD::Reticle);
		mHUD::SetVisible(RangeFinder, false);
		mHUD::SetVisible(Reticle, true);
		}
	else {
		$mHUD::Reticle = $mHUD::Reticle::Standard;
		mHUD::SetValue(Reticle, $mHUD::Reticle);
		mHUD::SetVisible(RangeFinder, false);
		mHUD::SetVisible(Reticle, true);
		}
	$mHUD::LastWeapon = $Inv::Name[getMountedItem(0)];
	}


function mHUD::SetVisible(%object, %state) {
	Control::SetVisible("mHUD::PlayGui::" @ %object, %state);
	if (included("cowboy\\CmdHUD.cs")) {
		Control::SetVisible("mHUD::CommandGui::" @ %object, %state);
		if ($mHUD::InventoryInitialized)
			Control::SetVisible("mHUD::CmdInventoryGui::" @ %object, %state);
		}
	}

function mHUD::SetValue(%object, %value) {
	Control::SetValue("mHUD::PlayGui::" @ %object, %value);
	if (included("cowboy\\CmdHUD.cs")) {
		Control::SetValue("mHUD::CommandGui::" @ %object, %value);
		if ($mHUD::InventoryInitialized)
			Control::SetValue("mHUD::CmdInventoryGui::" @ %object, %value);
		}
	}

function mHUD::CreateRangeFinder(%gui, %var) {
	%var = newobject("mHUD::" @ %gui @ "::RangeFinder", FearGuiFormattedText, $mHUD::X / 2 - 39, $mHUD::Y / 2 + 35, 79, 255);

	addToSet(%gui, %var);

	control::setvisible("mHUD::" @ %gui @ "::RangeFinder", false);

	echo("mHUD::" @ %gui @ "::RangeFinder Initialized");
	}

function mHUD::CreateReticle(%gui, %var) {
	%var = newobject("mHUD::" @ %gui @ "::Reticle", FearGuiFormattedText, $mHUD::X / 2 - 31, $mHUD::Y / 2 - 31, 63, 63);

	addToSet(%gui, %var);

	control::setvisible("mHUD::" @ %gui @ "::Reticle", false);

	echo("mHUD::" @ %gui @ "::Reticle Initialized");
	}
//
// Initialize the objects: load the gui, get the IDs, move stuff around
//
function mHUD::Init() {
	guiPushDialog(MainWindow, "gui\\mhud.gui");
	guiPopDialog(MainWindow, "gui\\mhud.gui");

	mHUD::CreateRangeFinder(PlayGui, $mHUD::PlayGui::RangeFinder);
	mHUD::CreateReticle(PlayGui, $mHUD::PlayGui::Reticle);

	if (included("cowboy\\CmdHUD.cs")) {
		mHUD::CreateRangeFinder(CommandGui, $mHUD::CommandGui::RangeFinder);
		mHUD::CreateReticle(CommandGui, $mHUD::CommandGui::Reticle);
		}

	Event::Attach(eventConnected, mHUD::Reset);
	Event::Attach(eventChangeMission, mHUD::Reset);
	}

//
// Because the CmdInventoryGui isn't loaded until you actually access the
// inventory screen, you have to wait until that happens to add the object!
//
function mHUD::InitInvCommandGui() {
	if (included("cowboy\\CmdHUD.cs")) {
		mHUD::CreateRangeFinder(CmdInventoryGui, $mHUD::CmdInventoryRangeFinder);
		mHUD::CreateReticle(CmdInventoryGui, $mHUD::CmdInventoryGuiReticle);
		schedule("mHUD::UpdateReticle();", $mHUD::InitInvTime);
		$mHUD::InventoryInitialized = true;
		}
	}

//
// Detect opening the inventory screen
//
function mHUD::GuiOpen(%gui) {
	if (%gui == CmdInventoryGui) {
		schedule("mHUD::InitInvCommandGui();", $mHUD::InitInvTime);
		schedule("Event::Detach(eventGuiOpen, mHUD::GuiOpen);", $mHUD::InitInvTime + 1);
		}
	}

//
// Reset all objects and variables
//
function mHUD::Reset() {
	control::setvisible(mHUD::Playgui, false);
	control::setvisible(mHUD::Commandgui, false);
	control::setvisible(mHUD::CmdInventorygui, false);
	$mHUD::LastWeapon = "";
	echo("mHUD Reset");
	}

$mHUD::Initialized = false;
$mHUD::InventoryInitialized = false;

Event::Attach(eventConnected, mHUD::Timer);
Event::Attach(eventGuiOpen, mHUD::GuiOpen);
