; TribesIP 3.5 - by Cowboy - http://www.planetstarsiege.com/cowboy/
;
; Requirements: mIRC 5.7, Starsiege: Tribes
;
; See the file TribesIPreadme.txt for installation and instructions

alias TIPversion set %TIP.version TribesIP 3.5 by Cowboy

on 1:LOAD: TIPinstall
on 1:CONNECT: tipstartup
ctcp 1:VERSION:*: /.ctcpreply $nick VERSION %TIP.version
on ^1:HOTLINK:*[IP*]*:*: return
on 1:HOTLINK:*[IP*]*:*: chooseplayer $1
on 1:TEXT:*[IP*]*:*: parseip $1-
on 1:ACTION:*[IP*]*:*: parseip $1-
on 1:NOTICE:*[IP*]*:*: parseip $1-
on 1:JOIN:%TIP.chanstr: {
  if (%TIP.notifymsg != $null && %TIP.notifyIP != $null) {
    if (%TIP.matchstr == $null || %TIP.matchstr isincs $nick) {
      notice $nick ( $+ %TIP.notifymsg $+ ) Repost via TribesIP: %TIP.notifyIP
    }
  }
}

alias tipstartup {
  TIPversion
  if ($window(@TribesIP) != @TribesIP) {
    echo -es Loading TribesIP.. Done
    showwindow
    if ($line(@TribesIP, 0) == 0) loadfavorites
  }
  if (%TIP.notifymsg != $null) {
    echo -es Auto-notice joiners still enabled! 
    echo -s Matchstring: $iif(%TIP.matchstr == $null, (none), %TIP.matchstr)
    echo -s Channels: %TIP.chanstr
    echo -s Message: ( $+ %TIP.notifymsg $+ ) Repost via TribesIP: %TIP.notifyIP
    chooseplayer
    did -f TIP 103
    did -h TIP 203
    tipnotifynames
  }
}

alias TIPinstall {
  :TIPinstallstart
  if ($version < 5.7) {
    echo %TIP.version requires mIRC version 5.7 or newer! Please get the latest version from http://www.mirc.com/
    halt
  }
  TIPversion
 
  var %file, %exename, %tribesdrive, %timehud = $false, %tribesdir, %configdir, %fullpath

  if ($dialog(TIPi1, TIPinstall1, -2) != $true) halt

  %fullpath = $dir=["Select your Tribes Executable..."] c:\dynamix\tribes\*.exe

  if (%fullpath == $null) {
    set %TIP.errormsg No Tribes executable file selected!
    if ($dialog(TIPe, TIPinstallerror, -2) != $true) halt
    else goto TIPinstallstart
  }
  %fullpath = $upper($shortfn(%fullpath))
  %exename = $gettok(%fullpath,$numtok(%fullpath,92),92)
  %TIP.tribespath = $deltok(%fullpath,$numtok(%fullpath,92),92) $+ \
  %tribesdrive = $gettok(%TIP.tribespath, 1, 92)
  %tribesdir = \ $+ $deltok(%TIP.tribespath,1,92)
  %configdir = %TIP.tribespath $+ config\

  if (%exename == timehud.exe) { 
    %timehud = $true
    %exename = /min %exename
  }
  if ($isfile(%fullpath) == $false) {
    set %TIP.errormsg %fullpath is not a valid tribes .EXE file!
    if ($dialog(TIPe, TIPinstallerror, -2) != $true) halt
    else goto TIPinstallstart
  }
  if ($isdir(%configdir) == $false) {
    set %TIP.errormsg %TIP.tribespath is not a valid tribes .EXE location! I can't find the %TIP.tribespath $+ CONFIG\ directory!
    if ($dialog(TIPe, TIPinstallerror, -2) != $true) halt
    else goto TIPinstallstart
  }
  %file = $shortfn($mircdir) $+ TribesIP.bat
  write -c %file
  write %file @echo off
  write -i %file 
  write %file echo !!!!!!!! %TIP.version (c)2000 Cowboy !!!!!!!!
  write %file echo.
  write %file echo http://www.planetstarsiege.com/cowboy/
  write %file echo.
  write %file echo If you need to use any other command line parameters, you can just add them in
  write %file echo at the end of the appropriate line! ( $+ %file $+ )
  write %file echo.
  write -i %file 
  write %file echo Changing directory to: %TIP.tribespath
  write -i %file 
  write %file %tribesdrive
  write %file cd $+ %tribesdir
  write -i %file 
  write %file echo.
  write %file echo Running: %exename % $+ 1 % $+ 2 % $+ 3 % $+ 4 % $+ 5 % $+ 6 % $+ 7 % $+ 8 % $+ 9
  write -i %file
  write %file start %exename % $+ 1 % $+ 2 % $+ 3 % $+ 4 % $+ 5 % $+ 6 % $+ 7 % $+ 8 % $+ 9
  write -i %file 
  if (%timehud) {
    write %file echo.
    write %file echo Since you are running TimeHUD, it's executed via "start /min" to minimize it!
    write %file echo (You can edit the file %file manually to change this)
  }
  write %file echo.
  write %file echo You'll notice that this DOS-box might remain after you choose to connect to a
  write %file echo game using TribesIP. This is normal, but annoying. What you can do to make it
  write %file echo go away is go to its Properties (Alt-Space, P) check the 'Close on Exit' box
  write %file echo and then the 'OK' button. Every time henceforth, it will close automatically!

  %file = %configdir $+ TribesIPrecord.cs
  write -c %file
  write %file // This file is used by %TIP.version $+ , don't worry about it!
  write %file $chr(32)
  write %file exec("TribesIP.cs");
  write %file setupRecorderFile();

  %file = %configdir $+ TribesIP.cs
  write -c %file
  write %file // This file is used by %TIP.version $+ , don't worry about it!
  write %file $chr(32)
  write %file for(% $+ i = 1; $ $+ cargv[% $+ i] != ""; % $+ i++) $chr(123)
  write %file $chr(9) $+ if($ $+ cargv[% $+ i] == "-player") $chr(123)
  write %file $chr(9) $+ $chr(9) $+ % $+ player = $ $+ cargv[% $+ i++];
  write %file $chr(9) $+ $chr(9) $+ $ $+ PCFG::CurrentPlayer = % $+ player;
  write %file $chr(9) $+ $chr(9) $+ $ $+ PCFG::LastPlayer = % $+ player;
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::EMail = $ $+ PCFG::EMail" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::Gender = $ $+ PCFG::Gender" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::Info = $ $+ PCFG::Info" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::Name = $ $+ PCFG::Name" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::RealName = $ $+ PCFG::RealName" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::SkinBase = $ $+ PCFG::SkinBase" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::Tribe = $ $+ PCFG::Tribe" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::URL = $ $+ PCFG::URL" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::Voice = $ $+ PCFG::Voice" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ export("PCFG::*", "config\\Players.cs", False);
  write %file $chr(9) $+ $chr(125)
  write %file $chr(125)

  window -c @TribesIP

  $dialog(TIPi2, TIPinstall2, -2)

  showwindow
  if ($line(@TribesIP, 0) == 0) loadfavorites
  chooseplayer
  readmeimport
  did -f TIP 105
  notice $me TribesIP: It is STRONGLY suggested that you go into mIRC's options (Alt-O -> IRC) and check "Cancel away on keypress" to clear your /away when you come back from Tribes!
}

dialog TIPinstallerror {
  title "Tribes IP Installation Error!"
  option dbu
  size -1 -1 145 65
  text   "",                  1, 5 15 130 30, center
  text   "OOPS...",           2, 5 5 130 10,  center
  text   "$true"             98, 1 1 1 1 hide,result
  button "Install Again",    99, 5 50 60 10,  ok,default
  button "Nevermind",       100,72 50 60 10,  cancel
}
on 1:dialog:TIPe:init:0: {
  did -a TIPe 1 %TIP.errormsg
  unset %TIP.errormsg
}

dialog TIPinstall1 {
  title "Tribes IP Installation"
  option dbu
  size -1 -1 200 135
  text   "TribesIP (c)2000 Cowboy",                              1, 5 5 185 10,  center
  text   "Performing one-time initialization for this script!",  2, 5 20 185 10,  center
  text   "/------- This is only to create the files: -------\",  3, 5 35 185 10,  center
  text   "",                                                     4, 5 45 185 10,  center
  text   "config\TribesIP.cs",                                   5, 5 55 185 10,  center
  text   "config\TribesIPrecord.cs",                             6, 5 65 185 10,  center
  text   "\------- that will be used to run Tribes -------/",    7, 5 75 185 10,  center
  text   "In the dialog box, select the executable file you use to run Tribes! Normally this will be TRIBES.EXE, but if you run TimeHUD, you should select TIMEHUD.EXE!", 8, 5 90 185 30,  center
  text   "$true"               98,   1 1 1 1 hide,result
  button "Install TribesIP",   99,   5 120 90 10, ok,default
  button "Cancel",            100, 100 120 90 10, cancel
}
on 1:dialog:TIPi1:init:0: {
  did -a TIPi1 1 %TIP.version (c)2000 Cowboy
  did -a TIPi1 4 $shortfn($mircdir) $+ TribesIP.bat
}

dialog TIPinstall2 {
  title "Tribes IP Installation"
  option dbu
  size -1 -1 200 130
  text   "------- TribesIP installation Complete! -------", 1, 5 5 185 10,  center
  text   "",  2, 5 20 185 20,  center
  text   "",  3, 5 35 185 20,  center
  text   "",  4, 5 50 185 20,  center
  text   "TribesIP should be loaded now, you can right-click on a channel window and select TribesIP Chooser or just double-click a dropped IP link to use it.",  5, 5 65 185 20,  center
  text   "Note: do not delete the variable %TIP.tribespath. If this gets deleted, TribesIP will prompt you to re-install.", 6, 5 80 185 30,  center
  text   "Visit Cowboy's Tribes Scripting Site! http://www.planetstarsiege.com/cowboy/",  7, 5 100 185 20,  center
  button "OK",   99,   55 115 85 10, ok,default
}
on 1:dialog:TIPi2:init:0: {
  var %file
  %file = $upper($shortfn($mircdir)) $+ TribesIP.bat
  did -a TIPi2 2 File %file created $iif($exists(%file), successfully, UNSUCCESSFULLY)
  %file = %TIP.tribespath $+ CONFIG\TribesIPrecord.cs
  did -a TIPi2 3 File %file created $iif($exists(%file), successfully, UNSUCCESSFULLY)
  %file = %TIP.tribespath $+ CONFIG\TribesIP.cs
  did -a TIPi2 4 File %file created $iif($exists(%file), successfully, UNSUCCESSFULLY)
}

alias showwindow {
  if (%TIP.tribespath == $null) {
    set %TIP.errormsg The variable "%TIP.tribespath" has become unset, would you like to reinstall TribesIP?
    if ($dialog(TIPe, TIPinstallerror, -2) != $true) halt
    else TIPinstall
  }
  window -hkl @TribesIP
}

alias addip {
  getserver $1-
  if (IP !isin %TIP.address) {
    echo 
    echo Oops! You have to Enter IP (w/ optional server name) in format:
    echo server SERVER NAME [validIPaddress] or just [validIPaddress]
    echo example: server Big Deal [IP:123.4.5.67:28001:00]
    echo 
    halt
  }
  iline @TribesIP %TIP.loadfavorites $timestamp You manually added: server %TIP.servername [[ $+ %TIP.address $+ ]]
  sline @TribesIP %TIP.loadfavorites
  if ($dialog(TIP) != TIP) dialog -m TIP TIPchoose
  did -f TIP 101
  tiprefreshserverlist
}

alias getserver {
  var %i = 0, %word, %length, %ip, %name = (Unknown)

  :getserverloop
  inc %i
  %word = $gettok($1-, %i, 32)
  if (%word === server) {
    %name = $null
    :getservernameloop
    inc %i
    %word = $gettok($1-, %i, 32)
    if (*[IP*]* !iswm %word) {
      %name = %name %word
      if (%i <= $numtok($1-, 32)) goto getservernameloop
    }
  }
  if (*[IP*]* iswm %word) {
    %word = kludge $+ %word $+ kludge
    ; yes, i have a sense of humor
    %word = $right(%word, $calc(1 - $pos(%word,[IP,1)))
    %word = $left(%word, $pos(%word,],1))
    %length = $calc($len(%word) - 2)
    %ip = $mid(%word, 2, %length)
  }
  else if (%i <= $numtok($1-, 32)) goto getserverloop

  set %TIP.address %ip
  set %TIP.servername %name
}

alias parseip {
  tipstartup
  getserver $1-

  if (%TIP.loadfavorites < 1 || %TIP.loadfavorites == $null) { %TIP.loadfavorites = 1 }
  if (%lastpostednick != $nick || %TIP.address != %lastpostedaddress) {
    set %lastpostedaddress %TIP.address
    set %lastpostednick $nick
    if ((IP:10. isin %TIP.address) || (IP:192.168. isin %TIP.address) || (IP:127.0.0.1 isin %TIP.address)) halt

    iline @TribesIP %TIP.loadfavorites $timestamp $nick says: server %TIP.servername [[ $+ %TIP.address $+ ]]
    if ($dialog(TIP) == TIP) did -i TIP 7 1 $timestamp $nick says: server %TIP.servername [[ $+ %TIP.address $+ ]]
  } 
}

alias loadfavorites {
  var %file = $shortfn($mircdir) $+ TribesIPfavorites.txt
  if ($exists(%file)) loadbuf @TribesIP %file
  else addfavorites server Cowboy's Script Testing Site! [IP:24.218.76.123:28001:00]
  set %TIP.loadfavorites $calc($line(@TribesIP,0) + 1)
  if (%TIP.loadfavorites > 1) sline @TribesIP 1
  
  var %i = 1
  while (%i < %TIP.loadfavorites) {
    if ($left($line(@TribesIP, %i), 8) == TribesIP) {
      rline @TribesIP %i $deltok($line(@TribesIP, %i),1,32)
    }
    inc %i
  }
}

alias addfavorites {
  if (%TIP.loadfavorites < 1 || %TIP.loadfavorites == $null) { %TIP.loadfavorites = 1 }
  getserver $iif($1- != $null, $1-, $sline(@TribesIP, 1))
  write $shortfn($mircdir) $+ TribesIPfavorites.txt server %TIP.servername [[ $+ %TIP.address $+ ]]
  iline 7 @TribesIP %TIP.loadfavorites server %TIP.servername [[ $+ %TIP.address $+ ]]
  inc %TIP.loadfavorites
}

alias delfavorites {
  var %i = $sline(@TribesIP, 1).ln
  if ($sline(@TribesIP, 1).ln < %TIP.loadfavorites) {
    getserver $sline(@TribesIP, 1)
    write -dl $+ $sline(@TribesIP, 1).ln $shortfn($mircdir) $+ TribesIPfavorites.txt
    dline @TribesIP $sline(@TribesIP, 1).ln
    dec %TIP.loadfavorites

    if (%i == %TIP.loadfavorites && %TIP.loadfavorites > 1) sline @TribesIP $calc(%i - 1)
    else sline @TribesIP %i
  }
}

alias tribeconnect {
  echo -es TribesIP: /run TribesIP.bat $1-
  run TribesIP.bat $1-
}

alias joinprint {
  if ($lock(run)) {
    beep
    echo -es You have to ENABLE /run to be able to execute the tribes .EXE file! Here's how to do it: Go into the OPTIONS screen (Alt-O) then General -> Lock and UNCHECK the 'Disable commands: /run' option!
    halt
  }

  getserver $sline(@TribesIP, 1)
  validIP

  echo -es TribesIP: Player set to $did(TIP,2,$did(TIP,2).sel)

  write -ds$Server::JoinPassword %TIP.tribespath $+ config\ServerPrefs.cs
  write %TIP.tribespath $+ config\ServerPrefs.cs $ $+ Server::JoinPassword = " $+ $did(TIP,4) $+ ";

  tribeconnect +connect %TIP.address +exec %TIP.recordline -player $calc($did(TIP,2).sel - 1)

  if ($1 != $null) describe $1 left via TribesIP to join server %TIP.servername [[ $+ %TIP.address $+ ]]
  else ame left via TribesIP to join server %TIP.servername [[ $+ %TIP.address $+ ]]

  if (%TIP.autoaway) away $timestamp TribesIP: Playing at server %TIP.servername [[ $+ %TIP.address $+ ]]
}

alias validIP {
  if (IP !isin %TIP.address) { echo -es Invalid IP or no server selected! | halt }
}

menu Menubar {
  Start TribesIP: { 
    tipstartup
  }
  Visit Cowboy's Scripts: url -an http://www.planetstarsiege.com/cowboy/
}

menu channel,nicklist,query {
  -
  Tribes Main Menu: {
    describe $iif($1, $1, $active) left via TribesIP to play Tribes...
    if (%TIP.autoaway) away TribesIP: In Tribes... $timestamp
    tribeconnect
  }
}

menu channel {
  -
  $iif($dialog(TIP) == TIP, Post Selected IP - this channel only): {
    getserver $sline(@TribesIP, 1)
    validIP
    describe $iif($1, $1, $active) reposts via TribesIP: server %TIP.servername [[ $+ %TIP.address $+ ]]
  }
  $iif($dialog(TIP) == TIP, Join Selected Server - this channel only): {
    joinprint $iif($1, $1, $active)
    dialog -x TIP
  }
}

menu nicklist,query {
  -
  $iif($dialog(TIP) == TIP, Post Selected IP - this person only): {
    getserver $sline(@TribesIP, 1)
    validIP
    describe $iif($1, $1, $active) reposts via TribesIP: server %TIP.servername [[ $+ %TIP.address $+ ]]
  }
  $iif($dialog(TIP) == TIP, Join Selected Server - this person only): {
    joinprint $iif($1, $1, $active)
    dialog -x TIP
  }
}

menu * {
  -
  $iif($dialog(TIP) != TIP, Start TribesIP Chooser): {
    if (%TIP.tribespath == $null) {
      set %TIP.errormsg The variable "%TIP.tribespath" has become unset, would you like to reinstall TribesIP?
      if ($dialog(TIPe, TIPinstallerror, -2) != $true) halt
      else TIPinstall
    }
    else {
      tipstartup
      chooseplayer
    }
  }
  $iif($dialog(TIP) == TIP, Query Server): {
    getserver $sline(@TribesIP, 1)
    %TIP.q1 = $gettok(%TIP.address,2,58)
    %TIP.q2 = $gettok(%TIP.address,3,58)
    validIP
    tipqs
  }
}

dialog TIPchoose {
  title "Tribes IP Chooser"
  option dbu
  size -1 -1 316 210

  tab "Join Server",                   101, 2 0 310 205
  tab "Import from GameServerList.cs", 102
  tab "Manual Add IP / Notice Joiners",103
  tab "About / Help",                  105

  text   "Choose Player",      1, 10 20 65 10,  center tab 101
  list                         2, 10 30 65 70, size tab 101
  text   "Server Password",    3, 10 105 65 10, center tab 101
  edit   "",                   4, 10 115 65 10, center,autohs tab 101
  check  "Auto Set Away: OFF",11, 10 127 65 10, left tab 101
  check  "Demo Record: OFF",   5, 10 137 65 10, left tab 101
  check  "Notice Joiners: OFF",10, 10 147 65 10, left tab 101
  text   "Choose Server",      6, 85 115 220 10, center tab 101
  list                         7, 85 125 220 75, size tab 101
  text   "Favorites",          8, 85 20 220 10, center tab 101
  list                         9, 85 30 220 75, size tab 101
  button "Add IP to Favorites",88, 87 115 60 8, tab 101
  button "Delete IP from Favs",89, 87 20 60 8, tab 101
  button "Post IP Globally",   90, 10 175 65 10, tab 101
  button "Join",               99, 10 190 30 10, ok tab 101
  button "Cancel",            100, 45 190 30 10, cancel tab 101
  button "Up",                 91, 259 20 22 8, tab 101
  button "Down",               92, 282 20 22 8, tab 101
  button "Delete Selected",    93, 259 115 45 8, tab 101
  button "Query Server",       94, 10 160 65 10, tab 101

  text   "Imported from GameServerList.cs",    106, 10 115 220 10, center tab 102
  list                                         107, 10 125 220 75, size tab 102
  text   "Current Favorites",                  108, 10 20 220 10, center tab 102
  list                                         109, 10 30 220 75, size tab 102
  button "Add Selected to Favorites",          110, 235 125 70 10, tab 102
  button "Delete Line from Favorites",         111, 235 30 70 10, tab 102
  text   "Search GameServerList.cs",           112, 235 165 70 10, center tab 102
  edit   "",                                   113, 235 175 70 10, center tab 102
  button "Down",                               114, 272 190 33 10, tab 102
  button "Up",                                 115, 235 190 33 10, tab 102
  button "Query Server",                       117, 235 140 70 10, tab 102
  button "Query Server",                       119, 235 60 70 10, tab 102
  button "Up",                                 121, 235 45 33 10, tab 102
  button "Down",                               122, 272 45 33 10, tab 102

  box    "Manual Add IP",                              130, 10 20 295 70, tab 103
  text   "IP address, example: 123.45.67.89:28001:01", 131, 15 35 205 10, center tab 103
  edit   "",                                           132, 15 45 205 10, center tab 103
  text   "Server name (optional)",                     133, 15 60 205 10, center tab 103
  edit   "",                                           134, 15 70 205 10, center tab 103
  button "Add IP to Server List",                      139, 225 40 75 10, tab 103
  button "Clear all fields",                           140, 225 55 75 10, tab 103
  button "Insert Selected IP",                         141, 225 70 75 10, tab 103

  box    "Auto-Notice Joiners",150, 10 100 295 100, tab 103
  text   "Channels",           151, 15 115 75 10, center tab 103
  list                         152, 15 125 75 70, size,extsel tab 103
  text   "Case-sensitive Match String (optional)",       153, 95 125 205 10, center,default tab 103
  edit   "",                   154, 95 135 205 10, center tab 103
  text   "Notice Text (required)",        155, 95 150 205 10, center tab 103
  edit   "",                   156, 95 160 205 20, center,multi tab 103
  edit   "",                   159, 95 110 205 10, center,read tab 103
  button "Accept Changes",     157, 95 185 65 10, tab 103
  button "Update Server",      160, 165 185 65 10, tab 103
  button "Clear all fields",   158, 235 185 65 10, tab 103


  text   "TribesIP (c)2000 Cowboy",      200, 10 20 295 10,  center tab 105
  box    "TribesIPreadme.txt",           201, 10 30 295 170, tab 105
  edit    "",                            202, 15 40 225 155, center,multi,vsbar,read tab 105
  icon                                   203, 222 -33 100 300, TribesIP.bmp
}

on 1:dialog:TIP:init:0: {
  var %i = 0, %val

  did -a TIP 200 %TIP.version (c)2000 Cowboy
  did -h TIP 203
  :tipnamesloop
  %val = $read -s$PCFG::Name $+ %i %TIP.tribespath $+ config\Players.cs
  if (%val != $null) {
    did -a TIP 2 $mid(%val,4,$calc($len(%val)-5))
    inc %i
    goto tipnamesloop
  }

  %val = $read -s$PCFG::CurrentPlayer %TIP.tribespath $+ config\Players.cs
  did -c TIP 2 $calc($mid(%val,4,$calc($len(%val)-5)) + 1)

  %val = $read -s$Server::JoinPassword %TIP.tribespath $+ config\ServerPrefs.cs
  did -a TIP 4 $mid(%val,4,$calc($len(%val)-5))

  did -a TIP 113 %TIP.lastsearched

  if (%TIP.recordstate) {
    did -a TIP 5 Demo Record: ON
    did -c TIP 5
  }
  if (%TIP.notifymsg != $null) {
    did -a TIP 10 Notify Joiners: ON
    did -c TIP 10
  }
  if (%TIP.autoaway) {
    did -a TIP 11 Auto Set Away: ON
    did -c TIP 11
  }

  if (%TIP.loadfavorites == 1) addfavorites server Cowboy's Script Testing Site! [IP:24.218.76.123:28001:00]
  tiprefreshserverlist
}

on 1:dialog:TIP:sclick:5: {
  if ($did(5).state == 1) {
    did -a TIP 5 Demo Record: ON
    set %TIP.recordstate $true
    set %TIP.recordline TribesIPrecord.cs +record 
  }
  else {
    did -a TIP 5 Demo Record: OFF
    set %TIP.recordstate $false
    set %TIP.recordline TribesIP.cs 
  }
}

on 1:dialog:TIP:sclick:10: {
  if ($did(10).state == 1) {
    did -f TIP 103
    did -h TIP 203
    tipnotifynames
  }
  else {
    did -a TIP 10 Notify Joiners: OFF
    unset %TIP.notifymsg
    unset %TIP.chanstr
    unset %TIP.matchstr
    unset %TIP.notifyIP
    echo -es Auto-notice joiners disabled!
  }
}

on 1:dialog:TIP:sclick:11: {
  if ($did(11).state == 1) {
    did -a TIP 11 Auto Set Away: ON
    %TIP.autoaway = $true
  }
  else {
    did -a TIP 11 Auto Set Away: OFF
    unset %TIP.autoaway
  }
}

on 1:dialog:TIP:sclick:7: {
  did -e TIP 88
  did -b TIP 89
  did -u TIP 9
  did -b TIP 91,92
  did -e TIP 93
  sline @TribesIP $calc(%TIP.loadfavorites + $did(7).sel - 1)
}

on 1:dialog:TIP:sclick:9: {
  did -b TIP 88
  did -e TIP 89
  did -u TIP 7
  did -e TIP 91,92
  did -b TIP 93
  sline @TribesIP $did(9).sel
}

on 1:dialog:TIP:sclick:88: {
  addfavorites
  sline @TribesIP $calc(%TIP.loadfavorites - 1)
  refreshtipfaves
  tipselect
  did -e TIP 91,92
  did -b TIP 93
}

on 1:dialog:TIP:sclick:89: {
  did -d TIP 9 $sline(@TribesIP,1).ln
  delfavorites
  tipselect
}

on 1:dialog:TIP:sclick:90: {
  getserver $sline(@TribesIP, 1)
  validIP
  ame reposts via TribesIP: server %TIP.servername [[ $+ %TIP.address $+ ]]
}

alias tipfavinsert {
  did -i TIP $1-
  iline @TribesIP $2 server $3-
  write -il $+ $2 $shortfn($mircdir) $+ TribesIPfavorites.txt server $3-
}

alias tipfavdelete {
  did -d TIP $1-2
  dline @TribesIP $2
  write -dl $+ $2 $shortfn($mircdir) $+ TribesIPfavorites.txt
}

alias tipfavselect {
  did -c TIP $1-2
  sline @TribesIP $2
}

on 1:dialog:TIP:sclick:91,121: {
  var %did = $iif($did == 91, 9, 109)
  var %line = $did(%did).sel, %text = $did(%did, %line).text
  if (%line > 1) {
    tipfavinsert %did $calc(%line - 1) %text
    tipfavdelete %did $calc(%line + 1)
    tipfavselect %did $calc(%line - 1)
  }
}

on 1:dialog:TIP:sclick:92,122: {
  var %did = $iif($did == 92, 9, 109)
  var %line = $did(%did).sel, %text = $did(%did, %line).text
  if (%line < $calc(%TIP.loadfavorites - 1) && %line != $null) {
    tipfavinsert %did $calc(%line + 2) %text
    tipfavdelete %did %line
    tipfavselect %did $calc(%line + 1)
  }
}

on 1:dialog:TIP:sclick:93: {
  var %i = $sline(@TribesIP, 1).ln
  dline @TribesIP %i
  did -d TIP 7 $calc(%i - %TIP.loadfavorites + 1)

  if ($did(7).lines == 0) {
    sline @TribesIP 1
    tipselect
  }
  else {
    if (%i > $line(@TribesIP, 0)) dec %i 
    sline @TribesIP %i
    did -c TIP 7 $calc(%i - %TIP.loadfavorites + 1)
  }
}

on 1:dialog:TIP:sclick:99: {
  if ($did(99).visible) {
    joinprint
  }
  else {
    halt
  }
}

on 1:dialog:TIP:sclick:139: {
  if ($did(132) != $null) {
    addip server $did(134) [[ $+ IP: $+ $did(132) $+ ]]
    did -r TIP 132,134
  }
}

on 1:dialog:TIP:sclick:140: {
  did -r TIP 132,134
}

on 1:dialog:TIP:sclick:141: {
  getserver $sline(@TribesIP, 1)
  validIP
  did -r TIP 132,134
  did -a TIP 132 $deltok(%TIP.address,1,58)
  did -a TIP 134 %TIP.servername
}

alias tiprefreshserverlist {
  if ($dialog(TIP) != TIP) halt
  refreshtipfaves
  refreshtipcaught
  tipselect
}

alias refreshtipfaves {
  var %i = 1

  did -r TIP 9

  :tipserversloop1
  if ($line(@TribesIP, %i) != $null && %i < %TIP.loadfavorites) {
    did -a TIP 9 $deltok($line(@TribesIP, %i),1,32)
    inc %i
    goto tipserversloop1
  }

  did -c TIP 9 $sline(@TribesIP, 1).ln
}

alias refreshtipcaught {
  var %i = %TIP.loadfavorites
  did -r TIP 7

  :tipserversloop2
  if ($line(@TribesIP, %i) != $null) {
    did -a TIP 7 $line(@TribesIP, %i)
    inc %i
    goto tipserversloop2
  }

  did -c TIP 7 $sline(@TribesIP, 1).ln
}

alias tipselect {
  if ($sline(@TribesIP,1).ln < %TIP.loadfavorites) {
    did -u TIP 7
    did -c TIP 9 $sline(@TribesIP,1).ln
    did -b TIP 88
    did -e TIP 89
    did -e TIP 91,92
    did -b TIP 93
  }
  else {
    did -u TIP 9
    did -c TIP 7 $calc($sline(@TribesIP,1).ln - %TIP.loadfavorites + 1)
    did -e TIP 88
    did -b TIP 89
    did -b TIP 91,92
    did -e TIP 93
  }
}

alias chooseplayer {

  if (%TIP.loadfavorites < 1 || %TIP.loadfavorites == $null) { %TIP.loadfavorites = 1 }

  var %i = %TIP.loadfavorites

  if ($dialog(TIP) != TIP) dialog -m TIP TIPchoose

  if ($1 == $null) tipselect
  else {

    while ($1 !isin $line(@TribesIP, %i)) {
      inc %i
      if ($line(@TribesIP, %i) == $null) {
        %i = %TIP.loadfavorites
        getserver $1-
        if (IP:10. isin %TIP.address || IP:192.168. isin %TIP.address || IP:127.0.0.1 isin %TIP.address) halt
        iline @TribesIP %TIP.loadfavorites $timestamp $nick says: server %TIP.servername [[ $+ %TIP.address $+ ]]
        tiprefreshserverlist
        break
      }
    }

    sline @TribesIP %i

    did -e TIP 88
    did -b TIP 89
    did -u TIP 9
    did -b TIP 91,92
    did -e TIP 93
    did -c TIP 7 $calc(%i - %TIP.loadfavorites + 1)
  }
}

on 1:dialog:TIP:sclick:101: {
  did -h TIP 203
  if (%TIP.notifymsg != $null) {
    did -a TIP 10 Notify Joiners: ON
    did -c TIP 10
  }
  else did -u TIP 10
}

on 1:dialog:TIP:sclick:102: {
  raffaves
  did -f TIP 102
  did -r TIP 106
  did -a TIP 106 Reading / Parsing GameServerList.cs
  .timer -m 1 100 rafimport
  did -h TIP 203
  did -b TIP 110,111,117,119,121,122
}

on 1:dialog:TIP:sclick:103: {
  did -h TIP 203
  tipnotifynames
}

on 1:dialog:TIP:sclick:105: readmeimport

alias readmeimport {
  var %file = $shortfn($mircdir) $+ TribesIPreadme.txt

  did -r TIP 202
  if ($exists(%file)) {

    var %i = 1
    while (%i <= $lines(%file)) {
      did -a TIP 202 $read -l $+ %i %file $crlf
      inc %i
    }

  }

  else did -a TIP 202 %file not found! Please unzip all TribesIP files into your mIRC directory!
  did -v TIP 203
}

alias rafimport {
  var %i, %file = %TIP.tribespath $+ config\GameServerList.cs

  did -r TIP 107
  if ($exists(%file)) {
    window -lsnhk @TribesIPimport
    window -lsnhk @TribesIPimportTo
    loadbuf @TribesIPimport %file

    %i = 0
    while (%i <= $line(@TribesIPimport,0)) {
      if (addGameServer isin $line(@TribesIPimport, %i)) {
        aline @TribesIPimportTo $gettok($line(@TribesIPimport,%i),4,34) [[ $+ $gettok($line(@TribesIPimport,%i),2,34) $+ :00 $+ ]]
      }
      inc %i
    }

    %i = 1
    while (%i < $line(@TribesIPimportTo,0)) {
      inc %i
      did -a TIP 107 $line(@TribesIPimportTo,%i)
    }

    window -c @TribesIPimport
    window -c @TribesIPimportTo
    did -e TIP 107
  }
  else {
    did -a TIP 107 GameServerList.cs does not exist! Please refresh the server list from within Tribes!
    did -b TIP 107
  }

  did -r TIP 106
  did -a TIP 106 Imported from GameServerList.cs

}

alias raffaves {
  var %i = 1
  did -r TIP 109
  :tipserversloop1
  if ($line(@TribesIP, %i) != $null && %i < %TIP.loadfavorites) {
    did -a TIP 109 $deltok($line(@TribesIP, %i),1,32)
    inc %i
    goto tipserversloop1
  }
}

on 1:dialog:TIP:sclick:107: {
  did -e TIP 110,117
}

on 1:dialog:TIP:sclick:109: {
  did -u TIP 7
  did -e TIP 111,119,121,122
  sline @TribesIP $did(109).sel
}

on 1:dialog:TIP:sclick:110: {
  if ($did(107).sel != $null) {
    getserver server $did(107,$did(107).sel).text
    write $shortfn($mircdir) $+ TribesIPfavorites.txt server %TIP.servername [[ $+ %TIP.address $+ ]]
    iline -s 7 @TribesIP %TIP.loadfavorites server %TIP.servername [[ $+ %TIP.address $+ ]]
    inc %TIP.loadfavorites
    tiprefreshserverlist
    raffaves
    did -c TIP 109 $sline(@TribesIP,1).ln
    did -e TIP 111,119,121,122
  }
}

on 1:dialog:TIP:edit:113: {
  %TIP.lastsearched = $did(113).text
}

on 1:dialog:TIP:sclick:114: {
  if ($did(113).text != $null) {
    var %text = $chr(42) $+ $did(113).text $+ $chr(42)
    var %i = $iif($did(107).sel, $did(107).sel, 1)
    
    while (%i < $did(107).lines) {
      inc %i
      if (%text iswm $did(107, %i).text) {
        did -c TIP 107 %i
        did -e TIP 110,117
        break
      }
    }
  }
}

on 1:dialog:TIP:sclick:115: {
  if ($did(113).text != $null) {
    var %text = $chr(42) $+ $did(113).text $+ $chr(42)
    var %i = $iif($did(107).sel, $did(107).sel, $calc($did(107).lines - 1))
    
    while (%i > 0) {
      dec %i
      if (%text iswm $did(107, %i).text) {
        did -c TIP 107 %i
        did -e TIP 110,117
        break
      }
    }
  }
}

on 1:dialog:TIP:sclick:111: {
  if ($did(109).sel != $null) {
    did -d TIP 109 $sline(@TribesIP,1).ln
    did -d TIP 9 $sline(@TribesIP,1).ln
    delfavorites
    tipselect
    did -c TIP 109 $sline(@TribesIP,1).ln
  }
}

on 1:dialog:TIP:sclick:158: {
  did -r TIP 154,156,159
  did -u TIP 152
  did -a TIP 159 - Press the Update Server button -
}

on 1:dialog:TIP:sclick:157: {
  var %i = 0, %chanstr
  validIP
  if ($did(152,0).sel == 0 || $did(156) == $null) {
    unset %TIP.notifymsg
    unset %TIP.chanstr
    unset %TIP.matchstr
    unset %TIP.notifyIP
    echo -s 
    echo -s Auto-notice joiners disabled! ( $+ $iif($did(156) == $null, No notice text, No channels chosen) $+ )
    halt
  }
  else if (You need to select a server in the Chooser! isin $did(159) || Press the Update Server button isin $did(159)) {
    echo -s 
    echo -s Auto-notice joiners disabled! (No server chosen)
    halt
  }

  :TIPanjloop
  inc %i
  if (%i <= $did(152,0).sel) {
    %chanstr = %chanstr $+ $iif(%i != 1, $chr(44)) $+ $gettok($did(152, $did(152,%i).sel), 1, 32)
    goto TIPanjloop
  }

  %TIP.chanstr = %chanstr
  %TIP.matchstr = $did(154)
  %TIP.notifymsg = $did(156)
  %TIP.notifyIP = $did(159)

  echo -s 
  echo -s Auto-notice joiners enabled! 
  echo -s 
  echo -s Matchstring: $iif(%TIP.matchstr == $null, (none), %TIP.matchstr)
  echo -s Channels: %TIP.chanstr
  echo -s Message: ( $+ %TIP.notifymsg $+ ) Repost via TribesIP: %TIP.notifyIP
}

on 1:dialog:TIP:sclick:160: {
  if ($sline(@TribesIP,0) == 0) {
    did -r TIP 159
    did -a TIP 159 You need to select a server in the Chooser! (Join Server page)
  }
  else {
    getserver $sline(@TribesIP, 1)
    validIP
    did -r TIP 159
    did -a TIP 159 server %TIP.servername [[ $+ %TIP.address $+ ]]
  }
}

alias tipnotifynames {
  var %i = 0
  did -r TIP 152
  :TIPchanloop
  inc %i
  if (%i <= $chan(0)) {
    did -a TIP 152 $chan(%i)
    goto TIPchanloop
  }
  did -a TIP 152 * (all channels)
  %i = 0
  :TIPchanloop2
  inc %i
  if (%i <= $did(TIP,152).lines) {
    if ($istok(%TIP.chanstr, $gettok($did(TIP, 152, %i).text, 1, 32), 44)) did -kc TIP 152 %i
    goto TIPchanloop2
  }
  did -r TIP 159
  if (%TIP.notifyIP == $null) did -a TIP 159 - Press the Update Server button -
  else {
    did -a TIP 159 %TIP.notifyIP
  }
  did -r TIP 154
  did -a TIP 154 %TIP.matchstr
  did -r TIP 156
  did -a TIP 156 %TIP.notifymsg
}

dialog TIPqueryserver {
  title "Tribes IP Server Query"
  option dbu
  size -1 -1 210 305

  text   "Name",  1, 5 3 15 10,  right
  text   "IP",    2, 5 14 15 10,  right
  text   "Ver",   3, 5 25 15 10,  right
  text   "Ping",  4, 5 36 15 10,  right
  text   "Mod",   5, 122 3 15 10,  right
  text   "Map",   6, 122 14 15 10,  right
  text   "Type",  7, 122 25 15 10,  right
  text   "Plyrs", 8, 122 36 15 10,  right

  edit   "",       11, 25 1 93 10,  center,read
  edit   "",       12, 25 12 93 10,  center,read
  edit   "",       13, 25 23 47 10,  center,read
  edit   "",       14, 25 34 47 10,  center,read

  edit   "",       15, 142 1 63 10,  center,read
  edit   "",       16, 142 12 63 10,  center,read
  edit   "",       17, 142 23 63 10,  center,read
  edit   "",       18, 142 34 63 10,  center,read


  edit   "",       29, 71 23 47 10,  center,read
  edit   "",       30, 71 34 47 10,  center,read



  edit   "",       20, 5 46 150 30, read,multi,vsbar


  list             21, 0 123 265 176
  list             22, 75 123 265 176
  list             23, 150 123 220 176
  list             24, 170 123 220 176
  list             25, 190 123 220 176

  list             26, 5 85 80 40,
  list             27, 85 85 35 40
  list             28, 120 85 35 40

  text   "Player Name",   31, 2 115 65 8
  text   "Team",          32, 77 115 65 8
  text   "Score",         33, 152 115 20 8
  text   "Ping",          34, 172 115 20 8
  text   "PL",            35, 192 115 20 8

  text   "Team Name",     36, 5 77 80 8, center
  text   "Players",       37, 85 77 35 8, center
  text   "Score",         38, 120 77 35 8, center

  check  "Auto-refresh"   98, 159 49 45 10, push
  combo                   102,160 64 20 50, drop
  text   "seconds",       103,181 66 20 10

  button "Refresh",       99, 159 87 45 10
  button "Close",         100, 159 102 34 10, cancel

  button "/\",            110, 194 102 10 10

  icon                   200,  -101 282 412 28, TribesIPquery.bmp

}

dialog TIPqueryserver1 {
  title "Tribes IP Server Query"
  option dbu
  size -1 -1 210 131

  text   "Name",  1, 5 3 15 10,  right
  text   "IP",    2, 5 14 15 10,  right
  text   "Ver",   3, 5 25 15 10,  right
  text   "Ping",  4, 5 36 15 10,  right
  text   "Mod",   5, 122 3 15 10,  right
  text   "Map",   6, 122 14 15 10,  right
  text   "Type",  7, 122 25 15 10,  right
  text   "Plyrs", 8, 122 36 15 10,  right

  edit   "",       11, 25 1 93 10,  center,read
  edit   "",       12, 25 12 93 10,  center,read
  edit   "",       13, 25 23 47 10,  center,read
  edit   "",       14, 25 34 47 10,  center,read

  edit   "",       15, 142 1 63 10,  center,read
  edit   "",       16, 142 12 63 10,  center,read
  edit   "",       17, 142 23 63 10,  center,read
  edit   "",       18, 142 34 63 10,  center,read


  edit   "",       29, 71 23 47 10,  center,read
  edit   "",       30, 71 34 47 10,  center,read



  edit   "",       20, 5 46 150 30, read,multi,vsbar


  list             21, 0 300 265 1
  list             22, 75 300 265 1
  list             23, 150 300 220 1
  list             24, 170 300 220 1
  list             25, 190 300 220 1

  list             26, 5 85 80 40,
  list             27, 85 85 35 40
  list             28, 120 85 35 40

  text   "Team Name",     36, 5 77 80 8, center
  text   "Players",       37, 85 77 35 8, center
  text   "Score",         38, 120 77 35 8, center

  check  "Auto-refresh"   98, 159 49 45 10, push
  combo                   102,160 64 20 50, drop
  text   "seconds",       103,181 66 20 10

  button "Refresh",       99, 159 87 45 10
  button "Close",         100, 159 102 34 10, cancel

  button "\/",            110, 194 102 10 10

  icon                   200,  -101 108 412 28, TribesIPquery.bmp

}

on 1:dialog:TIPqs:init:0: {
  did -a TIPqs 102 5
  did -a TIPqs 102 10
  did -a TIPqs 102 15
  did -a TIPqs 102 20

  if (%TIP.ardelay < 1 || %TIP.ardelay > 20 || %TIP.ardelay == $null) { %TIP.ardelay = 15 }

  did -c TIPqs 102 $int($calc(%TIP.ardelay / 5))
  
  TIPqsrefresh
}

on 1:dialog:TIPqs:sclick:21,22,23,24,25: {
  did -c TIPqs 21,22,23,24,25 $did($did,1).sel
}

on 1:dialog:TIPqs:sclick:98: {
  TIPqsautorefresh $did(98).state
}

alias TIPqsautorefresh {
  if (%TIP.ardelay < 1 || %TIP.ardelay > 20 || %TIP.ardelay == $null) { %TIP.ardelay = 15 }

  if ($1 == 1) { TIPqsrefresh | .timerTIPqs 0 %TIP.ardelay TIPqscheckrefresh }
  else .timerTIPqs off
}

on 1:dialog:TIPqs:sclick:102: {
  %TIP.ardelay = $did(102)
  TIPqsautorefresh $did(98).state
}

alias TIPqscheckrefresh {
  if ($dialog(TIPqs) == TIPqs) TIPqsrefresh
  else .timerTIPqs off
}

on 1:dialog:TIPqs:sclick:99: {
  TIPqsrefresh
}

alias TIPqs {
  if ($dialog(TIPqs) != TIPqs) {
    if (%TIP.dialog == $null) { %TIP.dialog = $true }
    var %null = $TIPtogglequery($iif(%TIP.dialog, $false, $true))
  }
  else TIPqsrefresh
}

on 1:dialog:TIPqs:sclick:110: {
  var %x = $dialog(TIPqs).x
  var %y = $dialog(TIPqs).y
  
  dialog -x TIPqs
  %TIP.dialog = $TIPtogglequery(%TIP.dialog, %x, %y)
}

alias TIPtogglequery {
  var %x = $iif($2 != $null, $2, -1)
  var %y = $iif($3 != $null, $3, -1)

  if ($1 == $true) {
    dialog -m TIPqs TIPqueryserver1
    dialog -s TIPqs %x %y -1 -1
    return $false
  }
  else {
    dialog -m TIPqs TIPqueryserver
    dialog -s TIPqs %x %y -1 -1
    return $true
  }

}

alias TIPqsrefresh {
  ;getserver $sline(@TribesIP, 1)
  QueryAndParse %TIP.q1 %TIP.q2 printquery printquerytimeout
}

on 1:dialog:TIP:dclick:107,109: {
  if ($did($did).sel != $null) {
    getserver server $did($did,$did($did).sel).text
    %TIP.q1 = $gettok(%TIP.address,2,58)
    %TIP.q2 = $gettok(%TIP.address,3,58)
    validIP
    tipqs
  }
}

on 1:dialog:TIP:sclick:117,119: {
  if ($did($calc($did - 10)).sel != $null) {
    getserver server $did($calc($did - 10),$did($calc($did - 10)).sel).text
    %TIP.q1 = $gettok(%TIP.address,2,58)
    %TIP.q2 = $gettok(%TIP.address,3,58)
    validIP
    tipqs
  }
}

on 1:dialog:TIP:sclick:94: {
  getserver $sline(@TribesIP, 1)
  %TIP.q1 = $gettok(%TIP.address,2,58)
  %TIP.q2 = $gettok(%TIP.address,3,58)
  validIP
  tipqs
}

on 1:dialog:TIP:dclick:7,9: {
  getserver $sline(@TribesIP, 1)
  %TIP.q1 = $gettok(%TIP.address,2,58)
  %TIP.q2 = $gettok(%TIP.address,3,58)
  validIP
  tipqs
}

alias printquery {
  var %i = 0, %string
  if ($dialog(TIPqs) == TIPqs) {
    did -r TIPqs 11,12,13,14,15,16,17,18,20,29,30
    did -a TIPqs 11 %ServerInfo.ServerName
    did -a TIPqs 12 $gettok(%TIP.address,2,58) $+ : $+ $gettok(%TIP.address,3,58)
    did -a TIPqs 13 %ServerInfo.GameVersion
    did -a TIPqs 14 %ServerInfo.Ping ms
    did -a TIPqs 15 %ServerInfo.Mod 
    did -a TIPqs 16 %ServerInfo.Map 
    did -a TIPqs 17 %ServerInfo.MissionType 
    did -a TIPqs 18 %ServerInfo.Players / %ServerInfo.MaxPlayers 
    did -a TIPqs 29 $iif(%ServerInfo.Dedicated == 1, Dedicated, Listen)
    did -a TIPqs 30 $iif(%ServerInfo.Password == 1, Password, No Password)

    %i = $numtok(%ServerInfo.Info,10)
    did -r TIPqs 20
    :TIPparseserverinfo
    if (%i > 0) {
      if (%i == $numtok(%ServerInfo.Info,10)) did -a TIPqs 20 $gettok(%ServerInfo.Info,%i,10)
      else did -i TIPqs 20 1 $gettok(%ServerInfo.Info,%i,10)
      dec %i
      goto TIPparseserverinfo
    }

    %i = 0
    did -r TIPqs 26,27,28
    :TIPrefreshteamsloop
    inc %i
    if (%i <= %ServerInfo.NumTeams) {
      %Serverinfo.TeamInfoString $+ %TIP.indexnum
      
      did -a TIPqs 26 $gettok( [ %Serverinfo.TeamInfoString [ $+ [ %i ] ] ] , 1, 255)
      
      if ( [ %Serverinfo.PlayerCount [ $+ [ %i ] ] ] != $null) did -a TIPqs 27 [ %Serverinfo.PlayerCount [ $+ [ %i ] ] ]
      else did -a TIPqs 27 0
      
      did -a TIPqs 28 $gettok( [ %Serverinfo.TeamInfoString [ $+ [ %i ] ] ] , 2, 255)
      goto TIPrefreshteamsloop
    }

    %i = 0
    did -r TIPqs 21,22,23,24,25
    :TIPrefreshplayersloop
    inc %i
    if (%i <= %ServerInfo.Players) {
 
      var %text %Serverinfo.playerInfoString [ $+ [ %i ] ]
      var %numt = $numtok(%text, 255)

      var %team = $gettok(%Serverinfo.TeamInfoString [ $+ [ $gettok(%text, 2, 255) ] ] , 1, 255)
      if (%team == $null) var %team = -----

      did -a TIPqs 21 $gettok(%text, 1, 255)
      did -a TIPqs 22 %team
      did -a TIPqs 23 $gettok(%text, 3, 255)
      did -a TIPqs 24 $gettok(%text, $calc(%numt - 1), 255)
      did -a TIPqs 25 $gettok(%text, %numt, 255)

      goto TIPrefreshplayersloop
    }
  }
  else {
    ;msg $active %ServerInfo.GameString %ServerInfo.Ping %ServerInfo.Dedicated %ServerInfo.Password %ServerInfo.Players $+ / $+ %ServerInfo.MaxPlayers %ServerInfo.CPU %ServerInfo.Mod %ServerInfo.MissionType %ServerInfo.Map %ServerInfo.NumTeams %ServerInfo.ServerName
  }

  unset %Serverinfo.*
}

;
; Most of the following code (the server query engine) by VeKToR.. Thanks Vek!!
;

alias QueryAndParse {
  if ($sock(SingleQuery).name != $null) sockclose SingleQuery

  bset &QueryPacket 1 98 1 1

  set %TIP.SinglePing $ticks
  set %TIP.QueryParseAlias $3
  sockudp -kb SingleQuery $1 $2 3 &QueryPacket

  .timerSingleParse 1 5 ParseandQueryTimeout $4 $1 $2
}

alias ParseAndQueryTimeout {
  sockclose SingleQuery
  $1 $2 $3
}

alias ReadPascalString {
  %TIP.lastbyte = $calc($1 + $bvar(&packet, $1) + 1)
  var %TIP.range $calc($1 + 1) $+ - $+ $calc(%TIP.lastbyte - 1)
  return $bvar(&packet, %TIP.range).text
}

on 1:UDPREAD:SingleQuery:{

  .timerSingleParse off

  unset %Serverinfo.*

  %Serverinfo.Ping = $calc($ticks - %TIP.SinglePing)
  unset %TIP.Singleping

  var %TIP.ip $sock($sockname).saddr
  var %TIP.port $sock($sockname).sport

  sockread -f &packet
  sockclose $sockname

  parseQueryPacket %TIP.ip $+ : $+ %TIP.port

  if ($isalias(%TIP.QueryParseAlias) == $true) %TIP.QueryParseAlias %TIP.ip %TIP.port
}

alias ParseQueryPacket {

  %Serverinfo.ResponseType = $bvar(&packet, 1)

  %Serverinfo.ID = $calc($bvar(&packet, 2) + $Calc($bvar(&packet, 3) * 256))

  %Serverinfo.GameString = $ReadPascalString(5)

  %Serverinfo.GameVersion = $ReadPascalString(%TIP.lastbyte)

  %Serverinfo.ServerName = $ReadPascalString(%TIP.lastbyte)

  %Serverinfo.Dedicated = $bvar(&packet, %TIP.lastbyte)

  inc %TIP.lastbyte 1
  %Serverinfo.Password = $bvar(&packet, %TIP.lastbyte)

  inc %TIP.lastbyte 1
  %Serverinfo.Players = $bvar(&packet, %TIP.lastbyte)

  inc %TIP.lastbyte 1
  %Serverinfo.MaxPlayers = $bvar(&packet, %TIP.lastbyte)

  if (%Serverinfo.ResponseType == 97) { queueserverqueries | return }

  ; 16-bit Int, first byte is low, last byte is high.
  inc %TIP.lastbyte 1
  %Serverinfo.CPU = $calc($bvar(&packet, %TIP.lastbyte) + $calc($bvar(&packet, $calc(%TIP.lastbyte + 1)) * 256))

  inc %TIP.lastbyte 2
  %Serverinfo.Mod = $ReadPascalString(%TIP.lastbyte)

  %Serverinfo.MissionType = $ReadPascalString(%TIP.lastbyte)

  %Serverinfo.Map = $ReadPascalString(%TIP.lastbyte)

  %Serverinfo.Info = $ReadPascalString(%TIP.lastbyte)

  %Serverinfo.NumTeams = $bvar(&packet, %TIP.lastbyte)
  var %TIP.range
  %TIP.range = %TIP.lastbyte $+ - $+ $bvar(&packet, 0)

  inc %TIP.lastbyte 1
  ProcessStringSegment Team $ReadPascalString(%TIP.lastbyte)

  ProcessStringSegment Player $ReadPascalString(%TIP.lastbyte)

  ; need temporary variables to hold the %TIP.t, %TIP.n, etc chars... mIRC doesnt handle
  ; that very elegantly =P
  ; oh, and some variables to make my life easier when substituting values into
  ; the format strings
  var %TIP.name
  var %TIP.team
  var %TIP.ping
  var %TIP.pl
  var %TIP.t $chr(37) $+ t
  var %TIP.n $chr(37) $+ n
  var %TIP.p $chr(37) $+ p
  var %TIP.l $chr(37) $+ l

  ; ----------------- Team Info Loop -------------------
  var %TIP.indexnum 1
  :TeamInfoLoop

  %TIP.name = $ReadPascalString(%TIP.LastByte)

  set %Serverinfo.TeamInfoString $+ %TIP.indexnum $replace($ReadPascalString(%TIP.LastByte), %TIP.t, %TIP.name, $chr(9), $chr(255))

  inc %TIP.indexnum 1
  if (%TIP.indexnum <= %Serverinfo.NumTeams) goto TeamInfoLoop
  ; ----------------- Team Info Loop -------------------

  ; ----------------- Player Info Loop -------------------
  var %TIP.indexnum 1
  if (%Serverinfo.Players < 1) goto SkipPlayers

  var %TIP.playerlist
  :PlayerInfoLoop

  %TIP.ping = $calc($bvar(&packet, %TIP.LastByte) * 4)

  inc %TIP.lastbyte 1
  %TIP.pl = $bvar(&packet, %TIP.LastByte)

  inc %TIP.lastbyte 1
  %TIP.team = $calc($bvar(&packet, %TIP.LastByte) + 1)
  inc %Serverinfo.PlayerCount $+ %TIP.team 1

  inc %TIP.lastbyte 1
  %TIP.name = $replace($ReadPascalString(%TIP.lastbyte), $chr(40), $chr(123), $chr(41), $chr(125))
  %TIP.playerlist = %TIP.playerlist $+ %TIP.name $+ $chr(255)

  set %Serverinfo.PlayerInfoString $+ %TIP.indexnum $replace($ReadPascalString(%TIP.lastbyte), %TIP.n, %TIP.name , %TIP.t, %TIP.team , %TIP.p, %TIP.ping , %TIP.l, %TIP.pl, $chr(9), $chr(255))

  inc %TIP.indexnum 1
  if (%TIP.indexnum <= %Serverinfo.Players) goto PlayerInfoLoop

  :SkipPlayers

  ; ----------------- Player Info Loop -------------------

}

alias ProcessStringSegment {
  var %token 0

  if ($2- == $null) { return }
  :ProcessLoop  
  inc %token 1
  set %ServerInfo. $+ $1 $+ Format [ %ServerInfo. [ $+ [ $1 [ $+ [ Format ] ] ] ] ] $+ $right($gettok($2-, %token, 9), $calc($len($gettok($2-, %token, 9)) - $iif(%token == 1, 0, 1))) $+ $chr(255)
  if (%token != 1) set %ServerInfo. $+ $1 $+ Pixels [ %ServerInfo. [ $+ [ $1 [ $+ [ Pixels ] ] ] ] ] $+ $asc($left($gettok($2-, %token, 9),1)) $+ $chr(255)

  if ($pos($2-, $chr(9), %token) != $null) goto ProcessLoop
}

alias printquerytimeout {
  if ($dialog(TIPqs) == TIPqs) {
    did -r TIPqs 11,12
    did -a TIPqs 11 Ping Timeout
    did -a TIPqs 12 $gettok(%TIP.address,2,58) $+ : $+ $gettok(%TIP.address,3,58)
  }
  unset %Serverinfo.*
}

; (c)2000 "Cowboy" Ben Alman, please do not modify or copy this in any way without my permission, thank you!
