; TribesIP 3.0 - by Cowboy - http://www.planetstarsiege.com/cowboy/
;
; Requirements: mIRC 5.61, Starsiege: Tribes
;
; See the file TribesIPreadme.txt for installation and instructions

alias TIPversion set %TIPversion TribesIP 3.0

on 1:LOAD: TIPinstall
on 1:CONNECT: tipstartup
ctcp 1:VERSION:*: /.ctcpreply $nick VERSION %TIPversion
on ^1:HOTLINK:[IP*]:*: return
on 1:HOTLINK:[IP*]:*: chooseplayer $1
on 1:TEXT:*[IP*]*:*: parseip $1-
on 1:ACTION:*[IP*]*:*: parseip $1-
on 1:NOTICE:*[IP*]*:*: parseip $1-
on 1:JOIN:%TIPchanstr: {
  if (%TIPnotifymsg != $null && %TIPnotifyIP != $null) {
    if (%TIPmatchstr == $null || %TIPmatchstr isincs $nick) {
      notice $nick ( $+ %TIPnotifymsg $+ ) Repost via TribesIP: %TIPnotifyIP
    }
  }
}

alias tipstartup {
  TIPversion
  if ($window(@TribesIP) != @TribesIP) {
    echo -es Loading TribesIP.. Done
    showwindow
    if ($line(@TribesIP, 0) == 0) loadfavorites
    if (%TIPnotifymsg != $null) {
      echo -es Auto-notice joiners still enabled! 
      echo -s Matchstring: $iif(%TIPmatchstr == $null, (none), %TIPmatchstr)
      echo -s Channels: %TIPchanstr
      echo -s Message: ( $+ %TIPnotifymsg $+ ) Repost via TribesIP: %TIPnotifyIP
    }
  }
}

alias TIPinstall {
  :TIPinstallstart
  if ($version < 5.61) {
    echo %TIPversion requires mIRC version 5.61 or newer! Please get the latest version from http://www.mirc.com/
    halt
  }
  TIPversion

  var %file, %exename, %timehud = $false, %tribesdrive, %tribesdir, %configdir, %fullpath

  if ($dialog(TIPi1, TIPinstall1, -2) != $true) halt

  %fullpath = $dir[="Select your Tribes Executable..."] c:\*.exe

  if (%fullpath == $null) {
    set %TIPerrormsg No Tribes executable file selected!
    if ($dialog(TIPe, TIPinstallerror, -2) != $true) halt
    else goto TIPinstallstart
  }
  %fullpath = $upper($shortfn(%fullpath))
  %exename = $gettok(%fullpath,$numtok(%fullpath,92),92)
  %tribespath = $deltok(%fullpath,$numtok(%fullpath,92),92) $+ \
  %tribesdrive = $gettok(%tribespath, 1, 92)
  %tribesdir = \ $+ $deltok(%tribespath,1,92)
  %configdir = %tribespath $+ config\

  if (%exename == timehud.exe) { 
    %timehud = $true
    %exename = start /m %exename
  }
  if ($isfile(%fullpath) == $false) {
    set %TIPerrormsg %fullpath is not a valid tribes .EXE file!
    if ($dialog(TIPe, TIPinstallerror, -2) != $true) halt
    else goto TIPinstallstart
  }
  if ($isdir(%configdir) == $false) {
    set %TIPerrormsg %tribespath is not a valid tribes .EXE location! I can't find the %tribespath $+ CONFIG\ directory!
    if ($dialog(TIPe, TIPinstallerror, -2) != $true) halt
    else goto TIPinstallstart
  }
  %file = $shortfn($mircdir) $+ TribesIP.bat
  write -c %file
  write %file @echo off
  write -i %file 
  write %file echo !!!!!!!! %TIPversion (c)1999 Cowboy !!!!!!!!
  write %file echo.
  write %file echo http://www.planetstarsiege.com/cowboy/
  write %file echo.
  write %file echo If you need to use any other command line parameters, you can just add them in
  write %file echo at the end of the appropriate line! ( $+ %file $+ )
  write %file echo.
  write -i %file 
  write %file echo Changing directory to: %tribespath
  write -i %file 
  write %file %tribesdrive
  write %file cd $+ %tribesdir
  write -i %file 
  write %file echo.
  write %file echo Running: %exename % $+ 1 % $+ 2 % $+ 3 % $+ 4 % $+ 5 % $+ 6 % $+ 7 % $+ 8 % $+ 9
  write -i %file
  write %file %exename % $+ 1 % $+ 2 % $+ 3 % $+ 4 % $+ 5 % $+ 6 % $+ 7 % $+ 8 % $+ 9
  write -i %file 
  if (%timehud) {
    write %file echo.
    write %file echo Since you are running TimeHUD, it's executed via "start /m" to minimize it!
    write %file echo (You can edit the file %file manually to change this)
  }
  write %file echo.
  write %file echo You'll notice that this DOS-box stays up after you choose to connect to a game 
  write %file echo using TribesIP. This is normal, but annoying... What you can do to make it go
  write %file echo away is go to its Properties box (Alt-Space, P) check the 'Close on Exit' box
  write %file echo and then the 'OK' button. Every time henceforth, it will close automatically!

  %file = %configdir $+ TribesIPrecord.cs
  write -c %file
  write %file // This file is used by %TIPversion $+ , don't worry about it!
  write %file $chr(32)
  write %file exec("TribesIP.cs");
  write %file setupRecorderFile();

  %file = %configdir $+ TribesIP.cs
  write -c %file
  write %file // This file is used by %TIPversion $+ , don't worry about it!
  write %file $chr(32)
  write %file for(% $+ i = 1; $ $+ cargv[% $+ i] != ""; % $+ i++) $chr(123)
  write %file $chr(9) $+ if($ $+ cargv[% $+ i] == "-player") $chr(123)
  write %file $chr(9) $+ $chr(9) $+ % $+ player = $ $+ cargv[% $+ i++];
  write %file $chr(9) $+ $chr(9) $+ $ $+ PCFG::CurrentPlayer = % $+ player;
  write %file $chr(9) $+ $chr(9) $+ $ $+ PCFG::LastPlayer = % $+ player;
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::EMail = $ $+ PCFG::EMail" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::Gender = $ $+ PCFG::Gender" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::Info = $ $+ PCFG::Info" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::Name = $ $+ PCFG::Name" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::RealName = $ $+ PCFG::RealName" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::SkinBase = $ $+ PCFG::SkinBase" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::Tribe = $ $+ PCFG::Tribe" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::URL = $ $+ PCFG::URL" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ eval("$ $+ PCFG::Voice = $ $+ PCFG::Voice" @ % $+ player @ ";");
  write %file $chr(9) $+ $chr(9) $+ export("PCFG::*", "config\\Players.cs", False);
  write %file $chr(9) $+ $chr(125)
  write %file $chr(125)

  $dialog(TIPi2, TIPinstall2, -2)

  showwindow
  chooseplayer
  did -f TIP 105
  readmeimport
}

dialog TIPinstallerror {
  title "Tribes IP Installation Error!"
  option dbu
  size -1 -1 135 50
  text   "",                       1, 5 15 130 30,  center
  text   "OOPS...",  2, 5 5 130 10,  center
  text   "$true"               98,   1 1 1 1 hide,result
  button "Install Again",          99,   5 50 60 10, ok,default
  button "Nevermind",            100,   72 50 60 10, cancel
}
on 1:dialog:TIPe:init:0: {
  did -a TIPe 1 %TIPerrormsg
  unset %TIPerrormsg
}

dialog TIPinstall1 {
  title "Tribes IP Installation"
  option dbu
  size -1 -1 192 120
  text   "TribesIP (c)1999 Cowboy",                              1, 5 5 185 10,  center
  text   "Performing one-time initialization for this script!",  2, 5 20 185 10,  center
  text   "/------- This is only to create the files: -------\",  3, 5 35 185 10,  center
  text   "",                                                     4, 5 45 185 10,  center
  text   "config\TribesIP.cs",                                   5, 5 55 185 10,  center
  text   "config\TribesIPrecord.cs",                             6, 5 65 185 10,  center
  text   "\------- that will be used to run Tribes -------/",    7, 5 75 185 10,  center
  text   "In the dialog box, select the executable file you use to run Tribes! Normally this will be TRIBES.EXE, but if you run TimeHUD, you should select TIMEHUD.EXE!", 8, 5 90 185 30,  center
  text   "$true"               98,   1 1 1 1 hide,result
  button "Install TribesIP",   99,   5 120 90 10, ok,default
  button "Cancel",            100, 100 120 90 10, cancel
}
on 1:dialog:TIPi1:init:0: {
  did -a TIPi1 1 %TIPversion (c)1999 Cowboy
  did -a TIPi1 4 $shortfn($mircdir) $+ TribesIP.bat
}

dialog TIPinstall2 {
  title "Tribes IP Installation"
  option dbu
  size -1 -1 192 115
  text   "------- TribesIP installation Complete! -------", 1, 5 5 185 10,  center
  text   "",  2, 5 20 185 20,  center
  text   "",  3, 5 35 185 20,  center
  text   "",  4, 5 50 185 20,  center
  text   "TribesIP should be loaded now, you can right-click on a channel window and select TribesIP Chooser or just double-click a dropped IP link to use it.",  5, 5 65 185 20,  center
  text   "Note: do not delete the variable %tribespath. If this gets deleted, TribesIP will prompt you to re-install.", 6, 5 80 185 30,  center
  text   "Visit Cowboy's Tribes Scripting Site! http://www.planetstarsiege.com/cowboy/",  7, 5 100 185 20,  center
  button "OK",   99,   55 115 85 10, ok,default
}
on 1:dialog:TIPi2:init:0: {
  var %file
  %file = $upper($shortfn($mircdir)) $+ TribesIP.bat
  did -a TIPi2 2 File %file created $iif($exists(%file), successfully, UNSUCCESSFULLY)
  %file = %tribespath $+ CONFIG\TribesIPrecord.cs
  did -a TIPi2 3 File %file created $iif($exists(%file), successfully, UNSUCCESSFULLY)
  %file = %tribespath $+ CONFIG\TribesIP.cs
  did -a TIPi2 4 File %file created $iif($exists(%file), successfully, UNSUCCESSFULLY)
}

alias showwindow {
  if (%tribespath == $null) {
    set %TIPerrormsg The variable "%tribespath" has become unset, would you like to reinstall TribesIP?
    if ($dialog(TIPe, TIPinstallerror, -2) != $true) halt
    else TIPinstall
  }
  window -hkl @TribesIP
}

alias addip {
  getserver $1-
  if (IP !isin %address) {
    echo 
    echo Oops! You have to Enter IP (w/ optional server name) in format:
    echo server SERVER NAME [validIPaddress] or just [validIPaddress]
    echo example: server Big Deal [IP:123.4.5.67:28001:00]
    echo 
    halt
  }
  iline @TribesIP %loadfavorites $timestamp You manually added: server %servername [[ $+ %address $+ ]]
  sline @TribesIP %loadfavorites
  if ($dialog(TIP) != TIP) dialog -m TIP TIPchoose
  did -f TIP 101
  tiprefreshserverlist
}

alias getserver {
  var %i = 0, %word, %length, %ip, %name = (Unknown)

  :getserverloop
  inc %i
  %word = $gettok($1-, %i, 32)
  if (%word === server) {
    %name = $null
    :getservernameloop
    inc %i
    %word = $gettok($1-, %i, 32)
    if ([IP*] !iswm %word) {
      %name = %name %word
      if (%i <= $numtok($1-, 32)) goto getservernameloop
    }
  }
  if ([IP*] iswm %word) {
    %length = $calc($len(%word) - 2)
    %ip = $mid(%word, 2, %length)
  }
  else if (%i <= $numtok($1-, 32)) goto getserverloop

  set %address %ip
  set %servername %name
}

alias parseip {
  tipstartup
  getserver $1-

  if (%loadfavorites < 1) %loadfavorites = 1
  if (%lastpostednick != $nick || %address != %lastpostedaddress) {
    set %lastpostedaddress %address
    set %lastpostednick $nick
    if (IP:10. isin %address || IP:192.168. isin %address || IP:127.0.0.1 isin %address) halt

    iline @TribesIP %loadfavorites $timestamp $nick says: server %servername [[ $+ %address $+ ]]
    if ($dialog(TIP) == TIP) did -i TIP 7 1 $timestamp $nick says: server %servername [[ $+ %address $+ ]]
  } 
}

alias loadfavorites {
  var %file = $shortfn($mircdir) $+ TribesIPfavorites.txt
  if ($exists(%file)) loadbuf @TribesIP %file
  else addfavorites server Cowboy's Script Testing Site! [IP:24.218.76.123:28001:00]
  set %loadfavorites $calc($line(@TribesIP,0) + 1)
  if (%loadfavorites > 1) sline @TribesIP 1
}

alias addfavorites {
  if (%loadfavorites < 1) %loadfavorites = 1
  getserver $iif($1- != $null, $1-, $sline(@TribesIP, 1))
  write $shortfn($mircdir) $+ TribesIPfavorites.txt TribesIP: server %servername [[ $+ %address $+ ]]
  iline 7 @TribesIP %loadfavorites TribesIP: server %servername [[ $+ %address $+ ]]
  inc %loadfavorites
}

alias delfavorites {
  var %i = $sline(@TribesIP, 1).ln
  if ($sline(@TribesIP, 1).ln < %loadfavorites) {
    getserver $sline(@TribesIP, 1)
    write -dl $+ $sline(@TribesIP, 1).ln $shortfn($mircdir) $+ TribesIPfavorites.txt
    dline @TribesIP $sline(@TribesIP, 1).ln
    dec %loadfavorites

    if (%i == %loadfavorites && %loadfavorites > 1) sline @TribesIP $calc(%i - 1)
    else sline @TribesIP %i
  }
}

alias tribeconnect {
  echo -es TribesIP: /run command.com /c TribesIP.bat $1-
  run command.com /c TribesIP.bat $1-
}

alias joinprint {
  getserver $sline(@TribesIP, 1)
  validIP

  echo -es TribesIP: Player set to $did(TIP,2,$did(TIP,2).sel)

  write -ds$Server::JoinPassword %tribespath $+ config\ServerPrefs.cs
  write %tribespath $+ config\ServerPrefs.cs $ $+ Server::JoinPassword = " $+ $did(TIP,4) $+ ";

  tribeconnect +connect %address +exec %recordline -player $calc($did(TIP,2).sel - 1)

  if ($1 != $null) describe $1 left via TribesIP to join server %servername [[ $+ %address $+ ]]
  else ame left via TribesIP to join server %servername [[ $+ %address $+ ]]

  away $timestamp TribesIP: Playing at server %servername [[ $+ %address $+ ]]
}

alias validIP {
  if (IP !isin %address) { echo -es Invalid IP or no server selected! | halt }
}

menu Menubar {
  Start TribesIP: { 
    tipstartup
  }
}

menu channel {
  Tribes Main Menu: {
    me left via TribesIP to play Tribes...
    away TribesIP: In Tribes... $timestamp
    tribeconnect
  }
  -
  $iif($dialog(TIP) != TIP, Start TribesIP Chooser): {
    if (%tribespath == $null) {
      set %TIPerrormsg The variable "%tribespath" has become unset, would you like to reinstall TribesIP?
      if ($dialog(TIPe, TIPinstallerror, -2) != $true) halt
      else TIPinstall
    }
    else {
      tipstartup
      chooseplayer
    }
  }
  $iif($dialog(TIP) == TIP, Post Selected IP in Channel): {
    getserver $sline(@TribesIP, 1)
    validIP
    me reposts via TribesIP: server %servername [[ $+ %address $+ ]]
  }
  $iif($dialog(TIP) == TIP, Join Selected Server): {
    joinprint #
    dialog -x TIP
  }
}

menu nicklist,query {
  $iif($dialog(TIP) == TIP, Give Selected IP to Nick): {
    getserver $sline(@TribesIP, 1)
    validIP
    if ($$1 != $me) describe $1 reposts via TribesIP: server %servername [[ $+ %address $+ ]]
  }
}

dialog TIPchoose {
  title "Tribes IP Chooser"
  option dbu
  size -1 -1 312 196

  tab "Join Server",                   101, 2 0 310 200
  tab "Import from GameServerList.cs", 102
  tab "Manual Add IP / Notice Joiners",103
  tab "About / Help",                  105

  text   "Choose Player",      1, 10 20 65 10,  center tab 101
  list                         2, 10 30 65 75, size tab 101
  text   "Server Password",    3, 10 115 65 10, center tab 101
  edit   "",                   4, 10 125 65 10, center,autohs tab 101
  check  "Demo Record: OFF",   5, 10 137 65 10, left tab 101
  check  "Notice Joiners: OFF",10, 10 147 65 10, left tab 101
  text   "Choose Server",      6, 85 115 220 10, center tab 101
  list                         7, 85 125 220 75, size tab 101
  text   "Favorites",          8, 85 20 220 10, center tab 101
  list                         9, 85 30 220 75, size tab 101
  button "Add IP to Favorites",88, 10 160 65 10, tab 101
  button "Post IP Globally",   90, 10 175 65 10, tab 101
  button "Join",               99, 10 190 30 10, ok tab 101
  button "Cancel",            100, 45 190 30 10, cancel tab 101
  button "Up",                 91, 259 20 22 8, tab 101
  button "Down",               92, 282 20 22 8, tab 101
  button "Delete Selected",    93, 259 115 45 8, tab 101

  text   "Imported from GameServerList.cs",    106, 10 115 220 10, center tab 102
  list                                         107, 10 125 220 75, size tab 102
  text   "Current Favorites",                  108, 10 20 220 10, center tab 102
  list                                         109, 10 30 220 75, size tab 102
  button "Add Selected to Favorites",          110, 235 125 70 10, tab 102
  button "Delete Line from Favorites",         111, 235 30 70 10, tab 102

  box    "Manual Add IP",                              130, 10 20 295 70, tab 103
  text   "IP address, example: 123.45.67.89:28001:01", 131, 15 35 205 10, center tab 103
  edit   "",                                           132, 15 45 205 10, center tab 103
  text   "Server name (optional)",                     133, 15 60 205 10, center tab 103
  edit   "",                                           134, 15 70 205 10, center tab 103
  button "Add IP to Server List",                      139, 225 40 75 10, tab 103
  button "Clear all fields",                           140, 225 55 75 10, tab 103
  button "Insert Selected IP",                         141, 225 70 75 10, tab 103

  box    "Auto-Notice Joiners",150, 10 100 295 100, tab 103
  text   "Channels",           151, 15 115 75 10, center tab 103
  list                         152, 15 125 75 70, size,extsel tab 103
  text   "Case-sensitive Match String (optional)",       153, 95 125 205 10, center,default tab 103
  edit   "",                   154, 95 135 205 10, center tab 103
  text   "Notice Text (required)",        155, 95 150 205 10, center tab 103
  edit   "",                   156, 95 160 205 20, center,multi tab 103
  edit   "",                   159, 95 110 205 10, center,read tab 103
  button "Accept Changes",     157, 95 185 65 10, tab 103
  button "Update Server",      160, 165 185 65 10, tab 103
  button "Clear all fields",   158, 235 185 65 10, tab 103


  text   "TribesIP (c)1999 Cowboy",      200, 10 20 295 10,  center tab 105
  box    "TribesIPreadme.txt",           201, 10 30 295 170, tab 105
  edit    "",                            202, 15 40 225 155, center,multi,vsbar,read tab 105
  icon                                   203, 222 -33 100 300, TribesIP.bmp
}

on 1:dialog:TIP:init:0: {
  var %i = 0

  did -a TIP 200 %TIPversion (c)1999 Cowboy
  did -h TIP 203
  :tipnamesloop
  %val = $read -s$PCFG::Name $+ %i %tribespath $+ config\Players.cs
  if (%val != $null) {
    did -a TIP 2 $mid(%val,4,$calc($len(%val)-5))
    inc %i
    goto tipnamesloop
  }

  %val = $read -s$PCFG::CurrentPlayer %tribespath $+ config\Players.cs
  did -c TIP 2 $calc($mid(%val,4,$calc($len(%val)-5)) + 1)

  %val = $read -s$Server::JoinPassword %tribespath $+ config\ServerPrefs.cs
  did -a TIP 4 $mid(%val,4,$calc($len(%val)-5))

  if (%recordstate) {
    did -a TIP 5 Demo Record: ON
    did -c TIP 5
  }
  if (%TIPnotifymsg != $null) {
    did -a TIP 10 Notify Joiners: ON
    did -c TIP 10
  }

  if (%loadfavorites == 1) addfavorites TribesIP: server Cowboy's Script Testing Site! [IP:24.218.76.123:28001:00]
  tiprefreshserverlist
}

on 1:dialog:TIP:sclick:5: {
  if ($did(5).state == 1) {
    did -a TIP 5 Demo Record: ON
    set %recordstate $true
    set %recordline TribesIPrecord.cs +record 
  }
  else {
    did -a TIP 5 Demo Record: OFF
    set %recordstate $false
    set %recordline TribesIP.cs 
  }
}

on 1:dialog:TIP:sclick:10: {
  if ($did(10).state == 1) {
    did -f TIP 103
    did -h TIP 203
    tipnotifynames
  }
  else {
    did -a TIP 10 Notify Joiners: OFF
    unset %TIPnotifymsg
    unset %TIPchanstr
    unset %TIPmatchstr
    unset %TIPnotifyIP
    echo -es Auto-notice joiners disabled!
  }
}

on 1:dialog:TIP:sclick:7: {
  did -a TIP 88 Add IP to Favorites
  did -u TIP 9
  did -b TIP 91,92
  did -e TIP 93
  sline @TribesIP $calc(%loadfavorites + $did(7).sel - 1)
}

on 1:dialog:TIP:sclick:9: {
  did -a TIP 88 Delete IP from Favs
  did -u TIP 7
  did -e TIP 91,92
  did -b TIP 93
  sline @TribesIP $did(9).sel
}

on 1:dialog:TIP:sclick:88: {
  if ($did(TIP,9,0).sel != 0) {
    did -d TIP 9 $sline(@TribesIP,1).ln
    delfavorites
    tipselect
  }
  else if ($did(TIP,7,0).sel != 0) {
    addfavorites
    sline @TribesIP $calc(%loadfavorites - 1)
    refreshtipfaves
    tipselect
    did -a TIP 88 Delete IP from Favs
    did -e TIP 91,92
    did -b TIP 93
  }
}

on 1:dialog:TIP:sclick:90: {
  getserver $sline(@TribesIP, 1)
  validIP
  ame reposts via TribesIP: server %servername [[ $+ %address $+ ]]
}

alias tipfavinsert {
  did -i TIP 9 $1-
  iline @TribesIP $1-
  write -il $+ $1 $shortfn($mircdir) $+ TribesIPfavorites.txt $2-
}

alias tipfavdelete {
  did -d TIP 9 $1
  dline @TribesIP $1
  write -dl $+ $1 $shortfn($mircdir) $+ TribesIPfavorites.txt
}

alias tipfavselect {
  did -c TIP 9 $1
  sline @TribesIP $1
}

on 1:dialog:TIP:sclick:91: {
  var %line = $did(9).sel, %text = $did(9, %line).text
  if (%line > 1) {
    tipfavinsert $calc(%line - 1) %text
    tipfavdelete $calc(%line + 1)
    tipfavselect $calc(%line - 1)
  }
}

on 1:dialog:TIP:sclick:92: {
  var %line = $did(9).sel, %text = $did(9, %line).text
  if (%line < $calc(%loadfavorites - 1) && %line != $null) {
    tipfavinsert $calc(%line + 2) %text
    tipfavdelete %line
    tipfavselect $calc(%line + 1)
  }
}

on 1:dialog:TIP:sclick:93: {
  var %i = $sline(@TribesIP, 1).ln
  dline @TribesIP %i
  did -d TIP 7 $calc(%i - %loadfavorites + 1)

  if ($did(7).lines == 0) {
    sline @TribesIP 1
    tipselect
  }
  else {
    if (%i > $line(@TribesIP, 0)) dec %i 
    sline @TribesIP %i
    did -c TIP 7 $calc(%i - %loadfavorites + 1)
  }
}

on 1:dialog:TIP:sclick:99: joinprint

on 1:dialog:TIP:sclick:139: {
  if ($did(132) != $null) {
    addip server $did(134) [[ $+ IP: $+ $did(132) $+ ]]
    did -r TIP 132,134
  }
}

on 1:dialog:TIP:sclick:140: {
  did -r TIP 132,134
}

on 1:dialog:TIP:sclick:141: {
  getserver $sline(@TribesIP, 1)
  validIP
  did -r TIP 132,134
  did -a TIP 132 $deltok(%address,1,58)
  did -a TIP 134 %servername
}

alias tiprefreshserverlist {
  if ($dialog(TIP) != TIP) halt
  refreshtipfaves
  refreshtipcaught
  tipselect
}

alias refreshtipfaves {
  var %i = 1

  did -r TIP 9

  :tipserversloop1
  if ($line(@TribesIP, %i) != $null && %i < %loadfavorites) {
    did -a TIP 9 $line(@TribesIP, %i)
    inc %i
    goto tipserversloop1
  }

  did -c TIP 9 $sline(@TribesIP, 1).ln
}

alias refreshtipcaught {
  var %i = %loadfavorites
  did -r TIP 7

  :tipserversloop2
  if ($line(@TribesIP, %i) != $null) {
    did -a TIP 7 $line(@TribesIP, %i)
    inc %i
    goto tipserversloop2
  }

  did -c TIP 7 $sline(@TribesIP, 1).ln
}

alias tipselect {
  if ($sline(@TribesIP,1).ln < %loadfavorites) {
    did -u TIP 7
    did -c TIP 9 $sline(@TribesIP,1).ln
    did -a TIP 88 Delete IP from Favs
    did -e TIP 91,92
    did -b TIP 93
  }
  else {
    did -u TIP 9
    did -c TIP 7 $calc($sline(@TribesIP,1).ln - %loadfavorites + 1)
    did -a TIP 88 Add IP to Favorites
    did -b TIP 91,92
    did -e TIP 93
  }
}

alias chooseplayer {
  var %i = %loadfavorites

  if (%loadfavorites < 1) %loadfavorites = 1
  if ($dialog(TIP) != TIP) dialog -m TIP TIPchoose

  if ($1 == $null) tipselect
  else {
    :chooseplayerloop
    if ($1 !isin $line(@TribesIP, %i)) {
      inc %i
      if ($line(@TribesIP, %i) == $null) {
        getserver $1-
        if (IP:10. isin %address || IP:192.168. isin %address || IP:127.0.0.1 isin %address) halt
        iline @TribesIP %loadfavorites $timestamp $nick says: server %servername [[ $+ %address $+ ]]
        sline @TribesIP %loadfavorites
        tiprefreshserverlist
      }
      else goto chooseplayerloop
    }

    else sline @TribesIP %i $calc(%i - %loadfavorites + 1)

    did -a TIP 88 Add IP to Favorites
    did -u TIP 9
    did -b TIP 91,92
    did -e TIP 93
    did -c TIP 7 $calc(%i - %loadfavorites + 1)
  }
}

on 1:dialog:TIP:sclick:101: {
  did -h TIP 203
  if (%TIPnotifymsg != $null) {
    did -a TIP 10 Notify Joiners: ON
    did -c TIP 10
  }
  else did -u TIP 10
}

on 1:dialog:TIP:sclick:102: {
  raffaves
  rafimport
  did -h TIP 203
  did -b TIP 110,111
}

on 1:dialog:TIP:sclick:103: {
  did -h TIP 203
  tipnotifynames
}

on 1:dialog:TIP:sclick:105: readmeimport

alias readmeimport {
  var %file = $shortfn($mircdir) $+ TribesIPreadme.txt

  did -r TIP 202
  if ($exists(%file)) loadbuf -o TIP 202 %file
  else did -a TIP 202 %file not found! Please unzip all TribesIP files into your mIRC directory!
  did -v TIP 203
}

alias rafimport {
  var %i, %file = %tribespath $+ config\GameServerList.cs

  did -r TIP 107
  if ($exists(%file)) {
    window -lsnhk @TribesIPimport
    loadbuf @TribesIPimport %file

    %i = $line(@TribesIPimport,0)
    :sortlistloop1
    if (addGameServer isin $line(@TribesIPimport, %i)) {
      rline @TribesIPimport %i server $gettok($line(@TribesIPimport,%i),4,34) [[ $+ $gettok($line(@TribesIPimport,%i),2,34) $+ :00 $+ ]]
    }
    else dline @TribesIPimport %i
    dec %i
    if (%i > 0) goto sortlistloop1

    %i = 0
    :sortlistloop2
    inc %i
    if (%i <= $line(@TribesIPimport,0)) {
      did -a TIP 107 $line(@TribesIPimport,%i)
      goto sortlistloop2
    }
    window -c @TribesIPimport
    did -e TIP 107
  }
  else {
    did -a TIP 107 GameServerList.cs does not exist! Please refresh the server list from within Tribes!
    did -b TIP 107
  }
}

alias raffaves {
  var %i = 1
  did -r TIP 109
  :tipserversloop1
  if ($line(@TribesIP, %i) != $null && %i < %loadfavorites) {
    did -a TIP 109 $line(@TribesIP, %i)
    inc %i
    goto tipserversloop1
  }
}

on 1:dialog:TIP:sclick:107: did -e TIP 110

on 1:dialog:TIP:sclick:109: {
  did -u TIP 7
  did -e TIP 111
  sline @TribesIP $did(109).sel
}

on 1:dialog:TIP:sclick:110: {
  if ($did(107).sel != $null) {
    getserver $did(107,$did(107).sel).text
    write $shortfn($mircdir) $+ TribesIPfavorites.txt TribesIP: server %servername [[ $+ %address $+ ]]
    iline -s 7 @TribesIP %loadfavorites TribesIP: server %servername [[ $+ %address $+ ]]
    inc %loadfavorites
    tiprefreshserverlist
    raffaves
    did -c TIP 109 $sline(@TribesIP,1).ln
    did -e TIP 111
  }
}

on 1:dialog:TIP:sclick:111: {
  if ($did(109).sel != $null) {
    did -d TIP 109 $sline(@TribesIP,1).ln
    did -d TIP 9 $sline(@TribesIP,1).ln
    delfavorites
    tipselect
    did -c TIP 109 $sline(@TribesIP,1).ln
  }
}

on 1:dialog:TIP:sclick:158: {
  did -r TIP 154,156,159
  did -u TIP 152
  did -a TIP 159 - Press the Update Server button -
}

on 1:dialog:TIP:sclick:157: {
  var %i = 0, %chanstr
  validIP
  if ($did(152,0).sel == 0 || $did(156) == $null) {
    unset %TIPnotifymsg
    unset %TIPchanstr
    unset %TIPmatchstr
    unset %TIPnotifyIP
    echo -s 
    echo -s Auto-notice joiners disabled! ( $+ $iif($did(156) == $null, No notice text, No channels chosen) $+ )
    halt
  }
  else if (You need to select a server in the Chooser! isin $did(159) || Press the Update Server button isin $did(159)) {
    echo -s 
    echo -s Auto-notice joiners disabled! (No server chosen)
    halt
  }

  :TIPanjloop
  inc %i
  if (%i <= $did(152,0).sel) {
    %chanstr = %chanstr $+ $iif(%i != 1, $chr(44)) $+ $gettok($did(152, $did(152,%i).sel), 1, 32)
    goto TIPanjloop
  }

  %TIPchanstr = %chanstr
  %TIPmatchstr = $did(154)
  %TIPnotifymsg = $did(156)
  %TIPnotifyIP = $did(159)

  echo -s 
  echo -s Auto-notice joiners enabled! 
  echo -s 
  echo -s Matchstring: $iif(%TIPmatchstr == $null, (none), %TIPmatchstr)
  echo -s Channels: %TIPchanstr
  echo -s Message: ( $+ %TIPnotifymsg $+ ) Repost via TribesIP: %TIPnotifyIP
}

on 1:dialog:TIP:sclick:160: {
  if ($sline(@TribesIP,0) == 0) {
    did -r TIP 159
    did -a TIP 159 You need to select a server in the Chooser! (Join Server page)
  }
  else {
    getserver $sline(@TribesIP, 1)
    validIP
    did -r TIP 159
    did -a TIP 159 server %servername [[ $+ %address $+ ]]
  }
}

alias tipnotifynames {
  var %i = 0
  did -r TIP 152
  :TIPchanloop
  inc %i
  if (%i <= $chan(0)) {
    did -a TIP 152 $chan(%i)
    goto TIPchanloop
  }
  did -a TIP 152 * (all channels)
  %i = 0
  :TIPchanloop2
  inc %i
  if (%i <= $did(152).lines) {
    if ($istok(%TIPchanstr, $gettok($did(152, %i).text, 1, 32), 44)) did -kc TIP 152 %i
    goto TIPchanloop2
  }
  did -r TIP 159
  if (%TIPnotifyIP == $null) did -a TIP 159 - Press the Update Server button -
  else {
    did -a TIP 159 %TIPnotifyIP
  }
  did -r TIP 154
  did -a TIP 154 %TIPmatchstr
  did -r TIP 156
  did -a TIP 156 %TIPnotifymsg
}

; (c)1999 "Cowboy" Ben Alman, please do not modify or copy this in any way without my permission, thank you!
