; !!!!!!!!!! TribesIP 2.4 - written by Rasia, modified and fixed by Cowboy !!!!!!!!!!
;
; Original by: Rasia
;              rasia@planetstarsiege.com
;              http://www.planetstarsiege.com/TheDen/
;
; Reworked by: Cowboy
;              cowboy@planetstarsiege.com
;              http://www.planetstarsiege.com/cowboy/
;              ICQ# 31184463
;
; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;
; Installation:    Unzip the TribesIP.mrc and TribesIP.txt files in your mirc 
;                  directory. At the status window in mirc, type:
;
;                  /load -rs TribesIP.mrc
;
;                  NOTE: Do _NOT_ put this line in your 'IRC perform On Connect'
;                        If you do, it will try to reinstall EVERY TIME you connect!
;
;                  Follow the on-screen instructions!
;
; ALSO! If you run mIRC 5.6, you have to enable the /run command for TribesIP to be
;       able to execute Tribes! Here's how to do it: Go into the OPTIONS screen
;       (Alt-D, O) then General -> Lock and UNCHECK the 'Disable /run' option!
;
; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;
; New features in 2.4: Some bugfixes, changed the "give IP to nick" to a /notice,
;                      but the "give IP to nick" in a query window just does a /msg.
;                      Also, added the ability to do string-matching in the "auto-
;                      notify joiners" so you can just give a server to tribesmates
;                      if you'd like! Also, added the ability to add or delete
;                      individual channels from the "auto-notify joiners" list. :)
;
; New features in 2.3: Now works with mIRC 5.6! Allow you to import servers from
;                      config\GameServerList.cs! (you still have to 'refresh' in
;                      Tribes) Opens up a seperate window that you can join from,
;                      post from, or select a line (or lines) to add to your
;                      Favorites! Also, added the /addIP command, you can type in
;                      anywhere to manually add an ip / join server.
;
;    Proper syntax is: /addIP server SERVER NAME [validIPaddress]
;                  or: /addIP [validIPaddress] 
;
;                      Also, I changet the 'away' message to be in the correct
;                      TribesIP format, so you can do a /whois on someone, and cut &
;                      paste that line directly into TribesIP to add it to the list!
;                      Oh yeah... now the Auto-notify joiners works! I use /notice
;                      (instead of /msg) to send a private message to whoever joins
;                      the channel(s) you set it to! ... and I just cleaned up alot
;                      of the code too!
;
; New features in 2.1: Deletes duplicates in the list, only keeps the most recent
;                      one (doesn't affect favorites)! Also, added 'Join last
;                      added server' option to the channel menu!
;
; New features in 2.0: Favorites! Save all your favorite servers! Also, filters
;                      out local-only IP masks 10.*.*.*, 192.168.*.*, 127.0.0.1
;                      so you don't have to deal with links you can't use! Shows
;                      state in TribesIP windowbar, can now Post IP, don't join
;                      multiple servers! Fixed the 'directory long-filename' bug!
;                      Oh yeah, enhanced installation script! Much nicer now!
;
; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;
; I first saw TribesLinker on Rasia's old page (on fortunecity, before he moved
; to PSS).. and as I had already been working on a Tribes IP Linker, I figured
; I'd check his out... Well, it was WAY better than mine.. Creating a separate
; window for the captured IP links was ingenious!
;
; A few problems though, is the installation procedure was problematic, with
; no error-checking.. And it wouldn't actually create a working .bat file!
;
; Also, I play alot of password-protected servers, so I *needed* to be able to
; join a server with the right password!
;
; So, I modified his script, cleaned it up, got it working...
;
; Note: Sets you marked as 'away' when you connect, this was a requested feature!
;
; All the servers you detect will be in the TribesIP window that this script
; creates when you connect to the server. If it doesn't create it the first time,
; no worries, just goto your Commands menu (its up ther by DCC, File, edit, etc.)
; There should be a Tribes IP Catcher menu option - just hit it, and boom, done.
; Also, this is the way to restart the window if you close it accidentally.
;
; Once you have a server in the TribesIP window, you can doubleclick to connect
; to it, or you can right click to get some options. NOTE: All these options, when
; activated via the TribesIP window will result in GLOBAL notification! If you only
; want to notify people on a per-channel or individual basis, click the channel or
; nicklist panels!
;
; Clicking in individual Channel windows will give you options that pertain to that
; specific channel ONLY! If you don't want to notify globally, you don't have to!
; Also, you can /notice a selected IP to a specific nickname (click the nicklist)
;
; Here are the basic options: (there are some other more obvious options in the menus)
;
; Join selected server -------- Joins the server, lets you type in a password for the 
;                               server. If you just hit <enter> it uses the last Tribes
;                               password (or no password if it's unnecessary)
; Join last added server ------ Joins the most recently added server into the TribesIP
;                               listbox. (appears only in the channel menu)
; Tribes Main Menu ------------ Just start tribes, like you clicked its Windows icon.
;
; Add selected to Favorites --- Adds selected lines to TribesIPfavorites.txt
; Remove selected from Favs --- Deletes selected lines from TribesIPfavorites.txt
;
; Enter manual IP (and join?) - Lets you manually type in a server name and/or IP to
;                               be added to the TribesIP listbox. If you want, you
;                               can then choose to join it!
; Post IP, don't join --------- Only posts the server in all your channels (no join)
;
; Delete selected line(s) ----- Deletes the selected lines from the TribesIP window.
;                               Note: if you want to delete a 'favorites' line, you
;                               must first remove it from the favorites list!
;
; Toggle auto-notify joiners -- Anytime someone Joins a channel you are on, it will
;                               send a private msg to them with the message that you
;                               specify, as well as the server IP of the currently
;                               selected server.
;
; Toggle demo record mode ----- Lets you toggle whether or not you want to record a
;                               demo! (also shows current status) Basically, it adds
;                               the +record parameter to the Tribes command line until
;                               you disable it! (defaults to disabled on startup)
;
; About TribesIP -------------- Gives you some info! (Tells you where to send your
;                               donations.. hehehe)
;
; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

on 1:LOAD: {
  //echo 8 -s TribesIP 2.4 - written by Rasia, modified and fixed by Cowboy
  //echo 4 -es Performing one-time initialization for this script!
  //echo 8 -es This is only to create the file %MircDirectory $+ TribesIP.bat and config\TribesIPrecord.cs that will be used to run Tribes!
  //echo 9 -es In the dialog box, select the executable file you use to run Tribes! Normally this will be TRIBES.EXE, but if you run TimeHUD, you should select TIMEHUD.EXE!

  %fullpath = $dir[="Select your Tribes Executable..."] c:\*.exe
  if (%fullpath == $null) { /beep | /echo 4 -es No Tribes executable file selected! Installation aborted! | /goto quit }
  /set %fullpath $shortfn(%fullpath)
  /set %exename $gettok(%fullpath,$numtok(%fullpath,92),92)
  /set %tribespath $deltok(%fullpath,$numtok(%fullpath,92),92) $+ \
  %tribesdrive = $gettok(%tribespath, 1, 92)
  %tribesdir = \ $+ $deltok(%tribespath,1,92)

  if (%exename == timehud.exe) { /set %timehud 1 | /set %exename start /m %exename }

  /set %MircDirectory $shortfn($mircdir)

  write -c %MircDirectory $+ TribesIP.bat
  write %MircDirectory $+ TribesIP.bat @echo off
  write -i %MircDirectory $+ TribesIP.bat 
  write %MircDirectory $+ TribesIP.bat echo !!!!!!!! TribesIP 2.4 - written by Rasia, modified and fixed by Cowboy !!!!!!!!
  write %MircDirectory $+ TribesIP.bat echo.
  write %MircDirectory $+ TribesIP.bat echo Cowboy
  write %MircDirectory $+ TribesIP.bat echo cowboy@planetstarsiege.com
  write %MircDirectory $+ TribesIP.bat echo http://www.planetstarsiege.com/cowboy/
  write %MircDirectory $+ TribesIP.bat echo ICQ# 31184463
  write %MircDirectory $+ TribesIP.bat echo.
  write %MircDirectory $+ TribesIP.bat echo If you need to use any other command line parameters, you can just add them in
  write %MircDirectory $+ TribesIP.bat echo at the end of the appropriate line! ( $+ %MircDirectory $+ TribesIP.bat)
  write %MircDirectory $+ TribesIP.bat echo.
  write -i %MircDirectory $+ TribesIP.bat 
  write %MircDirectory $+ TribesIP.bat echo Changing directory to: %tribespath
  write -i %MircDirectory $+ TribesIP.bat 
  write %MircDirectory $+ TribesIP.bat %tribesdrive
  write %MircDirectory $+ TribesIP.bat cd $+ %tribesdir
  write -i %MircDirectory $+ TribesIP.bat 
  write %MircDirectory $+ TribesIP.bat echo.
  write %MircDirectory $+ TribesIP.bat echo Running: %exename % $+ 1 % $+ 2 % $+ 3 % $+ 4 % $+ 5 % $+ 6 % $+ 7 % $+ 8 % $+ 9
  write -i %MircDirectory $+ TribesIP.bat
  write %MircDirectory $+ TribesIP.bat %exename % $+ 1 % $+ 2 % $+ 3 % $+ 4 % $+ 5 % $+ 6 % $+ 7 % $+ 8 % $+ 9
  write -i %MircDirectory $+ TribesIP.bat 
  if (%timehud == 1) {
    write %MircDirectory $+ TribesIP.bat echo.
    write %MircDirectory $+ TribesIP.bat echo Since you are running TimeHUD, it's executed via "start /m" to minimize it!
    write %MircDirectory $+ TribesIP.bat echo (You can edit the file %MircDirectory $+ TribesIP.bat manually to change this)
  }
  write %MircDirectory $+ TribesIP.bat echo.
  write %MircDirectory $+ TribesIP.bat echo You'll notice that this DOS-box stays up after you choose to connect to a game 
  write %MircDirectory $+ TribesIP.bat echo using TribesIP. This is normal, but annoying... What you can do to make it go
  write %MircDirectory $+ TribesIP.bat echo away is go to its Properties box (Alt-Space, P) check the 'Close on Exit' box
  write %MircDirectory $+ TribesIP.bat echo and then the 'OK' button. Every time henceforth, it will close automatically!

  //echo 9 -es File %MircDirectory $+ TribesIP.bat created successfully!

  /set %configdir %tribespath $+ config\
  :badconfigdir
  if ($isdir(%configdir) == $false) {
    //echo 4 -es Directory %configdir does not exist! Please choose the correct tribes\config directory!
    /set %configdir $sdir[="Select your Tribes CONFIG directory..."]
    if (%configdir == $null) { /beep | /echo 4 -es No tribes\config directory selected! Installation aborted! | /goto quit }
    /goto badconfigdir
  }
  else {
    write -c %configdir $+ TribesIPrecord.cs
    write %configdir $+ TribesIPrecord.cs // This file is used by TribesIP 2.4, don't worry about it!
    write %configdir $+ TribesIPrecord.cs
    write %configdir $+ TribesIPrecord.cs setupRecorderFile();
    //echo 9 -es File %configdir $+ TribesIPrecord.cs created successfully!
  }

  //echo 4 -s Do not delete the variables "%tribespath" or "%MircDirectory"! If either of these gets deleted, it could mess up the external file-handling of TribesIP, and will have to re-run this install!
  //echo 8 -es TribesIP should be loaded now, but minimized. If it becomes unloaded, you can click on the Commands Menu -> Tribes IP Catcher to start it again. (It will load MINIMIZED automatically on connect) If you use TimeHUD or any additional command-line options, you will have to manually edit the %MircDirectory $+ TribesIP.bat file! Thanks and good luck!
  //echo 9 -s Visit Cowboy's Web Page! http://www.planetstarsiege.com/cowboy/

  /showwindow -lkne

  :quit
  unset %exename
  unset %timehud
  unset %yesnoquestion
  unset %tribesdrive
  unset %tribesdir
  unset %fullpath
  unset %pathlen
  unset %yesno
}

on 1:CONNECT: {
  /set %recordstate Disabled
  /unset %recordline
  /set %notifystate Disabled
  /unset %joinermessage
  /unset %lastgrabbed
  /showwindow -lkne
  if ($line(@TribesIP, 0) == 0) /loadfavorites
  /showtitle
}

on 1:TEXT:*[IP*:#,?: {
  ;/if ($chan == #tribes) /halt
  /getserver $1-
  if (IP:10. isin %address) /halt
  else if (IP:192.168. isin %address) /halt
  else if (IP:127.0.0.1 isin %address) /halt
  /aline @TribesIP $timestamp $nick says: server %servername [[ $+ %address $+ ]]
  /set %newestservername %servername
  /set %newestaddress %address
  /deldupes
}

on 1:ACTION:*[IP*:#,?: {
  ;/if ($chan == #tribes) /halt
  /getserver $1-
  if (IP:10. isin %address) /halt
  else if (IP:192.168. isin %address) /halt
  else if (IP:127.0.0.1 isin %address) /halt
  /aline @TribesIP $timestamp $nick says: server %servername [[ $+ %address $+ ]]
  /set %newestservername %servername
  /set %newestaddress %address
  /deldupes
}

on 1:NOTICE:*[IP*:#,?: {
  /getserver $1-
  if (IP:10. isin %address) /halt
  else if (IP:192.168. isin %address) /halt
  else if (IP:127.0.0.1 isin %address) /halt
  /aline @TribesIP $timestamp $1-
  ;  /aline @TribesIP $timestamp $nick says: server %servername [[ $+ %address $+ ]]
  /set %newestservername %servername
  /set %newestaddress %address
  /deldupes
}

on 1:JOIN:%notifyscope: {
  if (%notifystate == Enabled) {
    if ((%notifyfilter isincs $nick) || (%notifyfilter == disabled)) {
      /notice $nick %joinermessage
    }
  }
}
alias getsetpassword {
  /set %passstring $?="Please Type Server Password: $+ $crlf $+ (or <enter> for none/last)"
  if (%passstring == $null) /goto exitpasswordgetterfunction
  /write -ds$Server::JoinPassword %tribespath $+ config\ServerPrefs.cs
  /write %tribespath $+ config\ServerPrefs.cs $ $+ Server::JoinPassword = " $+ %passstring $+ ";
  //echo 9 -es Password set to: %passstring
  :exitpasswordgetterfunction
}

alias joinprint {
  /tribeconnect +connect %address
  if ($1 = global) {
    /ame left via TribesIP to join server %servername [[ $+ %address $+ ]]
    /away $timestamp TribesIP: Playing at server %servername [[ $+ %address $+ ]]
  }
  else {
    /me left via TribesIP to join server %servername [[ $+ %address $+ ]]
    /away $timestamp TribesIP: Playing at server %servername [[ $+ %address $+ ]]
  }
}

alias getserver {
  /set %serverindex 0
  /set %servername (Unknown)
  :startgetserver
  /inc %serverindex
  set %findserverword $gettok($1-,%serverindex,32)
  if (server === %findserverword) {
    /unset %servername
    :startaddserver
    /inc %serverindex
    /set %findserverword $gettok($1-,%serverindex,32)
    if ([IP isin %findserverword) {
      /set %iplength $calc($len(%findserverword) - 2)
      /set %address $mid(%findserverword,2,%iplength)
      /goto exitgetserver
    }
    /set %servername %servername %findserverword
    /goto startaddserver
  }
  if ([IP isin %findserverword) {
    /set %iplength $calc($len(%findserverword) - 2)
    /set %address $mid(%findserverword,2,%iplength)
    /goto exitgetserver
  }
  if (%findserverword == $null) {
    /unset %iplength
    /unset %getipindex
    /unset %getipword
    /unset %address

    /beep
    //echo 4 -s Oops! You have to Enter IP (w/ optional server name) in format:
    //echo 8 -s server SERVER NAME [validIPaddress] 4or just 8[validIPaddress] 
    //echo 4 -s example: 8server Big Deal [IP:123.4.5.67:28001:00]

    /halt
  }
  /goto startgetserver
  :exitgetserver
  /unset %iplength
  /unset %getipindex
  /unset %getipword
}

alias showwindow {
  if (%tribespath == $null) { /beep | /echo 4 -es Variable "%tribespath" has become unset, please re-install TribesIP! }
  if (%notifystate == Enabled) /echo 9 -es Auto-notify joiners still Enabled: %joinermessage %notifychan
  if (%recordstate == Enabled) /echo 9 -es Demo recording still Enabled!
  /window $1 @TribesIP /addIP @TribesConnect
}

alias deletelines {
  :loopdeletelines
  if ($sline(@TribesIP, 0) > 0) {
    if ($sline(@TribesIP, 1).ln < %loadfavorites) {
      /sline -r @TribesIP $sline(@TribesIP, 1).ln
    }
    else /dline @TribesIP $sline(@TribesIP, 1).ln
    goto loopdeletelines
  }
}

alias loadfavorites {
  /set %loadfavorites 0
  :loadfavoritesloop
  /inc %loadfavorites
  /set %lftemp %MircDirectory $+ TribesIPfavorites.txt
  if ($exists(%lftemp) == $false) { /unset %lftemp | /halt }
  /unset %lftemp
  /loadbuf %loadfavorites $+ - $+ %loadfavorites -c7 @TribesIP %MircDirectory $+ TribesIPfavorites.txt
  if ($line(@TribesIP, %loadfavorites) != $null) goto loadfavoritesloop
}

alias addfavorites {
  :loopaddfavorites
  if ($sline(@TribesIP, 0) > 0) {
    if ($sline(@TribesIP, 1).ln < %loadfavorites) {
      /sline -r @TribesIP $sline(@TribesIP, 1).ln
    }
    else {
      /getserver $sline(@TribesIP, 1)
      /dline @TribesIP $sline(@TribesIP, 1).ln
      /write %MircDirectory $+ TribesIPfavorites.txt TribesIP: server %servername [[ $+ %address $+ ]]
      /iline 7 @TribesIP %loadfavorites TribesIP: server %servername [[ $+ %address $+ ]]
      /inc %loadfavorites
    }
    /goto loopaddfavorites
  }
}

alias delfavorites {
  :loopdelfavorites
  if ($sline(@TribesIP, 0) > 0) {
    if ($sline(@TribesIP, $sline(@TribesIP, 0)).ln >= %loadfavorites) {
      /sline -r @TribesIP $sline(@TribesIP, $sline(@TribesIP, 0)).ln
    }
    else {
      /getserver $sline(@TribesIP, $sline(@TribesIP, 0))
      /write -dl $+ $sline(@TribesIP, $sline(@TribesIP, 0)).ln %MircDirectory $+ TribesIPfavorites.txt
      /dline @TribesIP $sline(@TribesIP, $sline(@TribesIP, 0)).ln
      /dec %loadfavorites
      /iline @TribesIP %loadfavorites TribesIP: server %servername [[ $+ %address $+ ]]
    }
    /goto loopdelfavorites
  }
}

alias autonotifytoggle {
  /unset %notifyscope
  /unset %notifychan
  /set %notifyfilter disabled
  if (%notifystate == Enabled) { 
    /set %notifystate Disabled
    /unset %joinermessage
    /echo 4 -es Auto-notify joiners Disabled!
  }
  else {
    if ($sline(@TribesIP, 0) == 0) {
      /echo 4 -es You MUST select a server to auto-join notify!
      /unset %joinermessage
    }
    else {
      /set %joinermessage $$?="What do you want it to say to joiners?"

      /set %wordserver $findtok(%joinermessage,server,0,32)
      :loopchangewordserver
      if (%wordserver > 0) {
        /set %joinermessage $reptok(%joinermessage,server,Server,%wordserver,32)
        /dec %wordserver
        /goto loopchangewordserver
      }
      /unset %wordserver

      /set %notifyfilter $?="Match string for auto-notify? $crlf $+ Ex. [DTM] will only notify users with [DTM] in their nick. (Leave blank if none)"
      /if (%notifyfilter == $null) /set %notifyfilter disabled

      /getserver $sline(@TribesIP, 1) 
      /set %joinermessage Welcome! ( $+ %joinermessage $+ ) Repost via TribesIP: server %servername [[ $+ %address $+ ]]
      /set %notifystate Enabled
      if ($1 == global) {
        /set %notifyscope $chr(35)
        /set %notifychan -> global
      }
      else {
        /set %notifyscope $chan
        /set %notifychan -> $chan
      }
      /echo 9 -es Auto-notify joiners Enabled: %joinermessage %notifychan $+ , Match String: %notifyfilter
    }
  }
  /showtitle
}

alias postnojoin {
  :looppostnojoin
  if ($sline($1, 0) > 0) {
    /getserver $sline($1, 1)
    /sline -r $1 $sline($1, 1).ln
    if ($2 == global) /ame reposts via TribesIP: server %servername [[ $+ %address $+ ]]
    else /me reposts via TribesIP: server %servername [[ $+ %address $+ ]]
    /goto looppostnojoin
  }
}

alias showtitle {
  /if (%notifystate == Enabled) /titlebar @TribesIP - Demo record mode ( $+ %recordstate $+ ) - Auto-notify joiners ( $+ %notifystate $+ %notifychan $+ , Match string: %notifyfilter $+ ) %joinermessage
  /else /titlebar @TribesIP - Demo record mode ( $+ %recordstate $+ ) - Auto-notify joiners ( $+ %notifystate $+ ) %joinermessage
}

alias deldupes {
  /set %numdeldupes $line(@TribesIP, 0)
  /set %deldupesaddress [[ $+ %address $+ ]]
  :loopdeldupes
  if (%numdeldupes <= %loadfavorites) { /unset %deldupesaddress | /unset %numdeldupes | /goto exitdeldupes }
  /dec %numdeldupes
  if ($gettok($line(@TribesIP, %numdeldupes), $numtok($line(@TribesIP, %numdeldupes), 32), 32) == %deldupesaddress) /dline @TribesIP %numdeldupes
  goto loopdeldupes
  :exitdeldupes
}

alias manualipadd {
  /getserver $$?="Enter IP (w/ optional server name) in format $+ $crlf $+ server SERVER NAME [validIPaddress] $+ $crlf $+ or just: [validIPaddress] $+ $crlf $+ ex: server Big Deal [IP:123.4.5.67:28001:00]"
  /aline @TribesIP $timestamp You manually added: server %servername [[ $+ %address $+ ]]
  /set %newestservername %servername
  /set %newestaddress %address
  /deldupes
  if ($?!="Would you like to join this server now?" == $false) /halt
  /getsetpassword
  /joinprint $1
}

alias addip {
  /getserver $1-
  /aline @TribesIP $timestamp You manually added: server %servername [[ $+ %address $+ ]]
  /set %newestservername %servername
  /set %newestaddress %address
  /deldupes
  if ($?!="Would you like to join this server now?" == $false) /halt
  /getsetpassword
  /joinprint global
}

alias demotoggle {
  if (%recordstate == Enabled) { /set %recordstate Disabled | /unset %recordline | /echo 4 -es Demo recording Disabled! }
  else { /set %recordstate Enabled | /set %recordline +exec TribesIPrecord.cs +record | /echo 9 -es Demo recording Enabled! }
  /showtitle
}

alias abouttribesip {
  if ($?!="TribesIP 2.4 $crlf $+ by Rasia, modified and fixed by Cowboy $crlf $crlf $+ cowboy@planetstarsiege.com $crlf $+ http://www.planetstarsiege.com/cowboy/ $crlf $crlf $+ Read the file TribesIP.txt for more information! $crlf $crlf $+ Thanks!" == sillylittleperson) {}
}

alias loadlist {
  /window -lks @ServerList @TribesServerList
  /titlebar @ServerList Loading GameServerList.cs... This may take a few seconds...
  /loadbuf @ServerList %configdir $+ GameServerList.cs

  /set %sortlist $line(@Serverlist,0)
  :sortlistloop
  if (addGameServer isin $line(@ServerList, %sortlist)) {
    /rline @ServerList %sortlist server $gettok($line(@ServerList,%sortlist),4,34) [[ $+ $gettok($line(@ServerList,%sortlist),2,34) $+ :00 $+ ]]
  }
  else /dline @Serverlist %sortlist
  /dec %sortlist
  if (%sortlist > 0) goto sortlistloop

  /unset %cleanlist
  /titlebar @ServerList GameServerList.cs loaded! Double-click to add line to Favorites!

}

alias addlistfavorites {
  :loopaddlistfavorites
  if ($sline(@ServerList, 0) > 0) {
    /getserver $sline(@ServerList, 1)
    /write %MircDirectory $+ TribesIPfavorites.txt TribesIP: server %servername [[ $+ %address $+ ]]
    /rline 7 @ServerList $sline(@ServerList, 1).ln server %servername [[ $+ %address $+ ]]
    /iline 7 @TribesIP %loadfavorites TribesIP: server %servername [[ $+ %address $+ ]]
    /inc %loadfavorites
    /goto loopaddlistfavorites
  }
}

menu Menubar {
  Start TribesIP: {
    /showwindow -lke
    if ($line(@TribesIP, 0) == 0) /loadfavorites
    /showtitle
  }
}

menu channel {
  TribesIP
  .Join selected server: {
    /getserver $sline(@TribesIP, 1)
    /getsetpassword
    /joinprint
  }
  .Join last added server {
    /set %servername %newestservername
    /set %address %newestaddress
    /getsetpassword
    /joinprint
  }
  .Tribes Main Menu: {
    /me left via TribesIP to play Tribes...
    /away TribesIP: In Tribes... $timestamp
    /tribeconnect
  }
  .-
  .Enter manual IP (and join?): { /manualipadd }
  .Post IP, don't join: { /postnojoin @TribesIP }
  .-
  .Toggle auto-notify joiners ( $+ %notifystate $+ %notifychan $+ ): { /autonotifytoggle }
  .Add this channel to auto-notify list: {
    /if ((%notifystate == enabled) && (# !isin %notifychan)) {
      /if (%notifyscope == $chr(35)) {
        /set %notifychan -> #
        /set %notifyscope #
      }
      /else {
        /set %notifychan %notifychan $+ , $+ #
        /set %notifyscope %notifyscope $+ , $+ #
      }
    }
  }
  .Remove this channel from auto-notify list: {
    /if ((%notifystate == enabled) && (# isin %notifychan)) {
      /set %notifyscope $remtok(%notifyscope,#,1,44)
      /set %notifychan -> %notifyscope
      /if (%notifyscope == $null) /autonotifytoggle
    }
  }
  .-
  .Toggle demo record mode ( $+ %recordstate $+ ): { /demotoggle }
  .-
  .About TribesIP: { /abouttribesip }
}

menu nicklist {
  TribesIP
  .Give IP to ...: {
    if ($sline(@TribesIP, 1) != $null) {
      if ($$1 != $null) {
        /getserver $sline(@TribesIP, 1)
        /notice $$1 reposts via TribesIP: server %servername [[ $+ %address $+ ]]
      }
      else { /beep | echo 4 -es You MUST select a nickname to give the IP to! }
    }
    else { /beep | echo 4 -es You MUST select a server to give! }
  }
  .-
  .(Status Only) Auto-notify joiners ( $+ %notifystate $+ %notifychan $+ , %notifyfilter $+ ): {}
  .(Status Only) Demo record mode ( $+ %recordstate $+ ): {}
  .-
  .About TribesIP: { /abouttribesip }
}

menu query {
  TribesIP
  .Give IP to ...: {
    if ($sline(@TribesIP, 1) != $null) {
      if ($$1 != $null) {
        /getserver $sline(@TribesIP, 1)
        /msg $$1 reposts via TribesIP: server %servername [[ $+ %address $+ ]]
      }
      else { /beep | echo 4 -es You MUST select a nickname to give the IP to! }
    }
    else { /beep | echo 4 -es You MUST select a server to give! }
  }
  .-
  .(Status Only) Auto-notify joiners ( $+ %notifystate $+ %notifychan $+ , %notifyfilter $+ ): {}
  .(Status Only) Demo record mode ( $+ %recordstate $+ ): {}
  .-
  .About TribesIP: { /abouttribesip }
}

menu @TribesConnect {
  dclick: {
    /getserver $sline(@TribesIP, 1)
    /getsetpassword
    /joinprint global
  }
  NOTE, Anything done through this menu will be global!: {}
  If you want to operate on a per-channel basis, select: {}
  The TribesIP menu in the specific Channel window!: {}
  -
  Join selected (optional password): {
    /getserver $sline(@TribesIP, 1)
    /getsetpassword
    /joinprint global
  }
  Tribes Main Menu: {
    /ame left via TribesIP to play Tribes...
    /away TribesIP: In Tribes... $timestamp
    /tribeconnect
  }
  -
  Add selected line(s) to Favorites: { /addfavorites }
  Remove selected line(s) from Favorites: { /delfavorites }
  -
  Import servers from GameServerList.cs: { /loadlist }
  -
  Enter manual IP (and join?): { /manualipadd global }
  Post IP, don't join: { /postnojoin @TribesIP global }
  -
  Delete selected line(s): { /deletelines }
  -
  Toggle auto-notify joiners ( $+ %notifystate $+ %notifychan $+ , %notifyfilter $+ ): { /autonotifytoggle global }
  -
  Toggle demo record mode ( $+ %recordstate $+ ):  { /demotoggle }
  -
  About TribesIP: { /abouttribesip }
}

menu @TribesServerList {
  dclick: { /addlistfavorites }
  Add selected line(s) to Favorites: { /addlistfavorites }  
  -
  Join selected (optional password): {
    /getserver $sline(@ServerList, 1)
    /getsetpassword
    /joinprint global
  }
  Tribes Main Menu: {
    /ame left via TribesIP to play Tribes...
    /away TribesIP: In Tribes... $timestamp
    /tribeconnect
  }
  -
  Post IP, don't join: { /postnojoin @ServerList global }
  -
  About TribesIP: { /abouttribesip }
}

alias tribeconnect {
  //echo 9 -es start TribesIP.bat $1- %recordline 
  /run start TribesIP.bat $1- %recordline 
}
