; !!!!!!! TribesIP 2.0 - written by Rasia, modified and fixed by Cowboy !!!!!!!
;
; Original by:
;              Rasia
;              rasia@planetstarsiege.com
;              http://www.planetstarsiege.com/TheDen/
;
; Reworked by:
;              Cowboy
;              cowboy@planetstarsiege.com
;              http://www.planetstarsiege.com/cowboy/
;              ICQ# 31184463
;
; New features in 2.0: Favorites! Save all your favorite servers! Also, filters
;                      out local-only IP masks 10.*.*.*, 192.168.*.*, 127.0.0.1
;                      so you don't have to deal with links you can't use! Shows
;                      state in TribesIP windowbar, can now Post IP, don't join
;                      multiple servers! Fixed the 'directory long-filename' bug!
;                      Oh yeah, enhanced installation script! Much nicer now!
;
; I first saw TribesLinker on Rasia's old page (on fortunecity, before he moved
; to PSS).. and as I had already been working on a Tribes IP Linker, I figured
; I'd check his out... Well, it was WAY better than mine.. Creating a separate
; window for the captured IP links was ingenious!
;
; A few problems though, is the installation procedure was problematic, with
; no error-checking.. And it wouldn't actually create a working .bat file!
;
; Also, I play alot of password-protected servers, so I *needed* to be able to
; join a server with the right password!
;
; So, I modified his script, cleaned it up, got it working...
;
; Note: Sets you marked as 'away' when you connect, this was a requested feature!
;
; Installation Instructions - Put the TribesIP.mrc file in your mirc directory.
;                             At the status window in mirc, type:
;
;                             /load -rs TribesIP.mrc
;
;                             Follow the on-screen instructions!
;
; All the servers you detect will be in the TribesIP window that this script
; creates when you connect to the server. If it doesn't create it the first time,
; no worries, just goto your Commands menu (its up ther by DCC, File, edit, etc.)
; There should be a Tribes IP Catcher menu option - just hit it, and boom, done.
; Also, this is the way to restart the window if you close it accidentally.
;
; Once you have a server in the TribesIP window, you can doubleclick to connect
; to it, or you can right click to get some options. NOTE: All these options, when
; activated via the TribesIP window will result in GLOBAL notification! If you only
; want to notify people on a per-channel or individual basis, click the channel or
; nicklist panels!
;
; Clicking in individual Channel windows will give you options that pertain to that
; specific channel ONLY! If you don't want to notify globally, you don't have to!
; Also, you can /msg a selected IP to a specific nickname (click the nicklist)
;
; Here are the basic options:
;
; Join selected server -------- Joins the server, doesn't specify a password!
; Join selected w/Password ---- Lets you type in the password for the server. If you
;                               just hit <enter> it uses the last Tribes password.
; Tribes Main Menu ------------ Just start tribes, like you clicked its Windows icon.
;
; Add selected to Favorites --- Adds selected lines to TribesIPfavorites.txt
; Delete selected from Favs --- Deletes selected lines from TribesIPfavorites.txt
;
; Enter manual IP (and join?) - Lets you manually type in a server name and/or IP to
;                               be added to the TribesIP listbox. If you want, you
;                               can then choose to join it!
; Post IP, don't join --------- Only posts the server in all your channels (no join)
;
; Delete selected line(s) ----- Deletes the selected lines from the TribesIP window.
;
; Toggle auto-notify joiners -- Anytime someone Joins a channel you are on, it will
;                               send a private msg to them with the message that you
;                               specify, as well as the server IP of the currently
;                               selected server.
;
; Toggle demo record mode ----- Lets you toggle whether or not you want to record a
;                               demo! (also shows current status) Basically, it adds
;                               the +record parameter to the Tribes command line until
;                               you disable it! (defaults to disabled on startup)
;
; About TribesIP -------------- Gives you some info! (Tells you where to send your
;                               donations.. hehehe)

on 1:LOAD: {
  //echo 8 -s TribesIP 2.0 - written by Rasia, modified and fixed by Cowboy
  //echo 4 -es Performing one-time initialization for this script!
  //echo 8 -es This is only to create the file %MircDirectory $+ TribesIP.bat and config\TribesIPrecord.cs that will be used to run Tribes!
  //echo 9 -es In the dialog box, select the executable file you use to run Tribes! Normally this will be TRIBES.EXE, but if you run TimeHUD, you should select TIMEHUD.EXE!

  %fullpath = $dir[="Select your Tribes Executable..."] c:\*.exe
  if (%fullpath == $null) { /echo 4 -es No Tribes executable file selected! Installation aborted! | /goto quit }
  /set %fullpath $shortfn(%fullpath)
  /set %exename $gettok(%fullpath,$numtok(%fullpath,92),92)
  /set %tribespath $deltok(%fullpath,$numtok(%fullpath,92),92) $+ \
  %tribesdrive = $gettok(%tribespath, 1, 92)
  %tribesdir = \ $+ $deltok(%tribespath,1,92)

  if (%exename == timehud.exe) { /set %timehud 1 | /set %exename start /m %exename }

  /set %MircDirectory $shortfn($mircdir)

  write -c %MircDirectory $+ TribesIP.bat
  write -l1 %MircDirectory $+ TribesIP.bat @echo off
  write -l2 %MircDirectory $+ TribesIP.bat 
  write -l3 %MircDirectory $+ TribesIP.bat echo !!!!!!!! TribesIP 2.0 - written by Rasia, modified and fixed by Cowboy !!!!!!!!
  write -l4 %MircDirectory $+ TribesIP.bat echo.
  write -l5 %MircDirectory $+ TribesIP.bat echo Cowboy
  write -l6 %MircDirectory $+ TribesIP.bat echo cowboy@planetstarsiege.com
  write -l7 %MircDirectory $+ TribesIP.bat echo http://www.planetstarsiege.com/cowboy/
  write -l8 %MircDirectory $+ TribesIP.bat echo ICQ# 31184463
  write -l9 %MircDirectory $+ TribesIP.bat echo.
  write -l10 %MircDirectory $+ TribesIP.bat echo If you need to use any other command line parameters, you can just add them in
  write -l11 %MircDirectory $+ TribesIP.bat echo at the end of the appropriate line! ( $+ %MircDirectory $+ TribesIP.bat)
  write -l12 %MircDirectory $+ TribesIP.bat echo.
  write -l13 %MircDirectory $+ TribesIP.bat 
  write -l14 %MircDirectory $+ TribesIP.bat echo Changing directory to: %tribespath
  write -l15 %MircDirectory $+ TribesIP.bat 
  write -l16 %MircDirectory $+ TribesIP.bat %tribesdrive
  write -l17 %MircDirectory $+ TribesIP.bat cd $+ %tribesdir
  write -l18 %MircDirectory $+ TribesIP.bat 
  write -l19 %MircDirectory $+ TribesIP.bat echo.
  write -l20 %MircDirectory $+ TribesIP.bat echo Running: %exename % $+ 1 % $+ 2 % $+ 3 % $+ 4 % $+ 5 % $+ 6 % $+ 7 % $+ 8 % $+ 9
  write -l21 %MircDirectory $+ TribesIP.bat
  write -l22 %MircDirectory $+ TribesIP.bat %exename % $+ 1 % $+ 2 % $+ 3 % $+ 4 % $+ 5 % $+ 6 % $+ 7 % $+ 8 % $+ 9
  write -l23 %MircDirectory $+ TribesIP.bat 
  if (%timehud == 1) {
    write -l %MircDirectory $+ TribesIP.bat echo.
    write -l %MircDirectory $+ TribesIP.bat echo Since you are running TimeHUD, it's executed via "start /m" to minimize it!
    write -l %MircDirectory $+ TribesIP.bat echo (You can edit the file %MircDirectory $+ TribesIP.bat manually to change this)
  }
  write -l %MircDirectory $+ TribesIP.bat echo.
  write -l %MircDirectory $+ TribesIP.bat echo You'll notice that this DOS-box stays up after you choose to connect to a game 
  write -l %MircDirectory $+ TribesIP.bat echo using TribesIP. This is normal, but annoying... What you can do to make it go
  write -l %MircDirectory $+ TribesIP.bat echo away is go to its Properties box (Alt-Space, P) check the 'Close on Exit' box
  write -l %MircDirectory $+ TribesIP.bat echo and then the 'OK' button. Every time henceforth, it will close automatically!

  //echo 9 -es File %MircDirectory $+ TribesIP.bat created successfully!

  /set %configdir %tribespath $+ config\

  :badconfigdir
  if ($isdir(%configdir) == $false) {
    //echo 4 -es Directory %configdir does not exist! Please choose the correct tribes\config directory!
    /set %configdir $sdir[="Select your Tribes CONFIG directory..."]
    if (%configdir == $null) { /echo 4 -es No tribes\config directory selected! Installation aborted! | /goto quit }
    /goto badconfigdir
  }
  else {
    write -c %configdir $+ TribesIPrecord.cs
    write -l1 %configdir $+ TribesIPrecord.cs // This file is used by TribesIP 2.0, don't worry about it!
    write -l2 %configdir $+ TribesIPrecord.cs
    write -l3 %configdir $+ TribesIPrecord.cs setupRecorderFile();
    //echo 9 -es File %configdir $+ TribesIPrecord.cs created successfully!
  }

  //echo 4 -s Do not delete the variables "%tribespath" or "%MircDirectory"! If either of these gets deleted, it could mess up the external file-handling of TribesIP, and will have to re-run this install!
  //echo 8 -es TribesIP should be loaded now, but minimized. If it becomes unloaded, you can click on the Commands Menu -> Tribes IP Catcher to start it again. (It will load MINIMIZED automatically on connect) If you use TimeHUD or any additional command-line options, you will have to manually edit the %MircDirectory $+ TribesIP.bat file! Thanks and good luck!
  //echo 9 -s Visit Cowboy's Web Page! http://www.planetstarsiege.com/cowboy/

  /showwindow -lkn

  :quit
  unset %exename
  unset %timehud
  unset %yesnoquestion
  unset %tribesdrive
  unset %tribesdir
  unset %fullpath
  unset %pathlen
  unset %yesno
}

on 1:CONNECT: {
  /set %recordstate Disabled
  /unset %recordline
  /set %notifystate Disabled
  /unset %joinline
  /unset %joinermessage
  /unset %lastgrabbed
  /showwindow -lkn
  if ($line(@TribesIP, 1) == $null) /loadfavorites
  /showtitle
}

on 1:TEXT:*[IP*:#: {
  /getserver $1-
  if (IP:10. isin %address) /halt
  else if (IP:192.168. isin %address) /halt
  else if (IP:127.0.0.1 isin %address) /halt
  else if (%lastgrabbed != %address) {
    /set %lastgrabbed %address
    /aline @TribesIP $timestamp $nick says: server %servername [[ $+ %address $+ ]]
  }
}

on 1:ACTION:*[IP*:#: {
  /getserver $1-
  if (IP:10. isin %address) /halt
  else if (IP:192.168. isin %address) /halt
  else if (IP:127.0.0.1 isin %address) /halt
  else if (%lastgrabbed != %address) {
    /set %lastgrabbed %address
    /aline @TribesIP $timestamp $nick says: server %servername [[ $+ %address $+ ]]
  }
}

on 1:JOIN:%notifyscope:if (%notifystate == Enabled) { /msg $nick %joinermessage }

alias getsetpassword {
  /set %passstring $?="Please Type Server Password: $+ $crlf $+ (or <enter> for none/last)"
  if (%passstring == $null) /goto exitpasswordgetterfunction
  /write -ds$Server::JoinPassword %tribespath $+ config\ServerPrefs.cs
  /write -l %tribespath $+ config\ServerPrefs.cs $ $+ Server::JoinPassword = " $+ %passstring $+ ";
  //echo 9 -es Password set to: %passstring
  :exitpasswordgetterfunction
}

alias joinprint {
  /tribeconnect +connect %address
  if ($1 = global) {
    /ame left via TribesIP to join server %servername [[ $+ %address $+ ]]
    /away TribesIP: Playing at %address $timestamp
  }
  else {
    /me left via TribesIP to join server %servername [[ $+ %address $+ ]]
    /away TribesIP: Playing at %address $timestamp
  }
}

alias getserver {
  /set %serverindex 0
  /set %servername (Unknown)
  :startgetserver
  /inc %serverindex
  set %findserverword $gettok($1-,%serverindex,32)
  if (server isincs %findserverword) {
    /unset %servername
    :startaddserver
    /inc %serverindex
    /set %findserverword $gettok($1-,%serverindex,32)
    if ([IP isin %findserverword) {
      /set %iplength $len(%findserverword) - 2
      /set %address $mid(%findserverword,2,%iplength)
      /goto exitgetserver
    }
    /set %servername %servername %findserverword
    /goto startaddserver
  }
  if ([IP isin %findserverword) {
    /set %iplength $len(%findserverword) - 2
    /set %address $mid(%findserverword,2,%iplength)
    /goto exitgetserver
  }
  if (%findserverword == $null) {
    /unset %iplength
    /unset %getipindex
    /unset %getipword
    /unset %address
    /halt
  }
  /goto startgetserver
  :exitgetserver
  /unset %iplength
  /unset %getipindex
  /unset %getipword
}

alias tribeconnect {
  //echo 9 -es start TribesIP.bat $1- %recordline 
  /run start TribesIP.bat $1- %recordline 
}

alias showwindow {
  if (%tribespath == $null) /echo 4 -es Variable "%tribespath" has become unset, please re-install TribesIP!
  /unset %lastgrabbed
  if (%notifystate == Enabled) /echo 9 -es Auto-notify joiners still Enabled: %joinermessage %notifychan
  if (%recordstate == Enabled) /echo 9 -es Demo recording still Enabled!
  /window $1 @TribesIP @TribesConnect
}

alias deletelines {
  if ($sline(@TribesIP, 1) == $null) /halt
  /set %numlinks $sline(@TribesIP, 0)
  :loopdellink
  if (%numlinks > 0) { /dline @TribesIP $sline(@TribesIP, %numlinks).ln | /dec %numlinks }
  if (%numlinks == 0) { /unset %numlinks | /halt }
  goto loopdellink
}


alias loadfavorites {
  /set %loadfavorites 0
  :loadfavoritesloop
  /inc %loadfavorites
  /set %lftemp %MircDirectory $+ TribesIPfavorites.txt
  if ($exists(%lftemp) == $false) { /unset %lftemp | /halt }
  /unset %lftemp
  /loadbuf %loadfavorites $+ - $+ %loadfavorites -c7 @TribesIP %MircDirectory $+ TribesIPfavorites.txt
  if ($line(@TribesIP, %loadfavorites) != $null) goto loadfavoritesloop
}


alias addfavorites {
  if ($sline(@TribesIP, 1) == $null) /halt
  /set %numlinks $sline(@TribesIP, 0)
  :loopaddfavs
  if (%numlinks > 0) {
    if ($sline(@TribesIP, %numlinks).ln < %loadfavorites) { /dec %numlinks | goto loopaddfavs }
    /set %tribesiplinenum $sline(@TribesIP, %numlinks).ln
    /set %tribesipline $sline(@TribesIP, %numlinks)
    /getserver $sline(@TribesIP, %numlinks)
    /write -l %MircDirectory $+ TribesIPfavorites.txt TribesIP: server %servername [[ $+ %address $+ ]]
    /dline @TribesIP %tribesiplinenum
    /iline 7 @TribesIP %loadfavorites TribesIP: server %servername [[ $+ %address $+ ]]
    /inc %loadfavorites
    /dec %numlinks
  }
  if (%numlinks == 0) { /unset %numlinks | /halt }
  goto loopaddfavs
}

alias delfavorites {
  if ($sline(@TribesIP, 1) == $null) /halt
  /set %numlinks $sline(@TribesIP, 0)
  :loopdelfavs
  if (%numlinks > 0) {
    if ($sline(@TribesIP, %numlinks).ln >= %loadfavorites) { /dec %numlinks | goto loopdelfavs }
    /set %tribesiplinenum $sline(@TribesIP, %numlinks).ln
    /set %tribesipline $sline(@TribesIP, %numlinks)
    /write -dl $+ $sline(@TribesIP, %numlinks).ln %MircDirectory $+ TribesIPfavorites.txt
    /dline @TribesIP %tribesiplinenum
    /dec %loadfavorites
    /iline @TribesIP %loadfavorites %tribesipline
    /dec %numlinks
  }
  if (%numlinks == 0) { /unset %numlinks | /halt }
  goto loopdelfavs
}

alias autonotifytoggle {
  /unset %notifyscope
  /unset %notifychan
  if (%notifystate == Enabled) { 
    /set %notifystate Disabled
    /unset %joinline
    /unset %joinermessage
    /echo 4 -es Auto-notify joiners Disabled!
  }
  else {
    /set %joinline $sline(@TribesIP, 1)
    if (%joinline == $null) {
      /echo 4 -es You MUST select a server to auto-join notify!
      /unset %joinline
      /unset %joinermessage
    }
    else {
      /set %joinermessage $$?="What Reason?"
      /getserver $sline(@TribesIP, 1) 
      /set %joinermessage Welcome! ( $+ %joinermessage $+ ) Repost via TribesIP: server %servername [[ $+ %address $+ ]]
      /set %notifystate Enabled
      if ($1 == global) {
        /set %notifyscope #
        /set %notifychan -> global
      }
      else {
        /set %notifyscope $chan
        /set %notifychan -> $chan
      }
      /echo 9 -es Auto-notify joiners Enabled: %joinermessage %notifychan
    }
  }
  /showtitle
}

alias postnojoin {
  /set %numlinks $sline(@TribesIP, 0)
  if ($sline(@TribesIP, %numlinks) == $null) { /unset %numlinks | /halt }
  :looppnjlink
  /getserver $sline(@TribesIP, %numlinks)

  if (%numlinks > 0) {
    if ($sline(@TribesIP, 1) != $null) {
      /getserver $sline(@TribesIP, %numlinks)
      if ($1 == global) /ame reposts via TribesIP: server %servername [[ $+ %address $+ ]]
      else /me reposts via TribesIP: server %servername [[ $+ %address $+ ]]
    }
  }
  if (%numlinks == 0) { /unset %numlinks | /halt }
  /dec %numlinks
  goto looppnjlink
}

alias showtitle {
  /titlebar @TribesIP - Demo record mode ( $+ %recordstate $+ ) - Auto-notify joiners ( $+ %notifystate $+ %notifychan $+ ) %joinermessage
}

alias manualipadd {
  /getserver $$?="Enter IP (w/ optional server name) in format $+ $crlf $+ server SERVER NAME [validIPaddress] $+ $crlf $+ or just: [validIPaddress] $+ $crlf $+ ex: server Big Deal [IP:123.4.5.67:28001:00]"
  /set %lastgrabbed %address
  /aline @TribesIP $timestamp You manually added: server %servername [[ $+ %address $+ ]]
  if ($?!="Would you like to join this server now?" == $false) /halt
  /getsetpassword
  /joinprint $1

}

alias demotoggle {
  if (%recordstate == Enabled) { /set %recordstate Disabled | /unset %recordline | /echo 4 -es Demo recording Disabled! }
  else { /set %recordstate Enabled | /set %recordline +exec TribesIPrecord.cs +record | /echo 9 -es Demo recording Enabled! }
  /showtitle
}

alias abouttribesip {
  if ($?!="TribesIP 2.0 $crlf $+ by Rasia, modified and fixed by Cowboy $crlf $crlf $+ cowboy@planetstarsiege.com $crlf $+ http://www.planetstarsiege.com/cowboy/ $crlf $crlf $+ Read the file TribesIP.txt for more information! $crlf $crlf $+ Thanks!" == sillylittleperson) {}
}

menu Menubar {
  Tribes IP Catcher: {
    /showwindow -lk
    if ($line(@TribesIP, 1) == $null) /loadfavorites
    /showtitle
  }
}

menu channel {
  TribesIP
  .Join selected server: {
    /getserver $sline(@TribesIP, 1)
    /joinprint
  }
  .Join selected, set password: {
    /getserver $sline(@TribesIP, 1)
    /getsetpassword
    /joinprint
  }
  .-
  .Enter manual IP (and join?): { /manualipadd }
  .Post IP, don't join: { /postnojoin }
  .-
  .Toggle auto-notify joiners ( $+ %notifystate $+ %notifychan $+ ): { /autonotifytoggle }
  .-
  .Toggle demo record mode ( $+ %recordstate $+ ): { /demotoggle }
  .-
  .About TribesIP: { /abouttribesip }
}

menu nicklist {
  TribesIP
  .Give IP to ...: {
    if ($sline(@TribesIP, 1) != $null) {
      if ($$1 != $null) {
        /getserver $sline(@TribesIP, 1)
        /msg $$1 reposts via TribesIP: server %servername [[ $+ %address $+ ]]
      }
      else echo 4 -es You MUST select a nickname to give the IP to!
    }
    else echo 4 -es You MUST select a server to post
  }
  .-
  .(Status Only) Auto-notify joiners ( $+ %notifystate $+ %notifychan $+ ): {}
  .(Status Only) Demo record mode ( $+ %recordstate $+ ): {}
  .-
  .About TribesIP: { /abouttribesip }
}

menu @TribesConnect {
  dclick: {
    /getserver $sline(@TribesIP, 1)
    /joinprint global
  }
  NOTE, Anything done through this menu will be global!: {}
  If you want to operate on a per-channel basis, select: {}
  The TribesIP menu in the specific Channel window!: {}
  -
  Join selected server: {
    /getserver $sline(@TribesIP, 1)
    /joinprint global
  }
  Join selected, set password: {
    /getserver $sline(@TribesIP, 1)
    /getsetpassword
    /joinprint global
  }
  Tribes Main Menu: {
    /ame left via TribesIP to play Tribes...
    /away TribesIP: In Tribes... $timestamp
    /tribeconnect
  }
  -
  Add selected line(s) to Favorites: { /addfavorites }
  Delete selected line(s) from Favorites: { /delfavorites }
  -
  Enter manual IP (and join?): { /manualipadd global }
  Post IP, don't join: { /postnojoin global }
  -
  Delete selected line(s): { /deletelines }
  -
  Toggle auto-notify joiners ( $+ %notifystate $+ %notifychan $+ ): { /autonotifytoggle global }
  -
  Toggle demo record mode ( $+ %recordstate $+ ):  { /demotoggle }
  -
  About TribesIP: { /abouttribesip }
}
