// !!!!!!!!!! HUDtris 1.0 -> Tetris-like game for Tribes <- 6/19/99 !!!!!!!!!!!
// 
// By:
//    Cowboy
//    cowboy@planetstarsiege.com
//    http://www.planetstarsiege.com/cowboy/
//    ICQ# 31184463
// 
// Requires Presto Pack 0.93+
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// 
// Installation notes:
// 
// Unzip file to your tribes directory! All the files will be put in the right
// places!
//
// (HUDtris.cs and HUDtris.vol go into tribes\config\cowboy directory)
//
// Add the line Include("cowboy\\HUDtris.cs"); to your Autoexec.cs line after
// the exec("presto\\install.cs"); line...
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// Gameplay / notes:
//
// You should know how to play this! Good luck!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// I had NO access to any Tetris source code, I just saw a few sites on the WEB
// about it! http://synergy.design.ucla.edu/gallery/kobashik/tetris/tetris.html
// seems to be the coolest! http://www.geocities.com/Hollywood/2430/tetris.html
// is another site concerned with the Tetris Company's actions to remove *ALL*
// shareware and freeware Tetris-like games from the public domain based only
// on a 'look-and-feel' basis!
// 
// (c) 1999 Cowboy, whatever... I hope you enjoy this, and all that I ask is 
// that you give me props for it.. enjoy!
//
// disclaimer: all trademarks belong to their respective owners
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

// - KEY CONFIGURATION -
//
// set these to whatever you want
//
$HUDtris:KeyToggle = "alt t";

$HUDtris:KeyLeft = "left";
$HUDtris:KeyRight = "right";
$HUDtris:KeyDown = "down";
$HUDtris:KeyRotate = "up";

// !!!!!!! ----- end user editable section ----- !!!!!!!
//
// go away! nothing you could possibly want is in here..

Include("presto\\Install.cs");
Include("presto\\Event.cs");
Include("presto\\HUD.cs");

// just stuff to help me organize the HUD
$HUDtris::BlockSize = 10;
$HUDtris::Columns = 10;
$HUDtris::Rows = 20;
$HUDtris::BoardXoffset = 20;
$HUDtris::BoardYoffset = 60;
$HUDtris::StuffXoffset = 140;
$HUDtris::StuffYoffset = 60;

// score for dropping lines
// depends on how many lines are dropped at once
$HUDtris::ScoreValue[0] = 1;
$HUDtris::ScoreValue[1] = 10;
$HUDtris::ScoreValue[2] = 30;
$HUDtris::ScoreValue[3] = 70;
$HUDtris::ScoreValue[4] = 200;

// set the delay times for each level
$HUDtris::LevelValue[0] = 10;
$HUDtris::LevelValue[1] = 10;
$HUDtris::LevelValue[2] = 9;
$HUDtris::LevelValue[3] = 9;
$HUDtris::LevelValue[4] = 8;
$HUDtris::LevelValue[5] = 7;
$HUDtris::LevelValue[6] = 6;
$HUDtris::LevelValue[7] = 5;
$HUDtris::LevelValue[8] = 4;
$HUDtris::LevelValue[9] = 3;
$HUDtris::LevelValue[10] = 2;

// define colors (for block bitmaps)
//
// notice if you set $HUDtris::Color[0] = Black; it uses the black 'block' i
// made... I prefer it transparent though, so i just use a bogus bitmap name
$HUDtris::Color[0] = blahblahblah;
$HUDtris::Color[1] = Blue;
$HUDtris::Color[2] = Green;
$HUDtris::Color[3] = Red;
$HUDtris::Color[4] = Cyan;
$HUDtris::Color[5] = Magenta;
$HUDtris::Color[6] = Yellow;
$HUDtris::Color[7] = White;

// define image tables for tetrads
//
// kinda like arrays...
$HUDtris::Shape[0,0,0] = 0;
$HUDtris::Shape[0,0,1] = 0;
$HUDtris::Shape[0,0,2] = 0;
$HUDtris::Shape[0,0,3] = 0;
$HUDtris::Shape[0,1,0] = 0;
$HUDtris::Shape[0,1,1] = 1;
$HUDtris::Shape[0,1,2] = 1;
$HUDtris::Shape[0,1,3] = 0;
$HUDtris::Shape[0,2,0] = 0;
$HUDtris::Shape[0,2,1] = 1;
$HUDtris::Shape[0,2,2] = 1;
$HUDtris::Shape[0,2,3] = 0;
$HUDtris::Shape[0,3,0] = 0;
$HUDtris::Shape[0,3,1] = 0;
$HUDtris::Shape[0,3,2] = 0;
$HUDtris::Shape[0,3,3] = 0;

$HUDtris::Shape[1,0,0] = 0;
$HUDtris::Shape[1,0,1] = 2;
$HUDtris::Shape[1,0,2] = 0;
$HUDtris::Shape[1,0,3] = 0;
$HUDtris::Shape[1,1,0] = 0;
$HUDtris::Shape[1,1,1] = 2;
$HUDtris::Shape[1,1,2] = 0;
$HUDtris::Shape[1,1,3] = 0;
$HUDtris::Shape[1,2,0] = 0;
$HUDtris::Shape[1,2,1] = 2;
$HUDtris::Shape[1,2,2] = 2;
$HUDtris::Shape[1,2,3] = 0;
$HUDtris::Shape[1,3,0] = 0;
$HUDtris::Shape[1,3,1] = 0;
$HUDtris::Shape[1,3,2] = 0;
$HUDtris::Shape[1,3,3] = 0;

$HUDtris::Shape[2,0,0] = 0;
$HUDtris::Shape[2,0,1] = 0;
$HUDtris::Shape[2,0,2] = 3;
$HUDtris::Shape[2,0,3] = 0;
$HUDtris::Shape[2,1,0] = 0;
$HUDtris::Shape[2,1,1] = 0;
$HUDtris::Shape[2,1,2] = 3;
$HUDtris::Shape[2,1,3] = 0;
$HUDtris::Shape[2,2,0] = 0;
$HUDtris::Shape[2,2,1] = 3;
$HUDtris::Shape[2,2,2] = 3;
$HUDtris::Shape[2,2,3] = 0;
$HUDtris::Shape[2,3,0] = 0;
$HUDtris::Shape[2,3,1] = 0;
$HUDtris::Shape[2,3,2] = 0;
$HUDtris::Shape[2,3,3] = 0;

$HUDtris::Shape[3,0,0] = 0;
$HUDtris::Shape[3,0,1] = 0;
$HUDtris::Shape[3,0,2] = 0;
$HUDtris::Shape[3,0,3] = 0;
$HUDtris::Shape[3,1,0] = 0;
$HUDtris::Shape[3,1,1] = 4;
$HUDtris::Shape[3,1,2] = 0;
$HUDtris::Shape[3,1,3] = 0;
$HUDtris::Shape[3,2,0] = 4;
$HUDtris::Shape[3,2,1] = 4;
$HUDtris::Shape[3,2,2] = 4;
$HUDtris::Shape[3,2,3] = 0;
$HUDtris::Shape[3,3,0] = 0;
$HUDtris::Shape[3,3,1] = 0;
$HUDtris::Shape[3,3,2] = 0;
$HUDtris::Shape[3,3,3] = 0;

$HUDtris::Shape[4,0,0] = 0;
$HUDtris::Shape[4,0,1] = 5;
$HUDtris::Shape[4,0,2] = 0;
$HUDtris::Shape[4,0,3] = 0;
$HUDtris::Shape[4,1,0] = 0;
$HUDtris::Shape[4,1,1] = 5;
$HUDtris::Shape[4,1,2] = 0;
$HUDtris::Shape[4,1,3] = 0;
$HUDtris::Shape[4,2,0] = 0;
$HUDtris::Shape[4,2,1] = 5;
$HUDtris::Shape[4,2,2] = 0;
$HUDtris::Shape[4,2,3] = 0;
$HUDtris::Shape[4,3,0] = 0;
$HUDtris::Shape[4,3,1] = 5;
$HUDtris::Shape[4,3,2] = 0;
$HUDtris::Shape[4,3,3] = 0;

$HUDtris::Shape[5,0,0] = 0;
$HUDtris::Shape[5,0,1] = 6;
$HUDtris::Shape[5,0,2] = 0;
$HUDtris::Shape[5,0,3] = 0;
$HUDtris::Shape[5,1,0] = 0;
$HUDtris::Shape[5,1,1] = 6;
$HUDtris::Shape[5,1,2] = 6;
$HUDtris::Shape[5,1,3] = 0;
$HUDtris::Shape[5,2,0] = 0;
$HUDtris::Shape[5,2,1] = 0;
$HUDtris::Shape[5,2,2] = 6;
$HUDtris::Shape[5,2,3] = 0;
$HUDtris::Shape[5,3,0] = 0;
$HUDtris::Shape[5,3,1] = 0;
$HUDtris::Shape[5,3,2] = 0;
$HUDtris::Shape[5,3,3] = 0;

$HUDtris::Shape[6,0,0] = 0;
$HUDtris::Shape[6,0,1] = 0;
$HUDtris::Shape[6,0,2] = 7;
$HUDtris::Shape[6,0,3] = 0;
$HUDtris::Shape[6,1,0] = 0;
$HUDtris::Shape[6,1,1] = 7;
$HUDtris::Shape[6,1,2] = 7;
$HUDtris::Shape[6,1,3] = 0;
$HUDtris::Shape[6,2,0] = 0;
$HUDtris::Shape[6,2,1] = 7;
$HUDtris::Shape[6,2,2] = 0;
$HUDtris::Shape[6,2,3] = 0;
$HUDtris::Shape[6,3,0] = 0;
$HUDtris::Shape[6,3,1] = 0;
$HUDtris::Shape[6,3,2] = 0;
$HUDtris::Shape[6,3,3] = 0;

// HUD update function
function HUDtris::Update() {
	if ($HUDtris::Level > 10) // set delay
		%delay = 1;
	else
		%delay = $HUDtris::LevelValue[$HUDtris::Level];

	if (floor(getSimTime() * 20) % %delay == 0) {
		// move the piece down if possible, otherwise
		// lock it in place and get the next piece
		if (!HUDtris::CanMove(down)) {
			HUDtris::LockCurrentShape($HUDtris::X, $HUDtris::Y);
			HUDtris::DeleteLines();
			HUDtris::SetScore();
			HUDtris::ShowScore();
			if (HUDtris::PlaceShape())
				HUDtris::NextShape(floor(getRandom() * 100) % 7);
			else {
				HUDtris::WaitMode(); // you lose.. game over!
			}
			
		}
	}
	
	HUD::Display(HUDtris);
	return 0.05;
}

function HUDtris::MakeHUD() {
	// make hud frame
	HUD::New(HUDtris, HUDtris::Update, "100%-6 50% 200 280");
	
	// make background frame(s) for hud - making 1 big frame didn't work, as the
	// bitmap was too big for tribes to render reliably! So I broke it into 2 frames...
	$HUDtris::BackgroundTop = HUD::AddObject(HUDtris, FearGuiFormattedText, 2, 1, 198, 139);
	$HUDtris::BackgroundBottom = HUD::AddObject(HUDtris, FearGuiFormattedText, 2, 140, 198, 139);
	Control::Setvalue(Object::getName($HUDtris::BackgroundTop), "<B0,0:HUDtrisScreenTop.bmp>");
	Control::Setvalue(Object::getName($HUDtris::BackgroundBottom), "<B0,0:HUDtrisScreenBottom.bmp>");

	// make board frame
	$HUDtris::BoardFrame = HUD::AddObject(HUDtris, FearGuiFormattedText, $HUDtris::BoardXoffset, $HUDtris::BoardYoffset, $HUDtris::Columns * $HUDtris::BlockSize, $HUDtris::Rows * $HUDtris::BlockSize);
	
	// make grid
	for (%x = 0; %x < $HUDtris::Columns; %x++) {
		for (%y = 0; %y < $HUDtris::Rows; %y++)
			$HUDtris::Board[%x, %y] = HUD::AddObject(HUDtris, FearGuiFormattedText, ($HUDtris::BlockSize * %x) + $HUDtris::BoardXoffset, ($HUDtris::BlockSize * %y) + $HUDtris::BoardYoffset, $HUDtris::BlockSize, $HUDtris::BlockSize);
	}

	//board overlay, for end-game text and instructions
	$HUDtris::BoardOverlay = HUD::AddObject(HUDtris, FearGui::FearGuiMenu, $HUDtris::BoardXoffset - 3, $HUDtris::BoardYoffset - 3, $HUDtris::Columns * $HUDtris::BlockSize + 6, $HUDtris::Rows * $HUDtris::BlockSize + 6);
	$HUDtris::BoardOverlay2 = newObject("HUDtris::BoardOverlay2", FearGui::FearGuiMenu, 0, 0, $HUDtris::Columns * $HUDtris::BlockSize + 6, $HUDtris::Rows * $HUDtris::BlockSize + 6);
	addToSet($HUDtris::BoardOverlay, $HUDtris::BoardOverlay2);
	$HUDtris::BoardOverlayText = newObject("HUDtris::BoardOverlayText", FearGuiFormattedText, 0, 0, $HUDtris::Columns * $HUDtris::BlockSize + 6, $HUDtris::Rows * $HUDtris::BlockSize + 6);
	addToSet($HUDtris::BoardOverlay, $HUDtris::BoardOverlayText);
	Control::SetVisible(Object::getName($HUDtris::BoardOverlay), false);

	// clear board
	HUDtris::InitBoard();
	
	// make counter frames
	$HUDtris::HighScoreFrame = HUD::AddObject(HUDtris, FearGuiFormattedText, $HUDtris::StuffXoffset-79, $HUDtris::StuffYoffset + 16, 4 * $HUDtris::BlockSize, 14);
	$HUDtris::CurrentScoreFrame = HUD::AddObject(HUDtris, FearGuiFormattedText, $HUDtris::StuffXoffset-79, $HUDtris::StuffYoffset + 51, 4 * $HUDtris::BlockSize, 14);
	$HUDtris::LinesFrame = HUD::AddObject(HUDtris, FearGuiFormattedText, $HUDtris::StuffXoffset-79, $HUDtris::StuffYoffset + 86, 4 * $HUDtris::BlockSize, 14);
	$HUDtris::LevelFrame = HUD::AddObject(HUDtris, FearGuiFormattedText, $HUDtris::StuffXoffset-79, $HUDtris::StuffYoffset + 121, 4 * $HUDtris::BlockSize, 14);

	// make next piece frame
	$HUDtris::NextFrame = HUD::AddObject(HUDtris, FearGuiFormattedText, $HUDtris::StuffXoffset, $HUDtris::StuffYoffset + 160, 4 * $HUDtris::BlockSize, 4 * $HUDtris::BlockSize);
	
	// make next piece grid	
	for (%x = 0; %x < 4; %x++) {
		for (%y = 0; %y < 4; %y++)
			$HUDtris::Next[%x, %y] = HUD::AddObject(HUDtris, FearGuiFormattedText, ($HUDtris::BlockSize * %x) + $HUDtris::StuffXoffset, ($HUDtris::BlockSize * %y) + $HUDtris::StuffYoffset + 160, $HUDtris::BlockSize, $HUDtris::BlockSize);
	}

	// get next shape
	HUDtris::NextShape(floor(getRandom() * 100) % 7);

	// display the scores
	HUDtris::ShowScore();

	// show keys / instructions before game starts
	HUDtris::WaitMode();
}

// set the score, high score, lines, level
function HUDtris::SetScore() {
	$HUDtris::CurrentScore += ($HUDtris::Level + 1) * $HUDtris::ScoreValue[$HUDtris::TempLines];
	if ($HUDtris::CurrentScore > $pref::HUDtris::HighScore) {
		$pref::HUDtris::HighScore = $HUDtris::CurrentScore;
		$HUDtris::NewHighScore = true;
	}
	$HUDtris::Lines += $HUDtris::TempLines;
	$HUDtris::LinesSoFar += $HUDtris::TempLines;
	if ($HUDtris::LinesSoFar > ($HUDtris::Level + 1) * 10) {
		$HUDtris::LinesSoFar = $HUDtris::LinesSoFar % (($HUDtris::Level + 1) * 10);
		$HUDtris::Level++;
	}
}

// display the score, high score, lines, level
function HUDtris::ShowScore() {
	Control::Setvalue(Object::getName($HUDtris::HighScoreFrame), "<jc><f2>" @ $pref::HUDtris::HighScore);
	Control::Setvalue(Object::getName($HUDtris::CurrentScoreFrame), "<jc><f2>" @ $HUDtris::CurrentScore);
	Control::Setvalue(Object::getName($HUDtris::LinesFrame), "<jc><f2>" @ $HUDtris::Lines);
	Control::Setvalue(Object::getName($HUDtris::LevelFrame), "<jc><f2>" @ $HUDtris::Level);
}

// clear the board, reset variables
function HUDtris::InitBoard() {
	for (%x = 0; %x < $HUDtris::Columns; %x++) {
		for (%y = 0; %y < $HUDtris::Rows; %y++) {
			HUDtris::SetBlock(%x, %y, 0);
			HUDtris::ColorBlock(%x, %y, 0);
		}
	}
	$HUDtris::Lines = 0;
	$HUDtris::Level = 0;
	$HUDtris::CurrentScore = 0;
	$HUDtris::LinesSoFar = 0;
	$HUDtris::NewHighScore = false;
	$HUDtris::Processing = false;
	if ($pref::HUDtris::HighScore <= 0) $pref::HUDtris::HighScore = 0;
}

// just show a bitmap/color in a block. (temporary,
// must still be HUDtris::ColorBlock()'ed to lock it)
function HUDtris::SetBlock(%x, %y, %color) {
	Control::SetValue(Object::getName($HUDtris::Board[%x, %y]), "<B0,0:HUDtris" @ $HUDtris::Color[%color] @ ".bmp>");
	}

// set the block to the appropriate color. (lock down the color)
function HUDtris::ColorBlock(%x, %y, %color) {
	$HUDtris::BoardColor[%x, %y] = %color;
	}

// make %shape the next tetrad, display in the 'next shape' window
function HUDtris::NextShape(%shape) {
	for (%x = 0; %x < 4; %x++) {
		for (%y = 0; %y < 4; %y++) {
			$HUDtris::NextShape[%x, %y] = $HUDtris::Shape[%shape, %y, %x];
			Control::SetValue(Object::getName($HUDtris::Next[%x, %y]), "<B0,0:HUDtris" @ $HUDtris::Color[$HUDtris::NextShape[%x, %y]] @ ".bmp>");
		}
	}
	$HUDtris::NextShape = %shape;
}

// take the 'next shape', place it on the board for play
function HUDtris::PlaceShape() {
	while ($HUDtris::Processing) HUDtris::Nothing();
	
	for (%x = 0; %x < 4; %x++) {
		for (%y = 0; %y < 4; %y++) {
			$HUDtris::CurrentShape[%x, %y] = $HUDtris::NextShape[%x, %y];
		}
	}
	$HUDtris::X = 3;
	if ($HUDtris::NextShape == 0 || $HUDtris::NextShape == 3)
		$HUDtris::Y = -1;
	else
		$HUDtris::Y = 0;
		
	HUDtris::PlaceCurrentShape($HUDtris::X, $HUDtris::Y);

	if (HUDtris::IsValidLocation($HUDtris::X, $HUDtris::Y))
		return true;
	else
		return false;
}

// show the tetrad in the position %x, %y
function HUDtris::PlaceCurrentShape(%x, %y) {
	for (%i = 0; %i < 4; %i++) {
		for (%j = 0; %j < 4; %j++) {
			if ($HUDtris::CurrentShape[%i, %j] != 0)
				HUDtris::SetBlock(%x+%i, %y+%j, $HUDtris::CurrentShape[%i, %j]);
		}
	}
}

// lock the tetrad into the position %x, %y
function HUDtris::LockCurrentShape(%x, %y) {
	for (%i = 0; %i < 4; %i++) {
		for (%j = 0; %j < 4; %j++) {
			if ($HUDtris::CurrentShape[%i, %j] != 0)
				HUDtris::ColorBlock(%x+%i, %y+%j, $HUDtris::CurrentShape[%i, %j]);
		}
	}
}

// un-display the tetrad from position %x, %y
function HUDtris::RestoreBoard(%x, %y) {
	for (%i = 0; %i < 4; %i++) {
		for (%j = 0; %j < 4; %j++) {
			HUDtris::SetBlock(%x+%i, %y+%j, $HUDtris::BoardColor[%x+%i, %y+%j]);
		}
	}
}

// check to see if the tetrad can be placed at %x, %y
// returns true/false
function HUDtris::IsValidLocation(%x, %y) {
	for (%i = 0; %i < 4; %i++) {
		for (%j = 0; %j < 4; %j++) {
			if ($HUDtris::CurrentShape[%i, %j] != 0 && %x + %i > $HUDtris::Columns - 1)
				return false;
			else if ($HUDtris::CurrentShape[%i, %j] != 0 && %x + %i < 0)
				return false;
			else if ($HUDtris::CurrentShape[%i, %j] != 0 && %y + %j > $HUDtris::Rows - 1)
				return false;
			else if ($HUDtris::CurrentShape[%i, %j] != 0 && %y + %j < 0)
				return false;
			else if ($HUDtris::BoardColor[%x+%i, %y+%j] != 0 && $HUDtris::CurrentShape[%i, %j] != 0)
				return false;
		}
	}
	return true;
}

// rotate the tetrad in %direction
function HUDtris::Rotate(%direction) {
	if (%direction == clockwise) {
		for (%x = 0; %x < 4; %x++) {
			for (%y = 0; %y < 4; %y++) {
				%HUDtris::TempShape[%x, %y] = $HUDtris::CurrentShape[3 - %y, %x];
			}
		}
	}
	else if (%direction == counterclockwise) {
		for (%x = 0; %x < 4; %x++) {
			for (%y = 0; %y < 4; %y++) {
				%HUDtris::TempShape[%x, %y] = $HUDtris::CurrentShape[%y, 3 - %x];
			}
		}
	}
	else return false;
	
	for (%x = 0; %x < 4; %x++) {
		for (%y = 0; %y < 4; %y++) {
			$HUDtris::CurrentShape[%x, %y] = %HUDtris::TempShape[%x, %y];
		}
	}
	return true;
}

// check to see if the tetrad can be rotated
function HUDtris::CanRotate(%direction) {
	if (!HUD::GetDisplayed(HUDtris)) return;
	HUDtris::Rotate(%direction);
	if (HUDtris::IsValidLocation($HUDtris::X, $HUDtris::Y)) {
		HUDtris::RestoreBoard($HUDtris::X, $HUDtris::Y);
		HUDtris::PlaceCurrentShape($HUDtris::X, $HUDtris::Y);
	}
	else {
		if (%direction == clockwise)
			HUDtris::Rotate(counterclockwise);
		else
			HUDtris::Rotate(clockwise);
	}
}

// move the tetrad
// first restore the board under it, then draw the tetrad
// in its new position
function HUDtris::MoveShape(%direction) {
	HUDtris::RestoreBoard($HUDtris::X, $HUDtris::Y);

	if (%direction == right)
		$HUDtris::X++;
	else if (%direction == left)
		$HUDtris::X--;
	else if (%direction == down)
		$HUDtris::Y++;

	HUDtris::PlaceCurrentShape($HUDtris::X, $HUDtris::Y);
}

// check to see if the tetrad can be moved in %direction
// returns true/false
function HUDtris::CanMove(%direction) {
	if (!HUD::GetDisplayed(HUDtris)) return true;
	%x = 0;
	%y = 0;
	if (%direction == right)
		%x = 1;
	else if (%direction == left)
		%x = -1;
	else if (%direction == down)
		%y = 1;

	if (HUDtris::IsValidLocation($HUDtris::X + %x, $HUDtris::Y + %y)) {
		HUDtris::MoveShape(%direction);
		return true;
	}
	else
		return false;
}

// inspired by writer's jump.cs, these 2 functions allow you to hold down
// a key to repeat a particular movement! Very useful!
function HUDtris::Move(%direction, %state, %speed) {
	if(%state) {
		$HUDtris::Moving[%direction] = 1;
		HUDTris::KeepMoving(%direction, %speed);
	}
	else
		$HUDtris::Moving[%direction] = 0;
}

function HUDtris::KeepMoving(%direction, %speed) {
	if($HUDtris::Moving[%direction]) {
		HUDtris::CanMove(%direction);
		schedule("HUDtris::KeepMoving(" @ %direction @ ", " @ %speed @ ");", %speed);
	}
}

// go through the board and see if there are any completed
// lines that can be deleted (and added to the lines counter)
function HUDtris::DeleteLines() {
	$HUDtris::Processing = true;
	$HUDtris::TempLines = 0;
	for (%row = 0; %row < $HUDtris::Rows; %row++) {
		%IncompleteRow = false;
		for (%x = 0; %x < $HUDtris::Columns; %x++)
			if ($HUDtris::BoardColor[%x, %row] == 0) %IncompleteRow = true;
					
		if (!%IncompleteRow) {
			$HUDtris::TempLines++;
			for (%y = %row-1; %y >= 0; %y--) {
				for (%x = 0; %x < $HUDtris::Columns; %x++) {
					HUDtris::ColorBlock(%x, %y+1, $HUDtris::BoardColor[%x, %y]);
					HUDtris::SetBlock(%x, %y+1, $HUDtris::BoardColor[%x, %y]);
				}
			}
			
			for (%x = 0; %x < $HUDtris::Columns; %x++) {
				HUDtris::ColorBlock(%x, 0, 0);
				HUDtris::SetBlock(%x, 0, 0);
			}
		}
	}
	$HUDtris::Processing = false;
}
	
// initiate a game.. set the keys up correctly, set up the board, etc..
function HUDtris::PlayMode() {
	if (!HUD::GetDisplayed(HUDtris)) return true;

	HUD::SetUpdateFunc(HUDtris, HUDtris::Update);
	HUDtris::BoardOverlayClear();
	HUDtris::InitBoard();

	bindKey(play, $HUDtris:KeyLeft, "HUDtris::Move(left, true, 0.2);", "HUDtris::Move(left, false);");
	bindKey(play, $HUDtris:KeyRight, "HUDtris::Move(right, true, 0.2);", "HUDtris::Move(right, false);");
	bindKey(play, $HUDtris:KeyDown, "HUDtris::Move(down, true, 0.1);", "HUDtris::Move(down, false);");
	bindKey(play, $HUDtris:KeyRotate, "HUDtris::CanRotate(clockwise);");

	HUDtris::NextShape(floor(getRandom() * 100) % 7);
	HUDtris::PlaceShape();
	HUDtris::NextShape(floor(getRandom() * 100) % 7);
}

// game over! stop the hud from updating, display the appropriate board overlay,
// redefine the keys, and wait...
function HUDtris::WaitMode() {
	HUD::SetUpdateFunc(HUDtris, HUDtris::Nothing);

	HUDtris::NextShape();

	HUDtris::BindKeysToNothing();

	Control::SetVisible(Object::getName($HUDtris::BoardOverlay), true);

	if ($HUDtris::NewHighScore) {
		HUDtris::BoardOverlayNewHighScore();
		schedule("HUDtris::BoardOverlayIntro();", 8);
	}
	else if ($HUDtris::CurrentScore > 0) {
		HUDtris::BoardOverlayEndGame();
		schedule("HUDtris::BoardOverlayIntro();", 8);
	}
	else {	
		HUDtris::BoardOverlayIntro();
	}

	schedule("HUDtris::BindKeysToStartPlay();", 2);
}

// turns the board overlay off
function HUDtris::BoardOverlayClear() {
	Control::SetVisible(Object::getName($HUDtris::BoardOverlay), false);
}

// display the keys/intro overlay
function HUDtris::BoardOverlayIntro() {
	Control::SetValue(Object::getName($HUDtris::BoardOverlayText), "<jc><f1>version 1.0\n\n<f2>by Cowboy\n\n<f2>Keys:\n<f1>Toggle: " @ $HUDtris:KeyToggle @ "\n\n<f2>Move:\n<f1>Left: " @ $HUDtris:KeyLeft @ "\nRight: " @ $HUDtris:KeyRight @ "\nDown: " @ $HUDtris:KeyDown @ "\nRotate: " @ $HUDtris:KeyRotate @ "\n\n<f1>Press a <f2>move\nkey <f1>to start\n");
}

// randomly pick an end-game overlay, depending on the level
function HUDtris::BoardOverlayEndGame() {
	if ($HUDtris::Level < 3)
		%overlay = floor(getRandom() * 100) % 4;
	else if ($HUDtris::Level < 6)
		%overlay = floor(getRandom() * 100) % 8;
	else
		%overlay = floor(getRandom() * 100) % 4 + 4;
	
	Control::SetValue(Object::getName($HUDtris::BoardOverlayText), HUDtris::SetOverlayText(%overlay));
}	

// chose the overlay text then!
function HUDtris::SetOverlayText(%i) {
	if (%i == 1)
		return "<jc><f1>Well...\n\nThat's a pretty\nlame score!\n\nYou know?\n\n<f2>" @ $HUDtris::CurrentScore @ " points?\n\nYou made it\nto level " @ $HUDtris::Level @ "?\n\n<f1>Doh!\n\nTry again!\n";
	else if (%i == 2)
		return "<jc><f1>Improving...\n\nYou can still\ndo better!\n\n<f2>" @ $HUDtris::CurrentScore @ " points?\n\n<f1>My grandma\ncould score\nhigher!\n\n<f2>You made it\nto level " @ $HUDtris::Level @ "..\n\n<f1>Try again!\n";
	else if (%i == 3)
		return "<jc><f1>Ouch!\n\nCan you\ndo better?\n\n<f2>" @ $HUDtris::CurrentScore @ " points?\n\n<f1>I'm beginning\nto have my\ndoubts!\n\n<f2>You made it\nto level " @ $HUDtris::Level @ "..\n\n<f1>Try again!\n";
	else if (%i == 4)
		return "<jc><f1>Wow!\n\nYou were\non a roll!\n\n<f2>" @ $HUDtris::CurrentScore @ " points..\n\n<f1>What happened?\n\n<f2>You made it\nto level " @ $HUDtris::Level @ "!\n\n<f1>Don't give up..\n\nTry again!\n";
	else if (%i == 5)
		return "<jc><f1>Way Cool!\n\nYou're getting\nbetter!\n\n<f2>" @ $HUDtris::CurrentScore @ " points!\n\nYou made it\nto level " @ $HUDtris::Level @ "!\n\n<f1>Can you top\nthat? I bet\nthat you can!\n\nTry again!\n";
	else if (%i == 6)
		return "<jc><f1>Well Done!\n\n<f2>" @ $HUDtris::CurrentScore @ " points!\n\n<f1>Better and\nbetter...\n\n<f2>You made it\nto level " @ $HUDtris::Level @ "!\n\n<f1>I could still\nkick your butt\nat CTF though!\n\nTry again!\n";
	else if (%i == 7)
		return "<jc><f1>Amazing!\n\n<f2>" @ $HUDtris::CurrentScore @ " points!\n\n<f1>That's pretty\ndarn good!\n\n<f2>You made it\nto level " @ $HUDtris::Level @ "!\n\n<f1>Aren't you\nsupposed to be\nplaying Tribes?\n\nTry again!\n";
	else
		return "<jc><f1>Hmmn...\n\nYou are trying\nto win, right?\n\n<f2>" @ $HUDtris::CurrentScore @ " points?\n\n<f1>That's it?\n\n<f2>You made it\nto level " @ $HUDtris::Level @ "?\n\n<f1>Ouch!\n\nTry again!\n";
}

// if there is a new high score, show it!
function HUDtris::BoardOverlayNewHighScore() {
	Control::SetValue(Object::getName($HUDtris::BoardOverlayText), "<jc><f1>Nice Work!\n\n<f2>You just got a\nnew High Score!\n\n" @ $pref::HUDtris::HighScore @ " points!\n\n<f1>You think you\nare the best?\n\n<f2>Well... you\nonly made it\nto level " @ $HUDtris::Level @ "!\n\n<f1>Try again!\n");
}	

// rest the keys.. sometime the user might have a key held down
// this gets around that..
function HUDtris::BindKeysToNothing() {
	bindKey(play, $HUDtris:KeyLeft, "HUDtris::Nothing();", "HUDtris::Nothing();");
	bindKey(play, $HUDtris:KeyRight, "HUDtris::Nothing();", "HUDtris::Nothing();");
	bindKey(play, $HUDtris:KeyDown, "HUDtris::Nothing();", "HUDtris::Nothing();");
	bindKey(play, $HUDtris:KeyRotate, "HUDtris::Nothing();", "HUDtris::Nothing();");
}

// get the game keys set up
function HUDtris::BindKeysToStartPlay() {
	bindKey(play, $HUDtris:KeyLeft, "HUDtris::PlayMode();");
	bindKey(play, $HUDtris:KeyRight, "HUDtris::PlayMode();");
	bindKey(play, $HUDtris:KeyDown, "HUDtris::PlayMode();");
	bindKey(play, $HUDtris:KeyRotate, "HUDtris::PlayMode();");
}

// whatever...
function HUDtris::Nothing() {
	// don't want to update at the moment
	// just do nothing, and return
	return 0.1;
}

// i suggested this function to Presto... to 'seed' the random number generator
function InitializeGetRandom() {
	echo("Seeding random numbers... " @ $pref::burn_randoms);
	for (%i=0; %i < $pref::burn_randoms; %i++) {
		GetRandom();
	}
	$pref::burn_randoms = floor(GetRandom() * 32768);
}

// load the .vol file
newObject(HUDtris, SimVolume, "cowboy\\HUDtris.vol");

bindKey(play, $HUDtris:KeyToggle, "HUD::ToggleDisplay(HUDtris);");
	
Event::Attach(eventConnected, HUDtris::MakeHUD);

InitializeGetRandom();

if ($Presto::version >= 0.93) {
	Presto::AddScriptBanner(HUDtris, "<B3,4:HUDtrisPrestoBanner.bmp>");
	}
