// FlagTimerHUD - v0.7 beta
//
// (c) 7-1-99 Cowboy, don't modify this without my permission
// -
// Let me know of any BUGS or REASONABLE suggestions, thanks. My email
// is cowboy@planetstarsiege.com
// -
// This is a limited-release beta! It currently has no on/off toggle...
// (on my to-do list)
// -
// NOTE: Requires Presto Pack 0.93 or greater and ObjectiveHUD!
// 
// My Page: http://www.planetstarsiege.com/cowboy/
// Presto Pack: http://www.planetstarsiege.com/presto/
// ObjectiveHUD: http://www.crunchy.oaktree.co.uk/scripting/
// -
// Installation:
//
// put these files in tribes\config\cowboy\
//
// add the line: include("cowboy\\FlagTimerHUD.cs");
// to autoexec.cs somewhere AFTER the ObjectiveHUD line
// -
// My IRC conversation with AdrenFreak (from Planet Tribes) here:
//
// <[SS-12]Cowboy> heh
// <[SS-12]Cowboy> you there?
// <[SS-12]Cowboy> got a new hud I'm working on
// <[SS-12]Cowboy> ...
// <FSC-Adren-DTM> ?
// <[SS-12]Cowboy> you use objectivehud?
// <FSC-Adren-DTM> Yeah, I use Obj
// <[SS-12]Cowboy> cool
// <[SS-12]Cowboy> this requires it
// <[SS-12]Cowboy> it's basically a flag cap 'stopwatch'
// <[SS-12]Cowboy> every time you grab a flag of the stand, it starts a counter.
// <[SS-12]Cowboy> if and when YOU cap it, it ends the counter
// <[SS-12]Cowboy> saves best and average times on a per-map basis to an external file
// <[SS-12]Cowboy> for lifetime stats
// <[SS-12]Cowboy> if you grab a flag that someone else dropped, it won't time you.
// <[SS-12]Cowboy> it will time you ONLY if you are the original 'grabber'
// <[SS-12]Cowboy> :)
// <[SS-12]Cowboy> i was trying to see how fast i could cap on SnowBlind earlier
// <[SS-12]Cowboy> and i needed someone with a stopwatch to do it.. then i thought of this
// <[SS-12]Cowboy> :)
// <[SS-12]Cowboy> this beats the heck out of that
// <[SS-12]Cowboy> hehe
// <[SS-12]Cowboy> what do you think?
// <Adren-PTstaff> Cowboy?
// <Adren-PTstaff> I just missed everything you said after cool
// *** FSC-Adren-DTM has quit IRC (Connection reset by peer)
// <[SS-12]Cowboy> doh
// <Adren-PTstaff> This is getting annoying... two drops
// <Adren-PTstaff> Is this three?
//
// Then his response via ICQ once i resent him the text:
//
// "OOOOH!!!!! I can name 10 people who want that, I'm one of them. :)"


// Screen positioning:
//
// Normal positioning for the HUD (i put it here, on the right side of the screen)
// where it's out of the way of everything else. This HUD will resize downward, so
// if you get 10 caps in the game, it's going to be almost 200 pixels high! (keep
// this in mind when you decide on its location)

$FlagTimerHUD::X = "100%-6";
$FlagTimerHUD::Y = 85;


// Here begins the important stuff....
//
Include("Presto\\Event.cs");
Include("Crunchy\\Events.cs");
Include("Presto\\HUD.cs");
Include("Presto\\TeamTrak.cs");
Include("Crunchy\\ObjectiveTrak.cs");

// thanks to Crunchy.. these events are awesome
Event::Attach(eventFlagTaken, FlagTimerHUD::FlagTaken);
Event::Attach(eventFlagCaptured, FlagTimerHUD::FlagCaptured);
Event::Attach(eventFlagDropped, FlagTimerHUD::FlagDropped);
Event::Attach(eventFlagReturned, FlagTimerHUD::FlagReturned);

// Reset the HUD
Event::Attach(eventConnected, FlagTimerHUD::Initialize);
Event::Attach(eventChangeMission, FlagTimerHUD::ChangeMission);

// Move it between the Play Gui and  CmdObjectives Gui
Event::Attach(eventGuiOpen, FlagTimerHUD::ChangeGui);

// The notice banner
Presto::AddScriptBanner(FlagTimerHUD, "\n<f2><jc>FlagTimerHUD 0.7 beta\n\n<f1>The fastest HUD in the West\n\n<f2>(c) 7/1/99 - Cowboy\n\n<f1>cowboy@planetstarsiege.com");

// You shouldn't have to edit these
//
$FlagTimerHUD::Width = 120;
$FlagTimerHUD::objX = "100%-40";
$FlagTimerHUD::objY = 85;
$FlagTimerHUD::objWidth = 120;

// If the flag is taken
//
function FlagTimerHUD::FlagTaken(%teamNum, %client) {
	if (%client == getManagerID()) { 				// You grabbed the flag

		if ($FlagTimerHUD::OnStand) { 				// The flag was on the stand
			$FlagTimerHUD::GrabbedOffStand = true; 		// You grabbed it from their stand
			$FlagTimerHUD::StartTime = getSimTime(); 	// Start the timer
		}
		else if ($FlagTimerHUD::HasFlag != dropped) 		// You grabbed it from the field
			$FlagTimerHUD::GrabbedOffStand = false; 	// Someone else grabbed it from the stand

		$FlagTimerHUD::HasFlag = true; 				// You have the flag
	}

	if (%teamNum != Client::getTeam(getManagerId())) 		// The enemy's flag was grabbed
		$FlagTimerHUD::OnStand = false;				// so it's no longer on their stand
}

// If the flag is capped
//
function FlagTimerHUD::FlagCaptured(%teamNum, %client) {
	if (%teamNum != Client::getTeam(getManagerId())) {		// The enemy's flag was capped!
		$FlagTimerHUD::OnStand = true;				// It's back on it's stand
		$FlagTimerHUD::HasFlag = false;				// You don't have it
	}
	if (%client == getManagerID()) {				// You capped it
		$FlagTimerHUD::HasFlag = capped;

		if ($FlagTimerHUD::GrabbedOffStand)			// Did you grab it originally?
			$FlagTimerHUD::CapTime = $FlagTimerHUD::ElapsedTime;
	}
}

// If the flag is dropped
//
function FlagTimerHUD::FlagDropped(%teamNum, %client) {
	if (%client == getManagerID()) {				// You dropped the flag, mid-field
		$FlagTimerHUD::HasFlag = dropped;			
	}
	if (%teamNum != Client::getTeam(getManagerId()))		// The enemy's flag was dropped
		$FlagTimerHUD::OnStand = false;				// so, it can't be on the stand, can it?
}

// If the flag is returned
//
function FlagTimerHUD::FlagReturned(%teamNum, %client) {
	if (%teamNum != Client::getTeam(getManagerId())) {		// The enemy returned their flag
		$FlagTimerHUD::OnStand = true;				// It's back on its stand
		$FlagTimerHUD::HasFlag = returned;
	}
}

// The HUD update function
//
function FlagTimerHUD::Update() {
	// If you make the cap that ends the mission, the Server Time gets reset
	// before the HUD can update, and you end up with a huge negative number,
	// like -341.5 seconds (that REALLY screws up your 'best' and 'avg' speed! :)
	if (getSimTime() - $FlagTimerHUD::StartTime > 0)
		$FlagTimerHUD::ElapsedTime = getSimTime() - $FlagTimerHUD::StartTime;
		
	// match ended
	if ($FlagTimerHUD::MatchOver)
		Control::Setvalue(Object::getName($FlagTimerHUD::CurrentFrame), "<jc><f0>- Match Over -");
		
	// you just capped
	else if ($FlagTimerHUD::HasFlag == capped) {
		if ($FlagTimerHUD::GrabbedOffStand) {
			Control::Setvalue(Object::getName($FlagTimerHUD::CurrentFrame), "<jc><f1>Cap " @ $FlagTimerHUD::Lines - 2 @ ": <f2>" @ StopwatchStyle($FlagTimerHUD::CapTime));
			
			$FlagTimerHUD::AvgTime[$ServerMission] = (($FlagTimerHUD::AvgTime[$ServerMission] * $FlagTimerHUD::Caps[$ServerMission]) + $FlagTimerHUD::CapTime) / $FlagTimerHUD::Caps[$ServerMission]++;

			if ($FlagTimerHUD::BestTime[$ServerMission] == 0 || $FlagTimerHUD::CapTime < $FlagTimerHUD::BestTime[$ServerMission]) {
				$FlagTimerHUD::BestTime[$ServerMission] = $FlagTimerHUD::CapTime;
				FlagTimerHUD::UpdateBestTime("<f2>");
			}
			else
				FlagTimerHUD::UpdateBestTime("<f1>");
				
			// export all the variables.. keep track of 'lifetime stats' this way
			File::Delete("config\\FlagRunTimes.cs");
			export("$FlagTimerHUD::Caps*", "config\\FlagRunTimes.cs", true);
			export("$FlagTimerHUD::BestTime*", "config\\FlagRunTimes.cs", true);
			export("$FlagTimerHUD::AvgTime*", "config\\FlagRunTimes.cs", true);
		}
		else
			Control::Setvalue(Object::getName($FlagTimerHUD::CurrentFrame), "<jc><f1>Cap " @ $FlagTimerHUD::Lines - 2 @ ": <f2>(nr)");
		
		$FlagTimerHUD::CurrentFrame = FlagTimerHUD::Addline();
		$FlagTimerHUD::HasFlag = false;
		$FlagTimerHUD::ResetFlag = true;
	}
	
	// you have the flag
	else if ($FlagTimerHUD::HasFlag) {
		if ($FlagTimerHUD::GrabbedOffStand)
			Control::Setvalue(Object::getName($FlagTimerHUD::CurrentFrame), "<jc><f1> "@ StopwatchStyle($FlagTimerHUD::ElapsedTime));
		else
			Control::Setvalue(Object::getName($FlagTimerHUD::CurrentFrame), "<jc><f1>You have the Flag!");
	}
	
	// you dropped the flag (doh!)
	else if ($FlagTimerHUD::HasFlag == dropped) {
		if ($FlagTimerHUD::GrabbedOffStand)
			Control::Setvalue(Object::getName($FlagTimerHUD::CurrentFrame), "<jc><f0>" @ StopwatchStyle($FlagTimerHUD::ElapsedTime));
		else
			Control::Setvalue(Object::getName($FlagTimerHUD::CurrentFrame), "<jc><f0>Flag Dropped!");
	}
	
	// you gotta go get their flag
	else
		Control::Setvalue(Object::getName($FlagTimerHUD::CurrentFrame), "<jc><f0>Get their flag!");
		
	// update the HUD in this many seconds
	return 0.1;
}

// Add a new line of info to the HUD, return the object ID of the
// line's frame
//
function FlagTimerHUD::Addline() {
	HUD::Move(FlagTimerHUD, $FlagTimerHUD::X @" "@ $FlagTimerHUD::Y @" "@ $FlagTimerHUD::Width @" "@ $FlagTimerHUD::Lines++ * 16);
	return HUD::AddObject(FlagTimerHUD, FearGuiFormattedText, 0, ($FlagTimerHUD::Lines - 1) * 16 - 2, $FlagTimerHUD::Width, 16);
}

// Reset the HUD, laod all variables, etc...
//
function FlagTimerHUD::Initialize() {
	
	// Import 'lifetime stat' variables
	exec("FlagRunTimes.cs");
	
	// Make the HUD
	HUD::New(FlagTimerHUD, FlagTimerHUD::Update, $FlagTimerHUD::X @" "@ $FlagTimerHUD::Y @" "@ $FlagTimerHUD::Width @" "@ 16);

	$FlagTimerHUD::OnStand = true;
	$FlagTimerHUD::HasFlag = false;
	$FlagTimerHUD::MatchOver = false;

	$FlagTimerHUD::Lines = 0;
	$FlagTimerHUD::BestFrame = FlagTimerHUD::Addline();
	$FlagTimerHUD::AvgFrame = FlagTimerHUD::Addline();
	
	// I had to schedule this.. or it wouldn't actually work.. weird
	// (it'd make the frame, but not 'Move' the main HUD
	schedule("$FlagTimerHUD::CurrentFrame = FlagTimerHUD::Addline();", 10);
	
	Control::Setvalue(Object::getName($FlagTimerHUD::BestFrame), "<jc><f1>Checking...");
	Control::Setvalue(Object::getName($FlagTimerHUD::AvgFrame), "");

	// Wait a few secs to set this stuff... $ServerMission and
	// $ServerMissionType aren't set immediately
	schedule("FlagTimerHUD::SetServerMissionVars();", 10);
	schedule("FlagTimerHUD::UpdateBestTime(\"<f1>\");", 10);
	
	// show the hud, start it going
	HUD::Display(FlagTimerHUD, true);
	HUD::Update(FlagTimerHUD);
}

// Initialize the counters, if the mission type is not appropriate,
// Don't display the HUD
//
function FlagTimerHUD::SetServerMissionVars() {
	if ($ServerMissionType == "Capture the Flag" || $ServerMissionType == "Multiple Team") {
		if ($FlagTimerHUD::BestTime[$ServerMission] == 0) $FlagTimerHUD::BestTime[$ServerMission] = 0;
		if ($FlagTimerHUD::AvgTime[$ServerMission] == 0) $FlagTimerHUD::AvgTime[$ServerMission] = 0;
		if ($FlagTimerHUD::Caps[$ServerMission] == 0) $FlagTimerHUD::Caps[$ServerMission] = 0;
	}
	else 
		HUD::Display(FlagTimerHUD, false);
}	

// I just don't like rewriting code where i can use a function...
//
function FlagTimerHUD::UpdateBestTime(%color) {
	Control::Setvalue(Object::getName($FlagTimerHUD::BestFrame), "<jc><f1>Best: " @ %color @ StopwatchStyle($FlagTimerHUD::BestTime[$ServerMission]));
	Control::Setvalue(Object::getName($FlagTimerHUD::AvgFrame), "<jc><f1>Avg: <f1>" @ StopwatchStyle($FlagTimerHUD::AvgTime[$ServerMission]));
}

// If the mission is changed, do this stuff
//
function FlagTimerHUD::ChangeMission() {
	$FlagTimerHUD::MatchOver = true;
	HUD::Move(FlagTimerHUD, $FlagTimerHUD::objX @" "@ $FlagTimerHUD::objY @" "@ $FlagTimerHUD::objWidth @" "@ $FlagTimerHUD::Lines * 16);
	schedule("$FlagTimerHUD::MatchOver = false;", 20);
	schedule("FlagTimerHUD::Initialize();", 20);
}

// This should honestly be put into the Presto Pack, triggers
// an event when the Objective screen is opened
//
function CmdObjectivesGui::onOpen() {
	Event::Trigger(eventGuiOpen, CmdObjectivesGui);
}

// If you switch to the 'objective screen' it moves the HUD there too
// (so when the mission ends, you can see your best speed)
//
function FlagTimerHUD::ChangeGui(%gui) {
	if (%gui == PlayGui || %gui == CmdObjectivesGui)
		HUD::SetGui(FlagTimerHUD, %gui);
}

//
// Parse seconds into mm:ss.t
//
function StopwatchStyle(%time) {
	%minutes = floor(%time / 60);
	%seconds = %time % 60;
	%tenths = floor(%time * 10) - (floor(%time) * 10) ;
	%TimeString = %minutes @ ":";
	if (%Seconds < 10)
		%TimeString = %TimeString @ "0";
	return %TimeString @ %seconds @ "." @ %tenths;
}
