// FlagCapsHUD! - version 1.0
//
// (c) 7/8/99 Cowboy, don't modify this without my permission
// -
// Let me know of any BUGS, thanks. My email is cowboy@planetstarsiege.com
// -
// NOTE: Requires Presto Pack 0.93 or greater and ObjectiveTrak!
//       (ObjectiveTrak is part of the ObjectiveHUD package)
//
// Also, Zear's NewOpts is strongly recommended! Please use it! This *will*
// work without it installed, but NewOpts makes it SOOO much better, and I
// will not tell yuo how to edit this script manually if you ask. I will
// simply say "get NewOpts!" :)
// 
// My Page: http://www.planetstarsiege.com/cowboy/
// Presto Pack: http://www.planetstarsiege.com/presto/
// ObjectiveHUD: http://www.crunchy.oaktree.co.uk/scripting/
// Zear's NewOpts: http://www.planetstarsiege.com/zear/
// -
// Installation:
//
// unzip the .zip into your tribes\ directory!
//
// (these files should end up in tribes\config\cowboy\)
//
// add the line: include("cowboy\\FlagCapsHUD.cs");
// to autoexec.cs somewhere AFTER the exec("presto\\install.cs");
// line, and after the NewOpts line (if applicable)...
// -
// My IRC conversation with AdrenFreak (from Planet Tribes) here:
//
// <[SS-12]Cowboy> heh
// <[SS-12]Cowboy> you there?
// <[SS-12]Cowboy> got a new hud I'm working on
// <[SS-12]Cowboy> ...
// <FSC-Adren-DTM> ?
// <[SS-12]Cowboy> you use objectivehud?
// <FSC-Adren-DTM> Yeah, I use Obj
// <[SS-12]Cowboy> cool
// <[SS-12]Cowboy> this requires it
// <[SS-12]Cowboy> it's basically a flag cap 'stopwatch'
// <[SS-12]Cowboy> every time you grab a flag of the stand, it starts a counter.
// <[SS-12]Cowboy> if and when YOU cap it, it ends the counter
// <[SS-12]Cowboy> saves best and average times on a per-map basis to an external file
// <[SS-12]Cowboy> for lifetime stats
// <[SS-12]Cowboy> if you grab a flag that someone else dropped, it won't time you.
// <[SS-12]Cowboy> it will time you ONLY if you are the original 'grabber'
// <[SS-12]Cowboy> :)
// <[SS-12]Cowboy> i was trying to see how fast i could cap on SnowBlind earlier
// <[SS-12]Cowboy> and i needed someone with a stopwatch to do it.. then i thought of this
// <[SS-12]Cowboy> :)
// <[SS-12]Cowboy> this beats the heck out of that
// <[SS-12]Cowboy> hehe
// <[SS-12]Cowboy> what do you think?
// <Adren-PTstaff> Cowboy?
// <Adren-PTstaff> I just missed everything you said after cool
// *** FSC-Adren-DTM has quit IRC (Connection reset by peer)
// <[SS-12]Cowboy> doh
// <Adren-PTstaff> This is getting annoying... two drops
// <Adren-PTstaff> Is this three?
//
// Then his response via ICQ once i resent him the text:
//
// "OOOOH!!!!! I can name 10 people who want that, I'm one of them. :)"

if (included("newopts\\newopts.cs") != 1) {

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// Key Bindings / Screen positions (Only used if you're NOT running NewOpts)
//

$FlagCapsHUD:KeyToggle = "alt f5";	// Key to toggle the HUD in-game
$FlagCapsHUD:TauntCycle = "control f5"; // Key to cycle taunt-modes in-game

$pref::FlagCapsHUDDefaultDisplay = 3;	// Default HUD state on mission start.
					// 1 = ON
					// 2 = OFF
					// 3 = ON for CTF missions

$FlagCapsHUD:DefaultTauntMode = 2;	// This is the default 'taunt' setting.
					// 1 = DISABLED
					// 2 = GLOBAL
					// 3 = TEAM ONLY
}

function FlagCapsHUD::CheckXY() {

	// if x and y coord variables aren't set, restore defaults
	if ($pref::FlagCapsHUDx != "" && $pref::FlagCapsHUDy != "") return;
	echo("Restoring FlagCapsHUD X, Y HUD position defaults!");

	// Here are the default X and Y coordinates. This HUD will extend downwards,
	// so I'd recommend putting it in one of the top corners. This position is
	// under the default compass position, on the top right side of the screen.
	
	$pref::FlagCapsHUDx = "100%-6";
	$pref::FlagCapsHUDy = "85";
	
}

// !!!!!!! ----- end user editable section ----- !!!!!!!
//
// go away! nothing you could possibly want is in here..
//
// Here begins the "important" stuff....
//
Include("Presto\\Event.cs");
Include("Crunchy\\Events.cs");
Include("Presto\\HUD.cs");
Include("Presto\\say.cs");
Include("Presto\\TeamTrak.cs");
Include("Crunchy\\ObjectiveTrak.cs");

// thanks to Crunchy.. these events are awesome
Event::Attach(eventFlagTaken, FlagCapsHUD::FlagTaken);
Event::Attach(eventFlagCaptured, FlagCapsHUD::FlagCaptured);
Event::Attach(eventFlagDropped, FlagCapsHUD::FlagDropped);
Event::Attach(eventFlagReturned, FlagCapsHUD::FlagReturned);

// Reset the HUD
Event::Attach(eventConnected, FlagCapsHUD::Initialize);
Event::Attach(eventChangeMission, FlagCapsHUD::ChangeMission);

// Move it between the Play Gui and CmdObjectives Gui
Event::Attach(eventGuiOpen, FlagCapsHUD::ChangeGui);

// load the .vol file
newObject(FlagCapsHUD, SimVolume, "cowboy\\FlagCapsHUD.vol");

// make the .wav work! You can just type Say::Public(FCH); to say it! :)
Say::New(FCH, "FCH", "FlagCapsHUD!");

// The notice banner
Presto::AddScriptBanner(FlagCapsHUD, "<jr><b6,5:FCHPrestoBanner.bmp>\n<f2><jc> FlagCapsHUD! 1.0\n\n<f1> The fastest HUD\n in the West\n\n<f2> 7/8/99 - Cowboy\n");

// You shouldn't have to edit these
//
$FlagCapsHUD::objX = "100%-40";
$FlagCapsHUD::objY = 85;

// DON'T edit this
//
$FlagCapsHUD::Width = 74;

if ($pref::FlagCapsHUDDefaultTaunt == "") $pref::FlagCapsHUDDefaultTaunt = 2;
if ($pref::FlagCapsHUDDefaultDisplay == "") $pref::FlagCapsHUDDefaultDisplay = 3;

// If the flag is taken
//
function FlagCapsHUD::FlagTaken(%teamNum, %client) {
	if (Client::getTeam(%client) == Client::getTeam(getManagerId())) { 	
		if (%client == getManagerID()) {
			if ($FlagCapsHUD::OnStand || $FlagCapsHUD::GrabbedOffStand == getManagerId())
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 1);
			else
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 4);
		}
		else {
			if ($FlagCapsHUD::OnStand || $FlagCapsHUD::GrabbedOffStand != getManagerId())
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 2);
			else
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 3);
		}

		if ($FlagCapsHUD::OnStand) {
			$FlagCapsHUD::GrabbedOffStand = %client;
			$FlagCapsHUD::StartTime = getSimTime();
		}

		$FlagCapsHUD::HasFlag = %client;
		$FlagCapsHUD::OnStand = false;
	}
}

// If the flag is capped
//
function FlagCapsHUD::FlagCaptured(%teamNum, %client) {
	if (Client::getTeam(%client) == Client::getTeam(getManagerId())) {
		if (%client == getManagerID()) {				
			if ($FlagCapsHUD::GrabbedOffStand == getManagerId())			
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 1);
			else
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 4);	

			$FlagCapsHUD::HasFlag = capped;
		}
		else {		
			if ($FlagCapsHUD::GrabbedOffStand != getManagerId())
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 2);
			else
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 3);	

			$FlagCapsHUD::HasFlag = teamcapped;
		}
		
		$FlagCapsHUD::CapTime = $FlagCapsHUD::ElapsedTime;
		$FlagCapsHUD::OnStand = true;
	}
}

// If the flag is dropped
//
function FlagCapsHUD::FlagDropped(%teamNum, %client) {
	if (%teamNum != Client::getTeam(getManagerId())) {		
		$FlagCapsHUD::HasFlag = dropped;			
		$FlagCapsHUD::OnStand = false;
		$FlagCapsHUD::DroppedTime = getSimTime();
		FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 5);
	}
}

// If the flag is returned
//
function FlagCapsHUD::FlagReturned(%teamNum, %client) {
	if (%teamNum != Client::getTeam(getManagerId())) {		
		$FlagCapsHUD::OnStand = true;				
		$FlagCapsHUD::HasFlag = false;
		FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 8);
	}
}

// 'Safe' scheduling code from Presto! thanks!
//
function scheduled_FCH::Timer(%id) {
   if (%id != $FCH_scheduled_id)
      return;
   FlagCapsHUD::Update();
   schedule("scheduled_FCH::Timer("@$FCH_scheduled_id@");", 0.1);
   }
 
function schedule_FCH::Timer() {
   $FCH_scheduled_id++;
   schedule("scheduled_FCH::Timer("@$FCH_scheduled_id@");", 0.1);
   }
 
Event::Attach(eventConnected, schedule_FCH::Timer);

// The HUD update function
//
function FlagCapsHUD::Update() {
	// If you make the cap that ends the mission, the Server Time gets reset
	// before the HUD can update, and you end up with a huge negative number,
	// like -341.5 seconds (that REALLY screws up your 'best' and 'avg' speed!)
	if (getSimTime() - $FlagCapsHUD::StartTime > 0)
		$FlagCapsHUD::ElapsedTime = getSimTime() - $FlagCapsHUD::StartTime;
		
	// you just capped
	if ($FlagCapsHUD::HasFlag == capped) {
		if ($FlagCapsHUD::GrabbedOffStand == getManagerId()) {
			FlagCapsHUD::DrawText($FlagCapsHUD::Lines, "<jc><f1>" @ $FlagCapsHUD::Lines - 2 @ ": <f2>" @ StopwatchStyle($FlagCapsHUD::CapTime));
			
			if (!$PlayingDemo) {
				$FlagCapsHUD::AvgTime[$ServerMission] = (($FlagCapsHUD::AvgTime[$ServerMission] * $FlagCapsHUD::Caps[$ServerMission]) + $FlagCapsHUD::CapTime) / $FlagCapsHUD::Caps[$ServerMission]++;

				if ($FlagCapsHUD::BestTime[$ServerMission] == 0 || $FlagCapsHUD::CapTime < $FlagCapsHUD::BestTime[$ServerMission]) {
					$FlagCapsHUD::BestTime[$ServerMission] = $FlagCapsHUD::CapTime;
					FlagCapsHUD::UpdateBestTime(new);
				}
				else
					FlagCapsHUD::UpdateBestTime();

				if (floor(10 * $FlagCapsHUD::CapTime) <= floor(10 * $FlagCapsHUD::AvgTime[$ServerMission]))
					%capstring = "Flag Captured in " @ StopwatchStyle($FlagCapsHUD::CapTime) @ "... Beat that!";
				else
					%capstring = "Flag Captured!";
					
				if ($FlagCapsHUD:TauntMode == 2)
					schedule("Say::Public(FCH, \"" @ %capstring @ "\");", 1.5);
				else if ($FlagCapsHUD:TauntMode == 3)
					schedule("Say::Team(FCH, \"" @ %capstring @ "\");", 1.5);

				// export all the variables.. keep track of 'lifetime stats' this way
				File::Delete("config\\FlagCapTimes.cs");
				export("$FlagCapsHUD::Caps*", "config\\FlagCapTimes.cs", true);
				export("$FlagCapsHUD::BestTime*", "config\\FlagCapTimes.cs", true);
				export("$FlagCapsHUD::AvgTime*", "config\\FlagCapTimes.cs", true);
			}
		}
		else
			FlagCapsHUD::DrawText($FlagCapsHUD::Lines, "<jc><f1>" @ $FlagCapsHUD::Lines - 2 @ ": <f2>" @ StopwatchStyle($FlagCapsHUD::CapTime));
			
		FlagCapsHUD::Addline();
		$FlagCapsHUD::HasFlag = false;
	}

	// a teammate capped
	else if ($FlagCapsHUD::HasFlag == teamcapped) {
		FlagCapsHUD::DrawText($FlagCapsHUD::Lines, "<jc><f1>" @ $FlagCapsHUD::Lines - 2 @ ": <f2>" @ StopwatchStyle($FlagCapsHUD::CapTime));
		FlagCapsHUD::Addline();
		$FlagCapsHUD::HasFlag = false;
	}

	// match not yet started
	else if ($FlagCapsHUD::MatchOver == init)
		FlagCapsHUD::DrawText($FlagCapsHUD::Lines, "");

	// match ended
	else if ($FlagCapsHUD::MatchOver == over)
		return 1;
	
	else if ($FlagCapsHUD::HasFlag == dropped) {
		FlagCapsHUD::DrawText($FlagCapsHUD::Lines, "<jc><f2> "@ StopwatchStyle($FlagCapsHUD::ElapsedTime));
		%elapsed = floor((getSimTime() - $FlagCapsHUD::DroppedTime) * 10);
		
		if (%elapsed > 420) {
			if (%elapsed % 5 < 1)
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 7);
			else
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 5);
		}
		else if (%elapsed > 360) {
			if (%elapsed % 10 < 2)
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 7);
			else
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 5);
		}
		else if (%elapsed > 280) {
			if (%elapsed % 20 < 4)
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 7);
			else
				FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 5);
		}
	}
	
	// their flag is not in their base
	else if (!$FlagCapsHUD::OnStand) {
		FlagCapsHUD::DrawText($FlagCapsHUD::Lines, "<jc><f2> "@ StopwatchStyle($FlagCapsHUD::ElapsedTime));
	}
	
	// their flag is in their base
	else
		FlagCapsHUD::DrawText($FlagCapsHUD::Lines, "<jc><f1>Ready...");
		
	// update the HUD in this many seconds
	return 0.1;
}

// Put the appropriate bitmap in the appropriate line
//
function FlagCapsHUD::DrawBitmap(%index, %n) {
	Control::Setvalue(Object::getName($FlagCapsHUD::BitmapBox[%index]), "<B2,1:FCH-" @ %n @ ".bmp>");
}

// Put the appropriate text in the appropriate line
//
function FlagCapsHUD::DrawText(%index, %string) {
	Control::Setvalue(Object::getName($FlagCapsHUD::TextBox[%index]), %string);
}

// Add a new line of info to the HUD, return the object ID of the
// line's frame
//
function FlagCapsHUD::Addline() {
	HUD::Move(FlagCapsHUD, $pref::FlagCapsHUDx @" "@ $pref::FlagCapsHUDy @" "@ $FlagCapsHUD::Width @" "@ $FlagCapsHUD::Lines++ * 16 + 2);
	$FlagCapsHUD::BitmapBox[$FlagCapsHUD::Lines] = HUD::AddObject(FlagCapsHUD, FearGuiFormattedText, 0, ($FlagCapsHUD::Lines - 1) * 16, $FlagCapsHUD::Width, 16);
	$FlagCapsHUD::TextBox[$FlagCapsHUD::Lines] = HUD::AddObject(FlagCapsHUD, FearGuiFormattedText, 0, ($FlagCapsHUD::Lines - 1) * 16, $FlagCapsHUD::Width, 16);
	if ($FlagCapsHUD::Lines > 2)
		FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 8);
	else
		FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 6);
}

// Reset the HUD, laod all variables, etc...
//
function FlagCapsHUD::Initialize() {
	
	// Import 'lifetime stat' variables
	exec("FlagCapTimes.cs");
	
	// Make the HUD
	FlagCapsHUD::CheckXY();
	HUD::New(FlagCapsHUD, "", $FlagCapsHUD::X @" "@ $FlagCapsHUD::Y @" "@ $FlagCapsHUD::Width @" "@ 16);

	if (included("newopts\\newopts.cs") == 1)
		$FlagCapsHUD:TauntMode = $pref::FlagCapsHUDDefaultTaunt;
	else 
		$FlagCapsHUD:TauntMode = $FlagCapsHUD:DefaultTauntMode;

	$FlagCapsHUD::OnStand = true;
	$FlagCapsHUD::HasFlag = false;
	$FlagCapsHUD::MatchOver = init;

	$FlagCapsHUD::Lines = 0;
	FlagCapsHUD::Addline();
	FlagCapsHUD::Addline();
	FlagCapsHUD::Addline();
	
	FlagCapsHUD::DrawText(1, "<jc><f1>Please");
	FlagCapsHUD::DrawText(2, "<jc><f1>wait...");

	// Wait a few secs to set this stuff... $ServerMission and
	// $ServerMissionType aren't set immediately
	schedule("FlagCapsHUD::SetServerMissionVars();", 10);
	schedule("FlagCapsHUD::UpdateBestTime();", 10);
	
	// show the hud, start it going
	if ($pref::FlagCapsHUDDefaultDisplay == 1)
		HUD::Display(FlagCapsHUD, false);
	else if ($pref::FlagCapsHUDDefaultDisplay == 2 || $pref::FlagCapsHUDDefaultDisplay == 3)
		HUD::Display(FlagCapsHUD, true);

	HUD::Update(FlagCapsHUD);
}

// Initialize the counters, if the mission type is not appropriate,
// Don't display the HUD
//
function FlagCapsHUD::SetServerMissionVars() {
	if ($ServerMissionType != "Capture the Flag" && $ServerMissionType != "Multiple Team" && $pref::FlagCapsHUDDefaultDisplay != 2)
		HUD::Display(FlagCapsHUD, false);
	
	if ($FlagCapsHUD::BestTime[$ServerMission] == 0) $FlagCapsHUD::BestTime[$ServerMission] = 0;
	if ($FlagCapsHUD::AvgTime[$ServerMission] == 0) $FlagCapsHUD::AvgTime[$ServerMission] = 0;
	if ($FlagCapsHUD::Caps[$ServerMission] == 0) $FlagCapsHUD::Caps[$ServerMission] = 0;

	$FlagCapsHUD::MatchOver = false;
}	

// I just don't like rewriting code where i can use a function...
// Update the 'best' and 'avg' times
//
function FlagCapsHUD::UpdateBestTime(%n) {
	if (%n == new) {
		FlagCapsHUD::DrawBitmap(1, 11);
		FlagCapsHUD::DrawText(1, "<jc><f2>   " @ StopwatchStyle($FlagCapsHUD::BestTime[$ServerMission]));
	}
	else {
		FlagCapsHUD::DrawBitmap(1, 9);
		FlagCapsHUD::DrawText(1, "<jc><f1>   " @ StopwatchStyle($FlagCapsHUD::BestTime[$ServerMission]));
	}

	if ($PlayingDemo) {
		FlagCapsHUD::DrawBitmap(2, 5);
		FlagCapsHUD::DrawText(2, "<jc><f1>DEMO<f1>");
	}
	else {
		FlagCapsHUD::DrawBitmap(2, 10);
		FlagCapsHUD::DrawText(2, "<jc><f1>   " @ StopwatchStyle($FlagCapsHUD::AvgTime[$ServerMission]));
	}
}

// If the mission is changed, do this stuff
//
function FlagCapsHUD::ChangeMission() {
	$FlagCapsHUD::MatchOver = over;

	schedule("FlagCapsHUD::ChangeGui(CmdObjectivesGui);", 1);
	schedule("FlagCapsHUD::DrawBitmap($FlagCapsHUD::Lines, 8);", 1);
	schedule("FlagCapsHUD::DrawText($FlagCapsHUD::Lines, \"<jc><f1>Done!\");", 1);
	schedule("$FlagCapsHUD::MatchOver = false;", 20);
	schedule("FlagCapsHUD::Initialize();", 20);
}

// This should honestly be put into the Presto Pack, triggers
// an event when the Objective screen is opened
//
function CmdObjectivesGui::onOpen() {
	Event::Trigger(eventGuiOpen, CmdObjectivesGui);
}

// If you switch to the 'objective screen' it moves the HUD there too
// (so when the mission ends, you can see your best speed)
//
function FlagCapsHUD::ChangeGui(%gui) {
	if (%gui == PlayGui) {
		HUD::SetGui(FlagCapsHUD, %gui);
		HUD::Move(FlagCapsHUD, $pref::FlagCapsHUDx @" "@ $pref::FlagCapsHUDy @" "@ $FlagCapsHUD::Width @" "@ $FlagCapsHUD::Lines * 16 + 2);
	}
	else if (%gui == CmdObjectivesGui) {
		HUD::SetGui(FlagCapsHUD, %gui);
		HUD::Move(FlagCapsHUD, $FlagCapsHUD::objX @" "@ $FlagCapsHUD::objY @" "@ $FlagCapsHUD::Width @" "@ $FlagCapsHUD::Lines * 16 + 2);
	}
}

// hmmn.. cycle the taunts?
//
function FlagCapsHUD::TauntCycle(%n) {
	if (%n != "") $FlagCapsHUD:TauntMode = %n - 1;
	
	if ($FlagCapsHUD:TauntMode++ == 1)
		remoteBP(2048, "<jc><f1>FlagCapsHUD Cap Announce <f2>DISABLED", 3);
	else if ($FlagCapsHUD:TauntMode == 2)
		remoteBP(2048, "<jc><f1>FlagCapsHUD Cap Announce <f2>GLOBAL", 3);
	else if ($FlagCapsHUD:TauntMode == 3)
		remoteBP(2048, "<jc><f1>FlagCapsHUD Cap Announce <f2>TEAM ONLY", 3);
	else {
		$FlagCapsHUD:TauntMode = 0;
		FlagCapsHUD::TauntCycle();
	}
}

//
// Parse seconds into mm:ss.t
//
function StopwatchStyle(%time) {
	%minutes = floor(%time / 60);
	%seconds = %time % 60;
	%tenths = floor(%time * 10) - (floor(%time) * 10) ;
	%TimeString = %minutes @ ":";
	if (%Seconds < 10)
		%TimeString = %TimeString @ "0";
	return %TimeString @ %seconds @ "." @ %tenths;
}

// Setup NewOpts options page
function FlagCapsHUD::NewOptsOpen() {
	Control::setValue(FCH::HUDBitmap, "<B0,0:FCHPrestoBanner.bmp>");
	Control::setText(FCH::Xoffset, $pref::FlagCapsHUDx);
	Control::setText(FCH::Yoffset, $pref::FlagCapsHUDy);

	FGCombo::clear(FCH::DefaultTauntSelect);
	FGCombo::addEntry(FCH::DefaultTauntSelect, "Disabled", 1);
	FGCombo::addEntry(FCH::DefaultTauntSelect, "Public Say", 2);
	FGCombo::addEntry(FCH::DefaultTauntSelect, "Team Say", 3);
	FGCombo::setSelected(FCH::DefaultTauntSelect, $pref::FlagCapsHUDDefaultTaunt);
	
	FGCombo::clear(FCH::DefaultDisplaySelect);
	FGCombo::addEntry(FCH::DefaultDisplaySelect, "Start Off", 1);
	FGCombo::addEntry(FCH::DefaultDisplaySelect, "Start On", 2);
	FGCombo::addEntry(FCH::DefaultDisplaySelect, "On for CTF", 3);
	FGCombo::setSelected(FCH::DefaultDisplaySelect, $pref::FlagCapsHUDDefaultDisplay);
}

function FlagCapsHUD::SetDefaultTaunt() {
	$pref::FlagCapsHUDDefaultTaunt = FGCombo::getSelected(FCH::DefaultTauntSelect);
	$FlagCapsHUD:TauntMode = $pref::FlagCapsHUDDefaultTaunt;
}	

function FlagCapsHUD::SetDefaultDisplay() {
	$pref::FlagCapsHUDDefaultDisplay = FGCombo::getSelected(FCH::DefaultDisplaySelect);
}

// Close NewOpts options page, check that coordinates are valid
function FlagCapsHUD::NewOptsClose() {
	$pref::FlagCapsHUDx = NewOpts::validateAlphaText($pref::FlagCapsHUDx, "1234567890%+-");
	$pref::FlagCapsHUDy = NewOpts::validateAlphaText($pref::FlagCapsHUDy, "1234567890%+-");
}

// If NewOpts is NOT installed, set default keys (defineable at the
// top of this script)
function FlagCapsHUD::CheckNewOpts() {
	if (included("newopts\\newopts.cs") == 1) {
		NewOpts::registerHelp("FlagCapsHUD!",	"<jc>Screen Position\n",
						"<jl>Set the X and Y position of the HUD here. The format of the coordinates " @
						"is the same as in Presto's HUD.cs.\n\nThe defaults are X: <f2>100%-6<f1>, Y: <f2>85<f1>.\n\n" @
						"Please note that when you close the NewOpts page, it will try to validate the coordinates " @
						"by filtering out all characters other than <f2>1234567890%+- <f1>I bet if you try hard enough " @
						"you can screw it up though...");

		NewOpts::registerHelp("FlagCapsHUD!",	"<jc>How it Works\n",
						"<jl>Every time the flag is grabbed off the enemy's flag stand, it starts a timer. This timer " @
						"counts upwards in 0.1 second intervals. When the flag is capped, the timer is stopped, and the " @
						"line is recorded in the HUD.\n\n<jc><f2>NOTE: The cap time only gets saved\nexternally if YOU grab the\n" @
						"flag and YOU cap it.\n\n<jl><f1>Your best and average time, along with the total number of caps are " @
						"saved externally to the file <f2>FlagCapTimes.cs <f1>in the tribes\\config\\ directory, on a per-map basis.");
		
		NewOpts::registerHelp("FlagCapsHUD!",	"<jc>State-of-the-HUD\n",
						"<jl>I like to use <f2>Alt-F5 <f1>for the HUD toggle, although I must say, I don't need it often... " @
						"You can set the HUD to default to ON on CTF missions (and Multiple-Team CTF missions), as those are really " @
						"the only maps it will do anything on... Or you can just change it to always be ON or OFF. The HUD will " @
						"still track and register caps regardless of its display state! And if it doesn't come up.. or you want " @
						"it to go away, just toggle it!");

		NewOpts::registerHelp("FlagCapsHUD!",	"<jc>Taunting?\n",
						"<jl>It's not a BAD taunt.. it only displays if you grab the flag AND cap it... If you beat your average, " @
						"It tells everyone your cap time (and plays a REALLY cool .wav file) - You can choose to disable it, say it " @
						"publicly, or just tell your teammates.. My default Taunt-mode cycle key is <f2>Ctrl-F5 <f1> - and BTW, the " @
						"\"voice\" is just me doing my worst \"Boston Accent\" (Ted Kennedy impersonation), saying <f2>FlagCapsHUD!");

		NewOpts::registerHelp("FlagCapsHUD!",	"<jc>There you go...\n",
						"<jl>A funny story... This idea came up originally while I was racing a fellow teammate on " @
						"SnowBlind - he had a stopwatch and I didn't, so I kept asking him to time me.. I think this is " @
						"a LITTLE more accurate.. and looks neat too! :) If you have questions, you can send email to " @
						"<f2>cowboy@planetstarsiege.com<f1>\n\n" @
						"<jc>Or visit my web page at <f2>http://www.planetstarsiege.com/cowboy/<f1>\n\n" @
						"Thanks, Cowboy - 7/8/99");
			
		
		NewOpts::Register("FlagCapsHUD!", "FlagCapsHUD.gui", "FlagCapsHUD::NewOptsOpen();", "FlagCapsHUD::NewOptsClose();", true);
		
		// disallow resizing the HUD in MudMover
		HudMover::constrainHud(FlagCapsHUD, size);
	}
	else {
		echo("NewOpts not installed! Setting FlagCapsHUD Toggle Key to: " @ $FlagCapsHUD:KeyToggle @ " via script!");
		echo("NewOpts not installed! Setting FlagCapsHUD Taunt Cycle Key to: " @ $FlagCapsHUD:TauntCycle @ " via script!");
		echo("If you DID install NewOpts, make sure FlagCapsHUD.cs is loaded AFTER NewOpts in Autoexec.cs!");

		bindKey(play, $FlagCapsHUD:KeyToggle, "HUD::ToggleDisplay(FlagCapsHUD);");
		bindKey(play, $FlagCapsHUD:TauntCycle, "FlagCapsHUD::TauntCycle();");
	}
}

FlagCapsHUD::CheckNewOpts();

FlagCapsHUD::CheckXY();
