// DemoHUD++ version 1.1
//
// (c) 7/25/99 Cowboy, don't modify this without my permission
//
//    Written by: Cowboy
//    Code ideas and bitmaps: Mannkind
//    Original Concept: Faze
//
// Let me know of any BUGS, thanks. My email is cowboy@planetstarsiege.com
// 
// NOTE: Requires Presto Pack 0.93 or greater!
//
// Also, Zear's NewOpts is strongly recommended! Please use it! This *will*
// work without it installed, but NewOpts makes it SOOO much better, and I
// will not tell yuo how to edit this script manually if you ask. I will
// simply say "get NewOpts!" :)
// 
// My Page: http://www.planetstarsiege.com/cowboy/
// Presto Pack: http://www.planetstarsiege.com/presto/
// Zear's NewOpts: http://www.planetstarsiege.com/zear/
// 
// Installation:
//
// unzip the .zip into your tribes\ directory!
//
// (these files should end up in tribes\config\cowboy\)
//
// add the line: include("cowboy\\DemoHUD.cs");
// to autoexec.cs somewhere AFTER the exec("presto\\install.cs");
// line, and after the NewOpts line (if applicable)...
//
// NOTE: Please check that NO OTHER DemoHUD is loaded. This is a complete
//       relacement for ANY other "DemoHUD"

//
// This is the "doesn't have NewOpts section"
//
// default X and Y coords... edit manually if you don't have HudMover

$DemoHUD::X = "6";
$DemoHUD::Y = "65%";

if (!included("newopts\\newopts.cs")) {

// Auto-move DemoHUD++ to different GUIs ?
$pref::DemoHUDChangeGui = false;

// default keys... edit manually if you don't have NewOpts

bindKey(play, "control right"	,"DemoHUD::ChangeSpeed(ff);");
bindKey(play, "control up"	,"DemoHUD::ChangeSpeed();");
bindKey(play, "control down"	,"DemoHUD::ChangeSpeed(pause);");
bindKey(play, "control left"	,"DemoHUD::ChangeSpeed(sd);");
bindKey(play, "alt f8"		,"DemoHUD::ToggleHUD();");

// set a Skin!

$pref::DemoHUDSkin = 1;		// 1: Wood	2: Blue
				// 3: Brick	4: Metal
				// 5: Spark	6: Water
				// 7: Fruit

echo("NewOpts not installed - setting default keys/settings via script!");
}

// Define the 'steps' used for speed changes
//
// done this way, there's a LOT less condition checking!
//
$DemoHUD::Scale[0] = 0;
$DemoHUD::Scale[1] = 0.25;
$DemoHUD::Scale[2] = 0.5;
$DemoHUD::Scale[3] = 1;
$DemoHUD::Scale[4] = 2;
$DemoHUD::Scale[5] = 3;
$DemoHUD::Scale[6] = 4;
$DemoHUD::Scale[7] = 5;
$DemoHUD::Scale[8] = 6;
$DemoHUD::Scale[9] = 8;
$DemoHUD::Scale[10] = 10;
$DemoHUD::Scale[11] = 12;
$DemoHUD::Scale[12] = 14;
$DemoHUD::Scale[13] = 16;
$DemoHUD::Scale[14] = 20;
$DemoHUD::Scale[15] = 24;

// Check the CPU speed, and limit the max ff speed, so you don't crash
// your machine!
//
// Mannkind - what do you think of this code? :)
//
if ($CPU::EstimatedSpeed < 200)
	$DemoHUD::SpeedLimit = 6;
else if ($CPU::EstimatedSpeed <= 233)
	$DemoHUD::SpeedLimit = 8;
else if ($CPU::EstimatedSpeed <= 300)
	$DemoHUD::SpeedLimit = 10;
else if ($CPU::EstimatedSpeed <= 333)
	$DemoHUD::SpeedLimit = 11;
else if ($CPU::EstimatedSpeed <= 400)
	$DemoHUD::SpeedLimit = 12;
else if ($CPU::EstimatedSpeed <= 450)
	$DemoHUD::SpeedLimit = 13;
else if ($CPU::EstimatedSpeed < 500)
	$DemoHUD::SpeedLimit = 14;
else
	$DemoHUD::SpeedLimit = 15;

// Load the volume (.gui and .bmp files)
//
newObject(DemoHUD, SimVolume, "cowboy\\DemoHUD.vol");

// The notice banner
Presto::AddScriptBanner(DemoHUD, "<B6,20:DemoHUDPrestoBanner.bmp>\n<jc><f1>View \nDemos in \nStyle! \n\n<f0>Now, \nPoint \n& Click! ");

// Instead of a seperate function for each different button, make one function
// that you can pass four different params to! Cut down on code this way!
//
function DemoHUD::ChangeSpeed(%speed) {
	if ($PlayingDemo) {							// we ARE playing a demo right?
	
		if (%speed == pause)						//  pause
			$DemoHUD::CurrentScale = 0;				//   set speed to 0, pause

        	else if (%speed == sd) {					//  slow down
        		if ($DemoHUD::CurrentScale > 1)				//   if we CAN,
				$DemoHUD::CurrentScale--;			//    slow it down
				
	        	else if ($DemoHUD::CurrentScale == 0)			//  if we're paused,
				$DemoHUD::CurrentScale = 2;			//   slow down as if from 1x
		}
		
		else if (%speed == ff) {					//  fast forward
			if ($DemoHUD::CurrentScale < $DemoHUD::SpeedLimit) {	//   if we CAM speed up,
				
				if ($DemoHUD::CurrentScale == 0)		//    (if we're paused,
					$DemoHUD::CurrentScale = 3;		//     set to 1x speed)
					
				$DemoHUD::CurrentScale++;			//    then speed up!
			}
		}
		else								// play (no param, default)
			$DemoHUD::CurrentScale = 3;				//  1x speed!
        		
	}
	else
		$DemoHUD::CurrentScale = 3;					//  if not in demo, set to 1x speed!
	
	$SimGame::TimeScale = $DemoHUD::Scale[$DemoHUD::CurrentScale];		// actually SET the game speed

	UpdateDemoHud();							// update the HUD!
}	

// Update the HUD!
//
function UpdateDemoHUD() {
	// draw the Background
	Control::Setvalue(Object::getName($DemoHUD::BackgroundLayer), "<B0,0:DemoHUDSkin" @ $pref::DemoHUDSkin @ ".bmp>");
	
	// Paused	
	if ($DemoHUD::Scale[$DemoHUD::CurrentScale] == 0) {
		Control::Setvalue(Object::getName($DemoHUD::ButtonLayer), "<jl><B35,0:DemoHUDpause.bmp>");
		Control::Setvalue(Object::getName($DemoHUD::TextLayer), "<jc><f0>DemoHUD++\n<f1>Paused");
	}
	
	// Slowed down
	else if ($DemoHUD::Scale[$DemoHUD::CurrentScale] < 1) {
		Control::Setvalue(Object::getName($DemoHUD::ButtonLayer), "<jl><B9,0:DemoHUDsd.bmp>");
		Control::Setvalue(Object::getName($DemoHUD::TextLayer), "<jc><f0>DemoHUD++\n<f1>Speed:<f1> " @ $DemoHUD::Scale[$DemoHUD::CurrentScale] @ "x");
	}
	
	// Fast Forward
	else if ($DemoHUD::Scale[$DemoHUD::CurrentScale] > 1) {
		Control::Setvalue(Object::getName($DemoHUD::ButtonLayer), "<jr><B8,0:DemoHUDff.bmp>");
		Control::Setvalue(Object::getName($DemoHUD::TextLayer), "<jc><f0>DemoHUD++\n<f1>Speed:<f1> " @ $DemoHUD::Scale[$DemoHUD::CurrentScale] @ "x");
	}
	
	// Plasy Speed
	else {
		Control::Setvalue(Object::getName($DemoHUD::ButtonLayer), "<jr><B34,0:DemoHUDplay.bmp>");
		Control::Setvalue(Object::getName($DemoHUD::TextLayer), "<jc><f0>DemoHUD++\n<f1>Normal");
	}
	
	return 0;
}


// Initialize the HUD and settings
//
function DemoHUD::Init() {
	DemoHUD::CheckSize();					// make sure HudMover's DemoHUD settings are correct!
	DemoHUD::ChangeSpeed();					// set play speed to 1x
	DemoHUD::CheckSkin();					// make sure the skin is ok
	
	UpdateDemoHUD();					// Redraw the HUD
	HUD::Display(DemoHUD, false);				// turn the HUD off
	
	schedule("HUD::Display(DemoHUD, $PlayingDemo);", 5);	// schedule to show/hide the hud in 5 seconds
}

// This is the actual "Presto" HUD update function
//
function DemoHUDLoop() {
	if ($PlayingDemo) {			// If we're in a demo
		cursorOn(MainWindow);		//  Show the mouse cursor (for point & clickiness)
		return 0.5;			//  check back in this many seconds
	}
	else {					// not playing a demo
		DemoHUD::ChangeSpeed();		//  set play speed to 1x
		return 2;			//  return in 2 seconds - JUST in case... weird things have happened!
	}
}

// Do you want DemoHUD++ to "follow" you around as you travel through the different GUIs?
//
function DemoHUD::ChangeGui(%gui) {
	
	// if you're in a demo and in one of the different GUIs, switch if necessary
	if (%gui == PlayGui || %gui == CommandGui || %gui == CmdInventoryGui || %gui == CmdObjectivesGui) {
		if ($PlayingDemo && $pref::DemoHUDChangeGui)
			HUD::SetGui(DemoHUD, %gui);
	}
}

// This is going into presto 0.94
//
if ($Presto::version < 0.94) {
	function CmdObjectivesGui::onOpen() {
		Event::Trigger(eventGuiOpen, CmdObjectivesGui);
	}
}

// Toggle the HUD
//
function DemoHUD::ToggleHUD() {
	HUD::ToggleDisplay(DemoHUD);		// Toggle the HUD
	
	if (!HUD::GetDisplayed(DemoHUD))	// If the HUD has been shut off
		cursorOff(MainWindow);		//  disable the mouse cursor
}

// make sure HudMover's DemoHUD settings are correct!
//
// (if someone had an older "DemoHUD" that was a different size, fix it!)
//
function DemoHUD::CheckSize() {
	if (getWord($Hud::prefs::last::DemoHUD, 2) != 118 || getWord($Hud::prefs::last::DemoHUD, 3) != 86)
		$Hud::prefs::last::DemoHUD = $DemoHUD::X @" "@ $DemoHUD::Y @" 118 86";

	if (getWord($Hud::prefs::default::DemoHUD, 2) != 118 || getWord($Hud::prefs::default::DemoHUD, 3) != 86)
		$Hud::prefs::default::DemoHUD = $DemoHUD::X @" "@ $DemoHUD::Y @" 118 86";
}

// Make the HUD. Only do this once, when this script is first loaded.
//
function DemoHUD::CreateHUD() {
	// make the HUD
	HUD::New(DemoHUD, DemoHUDLoop, $DemoHUD::X @" "@ $DemoHUD::Y @" 118 86");

	// make the 3 'layers'
	$DemoHUD::BackgroundLayer = HUD::AddObject(DemoHUD, FearGuiFormattedText, 0, 0, 118, 86);
	$DemoHUD::TextLayer = HUD::AddObject(DemoHUD, FearGuiFormattedText, 0, 17, 118, 46);
	$DemoHUD::ButtonLayer = HUD::AddObject(DemoHUD, FearGuiFormattedText, 0, 60, 118, 30);

	// make the 'clickable' buttons
	$DemoHUD::sdButton = newObject("DemoHUD::sdButton", FearGui::FGUniversalButton, 10, 1, 22, 18, "", "DemoHUD::ChangeSpeed(sd);");
	$DemoHUD::pauseButton = newObject("DemoHUD::pauseButton", FearGui::FGUniversalButton, 36, 1, 22, 18, "", "DemoHUD::ChangeSpeed(pause);");
	$DemoHUD::playButton = newObject("DemoHUD::playButton", FearGui::FGUniversalButton, 62, 1, 22, 18, "", "DemoHUD::ChangeSpeed();");
	$DemoHUD::ffButton = newObject("DemoHUD::ffButton", FearGui::FGUniversalButton, 88, 1, 22, 18, "", "DemoHUD::ChangeSpeed(ff);");

	// put the buttons in the HUD
	addToSet($DemoHUD::ButtonLayer, $DemoHUD::sdButton);
	addToSet($DemoHUD::ButtonLayer, $DemoHUD::pauseButton);
	addToSet($DemoHUD::ButtonLayer, $DemoHUD::playButton);
	addToSet($DemoHUD::ButtonLayer, $DemoHUD::ffButton);

	// don't let HudMover resize the HUD (just move it)
	HudMover::constrainHud(DemoHUD, size);
}

// NewOpts Stuff
//
function DemoHUD::NewOptsInit() {
	if (included("newopts\\newopts.cs")) {
		
		NewOpts::registerHelp("DemoHUD++",	"<jc>Keep it simple\n",
							"<jl>OK... This is meant to be really simple. It requires <f2>NewOpts <f1>support to bind keys. " @
							"If you want to move the HUD, use <f2>HudMover. <f1>(Suggestion, PAUSE the demo before moving the HUD) " @
							"You can point + click on the HUD's buttons to change speeds. You can just use the keys. It " @
							"doesn't matter to me! <f2>NOTE: if the TAB menu is displayed, you can't click the buttons.. " @
							"<f1>This is a 'feature' in tribes itself, and cannot be changed.");

		NewOpts::registerHelp("DemoHUD++",	"<jc>Also,\n",
							"<jl>There is a keybind for the <f2>Toggle <f1>because it was requested.. And a checkbox if you want " @
							"to have DemoHUD++ <f2>change GUIs <f1>through the demo (like the Command Map screen, Inventory screen, etc.\n\n" @
							"OH YEAH! almost forgot - <f2>CUSTOM SKINS! <f1>Hee hee hee.. Anything is possible in Tribes!");

		NewOpts::registerHelp("DemoHUD++",	"<jc>Shout-outs\n",
							"<jl>This originally started with me a few weeks ago. <f2>Mannkind <f1>was adding NewOpts support " @
							"to <f2>Faze's <f1>original HUD.. I suggested, that while he was at it, he should really make some nice custom " @
							"bitmaps too.. <f2>(I had just finished HUDtris and FlagCapsHUD! and was a little bitmap-crazed) " @
							"<f1>Well, he <f2>finally <f1>caved in, and made some bitmaps (the ones you see as the buttons now) " @
							"but was having troubles with the palette... So, I converted them, and he included them in his latest " @
							"release.\n\nWell... I needed more! I figured, why not make this thing look <f2>REALLY <f1>cool, so I just " @
							"started hacking away at it. Well, I wasn't too happy with the source.. So I just decided to write it " @
							"again, from scratch. Took me a couple hours, and I cut the code down to less than 1/2 the size. I " @
							"also fixed the little bit about it <f2>HANGING <f1>my damn computer.. and found a nice little " @
							"variable to automatically detect the CPU speed (just browse the .exe)\n\nAnd of course, <f2>GrymReaper " @
							"<f1>had to add his <f2>$0.02, <f1>so he made me add the point + click bit in... Not too hard. OK! That's it!");

		NewOpts::registerHelp("DemoHUD++",	"<jc>So,\n",
							"<jl>in case you DIDN'T get that, thanks to <f2>Faze <f1>(original script), <f2>Mannkind <f1>(code, lotsa ideas, and GFX), " @
							"<f2>GrymReaper <f1>(bugging me), and of course <f2>Zear <f1>(for making NewOpts and HudMover so easy to use) !!!!!!");
						
		NewOpts::registerHelp("DemoHUD++",	"<jc>Enjoy this!\n",
							"If you have any questions, you can send email to " @
							"<f2>cowboy@planetstarsiege.com<f1>\n\n" @
							"<jc>Or visit my web page at <f2>http://www.planetstarsiege.com/cowboy/<f1>\n\n" @
							"Thanks, Cowboy - 7/25/99");

		NewOpts::Register("DemoHUD++", "DemoHUD.gui", "DemoHUD::NewOptsOpen();", "", true);
		
	}
}

// When you open the NewOpts page, do this:
//
function DemoHUD::NewOptsOpen() {
	Control::Setvalue(DemoHUD::pauseBitmap, "<B0,0:DemoHUDpause.bmp>");
	Control::Setvalue(DemoHUD::playBitmap, "<B0,0:DemoHUDplay.bmp>");
	Control::Setvalue(DemoHUD::sdBitmap, "<B0,0:DemoHUDsd.bmp>");
	Control::Setvalue(DemoHUD::ffBitmap, "<B0,0:DemoHUDff.bmp>");
	Control::Setvalue(DemoHUD::NO1, "<B0,0:DemoHUDNO1.bmp>");
	Control::Setvalue(DemoHUD::NO2, "<B0,0:DemoHUDNO2.bmp>");
	Control::Setvalue(DemoHUD::NO3, "<B0,0:DemoHUDNO3.bmp>");
	Control::Setvalue(DemoHUD::NO4, "<B0,0:DemoHUDNO4.bmp>");
	Control::Setvalue(DemoHUD::byCowboy, "<jc><f0>DemoHUD++\n<f1>by Cowboy");

	schedule("Control::Setvalue(DemoHUD::Showbuttons, \"<jl><B7,0:DemoHUDsd.bmp>\");",	0.1);
	schedule("Control::Setvalue(DemoHUD::Showbuttons, \"<jl><B33,0:DemoHUDpause.bmp>\");",	0.2);
	schedule("Control::Setvalue(DemoHUD::Showbuttons, \"<jl><B59,0:DemoHUDplay.bmp>\");",	0.3);
	schedule("Control::Setvalue(DemoHUD::Showbuttons, \"<jl><B85,0:DemoHUDff.bmp>\");",	0.4);
	schedule("Control::Setvalue(DemoHUD::Showbuttons, \"<jl><B7,0:DemoHUDsd.bmp>\");",	0.5);
	schedule("Control::Setvalue(DemoHUD::Showbuttons, \"<jl><B33,0:DemoHUDpause.bmp>\");",	0.6);
	schedule("Control::Setvalue(DemoHUD::Showbuttons, \"<jl><B59,0:DemoHUDplay.bmp>\");",	0.7);

	DemoHUD::CheckSkin();
	
	FGCombo::clear(DemoHUD::ChooseSkin);
	FGCombo::addEntry(DemoHUD::ChooseSkin, "Wood", 1);
	FGCombo::addEntry(DemoHUD::ChooseSkin, "Blue", 2);
	FGCombo::addEntry(DemoHUD::ChooseSkin, "Brick", 3);
	FGCombo::addEntry(DemoHUD::ChooseSkin, "Metal", 4);
	FGCombo::addEntry(DemoHUD::ChooseSkin, "Spark", 5);
	FGCombo::addEntry(DemoHUD::ChooseSkin, "Water", 6);
	FGCombo::addEntry(DemoHUD::ChooseSkin, "Fruit", 7);
	FGCombo::setSelected(DemoHUD::ChooseSkin, $pref::DemoHUDSkin);

	Control::Setvalue(DemoHUD::NoticeText, "<B0,0:DemoHUDSkin" @ $pref::DemoHUDSkin @ ".bmp><jc><f2>Version 1.1\n<f1>View Demos in Style!\n<f0>Now, Point & Click!\n<f2>Shout-outs:\n<f0>Concept: <f1>Faze\n<f0>Code/GFX: <f1>Mannkind");
}

function DemoHUD::CheckSkin() {
	if ($pref::DemoHUDSkin < 1 || $pref::DemoHUDSkin > 7)
		$pref::DemoHUDSkin = 1;
}

function DemoHUD::SetSkin() {
	$pref::DemoHUDSkin = FGCombo::getSelected(DemoHUD::ChooseSkin);
	DemoHUD::NewOptsOpen();
}	


Event::Attach(eventConnectionAccepted, DemoHUD::Init);
Event::Attach(eventGuiOpen, DemoHUD::ChangeGui);

// make the HUD
DemoHUD::CreateHUD();

// initialize NewOpts
DemoHUD::NewOptsInit();
