//  Mod to Allow control of voting options
//
//  Uses ModMgt by Shane Hyde
//

//  Name & version
//
$modmgtModName = "SHVoteCtrl";
$modmgtModVers = "1.30";

$SHVoteCtrl[admin] = 1;  	// Disallow Admin voting
$SHVoteCtrl[cmission] = 1;	// Allow mission changing
$SHVoteCtrl[kick] = 0;		// Allow kicking
$SHVoteCtrl[dtd] = 1;		// Disallow Disable team damage
$SHVoteCtrl[etd] = 0;		// Allow Enable Team damage
$SHVoteCtrl[tourney] = 1;	// Disallow Set to Tourney mode
$SHVoteCtrl[ffa] = 0;		// Allow Set to FFA

function Admin::startVote(%clientId, %topic, %action, %option)
{
   if($SHVoteCtrl[%action] == 1)
   {
	echo("$SHVoteCtrl[" @ %action @ "] = " @ $SHVoteCtrl[%action]);
        Client::SendMessage(%clientid,0,"This option cannot be voted on this server");
        return;
   }

   if(%clientId.lastVoteTime == "")
      %clientId.lastVoteTime = -$Server::MinVoteTime;

   // we want an absolute time here.
   %time = getIntegerTime(true) >> 5;
   %diff = %clientId.lastVoteTime + $Server::MinVoteTime - %time;

   if(%diff > 0)
   {
      Client::sendMessage(%clientId, 0, "You can't start another vote for " @ floor(%diff) @ " seconds.");
      return;
   }
   if($curVoteTopic == "")
   {
      if(%clientId.numFailedVotes)
         %time += %clientId.numFailedVotes * $Server::VoteFailTime;

      %clientId.lastVoteTime = %time;
      $curVoteInitiator = %clientId;
      $curVoteTopic = %topic;
      $curVoteAction = %action;
      $curVoteOption = %option;
      if(%action == "kick")
         $curVoteOption.kickTeam = GameBase::getTeam($curVoteOption);
      $curVoteCount++;
      bottomprintall("<jc><f1>" @ Client::getName(%clientId) @ " <f0>initiated a vote to <f1>" @ $curVoteTopic, 10);
      for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
         %cl.vote = "";
      %clientId.vote = "yes";
      for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
         if(%cl.menuMode == "options")
            Game::menuRequest(%clientId);
      schedule("Admin::countVotes(" @ $curVoteCount @ ", true);", $Server::VotingTime, 35);
   }
   else
   {
      Client::sendMessage(%clientId, 0, "Voting already in progress.");
   }
}

echo($modmgtModName @ " v" @ $modmgtModVers @ " loaded");
