//  Mod to keep players inside the map area in CTF
//
//  Uses ModMgt by Shane Hyde
//  Download it from http://www.users.bigpond.net.au/shyde/tribes/
//

//  Name & version
//
$modmgtModName = "SHStayInside";
$modmgtModVers = "1.30";

//
//  Only do this for CTF
//
if($Game::missionType == "CTF")
{

//Player has a total of 10 seconds per life allowed outside designated mission area.
//After a player expends this 10 sec, the player is remotely killed.
//-lesson to be learned= stay in the mission area!
function Player::leaveMissionArea(%player)
{
   %cl = Player::getClient(%player);
	Client::sendMessage(%cl,1,"You have left the mission area. In 10 secs, you start to die!");
	%player.outArea=1;
	alertPlayer(%player, 5);
}

//called if player leaves mission area
function Player::enterMissionArea(%player)
{
   %player.outArea="";
	echo("player entering map again");
  %cl = Player::getClient(%player);
Client::sendMessage(%cl,1,"You have returned to the mission area");
}
  
function alertPlayer(%player, %count)
{
	if(%player.outArea == 1) {
		%clientId = Player::getClient(%player);
	  	Client::sendMessage(%clientId,1,"~wLeftMissionArea.wav");
		if(%count == 4)
		{
			%set = nameToID("MissionCleanup/ObjectivesSet");
			for(%i = 0; (%obj = Group::getObject(%set, %i)) != -1; %i++)
	  			GameBase::virtual(%obj, "playerLeaveMissionArea", %player);		
			schedule("alertPlayer(" @ %player @ ", " @ %count - 1 @ ");",2,%clientId);
		}	
		else if(%count > 1)
		   schedule("alertPlayer(" @ %player @ ", " @ %count - 1 @ ");",2,%clientId);
		else
		   	schedule("leaveMissionAreaDamage(" @ %clientId @ ");",1,%clientId);
	}
}

function leaveMissionAreaDamage(%client)
{
	%player = Client::getOwnedObject(%client);
	if(%player.outArea == 1) {
		if(!Player::isDead(%player)) {
		  	Player::setDamageFlash(%client,0.1);
			GameBase::setDamageLevel(%player,GameBase::getDamageLevel(%player) + 0.05);
	   	schedule("leaveMissionAreaDamage(" @ %client @ ");",1);
		}
		else 
			playNextAnim(%client);	
	}
}

	echo($modmgtModName @ " v" @ $modmgtModVers @ " loaded");
}
else
{
	//  Not CTF so dont do anything
	echo("No need for stay inside to load");
}
