// ----------------------------------------------------------------------- //
//
// MODULE  : CharacterAttributes.h
//
// PURPOSE : Definitions for default character attributes
//
// CREATED : 12/9/97
//
// ----------------------------------------------------------------------- //

#ifndef __CHARACTER_ATTRIBUTES_H__
#define __CHARACTER_ATTRIBUTES_H__

#include "basetypes_de.h"
#include "ModelIds.h"
#include "ModelFuncs.h"

DFLOAT GetDefaultMass(DBYTE nId, ModelSize size);
DFLOAT GetDefaultHitPts(DBYTE nId, ModelSize size);
DFLOAT GetDefaultMaxHitPts(DBYTE nId, ModelSize size);
DFLOAT GetDefaultArmor(DBYTE nId, ModelSize size);
DFLOAT GetDefaultMaxArmor(DBYTE nId, ModelSize size);


// Defines....

#define INFINITE_MASS						100000.0f

// Player attributes...

#define	CA_PLAYER_ONFOOT_MASS				2000.0f
#define	CA_PLAYER_MECHA_MASS				(CA_PLAYER_ONFOOT_MASS * 5.0f)

//JSP TOW change
/*
#define	CA_PLAYER_ONFOOT_HITPTS				100.0f
#define	CA_PLAYER_ONFOOT_MAX_HITPTS			CA_PLAYER_ONFOOT_HITPTS
#define	CA_PLAYER_ONFOOT_ARMOR				50.0f
#define	CA_PLAYER_ONFOOT_MAX_ARMOR			(CA_PLAYER_ONFOOT_ARMOR*4.0f)
*/
#define	CA_PLAYER_ONFOOT_HITPTS				200.0f
#define	CA_PLAYER_ONFOOT_MAX_HITPTS			CA_PLAYER_ONFOOT_HITPTS
#define	CA_PLAYER_ONFOOT_ARMOR				200.0f
#define	CA_PLAYER_ONFOOT_MAX_ARMOR			CA_PLAYER_ONFOOT_ARMOR
///

#define	CA_PLAYER_KID_HITPTS				50.0f
#define	CA_PLAYER_KID_MAX_HITPTS			CA_PLAYER_KID_HITPTS
#define	CA_PLAYER_KID_ARMOR					0.0f
#define	CA_PLAYER_KID_MAX_ARMOR				CA_PLAYER_KID_ARMOR

#define	CA_PLAYER_AKUMA_HITPTS				1000.0f
#define	CA_PLAYER_PREDATOR_HITPTS			CA_PLAYER_AKUMA_HITPTS
#define	CA_PLAYER_ORDOG_HITPTS				CA_PLAYER_AKUMA_HITPTS
#define	CA_PLAYER_ENFORCER_HITPTS			CA_PLAYER_AKUMA_HITPTS

#define	CA_PLAYER_AKUMA_MAX_HITPTS			CA_PLAYER_AKUMA_HITPTS
#define	CA_PLAYER_PREDATOR_MAX_HITPTS		CA_PLAYER_PREDATOR_HITPTS
#define	CA_PLAYER_ORDOG_MAX_HITPTS			CA_PLAYER_ORDOG_HITPTS
#define	CA_PLAYER_ENFORCER_MAX_HITPTS		CA_PLAYER_ENFORCER_HITPTS

//JSP tag Tow Change Armor points...
/*
#define	CA_PLAYER_AKUMA_ARMOR				800.0f
#define	CA_PLAYER_PREDATOR_ARMOR			1200.0f
#define	CA_PLAYER_ORDOG_ARMOR				1000.0f
#define	CA_PLAYER_ENFORCER_ARMOR			1000.0f
*/

#define	CA_PLAYER_AKUMA_ARMOR				1000.0f
#define	CA_PLAYER_PREDATOR_ARMOR			1000.0f
#define	CA_PLAYER_ORDOG_ARMOR				1000.0f
#define	CA_PLAYER_ENFORCER_ARMOR			1000.0f

#define	CA_PLAYER_AKUMA_MAX_ARMOR			(CA_PLAYER_AKUMA_ARMOR*2.0f)
#define	CA_PLAYER_PREDATOR_MAX_ARMOR		(CA_PLAYER_PREDATOR_ARMOR*2.0f)
#define	CA_PLAYER_ORDOG_MAX_ARMOR			(CA_PLAYER_ORDOG_ARMOR*2.0f)
#define	CA_PLAYER_ENFORCER_MAX_ARMOR		(CA_PLAYER_ENFORCER_ARMOR*2.0f)
#define	CA_PLAYER_CONSTRUCTOR_MAX_ARMOR		(CA_PLAYER_CONSTRUCTOR_ARMOR*2.0f)


// AI attributes...

#define	CA_AI_MECHA_MASS			(CA_PLAYER_MECHA_MASS)
#define	CA_AI_VEHICLE_MASS			((CA_AI_MECHA_MASS) * 0.9f)
#define	CA_AI_ONFOOT_MASS			(CA_PLAYER_ONFOOT_MASS)

#define	CA_AI_ONFOOT_HITPTS			CA_PLAYER_ONFOOT_HITPTS
#define	CA_AI_ONFOOT_MAX_HITPTS		CA_PLAYER_ONFOOT_MAX_HITPTS
#define	CA_AI_ONFOOT_ARMOR			CA_PLAYER_ONFOOT_ARMOR
#define	CA_AI_ONFOOT_MAX_ARMOR		CA_PLAYER_ONFOOT_MAX_ARMOR

#define	CA_AI_MECHA_HITPTS			(CA_AI_ONFOOT_HITPTS * 5.0f)
#define	CA_AI_MECHA_MAX_HITPTS		(CA_AI_ONFOOT_MAX_HITPTS * 5.0f)
#define	CA_AI_MECHA_ARMOR			(CA_AI_ONFOOT_ARMOR * 5.0f)
#define	CA_AI_MECHA_MAX_ARMOR		(CA_AI_ONFOOT_MAX_ARMOR * 5.0f)

#define	CA_AI_LITTLEKID_MASS		CA_AI_ONFOOT_MASS
#define	CA_AI_LITTLEKID_HITPTS		25.0f
#define	CA_AI_LITTLEKID_MAX_HITPTS	CA_AI_LITTLEKID_HITPTS
#define	CA_AI_LITTLEKID_ARMOR		0.0f
#define	CA_AI_LITTLEKID_MAX_ARMOR	CA_AI_LITTLEKID_ARMOR

#define	CA_AI_CIVILIAN1_MASS		CA_AI_ONFOOT_MASS
#define	CA_AI_CIVILIAN1_HITPTS		50.0f
#define	CA_AI_CIVILIAN1_MAX_HITPTS	CA_AI_CIVILIAN1_HITPTS
#define	CA_AI_CIVILIAN1_ARMOR		0.0f
#define	CA_AI_CIVILIAN1_MAX_ARMOR	CA_AI_CIVILIAN1_ARMOR

#define	CA_AI_CIVILIAN2_MASS		CA_AI_ONFOOT_MASS
#define	CA_AI_CIVILIAN2_HITPTS		CA_AI_CIVILIAN1_HITPTS
#define	CA_AI_CIVILIAN2_MAX_HITPTS	CA_AI_CIVILIAN2_HITPTS
#define	CA_AI_CIVILIAN2_ARMOR		CA_AI_CIVILIAN1_ARMOR
#define	CA_AI_CIVILIAN2_MAX_ARMOR	CA_AI_CIVILIAN2_ARMOR

#define	CA_AI_OFFICER_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_OFFICER_HITPTS		50.0f
#define	CA_AI_OFFICER_MAX_HITPTS	CA_AI_OFFICER_HITPTS
#define	CA_AI_OFFICER_ARMOR			25.0f
#define	CA_AI_OFFICER_MAX_ARMOR		CA_AI_OFFICER_ARMOR

#define	CA_AI_TROOPER_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_TROOPER_HITPTS		50.0f
#define	CA_AI_TROOPER_MAX_HITPTS	CA_AI_TROOPER_HITPTS
#define	CA_AI_TROOPER_ARMOR			50.0f
#define	CA_AI_TROOPER_MAX_ARMOR		CA_AI_TROOPER_ARMOR

#define	CA_AI_ETROOPER_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_ETROOPER_HITPTS		125.0f
#define	CA_AI_ETROOPER_MAX_HITPTS	CA_AI_ETROOPER_HITPTS
#define	CA_AI_ETROOPER_ARMOR		125.0f
#define	CA_AI_ETROOPER_MAX_ARMOR	CA_AI_ETROOPER_ARMOR

#define	CA_AI_STROOPER_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_STROOPER_HITPTS		150.0f
#define	CA_AI_STROOPER_MAX_HITPTS	CA_AI_STROOPER_HITPTS
#define	CA_AI_STROOPER_ARMOR		150.0f
#define	CA_AI_STROOPER_MAX_ARMOR	CA_AI_STROOPER_ARMOR

#define	CA_AI_ESTROOPER_MASS		CA_AI_ONFOOT_MASS
#define	CA_AI_ESTROOPER_HITPTS		250.0f
#define	CA_AI_ESTROOPER_MAX_HITPTS	CA_AI_ESTROOPER_HITPTS
#define	CA_AI_ESTROOPER_ARMOR		250.0f
#define	CA_AI_ESTROOPER_MAX_ARMOR	CA_AI_ESTROOPER_ARMOR

#define	CA_AI_RASCAL_MASS			CA_AI_VEHICLE_MASS
#define	CA_AI_RASCAL_HITPTS			300.0f
#define	CA_AI_RASCAL_MAX_HITPTS		CA_AI_RASCAL_HITPTS
#define	CA_AI_RASCAL_ARMOR			300.0f
#define	CA_AI_RASCAL_MAX_ARMOR		CA_AI_RASCAL_ARMOR

#define	CA_AI_VIGILANCE_MASS		CA_AI_VEHICLE_MASS
#define	CA_AI_VIGILANCE_HITPTS		500.0f
#define	CA_AI_VIGILANCE_MAX_HITPTS	CA_AI_RASCAL_HITPTS
#define	CA_AI_VIGILANCE_ARMOR		500.0f
#define	CA_AI_VIGILANCE_MAX_ARMOR	CA_AI_RASCAL_ARMOR

#define	CA_AI_HAMMERHEAD_MASS		CA_AI_VEHICLE_MASS
#define	CA_AI_HAMMERHEAD_HITPTS		500.0f
#define	CA_AI_HAMMERHEAD_MAX_HITPTS	CA_AI_HAMMERHEAD_HITPTS
#define	CA_AI_HAMMERHEAD_ARMOR		500.0f
#define	CA_AI_HAMMERHEAD_MAX_ARMOR	CA_AI_HAMMERHEAD_ARMOR

#define	CA_AI_VANDAL_MASS			CA_AI_VEHICLE_MASS
#define	CA_AI_VANDAL_HITPTS			300.0f
#define	CA_AI_VANDAL_MAX_HITPTS		CA_AI_VANDAL_HITPTS
#define	CA_AI_VANDAL_ARMOR			300.0f
#define	CA_AI_VANDAL_MAX_ARMOR		CA_AI_VANDAL_ARMOR

#define	CA_AI_SPARROWHAWK_MASS		CA_AI_VEHICLE_MASS
#define	CA_AI_SPARROWHAWK_HITPTS	400.0f
#define	CA_AI_SPARROWHAWK_MAX_HITPTS CA_AI_SPARROWHAWK_HITPTS
#define	CA_AI_SPARROWHAWK_ARMOR		400.0f
#define	CA_AI_SPARROWHAWK_MAX_ARMOR	CA_AI_SPARROWHAWK_ARMOR

#define	CA_AI_VIOLATOR_MASS			CA_AI_MECHA_MASS
#define	CA_AI_VIOLATOR_HITPTS		900.0f
#define	CA_AI_VIOLATOR_MAX_HITPTS	CA_AI_VIOLATOR_HITPTS
#define	CA_AI_VIOLATOR_ARMOR		700.0f
#define	CA_AI_VIOLATOR_MAX_ARMOR	CA_AI_VIOLATOR_ARMOR

#define	CA_AI_AVC_MASS				CA_AI_MECHA_MASS
#define	CA_AI_AVC_HITPTS			500.0f
#define	CA_AI_AVC_MAX_HITPTS		CA_AI_AVC_HITPTS
#define	CA_AI_AVC_ARMOR				500.0f
#define	CA_AI_AVC_MAX_ARMOR			CA_AI_AVC_ARMOR

#define	CA_AI_RUIN150_MASS			CA_AI_MECHA_MASS
#define	CA_AI_RUIN150_HITPTS		800.0f
#define	CA_AI_RUIN150_MAX_HITPTS	CA_AI_RUIN150_HITPTS
#define	CA_AI_RUIN150_ARMOR			1000.0f
#define	CA_AI_RUIN150_MAX_ARMOR		CA_AI_RUIN150_ARMOR

#define	CA_AI_UHLANA3_MASS			CA_AI_MECHA_MASS
#define	CA_AI_UHLANA3_HITPTS		1500.0f
#define	CA_AI_UHLANA3_MAX_HITPTS	CA_AI_UHLANA3_HITPTS
#define	CA_AI_UHLANA3_ARMOR			1500.0f
#define	CA_AI_UHLANA3_MAX_ARMOR		CA_AI_UHLANA3_ARMOR

#define	CA_AI_ORDOG_MASS			CA_AI_MECHA_MASS
#define	CA_AI_ORDOG_HITPTS			CA_PLAYER_ORDOG_HITPTS
#define	CA_AI_ORDOG_MAX_HITPTS		CA_AI_ORDOG_HITPTS
#define	CA_AI_ORDOG_ARMOR			CA_PLAYER_ORDOG_ARMOR
#define	CA_AI_ORDOG_MAX_ARMOR		CA_AI_ORDOG_ARMOR

#define	CA_AI_AKUMA_MASS			CA_AI_MECHA_MASS
#define	CA_AI_AKUMA_HITPTS			CA_PLAYER_AKUMA_HITPTS
#define	CA_AI_AKUMA_MAX_HITPTS		CA_AI_AKUMA_HITPTS
#define	CA_AI_AKUMA_ARMOR			CA_PLAYER_AKUMA_ARMOR
#define	CA_AI_AKUMA_MAX_ARMOR		CA_AI_AKUMA_ARMOR

#define	CA_AI_ENFORCER_MASS			CA_AI_MECHA_MASS
#define	CA_AI_ENFORCER_HITPTS		CA_PLAYER_ENFORCER_HITPTS
#define	CA_AI_ENFORCER_MAX_HITPTS	CA_AI_ENFORCER_HITPTS
#define	CA_AI_ENFORCER_ARMOR		CA_PLAYER_ENFORCER_ARMOR
#define	CA_AI_ENFORCER_MAX_ARMOR	CA_AI_ENFORCER_ARMOR

#define	CA_AI_PREDATOR_MASS			CA_AI_MECHA_MASS
#define	CA_AI_PREDATOR_HITPTS		CA_PLAYER_PREDATOR_HITPTS
#define	CA_AI_PREDATOR_MAX_HITPTS	CA_AI_PREDATOR_HITPTS
#define	CA_AI_PREDATOR_ARMOR		CA_PLAYER_PREDATOR_ARMOR
#define	CA_AI_PREDATOR_MAX_ARMOR	CA_AI_PREDATOR_ARMOR

#define	CA_AI_ASSASSIN_MASS			CA_AI_MECHA_MASS
#define	CA_AI_ASSASSIN_HITPTS		4000.0f
#define	CA_AI_ASSASSIN_MAX_HITPTS	CA_AI_ASSASSIN_HITPTS
#define	CA_AI_ASSASSIN_ARMOR		4000.0f
#define	CA_AI_ASSASSIN_MAX_ARMOR	CA_AI_ASSASSIN_ARMOR

#define	CA_AI_ANDRA5_MASS			CA_AI_MECHA_MASS
#define	CA_AI_ANDRA5_HITPTS			600.0f
#define	CA_AI_ANDRA5_MAX_HITPTS		CA_AI_ANDRA5_HITPTS
#define	CA_AI_ANDRA5_ARMOR			600.0f
#define	CA_AI_ANDRA5_MAX_ARMOR		CA_AI_ANDRA5_ARMOR

#define	CA_AI_ANDRA10_MASS			CA_AI_MECHA_MASS
#define	CA_AI_ANDRA10_HITPTS		800.0f
#define	CA_AI_ANDRA10_MAX_HITPTS	CA_AI_ANDRA10_HITPTS
#define	CA_AI_ANDRA10_ARMOR			800.0f
#define	CA_AI_ANDRA10_MAX_ARMOR		CA_AI_ANDRA10_ARMOR

#define	CA_AI_RAKSHA_MASS			CA_AI_MECHA_MASS
#define	CA_AI_RAKSHA_HITPTS			2000.0f
#define	CA_AI_RAKSHA_MAX_HITPTS		CA_AI_RAKSHA_HITPTS
#define	CA_AI_RAKSHA_ARMOR			2000.0f
#define	CA_AI_RAKSHA_MAX_ARMOR		CA_AI_RAKSHA_ARMOR

#define	CA_AI_TENMA_MASS			CA_AI_MECHA_MASS
#define	CA_AI_TENMA_HITPTS			3000.0f
#define	CA_AI_TENMA_MAX_HITPTS		CA_AI_TENMA_HITPTS
#define	CA_AI_TENMA_ARMOR			3000.0f
#define	CA_AI_TENMA_MAX_ARMOR		CA_AI_TENMA_ARMOR

#define	CA_AI_COTHINEAL_MASS		(CA_AI_MECHA_MASS * 2.5f)
#define	CA_AI_COTHINEAL_HITPTS		1000000.0f
#define	CA_AI_COTHINEAL_MAX_HITPTS	CA_AI_COTHINEAL_HITPTS
#define	CA_AI_COTHINEAL_ARMOR		1000000.0f
#define	CA_AI_COTHINEAL_MAX_ARMOR	CA_AI_COTHINEAL_ARMOR


// Major Character attributes...

#define	CA_AI_KURA_MASS				CA_AI_ONFOOT_MASS
#define	CA_AI_KURA_HITPTS			200.0f
#define	CA_AI_KURA_MAX_HITPTS		CA_AI_KURA_HITPTS
#define	CA_AI_KURA_ARMOR			200.0f
#define	CA_AI_KURA_MAX_ARMOR		CA_AI_KURA_ARMOR
	
#define	CA_AI_HANK_MASS				CA_AI_ONFOOT_MASS
#define	CA_AI_HANK_HITPTS			200.0f
#define	CA_AI_HANK_MAX_HITPTS		CA_AI_HANK_HITPTS
#define	CA_AI_HANK_ARMOR			200.0f
#define	CA_AI_HANK_MAX_ARMOR		CA_AI_HANK_ARMOR
	
#define	CA_AI_ADMIRAL_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_ADMIRAL_HITPTS		200.0f
#define	CA_AI_ADMIRAL_MAX_HITPTS	CA_AI_ADMIRAL_HITPTS
#define	CA_AI_ADMIRAL_ARMOR			200.0f
#define	CA_AI_ADMIRAL_MAX_ARMOR		CA_AI_ADMIRAL_ARMOR
	
#define	CA_AI_KATHRYN_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_KATHRYN_HITPTS		200.0f
#define	CA_AI_KATHRYN_MAX_HITPTS	CA_AI_KATHRYN_HITPTS
#define	CA_AI_KATHRYN_ARMOR			200.0f
#define	CA_AI_KATHRYN_MAX_ARMOR		CA_AI_KATHRYN_ARMOR
	
#define	CA_AI_RYO_MASS				CA_AI_ONFOOT_MASS
#define	CA_AI_RYO_HITPTS			200.0f
#define	CA_AI_RYO_MAX_HITPTS		CA_AI_RYO_HITPTS
#define	CA_AI_RYO_ARMOR				200.0f
#define	CA_AI_RYO_MAX_ARMOR			CA_AI_RYO_ARMOR
	
#define	CA_AI_TOSHIRO_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_TOSHIRO_HITPTS		200.0f
#define	CA_AI_TOSHIRO_MAX_HITPTS	CA_AI_TOSHIRO_HITPTS
#define	CA_AI_TOSHIRO_ARMOR			200.0f
#define	CA_AI_TOSHIRO_MAX_ARMOR		CA_AI_TOSHIRO_ARMOR
	
#define	CA_AI_GABRIEL_MASS			(CA_AI_MECHA_MASS * 2.0f)
#define	CA_AI_GABRIEL_HITPTS		10000.0f
#define	CA_AI_GABRIEL_MAX_HITPTS	CA_AI_GABRIEL_HITPTS
#define	CA_AI_GABRIEL_ARMOR			10000.0f
#define	CA_AI_GABRIEL_MAX_ARMOR		CA_AI_GABRIEL_ARMOR
	
#define	CA_AI_BAKU_MASS				CA_AI_ONFOOT_MASS
#define	CA_AI_BAKU_HITPTS			400.0f
#define	CA_AI_BAKU_MAX_HITPTS		CA_AI_BAKU_HITPTS
#define	CA_AI_BAKU_ARMOR			400.0f
#define	CA_AI_BAKU_MAX_ARMOR		CA_AI_BAKU_ARMOR
	
#define	CA_AI_BAKU_MECHA_MASS		CA_AI_MECHA_MASS
#define	CA_AI_BAKU_MECHA_HITPTS		5000.0f
#define	CA_AI_BAKU_MECHA_MAX_HITPTS	CA_AI_BAKU_MECHA_HITPTS
#define	CA_AI_BAKU_MECHA_ARMOR		4000.0f
#define	CA_AI_BAKU_MECHA_MAX_ARMOR	CA_AI_BAKU_MECHA_ARMOR
	
#define	CA_AI_SAMANTHA_MASS			CA_AI_MECHA_MASS
#define	CA_AI_SAMANTHA_HITPTS		2000.0f
#define	CA_AI_SAMANTHA_MAX_HITPTS	CA_AI_SAMANTHA_HITPTS
#define	CA_AI_SAMANTHA_ARMOR		2000.0f
#define	CA_AI_SAMANTHA_MAX_ARMOR	CA_AI_SAMANTHA_ARMOR
	


#endif // __CHARACTER_ATTRIBUTES_H__
