//#define TA_TextDebug

#include "ClientInfoMgr.h"
#include "cpp_client_de.h"
#include "TextHelper.h"
#include "font12.h"
#include "font28.h"
#include "RiotClientShell.h"
#include <stdio.h>

#define VERT_SPACING 3

extern CRiotClientShell* g_pRiotClientShell;

CClientInfoMgr::CClientInfoMgr()
{
	m_pClients = DNULL;
	m_pClientDE = DNULL;

	m_nLastFontSize = 0;
	m_bFragSurfacesUpToDate = DFALSE;

	m_hFragDisplay = DNULL;
	m_cxFragDisplay = 0;
	m_cyFragDisplay = 0;
}

CClientInfoMgr::~CClientInfoMgr()
{
	if (!m_pClientDE) return;

	ClearAllFragSurfaces();

	CLIENT_INFO* ptr = DNULL;
	while (m_pClients)
	{
		ptr = m_pClients->pNext;
		m_pClientDE->FreeString (m_pClients->hstrName);
		delete m_pClients;
		m_pClients = ptr;
	}

	if (m_hFragDisplay) m_pClientDE->DeleteSurface (m_hFragDisplay);

//JSP add
	if (m_hTowArenaIDDisplay)
	{
		m_pClientDE->DeleteSurface (m_hTowArenaIDDisplay);
	}
	if (m_hTA_Victory)
	{
		m_pClientDE->DeleteSurface(m_hTA_Victory);
	}
	if (m_hTA_Defeat)
	{
		m_pClientDE->DeleteSurface(m_hTA_Defeat);
	}
	if (m_hTA_Suicide)
	{
		m_pClientDE->DeleteSurface(m_hTA_Suicide);
	}
	if (m_hTA_Name1)
	{
		m_pClientDE->DeleteSurface(m_hTA_Name1);
	}
	if (m_hTA_Health1)
	{
		m_pClientDE->DeleteSurface(m_hTA_Health1);
	}
	if (m_hTA_Armor1)
	{
		m_pClientDE->DeleteSurface(m_hTA_Armor1);
	}
	if (m_hTA_Name2)
	{
		m_pClientDE->DeleteSurface(m_hTA_Name2);
	}
	if (m_hTA_Health2)
	{
		m_pClientDE->DeleteSurface(m_hTA_Health2);
	}
	if (m_hTA_Armor2)
	{
		m_pClientDE->DeleteSurface(m_hTA_Armor2);
	}
	if (m_hTA_HealthBar1)
	{
		m_pClientDE->DeleteSurface(m_hTA_HealthBar1);
	}
	if (m_hTA_ArmorBar1)
	{
		m_pClientDE->DeleteSurface(m_hTA_ArmorBar1);
	}
	if (m_hTA_HealthBar2)
	{
		m_pClientDE->DeleteSurface(m_hTA_HealthBar2);
	}
	if (m_hTA_ArmorBar2)
	{
		m_pClientDE->DeleteSurface(m_hTA_ArmorBar2);
	}
	if (m_hPlayer1Color)
	{
		m_pClientDE->DeleteSurface(m_hPlayer1Color);
	}
	if (m_hPlayer2Color)
	{
		m_pClientDE->DeleteSurface(m_hPlayer2Color);
	}
	if(temp1)
	{
		m_pClientDE->DeleteSurface(temp1);
	}
	if(temp2)
	{
		m_pClientDE->DeleteSurface(temp2);
	}
	if(temp3)
	{
		m_pClientDE->DeleteSurface(temp3);
	}
	if(temp4)
	{
		m_pClientDE->DeleteSurface(temp4);
	}
///
}

void CClientInfoMgr::Init (CClientDE* pClientDE)
{
	m_pClientDE = pClientDE;

	UpdateFragDisplay (0);
}

void CClientInfoMgr::AddClient (HSTRING hstrName, DDWORD nID, int nFragCount, DBYTE r, DBYTE g, DBYTE b)
{
	if (!m_pClientDE) return;

	// if we already have this client in the list, just return

	CLIENT_INFO* pDup = m_pClients;
	while (pDup)
	{
		if (pDup->nID == nID) return;
		pDup = pDup->pNext;
	}

	// create the new object

	CLIENT_INFO* pNew = new CLIENT_INFO;
	if (!pNew) return;

	pNew->nID = nID;
	pNew->hstrName = hstrName;
	pNew->nFrags = nFragCount;
	pNew->r = r;
	pNew->g = g;
	pNew->b = b;

	// if this client is us, update our frag display

	DDWORD nLocalID = 0;
	m_pClientDE->GetLocalClientID (&nLocalID);
	if (pNew->nID == nLocalID)
	{
		UpdateFragDisplay (0);
	}

	// if we don't have a list yet, set the list pointer to the new object

	if (!m_pClients)
	{
		m_pClients = pNew;
		return;
	}

	// we do have a list - add the new object at the end

	CLIENT_INFO* ptr = m_pClients;
	while (ptr->pNext)
	{
		ptr = ptr->pNext;
	}
	ptr->pNext = pNew;
	pNew->pPrev = ptr;

	// if we're drawing all frag surfaces, redo them since this guy may affect the font size

	if (m_bFragSurfacesUpToDate)
	{
		UpdateAllFragSurfaces();
	}
}

void CClientInfoMgr::RemoveClient (DDWORD nID)
{
	if (!m_pClientDE || !m_pClients) return;

	// find the client

	CLIENT_INFO* ptr = m_pClients;
	while (ptr)
	{
		if (ptr->nID == nID) break;
		ptr = ptr->pNext;
	}
	if (!ptr) return;

	// remove the client from the list

	if (ptr->pNext) ptr->pNext->pPrev = ptr->pPrev;
	if (ptr->pPrev) ptr->pPrev->pNext = ptr->pNext;
	if (m_pClients == ptr) m_pClients = ptr->pNext;

	m_pClientDE->FreeString (ptr->hstrName);
	delete ptr;

	// if we're drawing all frag surfaces, redo them since this guy may affect the font size

	if (m_bFragSurfacesUpToDate)
	{
		UpdateAllFragSurfaces();
	}
}

void CClientInfoMgr::RemoveAllClients()
{
	if (!m_pClientDE) return;

	ClearAllFragSurfaces();

	CLIENT_INFO* ptr = DNULL;
	while (m_pClients)
	{
		ptr = m_pClients->pNext;
		m_pClientDE->FreeString (m_pClients->hstrName);
		delete m_pClients;
		m_pClients = ptr;
	}
	
	UpdateFragDisplay (0);
}

void CClientInfoMgr::AddFrag (DDWORD nLocalID, DDWORD nID)
{
	if (!m_pClientDE || !m_pClients) return;

	// find the client

	CLIENT_INFO* ptr = m_pClients;
	while (ptr)
	{
		if (ptr->nID == nID)
		{
			// add to the frag count
			ptr->nFrags++;
			
			// update the frag display
			if (nLocalID == nID)
			{
				UpdateFragDisplay (ptr->nFrags);
		//JSP add 2-20
					TA_PlayVictorySound();
			}
			else
			{
				//if(CRiotClientShell::GetTA_State()!=0)
					TA_PlayDefeatSound();
			}
		///

			// if we're drawing all frag counts, update this client
			if (m_bFragSurfacesUpToDate)
			{
				UpdateSingleFragSurface (ptr);
			}
			
			break;
		}
		ptr = ptr->pNext;
	}
	if (!ptr) return;

	// put this client in the correct position in the list (most frags to least frags)

	CLIENT_INFO* pCurrent = ptr;
	while (ptr->pPrev && pCurrent->nFrags > ptr->pPrev->nFrags)	ptr = ptr->pPrev;
	if (ptr == pCurrent) return;

	// we found a new position - remove current from the list

	pCurrent->pPrev->pNext = pCurrent->pNext;
	if (pCurrent->pNext) pCurrent->pNext->pPrev = pCurrent->pPrev;

	// put us back in in the correct position

	if (!ptr->pPrev)
	{
		m_pClients = pCurrent;
	}

	pCurrent->pPrev = ptr->pPrev;
	pCurrent->pNext = ptr;
	if (ptr->pPrev) ptr->pPrev->pNext = pCurrent;
	ptr->pPrev = pCurrent;
}

void CClientInfoMgr::RemoveFrag (DDWORD nLocalID, DDWORD nID)
{
	if (!m_pClientDE || !m_pClients) return;

	// find the client

	CLIENT_INFO* ptr = m_pClients;
	while (ptr)
	{
		if (ptr->nID == nID)
		{
			// remove from the frag count
			ptr->nFrags--;
			
			// update the frag display
			if (nLocalID == nID) UpdateFragDisplay (ptr->nFrags);

		//JSP add 1-4
		//We always want to play the suicide sound if removing frag...
			TA_PlaySuicideSound();
		///

			
			// if we're drawing all frag counts, update this client
			if (m_bFragSurfacesUpToDate)
			{
				UpdateSingleFragSurface (ptr);
			}
			
			break;
		}
		ptr = ptr->pNext;
	}
	if (!ptr) return;

	// put this client in the correct position in the list (most frags to least frags)

	CLIENT_INFO* pCurrent = ptr;
	while (ptr->pNext && pCurrent->nFrags < ptr->pNext->nFrags)	ptr = ptr->pNext;
	if (ptr == pCurrent) return;

	// we found a new position - remove current from the list

	pCurrent->pNext->pPrev = pCurrent->pPrev;
	if (pCurrent->pPrev) pCurrent->pPrev->pNext = pCurrent->pNext;
	if (m_pClients == pCurrent) m_pClients = pCurrent->pNext;

	// put us back in in the correct position

	pCurrent->pPrev = ptr;
	pCurrent->pNext = ptr->pNext;
	if (ptr->pNext) ptr->pNext->pPrev = pCurrent;
	ptr->pNext = pCurrent;
}

DDWORD CClientInfoMgr::GetNumClients()
{
	if (!m_pClientDE) return 0;

	CLIENT_INFO* ptr = m_pClients;

	DDWORD nCount = 0;
	while (ptr)
	{
		nCount++;
		ptr = ptr->pNext;
	}

	return nCount;
}

char* CClientInfoMgr::GetPlayerName (DDWORD nID)
{
	if (!m_pClientDE) return DNULL;

	CLIENT_INFO* ptr = m_pClients;
	while (ptr)
	{
		if (ptr->nID == nID) return m_pClientDE->GetStringData (ptr->hstrName);
		ptr = ptr->pNext;
	}

	return "";
}

void CClientInfoMgr::UpdateFragDisplay (int nFrags)
{
	if (!m_pClientDE) return;

	if (m_hFragDisplay) m_pClientDE->DeleteSurface (m_hFragDisplay);

	char str[16];
	itoa (nFrags, str, 10);
	
	m_hFragDisplay = CTextHelper::CreateSurfaceFromString (m_pClientDE, g_pRiotClientShell->GetMenu()->GetFont28s(), str);
	m_pClientDE->GetSurfaceDims (m_hFragDisplay, &m_cxFragDisplay, &m_cyFragDisplay);

	HDECOLOR hTransColor = m_pClientDE->SetupColor2(0.0f, 0.0f, 0.0f, DTRUE);
	m_pClientDE->OptimizeSurface (m_hFragDisplay, hTransColor);
}

void CClientInfoMgr::UpdateAllFragSurfaces()
{
	if (!m_pClientDE) return;

	// get our local id
	DDWORD nLocalID = 0;
	m_pClientDE->GetLocalClientID (&nLocalID);
	
	// make sure all surfaces are deleted
	ClearAllFragSurfaces();

	// get the screen surface and it's dimensions
	HSURFACE hScreen = m_pClientDE->GetScreenSurface();
	DDWORD nWidth = 0;
	DDWORD nHeight = 0;
	m_pClientDE->GetSurfaceDims (hScreen, &nWidth, &nHeight);

	// setup the necessary stuff
	HDECOLOR hTransColor = m_pClientDE->SetupColor1(0.0f, 0.0f, 0.0f, DTRUE);
	CFont12* pFontNormal = g_pRiotClientShell->GetMenu()->GetFont12n();
	CFont12* pFontSelected = g_pRiotClientShell->GetMenu()->GetFont12s();
	
	// create new surfaces
	CLIENT_INFO* pClient = m_pClients;
	while (pClient)
	{
		char* pstrName = m_pClientDE->GetStringData(pClient->hstrName);
		char nameString[256];
		if(pstrName && pstrName[0])
		{
		}
		else
		{
			pstrName = "unnamed";
		}
		
		DRect fillRect;
		
		sprintf(nameString, "  (%d) %s", (int)(pClient->m_Ping * 1000.0f), pstrName);
		pClient->hName = CTextHelper::CreateSurfaceFromString (m_pClientDE, (pClient->nID == nLocalID) ? pFontSelected : pFontNormal, nameString);
		
		m_pClientDE->GetSurfaceDims (pClient->hName, &pClient->szName.cx, &pClient->szName.cy);

		fillRect.left = fillRect.top = 0;
		fillRect.right = 10;
		fillRect.bottom = pClient->szName.cy;
		m_pClientDE->FillRect(pClient->hName, &fillRect, SETRGB(220, 220, 220));
		
		fillRect.left++;
		fillRect.top++;
		fillRect.right--;
		fillRect.bottom--;
		m_pClientDE->FillRect(pClient->hName, &fillRect, SETRGB(pClient->r, pClient->g, pClient->b));

		
		m_pClientDE->OptimizeSurface (pClient->hName, hTransColor);

		char strFragCount[16];
		itoa (pClient->nFrags, strFragCount, 10);

		pClient->hFragCount = CTextHelper::CreateSurfaceFromString (m_pClientDE, (pClient->nID == nLocalID) ? pFontSelected : pFontNormal, strFragCount);
		m_pClientDE->GetSurfaceDims (pClient->hFragCount, &pClient->szFragCount.cx, &pClient->szFragCount.cy);
		m_pClientDE->OptimizeSurface (pClient->hFragCount, hTransColor);

		pClient = pClient->pNext;
	}

	// set the flag
	m_bFragSurfacesUpToDate = DTRUE;
}

void CClientInfoMgr::ClearAllFragSurfaces()
{
	if (!m_pClientDE) return;

	CLIENT_INFO* pClient = m_pClients;
	while (pClient)
	{
		if (pClient->hFragCount) m_pClientDE->DeleteSurface (pClient->hFragCount);
		pClient->hFragCount = DNULL;
		pClient->szFragCount.cx = pClient->szFragCount.cy = 0;
		
		if (pClient->hName) m_pClientDE->DeleteSurface (pClient->hName);
		pClient->hName = DNULL;
		pClient->szName.cx = pClient->szName.cy = 0;

		pClient = pClient->pNext;
	}
	
	m_bFragSurfacesUpToDate = DFALSE;
}

void CClientInfoMgr::UpdateSingleFragSurface (CLIENT_INFO* pClient)
{
	if (!m_pClientDE || !pClient || !m_bFragSurfacesUpToDate) return;

	if (pClient->hFragCount) m_pClientDE->DeleteSurface (pClient->hFragCount);
	pClient->hFragCount = DNULL;

	// get our local id
	DDWORD nLocalID = 0;
	m_pClientDE->GetLocalClientID (&nLocalID);

	// create the font
	CFont12* pFontNormal = g_pRiotClientShell->GetMenu()->GetFont12n();
	CFont12* pFontSelected = g_pRiotClientShell->GetMenu()->GetFont12s();
	
	// create new surfaces
	if (pClient->hFragCount)
	{
		m_pClientDE->DeleteSurface (pClient->hFragCount);
		pClient->hFragCount = DNULL;
		pClient->szFragCount.cx = pClient->szFragCount.cy = 0;
	}
	
	char strFragCount[12];
	memset (strFragCount, 0, 12);
	itoa (pClient->nFrags, strFragCount, 10);

	pClient->hFragCount = CTextHelper::CreateSurfaceFromString (m_pClientDE, (pClient->nID == nLocalID) ? pFontSelected : pFontNormal, strFragCount);
	m_pClientDE->GetSurfaceDims (pClient->hFragCount, &pClient->szFragCount.cx, &pClient->szFragCount.cy);

	HDECOLOR hTransColor = m_pClientDE->SetupColor1(0.0f, 0.0f, 0.0f, DTRUE);
	m_pClientDE->OptimizeSurface (pClient->hFragCount, hTransColor);
}

void CClientInfoMgr::Draw (DBOOL bDrawSingleFragCount, DBOOL bDrawAllFragCounts)
{
	if (!m_pClientDE || (!bDrawSingleFragCount && !bDrawAllFragCounts)) return;

	// make sure we're in a network game

	int nGameMode = 0;
	m_pClientDE->GetGameMode(&nGameMode);
	if (nGameMode == STARTGAME_NORMAL || nGameMode == GAMEMODE_NONE) return;

	// see if we need to update all the surfaces

	if (bDrawAllFragCounts && !m_bFragSurfacesUpToDate)
	{
		UpdateAllFragSurfaces();
	}
	else if (!bDrawAllFragCounts && m_bFragSurfacesUpToDate)
	{
		ClearAllFragSurfaces();
	}

	HSURFACE hScreen = m_pClientDE->GetScreenSurface();
	DDWORD nScreenWidth = 0;
	DDWORD nScreenHeight = 0;
	m_pClientDE->GetSurfaceDims (hScreen, &nScreenWidth, &nScreenHeight);
	int nHalfWidth = (int)nScreenWidth / 2;

	// should we draw our frag count?
	if (bDrawSingleFragCount)
	{
		m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hFragDisplay, DNULL, nScreenWidth - m_cxFragDisplay, 0, DNULL);
	}

	// should we draw all the frag counts?
	
	if (bDrawAllFragCounts && m_bFragSurfacesUpToDate)
	{
		int nTotalHeight = 0;
		int nClients = 0;
		CLIENT_INFO* pClient = m_pClients;
		while (pClient)
		{
			nTotalHeight += __max (pClient->szName.cy, pClient->szFragCount.cy);
			nTotalHeight += VERT_SPACING;
			++nClients;
			pClient = pClient->pNext;
		}
		
		int nY = ((int)nScreenHeight - nTotalHeight) / 2;
		if (nY < 0) nY = 0;

		int i, nSorted;
		CLIENT_INFO *sorted[128], *pClosest;
		if(nClients > 128)
			nClients = 128;

		// Sort them..
		pClosest = DNULL;
		nSorted = 0;
		pClient = m_pClients;
		while(nSorted < nClients)
		{
			sorted[nSorted++] = pClient;
			pClient = pClient->pNext;
		}

		DBOOL bHappy = DFALSE;
		while(!bHappy)
		{
			bHappy = DTRUE;
			for(i=0; i < (nSorted-1); i++)
			{
				if(sorted[i]->nFrags < sorted[i+1]->nFrags)
				{
					CLIENT_INFO *pTemp = sorted[i];
					sorted[i] = sorted[i+1];
					sorted[i+1] = pTemp;
					bHappy = DFALSE;
				}
			}
		}


		for(i=0; i < nSorted; i++)
		{
			pClient = sorted[i];

			// Ok.. draw.
			//m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, pClient->hName, DNULL, nHalfWidth - pClient->szName.cx - 5, nY, DNULL);
			//m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, pClient->hFragCount, DNULL, nHalfWidth + 5, nY, DNULL);

			m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, pClient->hName, DNULL, 15, nY, DNULL);
			m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, pClient->hFragCount, DNULL, pClient->szName.cx + 20, nY, DNULL);

			nY += __max (pClient->szName.cy, pClient->szFragCount.cy) + VERT_SPACING;

			if (nY + __max (pClient->szName.cy, pClient->szFragCount.cy) > (int)nScreenHeight) break;
		}
	}
}

CLIENT_INFO* CClientInfoMgr::GetClientByID(DDWORD nID)
{
	CLIENT_INFO* ptr = m_pClients;
	while (ptr)
	{
		if (ptr->nID == nID) 
			return ptr;

		ptr = ptr->pNext;
	}
	return DNULL;
}


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void CClientInfoMgr::TA_Init()
{
//	m_pClientDE->CPrint("CClientInfoMgr::TA_Init()");

	hTransColor = m_pClientDE->SetupColor1(0.0f, 0.0f, 0.0f, DTRUE);

	ShouldDrawCountDownTimer = DTRUE;
	ShouldDrawNewCountDownTimer = DTRUE;

	m_bTA_CountdownSoundAlreadyPlayed = DFALSE;

	m_hTowArenaIDDisplay	= DNULL;
	m_cxTowArenaIDDisplay	= 0;
	m_cyTowArenaIDDisplay	= 0;

	m_hTA_VS				= DNULL;
	m_cxTA_VS				= 0;
	m_cyTA_VS				= 0;

//	m_hTA_OutcomePopup		= DNULL;
//	m_cxTA_OutcomePopup		= 0;
//	m_cyTA_OutcomePopup		= 0;

	m_hTA_Victory			= DNULL;;
	m_cxTA_Victory			= 0;
	m_cyTA_Victory			= 0;

	m_hTA_Victory = m_pClientDE->CreateSurfaceFromBitmap ("INTERFACE/Victory.pcx");
	m_pClientDE->GetSurfaceDims (m_hTA_Victory, &m_cxTA_Victory, &m_cyTA_Victory);
	m_pClientDE->OptimizeSurface (m_hTA_Victory, hTransColor);

	m_hTA_Defeat			= DNULL;
	m_cxTA_Defeat			= 0;
	m_cyTA_Defeat			= 0;

	m_hTA_Defeat = m_pClientDE->CreateSurfaceFromBitmap("INTERFACE/Defeat.pcx");
	m_pClientDE->GetSurfaceDims(m_hTA_Defeat, &m_cxTA_Defeat, &m_cyTA_Defeat);
	m_pClientDE->OptimizeSurface(m_hTA_Defeat, hTransColor);

	m_hTA_Suicide			= DNULL;
	m_cxTA_Suicide			= 0;
	m_cyTA_Suicide			= 0;

	m_hTA_Suicide = m_pClientDE->CreateSurfaceFromBitmap ("INTERFACE/Suicide.pcx");
	m_pClientDE->GetSurfaceDims (m_hTA_Suicide, &m_cxTA_Suicide, &m_cyTA_Suicide);
	m_pClientDE->OptimizeSurface (m_hTA_Suicide, hTransColor);

	m_hTA_Name1				= DNULL;
	m_cxTA_Name1			= 0;
	m_cyTA_Name1			= 0;

	m_hTA_Health1			= DNULL;
	m_cxTA_Health1			= 0;
	m_cyTA_Health1			= 0;

	m_hTA_Armor1			= DNULL;
	m_cxTA_Armor1			= 0;
	m_cyTA_Armor1			= 0;

	m_hTA_Name2				= DNULL;
	m_cxTA_Name2			= 0;
	m_cyTA_Name2			= 0;

	m_hTA_Health2			= DNULL;
	m_cxTA_Health2			= 0;
	m_cyTA_Health2			= 0;

	m_hTA_Armor2			= DNULL;
	m_cxTA_Armor2			= 0;
	m_cyTA_Armor2			= 0;
		
	m_hTA_HealthBar1		= DNULL;
	m_cxTA_HealthBar1		= 0;
	m_cyTA_HealthBar1		= 0;
	
	m_hTA_ArmorBar1			= DNULL;
	m_cxTA_ArmorBar1		= 0;
	m_cyTA_ArmorBar1		= 0;

	m_hTA_HealthBar2		= DNULL;
	m_cxTA_HealthBar2		= 0;
	m_cyTA_HealthBar2		= 0;
	
	m_hTA_ArmorBar2			= DNULL;
	m_cxTA_ArmorBar2		= 0;
	m_cyTA_ArmorBar2		= 0;

	m_hPlayer1Color			= DNULL;
	m_cxPlayer1Color		= 0;
	m_cyPlayer1Color		= 0;
	
	m_hPlayer2Color			= DNULL;
	m_cxPlayer2Color		= 0;
	m_cyPlayer2Color		= 0;

	temp1 = m_pClientDE->CreateSurfaceFromBitmap ("interface/HealthBar.pcx");
	temp2 = m_pClientDE->CreateSurfaceFromBitmap ("interface/ArmorBar.pcx");
	temp3 = m_pClientDE->CreateSurfaceFromBitmap ("interface/HealthBar.pcx");
	temp4 = m_pClientDE->CreateSurfaceFromBitmap ("interface/ArmorBar.pcx");

	m_pClientDE->OptimizeSurface(temp1, hTransColor);
	m_pClientDE->OptimizeSurface(temp2, hTransColor);
	m_pClientDE->OptimizeSurface(temp3, hTransColor);
	m_pClientDE->OptimizeSurface(temp4, hTransColor);

	TA_UpdateName1();
	TA_UpdateHealth1(0);
	TA_UpdateArmor1(0);
	TA_UpdateName2();
	TA_UpdateHealth2(0);
	TA_UpdateArmor2(0);
}


void	CClientInfoMgr::TA_DrawCountdownTimer()
{
	DFLOAT TimeCur = m_pClientDE->GetGameTime();
	static int TimeCounter = (int)TimeCur + 10;

	HSURFACE hScreen = m_pClientDE->GetScreenSurface();
	DDWORD nScreenWidth = 0;
	DDWORD nScreenHeight = 0;
	m_pClientDE->GetSurfaceDims(hScreen, &nScreenWidth, &nScreenHeight);
	
	if(ShouldDrawNewCountDownTimer)
	{
#ifdef TA_TextDebug
		m_pClientDE->CPrint("Drawing a NEW COUNTDOWN TIMER!!!!!!!!!!!!!!!!!no more");
#endif
		TimeCounter = (int)TimeCur + 10;
		ShouldDrawNewCountDownTimer = DFALSE;
	}
	
	if((int)(TimeCounter-TimeCur)<=0)
	{
		if((int)(TimeCounter-TimeCur)<=-1)
		{
			if(m_hTowArenaIDDisplay) m_pClientDE->DeleteSurface(m_hTowArenaIDDisplay);
			m_hTowArenaIDDisplay	= DNULL;
			m_cxTowArenaIDDisplay	= 0;
			m_cyTowArenaIDDisplay	= 0;
			ShouldDrawCountDownTimer = DFALSE;
			ShouldDrawNewCountDownTimer = DFALSE;
		}
		else
		{
			if(m_hTowArenaIDDisplay) m_pClientDE->DeleteSurface(m_hTowArenaIDDisplay);
			m_hTowArenaIDDisplay	= DNULL;
			m_cxTowArenaIDDisplay	= 0;
			m_cyTowArenaIDDisplay	= 0;
			char str[]={"FIGHT!"};
			m_hTowArenaIDDisplay = CTextHelper::CreateSurfaceFromString(m_pClientDE, g_pRiotClientShell->GetMenu()->GetFont28s(), str);
			m_pClientDE->GetSurfaceDims(m_hTowArenaIDDisplay, &m_cxTowArenaIDDisplay, &m_cyTowArenaIDDisplay);
			m_pClientDE->OptimizeSurface(m_hTowArenaIDDisplay, hTransColor);
					
			m_pClientDE->DrawSurfaceToSurfaceTransparent(hScreen, m_hTowArenaIDDisplay, DNULL, (int)((nScreenWidth/2.0f)-(m_cxTowArenaIDDisplay/2.0f)), (int)((nScreenHeight/3.0f)-(m_cyTowArenaIDDisplay/2.0f)), DNULL);
		}
		
	}
	else
	{
		static int oldtime = (int)(TimeCounter-TimeCur);
		if((int)(TimeCounter-TimeCur)!=oldtime)
		{
#ifdef TA_TextDebug
			m_pClientDE->CPrint("---***Not equal to old time!!!!!!!!!!!!!!!!!!!!!!!!");
#endif
			oldtime = (int)(TimeCounter-TimeCur);
			char str[4];
			itoa ((int)(TimeCounter-TimeCur), str, 10);

			if(m_hTowArenaIDDisplay)m_pClientDE->DeleteSurface(m_hTowArenaIDDisplay);
			m_hTowArenaIDDisplay	= DNULL;
			m_cxTowArenaIDDisplay	= 0;
			m_cyTowArenaIDDisplay	= 0;
			m_hTowArenaIDDisplay = CTextHelper::CreateSurfaceFromString(m_pClientDE, g_pRiotClientShell->GetMenu()->GetFont28s(), str);
			m_pClientDE->GetSurfaceDims(m_hTowArenaIDDisplay, &m_cxTowArenaIDDisplay, &m_cyTowArenaIDDisplay);
		}
		m_pClientDE->DrawSurfaceToSurfaceTransparent(hScreen, m_hTowArenaIDDisplay, DNULL, (int)((nScreenWidth/2.0f)-(m_cxTowArenaIDDisplay/2.0f)), (int)((nScreenHeight/3.0f)-(m_cyTowArenaIDDisplay/2.0f)), hTransColor);
		
		//JSP Draw the opponents vs. names
		m_pClientDE->DrawSurfaceToSurfaceTransparent(hScreen, m_hTA_VS, DNULL, (int)((nScreenWidth/2.0f)-(m_cxTA_VS/2.0f)), (int)((nScreenHeight/4.0f)-(m_cyTA_VS/2.0f)), hTransColor);

		//JSP play the 3...2...1...FIGHT! sound
		if((int)(TimeCounter-TimeCur)==3)
			TA_PlayCountdownSound();
	}
}


DBOOL	CClientInfoMgr::TA_ShouldDrawCountDownTimer()
{
	if(ShouldDrawCountDownTimer)
		return DTRUE;
	else
		return DFALSE;
}


void	CClientInfoMgr::TA_SetShouldDrawCountDownTimer(DBOOL blah)
{
	ShouldDrawCountDownTimer=blah;
}


void	CClientInfoMgr::TA_SetShouldDrawNewCountDownTimer(DBOOL blah)
{
	ShouldDrawNewCountDownTimer=blah;
}


void CClientInfoMgr::TA_PlayVictorySound()
{
	//JSP add Play VICTORY! sound...
	char* pVictoryFiles[] = 
	{
		"Sounds\\TowArena\\Victory1.wav",
		"Sounds\\TowArena\\Victory2.wav",
		"Sounds\\TowArena\\Victory3.wav",
		"Sounds\\TowArena\\Victory4.wav"
	};
	PlaySoundInfo playSoundInfo;
	PLAYSOUNDINFO_INIT(playSoundInfo);
	playSoundInfo.m_dwFlags = PLAYSOUND_CLIENT | PLAYSOUND_LOCAL;
	SAFE_STRCPY(playSoundInfo.m_szSoundName, pVictoryFiles[GetRandom(0,3)]);
	m_pClientDE->PlaySound(&playSoundInfo);
}


void CClientInfoMgr::TA_PlayDefeatSound()
{
	//JSP add Play DEFEAT! sound...
	char* pDefeatFiles[] = 
	{
		"Sounds\\TowArena\\Defeat1.wav",
		"Sounds\\TowArena\\Defeat2.wav",
		"Sounds\\TowArena\\Defeat3.wav",
		"Sounds\\TowArena\\Defeat4.wav"
	};
	PlaySoundInfo playSoundInfo;
	PLAYSOUNDINFO_INIT(playSoundInfo);
	playSoundInfo.m_dwFlags = PLAYSOUND_CLIENT | PLAYSOUND_LOCAL;
	SAFE_STRCPY(playSoundInfo.m_szSoundName, pDefeatFiles[GetRandom(0,3)]);
	m_pClientDE->PlaySound(&playSoundInfo);
}


void CClientInfoMgr::TA_PlaySuicideSound()
{
	//JSP add Play Suicide! sound...
	char* pSuicideFiles[] = 
	{
		"Sounds\\TowArena\\Suicide1.wav",
		"Sounds\\TowArena\\Suicide2.wav",
		"Sounds\\TowArena\\Suicide3.wav",
		"Sounds\\TowArena\\Suicide4.wav",
		"Sounds\\TowArena\\Suicide5.wav"
	};
	PlaySoundInfo playSoundInfo;
	PLAYSOUNDINFO_INIT(playSoundInfo);
	playSoundInfo.m_dwFlags = PLAYSOUND_CLIENT | PLAYSOUND_LOCAL;
	SAFE_STRCPY(playSoundInfo.m_szSoundName, pSuicideFiles[GetRandom(0,4)]);
	m_pClientDE->PlaySound(&playSoundInfo);
}


void CClientInfoMgr::TA_PlayCountdownSound()
{
	//JSP add Play Countdown sound...
	if(!TA_CountdownSoundAlreadyPlayed())
	{
		char* pCountdownFiles[] = 
		{
			"Sounds\\TowArena\\Countdown1.wav",
			"Sounds\\TowArena\\Countdown2.wav",
			"Sounds\\TowArena\\Countdown3.wav",
			"Sounds\\TowArena\\Countdown4.wav"
		};
		PlaySoundInfo playSoundInfo;
		PLAYSOUNDINFO_INIT(playSoundInfo);
		playSoundInfo.m_dwFlags = PLAYSOUND_CLIENT | PLAYSOUND_LOCAL;
		SAFE_STRCPY(playSoundInfo.m_szSoundName, pCountdownFiles[GetRandom(0,3)]);
		m_pClientDE->PlaySound(&playSoundInfo);

		m_bTA_CountdownSoundAlreadyPlayed = DTRUE;//Set to true to not play again...
	}
}


DBOOL	CClientInfoMgr::TA_CountdownSoundAlreadyPlayed()
{
	return m_bTA_CountdownSoundAlreadyPlayed ? DTRUE : DFALSE;
}


void CClientInfoMgr::TA_Victory()
{
	HSURFACE hScreen = m_pClientDE->GetScreenSurface();
	DDWORD nScreenWidth = 0;
	DDWORD nScreenHeight = 0;
	m_pClientDE->GetSurfaceDims (hScreen, &nScreenWidth, &nScreenHeight);
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hTA_Victory, DNULL, (int)((nScreenWidth/2.0f)-(m_cxTA_Victory/2.0f)), (int)((nScreenHeight/3.0f)-(m_cyTA_Victory/2.0f)), DNULL);
}


void CClientInfoMgr::TA_Defeat()
{
	HSURFACE hScreen = m_pClientDE->GetScreenSurface();
	DDWORD nScreenWidth = 0;
	DDWORD nScreenHeight = 0;
	m_pClientDE->GetSurfaceDims(hScreen, &nScreenWidth, &nScreenHeight);
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hTA_Defeat, DNULL, (int)((nScreenWidth/2.0f)-(m_cxTA_Defeat/2.0f)), (int)((nScreenHeight/3.0f)-(m_cyTA_Defeat/2.0f)), DNULL);
}


void CClientInfoMgr::TA_Suicide()
{
	HSURFACE hScreen = m_pClientDE->GetScreenSurface();
	DDWORD nScreenWidth = 0;
	DDWORD nScreenHeight = 0;
	m_pClientDE->GetSurfaceDims (hScreen, &nScreenWidth, &nScreenHeight);
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hTA_Suicide, DNULL, (int)((nScreenWidth/2.0f)-(m_cxTA_Suicide/2.0f)), (int)((nScreenHeight/3.0f)-(m_cyTA_Suicide/2.0f)), DNULL);
}


//Draws all the health/armor surfaces
void CClientInfoMgr::TA_DrawHealthArmor()
{
	HSURFACE hScreen = m_pClientDE->GetScreenSurface();
	DDWORD nScreenWidth = 0;
	DDWORD nScreenHeight = 0;
	m_pClientDE->GetSurfaceDims (hScreen, &nScreenWidth, &nScreenHeight);

	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hTA_Name1,		DNULL,(int)(nScreenWidth/2.0f-m_cxTA_Name1),	23, DNULL);
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hTA_Health1,	DNULL,(int)(nScreenWidth/2.0f),					23, DNULL);
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hTA_Armor1,	DNULL,(int)(nScreenWidth/2.0f+m_cxTA_Health1),	23, DNULL);

	m_pClientDE->DrawSurfaceToSurface			 (hScreen, m_hPlayer1Color, DNULL,(int)(nScreenWidth/2.0f-115.0f),	23+(m_cyTA_Name1+2) );
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hTA_HealthBar1,DNULL,(int)(nScreenWidth/2.0f-100.0f),	23+(m_cyTA_Name1+2), DNULL);
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hTA_ArmorBar1, DNULL,(int)(nScreenWidth/2.0f-100.0f),	23+(m_cyTA_Name1+2+m_cyTA_HealthBar1+2), DNULL);
	
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen,m_hTA_Name2,		DNULL,(int)(nScreenWidth/2.0f-m_cxTA_Name2),	23+(m_cyTA_Name1+2+m_cyTA_HealthBar1+2+m_cyTA_ArmorBar1+4), DNULL);
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen,m_hTA_Health2,	DNULL,(int)(nScreenWidth/2.0f),					23+(m_cyTA_Name1+2+m_cyTA_HealthBar1+2+m_cyTA_ArmorBar1+4), DNULL);
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen,m_hTA_Armor2,		DNULL,(int)(nScreenWidth/2.0f+m_cxTA_Health2),	23+(m_cyTA_Name1+2+m_cyTA_HealthBar1+2+m_cyTA_ArmorBar1+4), DNULL);

	m_pClientDE->DrawSurfaceToSurface			 (hScreen, m_hPlayer2Color, DNULL,(int)(nScreenWidth/2.0f-115.0f),23+(m_cyTA_Name1+2+m_cyTA_HealthBar1+2+m_cyTA_ArmorBar1+4+m_cyTA_Name2+2) );
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hTA_HealthBar2,DNULL,(int)(nScreenWidth/2.0f-100.0f),23+(m_cyTA_Name1+2+m_cyTA_HealthBar1+2+m_cyTA_ArmorBar1+4+m_cyTA_Name2+2), DNULL);
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hTA_ArmorBar2, DNULL,(int)(nScreenWidth/2.0f-100.0f),23+(m_cyTA_Name1+2+m_cyTA_HealthBar1+2+m_cyTA_ArmorBar1+4+m_cyTA_Name2+2+m_cyTA_HealthBar2+2), DNULL);
}


void CClientInfoMgr::TA_UpdateName1()
{
 	if (m_hTA_Name1) m_pClientDE->DeleteSurface(m_hTA_Name1);
	m_hTA_Name1				= DNULL;
	m_cxTA_Name1			= 0;
	m_cyTA_Name1			= 0;
	
	char str[24];
	strncpy(str,g_pRiotClientShell->cOpponentName1,23);
	m_hTA_Name1 = CTextHelper::CreateSurfaceFromString(m_pClientDE, g_pRiotClientShell->GetMenu()->GetFont08s(), str);
	m_pClientDE->GetSurfaceDims(m_hTA_Name1, &m_cxTA_Name1, &m_cyTA_Name1);
	m_pClientDE->OptimizeSurface(m_hTA_Name1, hTransColor);

	char vs[55];
	strcpy(vs,g_pRiotClientShell->cOpponentName1);
	strcat(vs," vs ");
	strcat(vs,g_pRiotClientShell->cOpponentName2);

 	if(m_hTA_VS) m_pClientDE->DeleteSurface(m_hTA_VS);
	m_hTA_VS				= DNULL;
	m_cxTA_VS				= 0;
	m_cyTA_VS				= 0;

	m_hTA_VS = CTextHelper::CreateSurfaceFromString(m_pClientDE, g_pRiotClientShell->GetMenu()->GetFont12s(), vs);
	m_pClientDE->GetSurfaceDims (m_hTA_VS, &m_cxTA_VS, &m_cyTA_VS);
	m_pClientDE->OptimizeSurface (m_hTA_VS, hTransColor);

	TA_UpdatePlayer1Color();
}


void CClientInfoMgr::TA_UpdateHealth1(DBYTE IsMechaMode)
{
	if (m_hTA_Health1) m_pClientDE->DeleteSurface(m_hTA_Health1);
	m_hTA_Health1			= DNULL;
	m_cxTA_Health1			= 0;
	m_cyTA_Health1			= 0;
	
	char str[10];
	char temp[5];
	strcpy(str,"  H:");
	strcat(str,itoa(g_pRiotClientShell->TA_Health1,temp,10));
	m_hTA_Health1 = CTextHelper::CreateSurfaceFromString (m_pClientDE, g_pRiotClientShell->GetMenu()->GetFont08s(), str);
	m_pClientDE->GetSurfaceDims(m_hTA_Health1, &m_cxTA_Health1, &m_cyTA_Health1);
	m_pClientDE->OptimizeSurface(m_hTA_Health1, hTransColor);
	
 	if (m_hTA_HealthBar1) m_pClientDE->DeleteSurface(m_hTA_HealthBar1);
	m_hTA_HealthBar1		= DNULL;
	m_cxTA_HealthBar1		= 0;
	m_cyTA_HealthBar1		= 0;

	m_hTA_HealthBar1 = m_pClientDE->CreateSurface(200,5);
	m_pClientDE->GetSurfaceDims(m_hTA_HealthBar1, &m_cxTA_HealthBar1, &m_cyTA_HealthBar1);

	DRect fillRect;
	fillRect.left = fillRect.top = 0;
	fillRect.bottom = 5;

    if(IsMechaMode)
		fillRect.right = (int)(g_pRiotClientShell->TA_Health1/5.0f);
	else
		fillRect.right = g_pRiotClientShell->TA_Health1;

    m_pClientDE->DrawSurfaceToSurface(m_hTA_HealthBar1,temp1,&fillRect,0,0);
	m_pClientDE->OptimizeSurface(m_hTA_HealthBar1, hTransColor);
}


void CClientInfoMgr::TA_UpdateArmor1(DBYTE IsMechaMode)
{
	if (m_hTA_Armor1) m_pClientDE->DeleteSurface(m_hTA_Armor1);
	m_hTA_Armor1			= DNULL;
	m_cxTA_Armor1			= 0;
	m_cyTA_Armor1			= 0;

	char str[10];
	char temp[5];
	strcpy(str,"  A:");
	strcat(str,itoa(g_pRiotClientShell->TA_Armor1,temp,10));
	m_hTA_Armor1 = CTextHelper::CreateSurfaceFromString (m_pClientDE, g_pRiotClientShell->GetMenu()->GetFont08s(), str);
	m_pClientDE->GetSurfaceDims(m_hTA_Armor1, &m_cxTA_Armor1, &m_cyTA_Armor1);
	m_pClientDE->OptimizeSurface(m_hTA_Armor1, hTransColor);
	
 	if (m_hTA_ArmorBar1) m_pClientDE->DeleteSurface(m_hTA_ArmorBar1);
	m_hTA_ArmorBar1			= DNULL;
	m_cxTA_ArmorBar1		= 0;
	m_cyTA_ArmorBar1		= 0;

	m_hTA_ArmorBar1 = m_pClientDE->CreateSurface(200,5);
	m_pClientDE->GetSurfaceDims(m_hTA_ArmorBar1, &m_cxTA_ArmorBar1, &m_cyTA_ArmorBar1);
	
	DRect fillRect;
	fillRect.left = fillRect.top = 0;
	fillRect.bottom = 5;

    if(IsMechaMode)
		fillRect.right = (int)(g_pRiotClientShell->TA_Armor1/5.0f);
	else
		fillRect.right = g_pRiotClientShell->TA_Armor1;

    m_pClientDE->DrawSurfaceToSurface(m_hTA_ArmorBar1,temp2,&fillRect,0,0);
	m_pClientDE->OptimizeSurface(m_hTA_ArmorBar1, hTransColor);
}


void CClientInfoMgr::TA_UpdateName2()
{
//	m_pClientDE->CPrint("CClientInfoMgr::TA_UpdateName2()");

	if (m_hTA_Name2) m_pClientDE->DeleteSurface(m_hTA_Name2);
	m_hTA_Name2				= DNULL;
	m_cxTA_Name2			= 0;
	m_cyTA_Name2			= 0;
	
	char str[24];
	strncpy(str,g_pRiotClientShell->cOpponentName2,23);
	m_hTA_Name2 = CTextHelper::CreateSurfaceFromString(m_pClientDE, g_pRiotClientShell->GetMenu()->GetFont08s(), str);
	m_pClientDE->GetSurfaceDims(m_hTA_Name2, &m_cxTA_Name2, &m_cyTA_Name2);
	m_pClientDE->OptimizeSurface(m_hTA_Name2, hTransColor);

	char vs[55];
	strcpy(vs,g_pRiotClientShell->cOpponentName1);
	strcat(vs," vs ");
	strcat(vs,g_pRiotClientShell->cOpponentName2);
 	
	if(m_hTA_VS) m_pClientDE->DeleteSurface(m_hTA_VS);
	m_hTA_VS				= DNULL;
	m_cxTA_VS				= 0;
	m_cyTA_VS				= 0;

	m_hTA_VS = CTextHelper::CreateSurfaceFromString(m_pClientDE, g_pRiotClientShell->GetMenu()->GetFont12s(), vs);
	m_pClientDE->GetSurfaceDims (m_hTA_VS, &m_cxTA_VS, &m_cyTA_VS);
	m_pClientDE->OptimizeSurface (m_hTA_VS, hTransColor);

	TA_UpdatePlayer2Color();
}


void CClientInfoMgr::TA_UpdateHealth2(DBYTE IsMechaMode)
{
	if (m_hTA_Health2) m_pClientDE->DeleteSurface(m_hTA_Health2);
	m_hTA_Health2			= DNULL;
	m_cxTA_Health2			= 0;
	m_cyTA_Health2			= 0;
	
	char str[10];
	char temp[5];
	strcpy(str,"  H:");
	strcat(str,itoa(g_pRiotClientShell->TA_Health2,temp,10));
	m_hTA_Health2 = CTextHelper::CreateSurfaceFromString (m_pClientDE, g_pRiotClientShell->GetMenu()->GetFont08s(), str);
	m_pClientDE->GetSurfaceDims(m_hTA_Health2, &m_cxTA_Health2, &m_cyTA_Health2);
	m_pClientDE->OptimizeSurface(m_hTA_Health2, hTransColor);
	
 	if (m_hTA_HealthBar2) m_pClientDE->DeleteSurface(m_hTA_HealthBar2);
	m_hTA_HealthBar2		= DNULL;
	m_cxTA_HealthBar2		= 0;
	m_cyTA_HealthBar2		= 0;

	m_hTA_HealthBar2 = m_pClientDE->CreateSurface(200,5);
	m_pClientDE->GetSurfaceDims(m_hTA_HealthBar2, &m_cxTA_HealthBar2, &m_cyTA_HealthBar2);

	DRect fillRect;
	fillRect.left = fillRect.top = 0;
	fillRect.bottom = 5;

    if(IsMechaMode)
		fillRect.right = (int)(g_pRiotClientShell->TA_Health2/5.0f);
	else
		fillRect.right = g_pRiotClientShell->TA_Health2;

    m_pClientDE->DrawSurfaceToSurface(m_hTA_HealthBar2,temp3,&fillRect,0,0);
	m_pClientDE->OptimizeSurface(m_hTA_HealthBar2, hTransColor);
}


void CClientInfoMgr::TA_UpdateArmor2(DBYTE IsMechaMode)
{
	if (m_hTA_Armor2) m_pClientDE->DeleteSurface(m_hTA_Armor2);
	m_hTA_Armor2			= DNULL;
	m_cxTA_Armor2			= 0;
	m_cyTA_Armor2			= 0;
	
	char str[10];
	char temp[5];
	strcpy(str,"  A:");
	strcat(str,itoa(g_pRiotClientShell->TA_Armor2,temp,10));
	m_hTA_Armor2 = CTextHelper::CreateSurfaceFromString (m_pClientDE, g_pRiotClientShell->GetMenu()->GetFont08s(), str);
	m_pClientDE->GetSurfaceDims (m_hTA_Armor2, &m_cxTA_Armor2, &m_cyTA_Armor2);
	m_pClientDE->OptimizeSurface (m_hTA_Armor2, hTransColor);
	
	if (m_hTA_ArmorBar2) m_pClientDE->DeleteSurface(m_hTA_ArmorBar2);
	m_hTA_ArmorBar2			= DNULL;
	m_cxTA_ArmorBar2		= 0;
	m_cyTA_ArmorBar2		= 0;

	m_hTA_ArmorBar2 = m_pClientDE->CreateSurface(200,5);
	m_pClientDE->GetSurfaceDims(m_hTA_ArmorBar2, &m_cxTA_ArmorBar2, &m_cyTA_ArmorBar2);

	DRect fillRect;
	fillRect.left = fillRect.top = 0;
	fillRect.bottom = 5;

    if(IsMechaMode)
		fillRect.right = (int)(g_pRiotClientShell->TA_Armor2/5.0f);
	else
		fillRect.right = g_pRiotClientShell->TA_Armor2;

    m_pClientDE->DrawSurfaceToSurface(m_hTA_ArmorBar2,temp4,&fillRect,0,0);
	m_pClientDE->OptimizeSurface(m_hTA_ArmorBar2, hTransColor);
}
	
void CClientInfoMgr::TA_UpdatePlayer1Color()
{
 	if (m_hPlayer1Color) m_pClientDE->DeleteSurface(m_hPlayer1Color);
	m_hPlayer1Color				= DNULL;
	m_cxPlayer1Color			= 0;
	m_cyPlayer1Color			= 0;
	
	// setup the necessary stuff
	HDECOLOR hTransColor = m_pClientDE->SetupColor1(0.0f, 0.0f, 0.0f, DFALSE);
		
	// create new surfaces
	CLIENT_INFO* pClient = m_pClients;
	while (pClient)
	{
		char* pstrName = m_pClientDE->GetStringData(pClient->hstrName);
		
		if(strcmp(pstrName,g_pRiotClientShell->cOpponentName1)==0)
		{
			DRect fillRect;
				
			m_hPlayer1Color = m_pClientDE->CreateSurface(10, 12);
			
			fillRect.left = fillRect.top = 0;
			fillRect.right = 10;
			fillRect.bottom = 12;
			m_pClientDE->FillRect(m_hPlayer1Color, &fillRect, SETRGB(220, 220, 220));
			
			fillRect.left++;
			fillRect.top++;
			fillRect.right--;
			fillRect.bottom--;
			m_pClientDE->FillRect(m_hPlayer1Color, &fillRect, SETRGB(pClient->r, pClient->g, pClient->b));

			m_pClientDE->OptimizeSurface (m_hPlayer1Color, hTransColor);
			m_pClientDE->GetSurfaceDims (m_hPlayer1Color, &m_cxPlayer1Color, &m_cxPlayer1Color);
		}
		
		pClient = pClient->pNext;
	}
}

void CClientInfoMgr::TA_UpdatePlayer2Color()
{
 	if (m_hPlayer2Color) m_pClientDE->DeleteSurface(m_hPlayer2Color);
	m_hPlayer2Color				= DNULL;
	m_cxPlayer2Color			= 0;
	m_cyPlayer2Color			= 0;
	
	// setup the necessary stuff
	HDECOLOR hTransColor = m_pClientDE->SetupColor1(0.0f, 0.0f, 0.0f, DFALSE);
		
	// create new surfaces
	CLIENT_INFO* pClient = m_pClients;
	while (pClient)
	{
		char* pstrName = m_pClientDE->GetStringData(pClient->hstrName);
		
		if(strcmp(pstrName,g_pRiotClientShell->cOpponentName2)==0)
		{
			DRect fillRect;
				
			m_hPlayer2Color = m_pClientDE->CreateSurface(10, 12);
			
			fillRect.left = fillRect.top = 0;
			fillRect.right = 10;
			fillRect.bottom = 12;
			m_pClientDE->FillRect(m_hPlayer2Color, &fillRect, SETRGB(220, 220, 220));
			
			fillRect.left++;
			fillRect.top++;
			fillRect.right--;
			fillRect.bottom--;
			m_pClientDE->FillRect(m_hPlayer2Color, &fillRect, SETRGB(pClient->r, pClient->g, pClient->b));

			m_pClientDE->OptimizeSurface (m_hPlayer2Color, hTransColor);
			m_pClientDE->GetSurfaceDims (m_hPlayer2Color, &m_cxPlayer2Color, &m_cxPlayer2Color);
		}
		
		pClient = pClient->pNext;
	}
}