// ----------------------------------------------------------------------- //
//
// MODULE  : WeaponPowerups.h
//
// PURPOSE : Riot weapon powerups implementation
//
// CREATED : 10/7/97
//
// ----------------------------------------------------------------------- //

#ifndef __WEAPON_POWERUPS_H__
#define __WEAPON_POWERUPS_H__

#include "Powerup.h"
#include "Bouncer.h"
#include "ModelFuncs.h"

class WeaponPowerup : public Powerup
{
	public :

		WeaponPowerup();

	protected :

		DDWORD			EngineMessageFn(DDWORD messageID, void *pData, DFLOAT lData);
		void			ObjectTouch(HOBJECT hObject);

		void			ReadProp( ObjectCreateStruct *pStruct );
		void			PostPropRead( ObjectCreateStruct *pStruct );
		void			InitialUpdate( CServerDE *pServer );

		DBYTE			m_iWeaponType;
		DDWORD			m_dwAmmo;
		ModelSize		m_eModelSize;

		CBouncer		m_bounce;

	private :

		void Save(HMESSAGEWRITE hWrite, DDWORD dwSaveFlags);
		void Load(HMESSAGEREAD hRead, DDWORD dwLoadFlags);
};

class PulseRiflePowerup : public WeaponPowerup
{
	public :
		PulseRiflePowerup();
};

class DeathChargePowerup : public WeaponPowerup
{
	public :
		DeathChargePowerup();
};

class PulseLauncherPowerup : public WeaponPowerup
{
	public :
		PulseLauncherPowerup();
};

class SniperRiflePowerup : public WeaponPowerup
{
	public :
		SniperRiflePowerup();
};

class MassDriverPowerup : public WeaponPowerup
{
	public :
		MassDriverPowerup();
};

class RiotCannonPowerup : public WeaponPowerup
{
	public :
		RiotCannonPowerup();
};

class AutoCannonsPowerup : public WeaponPowerup
{
	public :
		AutoCannonsPowerup();
};

class HealGunPowerup : public WeaponPowerup
{
	public :
		HealGunPowerup();
};

class SickGunPowerup : public WeaponPowerup
{
	public :
		SickGunPowerup();
};

class BlinderPowerup : public WeaponPowerup
{
	public :
		BlinderPowerup();
};

#endif //  __WEAPON_POWERUPS_H__