// ----------------------------------------------------------------------- //
//
// MODULE  : Teleporter.h
//
// PURPOSE : Teleporter - Definition
//
// CREATED : 6/7/99
//
// ----------------------------------------------------------------------- //

#ifndef __TELEPORTER_H__
#define __TELEPORTER_H__

#include "cpp_engineobjects_de.h"
#include "..\Shared\NetDefs.h"
#include "SurfaceTypes.h"
#include "Prop.h"

class Teleporter : public Prop
{
	public :

		Teleporter();
		~Teleporter();

		HSTRING		GetTriggerTarget()	const { return m_hstrTriggerTarget; }
		HSTRING		GetTriggerMessage()	const { return m_hstrTriggerMessage; }

	protected :

		virtual void  ObjectTouch(HOBJECT hObj);
		DDWORD EngineMessageFn(DDWORD messageID, void *pData, DFLOAT lData);
	
	private :

		HSTRING		m_hstrName;			// Name of start point
		DVector		m_vPitchYawRoll;	// Pitch, yaw, and roll of start point

		DVector		m_vDestination;		// Destination point of this teleporter
		
		HSTRING		m_hstrTriggerTarget;	// Name of object to trigger
		HSTRING		m_hstrTriggerMessage;	// Message to send to object

		DRotation	m_rRotation;
		
		//DVector		m_vDims;
		//DVector		m_vScale;

		DBOOL ReadProp(ObjectCreateStruct *pStruct);
};

#endif // __TELEPORTER_H__
