// ----------------------------------------------------------------------- //
//
// MODULE  : ModelNodes.h
//
// PURPOSE : Model node related utility functions
//
// CREATED : 6/26/98
//
// ----------------------------------------------------------------------- //

#ifndef __MODEL_NODES_H__
#define __MODEL_NODES_H__

#include "ModelIds.h"

enum NodeType { NT_HEAD, NT_LARM, NT_RARM, NT_LLEG, NT_RLEG, NT_PELVIS, NT_TORSO };
		
// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetNumModelNodes
//
//	PURPOSE:	Return the number of nodes in the model associated with
//				the particular id
//
// ----------------------------------------------------------------------- //

inline DDWORD GetNumModelNodes(DDWORD nId, ModelSize size=MS_NORMAL)
{
	DDWORD nRet = 0;

	return nRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetModelNodeName
//
//	PURPOSE:	Return the name of a particular model node
//
// ----------------------------------------------------------------------- //

inline char* GetModelNodeName(DDWORD dwIndex, DDWORD nId, ModelSize size=MS_NORMAL)
{
	char* pRet = DNULL;

	if (dwIndex < 0 || dwIndex > GetNumModelNodes(nId, size)) return pRet;

	return pRet;
}


#endif // __MODEL_NODES_H__
