// ----------------------------------------------------------------------- //
//
// MODULE  : AmmoBag.cpp
//
// PURPOSE : Riot Armor powerups - Implementation
//
// CREATED : 1/28/97
//
// ----------------------------------------------------------------------- //

#include "AmmoBag.h"
#include "ServerRes.h"
#include "PlayerObj.h"
#include "RiotMsgIds.h"
#include "cpp_server_de.h"

// ----------------------------------------------------------------------- //
// ----------------------------------------------------------------------- //
//
//	CLASS:		AmmoBag
//
//	PURPOSE:	Base Armor powerups
//
// ----------------------------------------------------------------------- //
// ----------------------------------------------------------------------- //

BEGIN_CLASS(AmmoBag)
	ADD_BOOLPROP_FLAG(Rotate, 1, PF_HIDDEN)
	ADD_REALPROP(RespawnTime, 10.0f)
	ADD_STRINGPROP_FLAG(SoundFile, "", PF_HIDDEN)
END_CLASS_DEFAULT(AmmoBag, Powerup, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmmoBag::AmmoBag
//
//	PURPOSE:	Handle object initialization
//
// ----------------------------------------------------------------------- //

AmmoBag::AmmoBag() : Powerup()
{
	m_nModelName = IDS_MODEL_AMMOBAG; 
	m_nModelSkin = IDS_SKIN_AMMOBAG;
	m_nSoundName = IDS_SOUND_ARMORREPAIR_100;
	m_bRotate = DTRUE;
	m_eType = PIT_DTM_AMMOBAG;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmmoBag::EngineMessageFn
//
//	PURPOSE:	Handle engine messages
//
// ----------------------------------------------------------------------- //

DDWORD AmmoBag::EngineMessageFn(DDWORD messageID, void *pData, DFLOAT fData)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return DFALSE;

	switch(messageID)
	{
		case MID_PRECREATE:
		{
			DDWORD dwRet = Powerup::EngineMessageFn(messageID, pData, fData);

			ObjectCreateStruct* pStruct = (ObjectCreateStruct*)pData;
			if (pStruct)
			{
				HSTRING hString = DNULL;
				
				hString = pServerDE->FormatString (m_nModelName);
				if (hString)
				{
					SAFE_STRCPY(pStruct->m_Filename, pServerDE->GetStringData (hString));
				}
				else
				{
					SAFE_STRCPY(pStruct->m_Filename, "dummy string");	// this will force the dummy model
				}
				pServerDE->FreeString (hString);

				hString = pServerDE->FormatString (m_nModelSkin);
				if (hString) SAFE_STRCPY(pStruct->m_SkinName, pServerDE->GetStringData (hString));
				pServerDE->FreeString (hString);

				if( m_hstrSoundFile )
					pServerDE->FreeString( m_hstrSoundFile );
				m_hstrSoundFile = pServerDE->FormatString (m_nSoundName);
			}

			m_bRotate = DFALSE;

			return dwRet;
		}
		
		case MID_INITIALUPDATE:
		{
			DVector vDims;
			VEC_SET(vDims, 20.0f, 25.0f, 10.0f);

			pServerDE->SetObjectDims(m_hObject, &vDims);
			break;
		}

		case MID_SAVEOBJECT:
		{
			Save((HMESSAGEWRITE)pData, (DDWORD)fData);
		}
		break;

		case MID_LOADOBJECT:
		{
			Load((HMESSAGEREAD)pData, (DDWORD)fData);
		}
		break;

		default : break;
	}

	return Powerup::EngineMessageFn(messageID, pData, fData);
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmmoBag::AddPowerup
//
//	PURPOSE:	Add powerup to object
//
// ----------------------------------------------------------------------- //

void AmmoBag::ObjectTouch(HOBJECT hObject)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return;

	CPlayerObj* pPlayer = (CPlayerObj*)pServerDE->HandleToObject(hObject);
	
	pPlayer->FullAmmoCheat();

	m_hClient = pPlayer->GetClient();
	m_bInformClient = DTRUE;
	
	HMESSAGEWRITE hWrite = pServerDE->StartMessageToObject (pPlayer, pServerDE->ObjectToHandle(this), MID_PICKEDUP);
	pServerDE->WriteToMessageFloat (hWrite, -1.0f);
	pServerDE->EndMessage (hWrite);
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Inventory::ObjectMessageFn()
//
//	PURPOSE:	Handle inventory messages
//
// ----------------------------------------------------------------------- //

DDWORD AmmoBag::ObjectMessageFn(LPBASECLASS pObject, HOBJECT hSender, DDWORD messageID, HMESSAGEREAD hRead)
{
	CServerDE* pServerDE = BaseClass::GetServerDE();
	if (!pServerDE) return 0;
	
	HMESSAGEWRITE hWrite = pServerDE->StartMessageToObject (pObject, hSender, MID_PICKEDUP);
	pServerDE->WriteToMessageFloat (hWrite, -1.0f);
	pServerDE->EndMessage (hWrite);

	return Powerup::ObjectMessageFn(hSender, messageID, hRead);
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmmoBag::Save
//
//	PURPOSE:	Save the object
//
// ----------------------------------------------------------------------- //

void AmmoBag::Save(HMESSAGEWRITE hWrite, DDWORD dwSaveFlags)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !hWrite) return;

	pServerDE->WriteToMessageDWord(hWrite, m_nArmor);
	pServerDE->WriteToMessageDWord(hWrite, m_nModelName);
	pServerDE->WriteToMessageDWord(hWrite, m_nModelSkin);
	pServerDE->WriteToMessageDWord(hWrite, m_nSoundName);
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmmoBag::Load
//
//	PURPOSE:	Load the object
//
// ----------------------------------------------------------------------- //

void AmmoBag::Load(HMESSAGEREAD hRead, DDWORD dwLoadFlags)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !hRead) return;

	m_nArmor	 = pServerDE->ReadFromMessageDWord(hRead);
	m_nModelName = pServerDE->ReadFromMessageDWord(hRead);
	m_nModelSkin = pServerDE->ReadFromMessageDWord(hRead);
	m_nSoundName = pServerDE->ReadFromMessageDWord(hRead);
}