
#include "de_server.h"
#include "sample_servershell.h"
#include "player.h"



// --------------------------------------------------------------- //
// These functions create the server shell for DirectEngine.
// --------------------------------------------------------------- //

ServerShellDE* CreateServerShell()
{
	return (ServerShellDE*)(new CSampleServerShell);
}


void DeleteServerShell(ServerShellDE *pShell)
{
	delete ((CSampleServerShell*)pShell);
}

SETUP_SERVERSHELL()


// This ties all the classes together and sets the DLL up to give
// a list of the classes to DirectEngine.
DEFINE_CLASSES()



// --------------------------------------------------------------- //
// CSampleServerShell member functions.
// --------------------------------------------------------------- //

LPBASECLASS CSampleServerShell::OnClientEnterWorld(HCLIENT hClient)
{
	ObjectCreateStruct createStruct;
	LPBASECLASS pObject;

	// Create an object to represent the client.
	INIT_OBJECTCREATESTRUCT(createStruct);
	pObject = GetServerDE()->CreateObject(GetServerDE()->GetClass("Player"), &createStruct);

	((Player*)pObject)->m_hClient = hClient;

	// Store the object pointer with the client for future reference.
	GetServerDE()->SetClientUserData(hClient, pObject);

	return pObject;
}


void CSampleServerShell::OnClientExitWorld(HCLIENT hClient)
{
	LPBASECLASS pObject;

	// Get rid of their object.
	pObject = (LPBASECLASS)GetServerDE()->GetClientUserData(hClient);
	if(pObject)
	{
		GetServerDE()->RemoveObject(pObject->m_hObject);
		GetServerDE()->SetClientUserData(hClient, DNULL);
	}
}


void CSampleServerShell::OnMessage(HCLIENT hSender, DBYTE messageID, HMESSAGEREAD hRead)
{
	LPBASECLASS pObject;
	DRotation rotation;

	// Is it a rotation message?
	if(messageID == 1)
	{
		// Ok, get the client's object.
		pObject = (LPBASECLASS)GetServerDE()->GetClientUserData(hSender);
		if(pObject)
		{
			// Set the object's rotation.
			GetServerDE()->ReadFromMessageRotation(hRead, &rotation);
			GetServerDE()->SetObjectRotation(pObject->m_hObject, &rotation);
		}
	}
}



