

#include "de_server.h"
#include "player.h"



// Command IDs (mapped to keys in autoexec.cfg).
#define COMMAND_FORWARD		0
#define COMMAND_BACKWARD	1
#define COMMAND_LEFT		10
#define COMMAND_RIGHT		11
#define COMMAND_STRAFE		9
#define COMMAND_SPEED		7



DDWORD Player::EngineMessageFn(DDWORD messageID, void *pData, DFLOAT lData)
{
	float moveSpeed = 120.0f;
	float terminalVelocity = 400.0f;
	DVector velocity, forward, right, up, temp;
	DRotation rotation;
	ObjectCreateStruct *pObjectCreateStruct;
	DVector dims;

	// See serverobj_de.h (near line 100) for descriptions of the messages.
	switch(messageID)
	{
		case MID_PRECREATE:
		{
			pObjectCreateStruct = (ObjectCreateStruct*)pData;
			
			// Force our object type to be a camera; this is because the engine
			// will optimize and not send down 'invisible' OT_NORMALs.
			pObjectCreateStruct->m_ObjectType = OT_CAMERA;
			pObjectCreateStruct->m_Flags |= FLAG_SOLID;
			break;
		}

		case MID_INITIALUPDATE:
		{
			// Tell LithTech to update us as soon as possible.
			GetServerDE()->SetNextUpdate(m_hObject, 0.001f);
			
			// Give us some dimensions.
			VEC_SET(dims, 7, 25, 7);
			GetServerDE()->SetObjectDims(m_hObject, &dims);
			break;
		}

		case MID_UPDATE:
		{
			// Check what commands are on and apply movement.
			GetServerDE()->GetVelocity(m_hObject, &velocity);
			GetServerDE()->GetObjectRotation(m_hObject, &rotation);
			GetServerDE()->GetRotationVectors(&rotation, &up, &right, &forward);

			if(GetServerDE()->IsCommandOn(m_hClient, COMMAND_FORWARD))
			{
				VEC_MULSCALAR(temp, forward, moveSpeed);
				VEC_ADD(velocity, velocity, temp);
			}

			if(GetServerDE()->IsCommandOn(m_hClient, COMMAND_BACKWARD))
			{
				VEC_MULSCALAR(temp, forward, -moveSpeed);
				VEC_ADD(velocity, velocity, temp);
			}

			if(GetServerDE()->IsCommandOn(m_hClient, COMMAND_STRAFE))
			{
				if(GetServerDE()->IsCommandOn(m_hClient, COMMAND_LEFT))
				{
					VEC_MULSCALAR(temp, right, -moveSpeed);
					VEC_ADD(velocity, velocity, temp);
				}

				if(GetServerDE()->IsCommandOn(m_hClient, COMMAND_RIGHT))
				{
					VEC_MULSCALAR(temp, right, moveSpeed);
					VEC_ADD(velocity, velocity, temp);
				}
			}

			// Slow down for when they aren't pressing keys.
			VEC_MULSCALAR(velocity, velocity, 0.8f);
			if(VEC_MAG(velocity) < 0.05f)
				VEC_SET(velocity, 0, 0, 0);

			// Update the object's velocity.
			GetServerDE()->SetVelocity(m_hObject, &velocity);
			
			// Register for another update..
			GetServerDE()->SetNextUpdate(m_hObject, 0.001f);
			break;
		}
	}
	
	// Pass the message on down.
	return BaseClass::EngineMessageFn(messageID, pData, lData);
}


// Expose the Player class for LithTech.
BEGIN_CLASS(Player)
// Properties would go here if this were an object we wanted level
// designers to be able to edit them from within DirectEditor.
//	ADD_REALPROP(SomeNum, 6)
END_CLASS_DEFAULT_FLAGS(Player, BaseClass, NULL, NULL, CF_HIDDEN)


