
#include <stdio.h>
#include "de_client.h"
#include "ltos.h"

#include "lt_bitmapwindow.h"

// --------------------------------------------------------------- //
// Command IDs (mapped to keys in autoexec.cfg).
// --------------------------------------------------------------- //

#define COMMAND_LEFT		10
#define COMMAND_RIGHT		11
#define COMMAND_LOOKUP		15
#define COMMAND_LOOKDOWN	16
#define COMMAND_QUIT		17

#define COMMAND_MENU		50

// --------------------------------------------------------------- //
// These functions create the client shell for DirectEngine.
// --------------------------------------------------------------- //

ClientShellDE* CreateClientShell()
{
	return ((ClientShellDE*)new LTOS);
}


void DeleteClientShell(ClientShellDE *pShell)
{
	delete ((LTOS*)pShell);
}

SETUP_CLIENTSHELL();



// --------------------------------------------------------------- //
// LTOS functions.
// --------------------------------------------------------------- //

LTOS::LTOS()
{
	m_hCamera = DNULL;
}

void LTOS::OnEngineInitialized()
{
	StartGameRequest request;
	HCONSOLEVAR hVar;

	SetupWindows();

	// Zero-out our request for safety.
	memset(&request,0,sizeof(request));

	// Look for the +runworld command-line parameter and start a world based on that.
	hVar = GetClientDE()->GetConsoleVar("runworld");
	request.m_pWorldName = GetClientDE()->GetVarValueString(hVar);
	request.m_Type = STARTGAME_NORMAL;
	GetClientDE()->StartGame(&request);
}

void LTOS::SetupSound(InitSoundInfo *pSoundInfo)
{
	// We're not using sound in this demo, set the voices to 0.
	pSoundInfo->m_nNumStaticVoices = 0;
	pSoundInfo->m_nNumDynamicVoices = 0;
}

void LTOS::OnEnterWorld()
{
	ObjectCreateStruct createStruct;


	INIT_OBJECTCREATESTRUCT(createStruct);
	createStruct.m_ObjectType = OT_CAMERA;
	m_hCamera = GetClientDE()->CreateObject(&createStruct);

	m_Yaw = m_Pitch = m_Roll = 0.0f;
}


void LTOS::OnExitWorld()
{
	if(m_hCamera)
	{
		GetClientDE()->DeleteObject(m_hCamera);
		m_hCamera = DNULL;
	}
}

void LTOS::OnEngineTerm()
{
	m_LWMgr.Destroy();
}


void LTOS::Update()
{
	HLOCALOBJ hClientObj;
	DVector pos;
	DRotation rotation;
	float radiansPerSec = 2.5f;
	HMESSAGEWRITE hMessage;
	DFLOAT offsets[3];

	m_LWMgr.HandleMouse(offsets);

	// If we're in the world, move and rotate our camera to 
	// line up with the (server-side) player object.
	if(m_hCamera)
	{
		hClientObj = GetClientDE()->GetClientObject();
		if(hClientObj)
		{
			GetClientDE()->GetObjectPos(hClientObj, &pos);
			GetClientDE()->SetObjectPos(m_hCamera, &pos);
			
			// Update our orientation.  We do this on the client and send the
			// angles to the server so mouse orientation is zero latency.
			if(GetClientDE()->IsCommandOn(COMMAND_LEFT))
			{
				m_Pitch -= radiansPerSec * GetClientDE()->GetFrameTime();
			}

			if(GetClientDE()->IsCommandOn(COMMAND_RIGHT))
			{
				m_Pitch += radiansPerSec * GetClientDE()->GetFrameTime();
			}

			if(GetClientDE()->IsCommandOn(COMMAND_LOOKUP))
			{
				m_Yaw -= radiansPerSec * GetClientDE()->GetFrameTime();
			}

			if(GetClientDE()->IsCommandOn(COMMAND_LOOKDOWN))
			{
				m_Yaw += radiansPerSec * GetClientDE()->GetFrameTime();
			}

			// Update our camera.
			GetClientDE()->SetupEuler(&rotation, m_Yaw, m_Pitch, m_Roll);
			GetClientDE()->SetObjectRotation(m_hCamera, &rotation);

			// Send the orientation to the server.  The server will update the
			// player object rotation.
			hMessage = GetClientDE()->StartMessage(1);
			GetClientDE()->WriteToMessageRotation(hMessage, &rotation);
			GetClientDE()->EndMessage(hMessage);
		}
	}
}


void LTOS::OnCommandOn(int command)
{
	if(command == COMMAND_QUIT)
	{
		GetClientDE()->Shutdown();
	} else
	if (command == COMMAND_MENU)
	{
		m_LWMgr.Activate(!m_LWMgr.IsActive());
	} else {
		if (m_LWMgr.IsActive())
			m_LWMgr.HandleCommand(command);
	}
}

void LTOS::PostUpdate()
{
	m_LWMgr.Render();
}

void LTOS::SetupWindows()
{
	GetClientDE()->CPrint("--------------------------------");
	GetClientDE()->CPrint("LT/OS - Lithium GUI for LithTech");
	GetClientDE()->CPrint("(C)1998 Monolith Productions");
	GetClientDE()->CPrint("--------------------------------");

	m_LWMgr.Initialize(GetClientDE());

	LithiumWindow *lWindow;
	LTBitmapWindow *lWindow2;

	lWindow2 = new LTBitmapWindow();

	lWindow2->Initialize(40,100,200,80,"images\\testpic2.pcx",LW_VISIBLE,&m_LWMgr,DTRUE);
	m_LWMgr.AddWindow(lWindow2);

	lWindow = new LithiumWindow();

	lWindow->Initialize(200,300,200,50,"Test Window #2",LW_VISIBLE | LW_TITLEBAR | LW_MOVEABLE | LW_RESIZABLE,&m_LWMgr);
	m_LWMgr.AddWindow(lWindow);

	lWindow = new LithiumWindow();

	lWindow->Initialize(100,100,200,150,"Test Window #1",LW_ACTIVE | LW_VISIBLE | LW_TITLEBAR | LW_MOVEABLE | LW_RESIZABLE,&m_LWMgr);
	m_LWMgr.AddWindow(lWindow);
}






